/* tracker-connection.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-connection.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * tracker_sparql_connection_get_finish:
 * @_res_: The #GAsyncResult from the callback used to return the #TrackerSparqlConnection
 * @error: The error which occurred or %NULL
 *
 * This function is called from the callback provided for
 * tracker_sparql_connection_get_async() to return the connection requested
 * or an error in cases of failure.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_local_new_async:
 * @flags: Flags to define connection behavior
 * @store: Location for the database
 * @journal: Location for the operation journal, or %NULL
 * @ontology: Location of the ontology used for this connection, or %NULL
 * @cancellable: A #GCancellable
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Returns: a new local #TrackerSparqlConnection using the specified
 * @cache/@journal locations, and the ontology specified in the @ontology
 * directory. Call g_object_unref() on the object when no longer used.
 *
 * See tracker_sparql_connection_local_new() for more details.
 *
 * Since: 2.0
 */
/**
 * tracker_sparql_connection_query_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL query operation.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously a SPARQL update.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_array_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: an array of strings containing the SPARQL update queries
 * @sparql_length1: the amount of strings you pass as @sparql
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously an array of SPARQL updates. Each update in the
 * array is its own transaction. This means that update n+1 is not halted
 * due to an error in update n.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_blank_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously a SPARQL update.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_load_async:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Loads, asynchronously, a Turtle file (TTL) into the store.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_statistics_async:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Retrieves, asynchronously, the statistics from the Store.
 *
 * Since: 0.10
 */

#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-sparql/tracker-namespace-manager.h"
#include <glib-object.h>

enum  {
	TRACKER_SPARQL_CONNECTION_0_PROPERTY,
	TRACKER_SPARQL_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_connection_properties[TRACKER_SPARQL_CONNECTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateAsyncData TrackerSparqlConnectionUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateArrayAsyncData TrackerSparqlConnectionUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateBlankAsyncData TrackerSparqlConnectionUpdateBlankAsyncData;
typedef struct _TrackerSparqlConnectionLoadAsyncData TrackerSparqlConnectionLoadAsyncData;
typedef struct _TrackerSparqlConnectionStatisticsAsyncData TrackerSparqlConnectionStatisticsAsyncData;

struct _TrackerSparqlConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
};

struct _TrackerSparqlConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
};

struct _TrackerSparqlConnectionLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	GFile* file;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
};

static gpointer tracker_sparql_connection_parent_class = NULL;

static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self,
                                                           const gchar* sparql,
                                                           GCancellable* cancellable,
                                                           GError** error);
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self,
                                            const gchar* sparql,
                                            gint priority,
                                            GCancellable* cancellable,
                                            GError** error);
static void tracker_sparql_connection_real_update_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self,
                                                  const gchar* sparql,
                                                  gint priority,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* _data_);
static void tracker_sparql_connection_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_array_async (TrackerSparqlConnection* self,
                                                        gchar** sparql,
                                                        gint sparql_length1,
                                                        gint priority,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean tracker_sparql_connection_real_update_array_async_co (TrackerSparqlConnectionUpdateArrayAsyncData* _data_);
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self,
                                                       const gchar* sparql,
                                                       gint priority,
                                                       GCancellable* cancellable,
                                                       GError** error);
static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self,
                                                        const gchar* sparql,
                                                        gint priority,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* _data_);
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self,
                                          GFile* file,
                                          GCancellable* cancellable,
                                          GError** error);
static void tracker_sparql_connection_real_load_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self,
                                                GFile* file,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* _data_);
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self,
                                                                GCancellable* cancellable,
                                                                GError** error);
static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* _data_);
static TrackerNamespaceManager* tracker_sparql_connection_real_get_namespace_manager (TrackerSparqlConnection* self);
static TrackerSparqlStatement* tracker_sparql_connection_real_query_statement (TrackerSparqlConnection* self,
                                                                        const gchar* sparql,
                                                                        GCancellable* cancellable,
                                                                        GError** error);
static GType tracker_sparql_connection_get_type_once (void);

static const GDBusErrorEntry tracker_sparql_error_entries[] = {{TRACKER_SPARQL_ERROR_PARSE, "org.freedesktop.Tracker1.SparqlError.Parse"}, {TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, "org.freedesktop.Tracker1.SparqlError.UnknownClass"}, {TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, "org.freedesktop.Tracker1.SparqlError.UnknownProperty"}, {TRACKER_SPARQL_ERROR_TYPE, "org.freedesktop.Tracker1.SparqlError.Type"}, {TRACKER_SPARQL_ERROR_CONSTRAINT, "org.freedesktop.Tracker1.SparqlError.Constraint"}, {TRACKER_SPARQL_ERROR_NO_SPACE, "org.freedesktop.Tracker1.SparqlError.NoSpace"}, {TRACKER_SPARQL_ERROR_INTERNAL, "org.freedesktop.Tracker1.SparqlError.Internal"}, {TRACKER_SPARQL_ERROR_UNSUPPORTED, "org.freedesktop.Tracker1.SparqlError.Unsupported"}};

GQuark
tracker_sparql_error_quark (void)
{
	static volatile gsize tracker_sparql_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("tracker-sparql-error-quark", &tracker_sparql_error_quark_volatile, tracker_sparql_error_entries, G_N_ELEMENTS (tracker_sparql_error_entries));
	return (GQuark) tracker_sparql_error_quark_volatile;
}

static GType
tracker_sparql_connection_flags_get_type_once (void)
{
	static const GEnumValue values[] = {{TRACKER_SPARQL_CONNECTION_FLAGS_NONE, "TRACKER_SPARQL_CONNECTION_FLAGS_NONE", "none"}, {TRACKER_SPARQL_CONNECTION_FLAGS_READONLY, "TRACKER_SPARQL_CONNECTION_FLAGS_READONLY", "readonly"}, {0, NULL, NULL}};
	GType tracker_sparql_connection_flags_type_id;
	tracker_sparql_connection_flags_type_id = g_enum_register_static ("TrackerSparqlConnectionFlags", values);
	return tracker_sparql_connection_flags_type_id;
}

GType
tracker_sparql_connection_flags_get_type (void)
{
	static volatile gsize tracker_sparql_connection_flags_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_connection_flags_type_id__once)) {
		GType tracker_sparql_connection_flags_type_id;
		tracker_sparql_connection_flags_type_id = tracker_sparql_connection_flags_get_type_once ();
		g_once_init_leave (&tracker_sparql_connection_flags_type_id__once, tracker_sparql_connection_flags_type_id);
	}
	return tracker_sparql_connection_flags_type_id__once;
}

/**
 * tracker_sparql_connection_get:
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * This function is used to give the caller a connection to Tracker they can
 * use for future requests. The best backend available to connect to
 * Tracker is returned. These backends include direct-access (for read-only
 * queries) and D-Bus (for both read and write queries).
 *
 * You can use <link linkend="tracker-overview-environment-variables">
 * environment variables</link> to influence how backends are used. If
 * no environment variables are provided, both backends are loaded and
 * chosen based on their merits. If you try to force a backend for a query
 * which it won't support (i.e. an update for a read-only backend), you will
 * see critical warnings.
 *
 * When calling either tracker_sparql_connection_get(),  or the asynchronous
 * variants of these functions, a mutex is used to protect the loading of
 * backends against potential race conditions. For synchronous calls, this
 * function will always block if a previous connection get method has been
 * called.
 *
 * All backends will call the D-Bus tracker-store API Wait() to make sure
 * the store and databases are in the right state before any user based
 * requests can proceed. There may be a small delay during this call if the
 * databases weren't shutdown cleanly and need to be checked on start up. If
 * the journal needs to be replayed in such an event, the delay may be
 * substantial while data is restored as best as possible.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_remote_new:
 * @uri_base: Base URI of the remote connection
 *
 * Returns: a new remote #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 1.12
 */
/**
 * tracker_sparql_connection_local_new:
 * @flags: Flags to define connection behavior
 * @store: Location for the database
 * @journal: Location for the operation journal, or %NULL
 * @ontology: Location of the ontology used for this connection, or %NULL
 * @cancellable: A #GCancellable
 * @error: The error which occurred or %NULL
 *
 * Returns: a new local #TrackerSparqlConnection using the specified
 * @cache/@journal locations, and the ontology specified in the @ontology
 * directory. Call g_object_unref() on the object when no longer used.
 *
 * This database connection is considered entirely private to the calling
 * process, if multiple processes use the same journal/cache locations,
 * the results are unpredictable.
 *
 * The @journal is used to rebuild the database in case of data corruption,
 * if %NULL is provided, the same location than @store will be assumed.
 *
 * The caller is entirely free to define an ontology or reuse Nepomuk for
 * its purposes. For the former see the "Defining ontologies" section in
 * this library docs. For the latter pass a %NULL @ontology.
 *
 * The @ontology argument may be a resource:/// URI, a directory location
 * must be provided, all children .ontology and .description files will
 * be read.
 *
 * The @store and @journal arguments expect directories, and those are
 * assumed to be entirely private to Tracker.
 *
 * Since: 2.0
 */
/**
 * tracker_sparql_connection_query:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL query
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL query on. The API call is completely synchronous, so
 * it may block.
 *
 * The @sparql query should be built with #TrackerSparqlBuilder, or
 * its parts correctly escaped using tracker_sparql_escape_string(),
 * otherwise SPARQL injection is possible.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 *
 * Since: 0.10
 */
static TrackerSparqlCursor*
tracker_sparql_connection_real_query (TrackerSparqlConnection* self,
                                      const gchar* sparql,
                                      GCancellable* cancellable,
                                      GError** error)
{
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_connection_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 426 "tracker-connection.c"
}

TrackerSparqlCursor*
tracker_sparql_connection_query (TrackerSparqlConnection* self,
                                 const gchar* sparql,
                                 GCancellable* cancellable,
                                 GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->query) {
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->query (self, sparql, cancellable, error);
#line 444 "tracker-connection.c"
	}
#line 260 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 448 "tracker-connection.c"
}

void
tracker_sparql_connection_query_async (TrackerSparqlConnection* self,
                                       const gchar* sparql,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->query_async) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->query_async (self, sparql, cancellable, _callback_, _user_data_);
#line 465 "tracker-connection.c"
	}
}

TrackerSparqlCursor*
tracker_sparql_connection_query_finish (TrackerSparqlConnection* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->query_finish) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->query_finish (self, _res_, error);
#line 481 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 485 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_update:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update. The API call is completely
 * synchronous, so it may block.
 *
 * The @sparql query should be built with #TrackerSparqlBuilder, or
 * its parts correctly escaped using tracker_sparql_escape_string(),
 * otherwise SPARQL injection is possible.
 *
 * Since: 0.10
 */
static void
tracker_sparql_connection_real_update (TrackerSparqlConnection* self,
                                       const gchar* sparql,
                                       gint priority,
                                       GCancellable* cancellable,
                                       GError** error)
{
#line 309 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (sparql != NULL);
#line 310 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:310: Interface 'update' not implemented");
#line 516 "tracker-connection.c"
}

void
tracker_sparql_connection_update (TrackerSparqlConnection* self,
                                  const gchar* sparql,
                                  gint priority,
                                  GCancellable* cancellable,
                                  GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 309 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (self != NULL);
#line 309 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 309 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update) {
#line 309 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->update (self, sparql, priority, cancellable, error);
#line 535 "tracker-connection.c"
	}
}

static void
tracker_sparql_connection_real_update_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	_data_ = _data;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionUpdateAsyncData, _data_);
#line 552 "tracker-connection.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return self ? g_object_ref (self) : NULL;
#line 560 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self,
                                             const gchar* sparql,
                                             gint priority,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (sparql != NULL);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateAsyncData);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_update_async_data_free);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = g_strdup (sparql);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql = _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->priority = priority;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp2_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_update_async_co (_data_);
#line 603 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_update_finish (TrackerSparqlConnection* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	TrackerSparqlConnectionUpdateAsyncData* _data_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return;
#line 618 "tracker-connection.c"
	}
}

/**
 * tracker_sparql_connection_update_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* _data_)
{
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 639 "tracker-connection.c"
		goto _state_0;
		default:
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 644 "tracker-connection.c"
	}
	_state_0:
#line 339 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:339: Interface 'update_async' not implemented");
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 657 "tracker-connection.c"
		}
	}
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 338 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 664 "tracker-connection.c"
}

void
tracker_sparql_connection_update_async (TrackerSparqlConnection* self,
                                        const gchar* sparql,
                                        gint priority,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_async) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->update_async (self, sparql, priority, cancellable, _callback_, _user_data_);
#line 682 "tracker-connection.c"
	}
}

void
tracker_sparql_connection_update_finish (TrackerSparqlConnection* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_finish) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->update_finish (self, _res_, error);
#line 698 "tracker-connection.c"
	}
}

static void
tracker_sparql_connection_real_update_array_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionUpdateArrayAsyncData, _data_);
#line 715 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_update_array_async (TrackerSparqlConnection* self,
                                                   gchar** sparql,
                                                   gint sparql_length1,
                                                   gint priority,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateArrayAsyncData);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_update_array_async_data_free);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql = sparql;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql_length1 = sparql_length1;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->priority = priority;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_update_array_async_co (_data_);
#line 754 "tracker-connection.c"
}

static GPtrArray*
tracker_sparql_connection_real_update_array_finish (TrackerSparqlConnection* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GPtrArray* result;
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return NULL;
#line 770 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = _data_->result;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 778 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_update_array_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update_array operation.
 *
 * <example>
 * <programlisting>
 * static void
 * async_update_array_callback (GObject      *source_object,
 *                              GAsyncResult *result,
 *                              gpointer      user_data)
 * {
 *     GError *error = NULL;
 *     GPtrArray *errors;
 *     guint i;
 *
 *     errors = tracker_sparql_connection_update_array_finish (connection, result, &error);
 *     g_assert_no_error (error);
 *
 *     for (i = 0; i < errors->len; i++) {
 *         const GError *e = g_ptr_array_index (errors, i);
 *
 *         ...
 *     }
 *
 *     g_ptr_array_unref (errors);
 * }
 * </programlisting>
 * </example>
 *
 * Returns: a #GPtrArray of size @sparql_length1 with elements that are
 * either NULL or a GError instance. The returned array should be freed with
 * g_ptr_array_unref when no longer used, not with g_ptr_array_free. When
 * you use errors of the array, you must g_error_copy them. Errors inside of
 * the array must be considered as const data and not freed. The index of
 * the error corresponds to the index of the update query in the array that
 * you passed to tracker_sparql_connection_update_array_async.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_connection_real_update_array_async_co (TrackerSparqlConnectionUpdateArrayAsyncData* _data_)
{
#line 403 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 403 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 831 "tracker-connection.c"
		goto _state_0;
		default:
#line 403 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 836 "tracker-connection.c"
	}
	_state_0:
#line 404 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:404: Interface 'update_array_async' not implem" \
"ented");
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 851 "tracker-connection.c"
		}
	}
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 405 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 858 "tracker-connection.c"
}

void
tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self,
                                              gchar** sparql,
                                              gint sparql_length1,
                                              gint priority,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_array_async) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->update_array_async (self, sparql, sparql_length1, priority, cancellable, _callback_, _user_data_);
#line 877 "tracker-connection.c"
	}
}

GPtrArray*
tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_array_finish) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->update_array_finish (self, _res_, error);
#line 893 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 897 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_update_blank:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update and returns the URNs of the generated nodes,
 * if any. The API call is completely synchronous, so it may block.
 *
 * The @sparql query should be built with #TrackerSparqlBuilder, or
 * its parts correctly escaped using tracker_sparql_escape_string(),
 * otherwise SPARQL injection is possible.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 *
 * Since: 0.10
 */
static GVariant*
tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self,
                                             const gchar* sparql,
                                             gint priority,
                                             GCancellable* cancellable,
                                             GError** error)
{
	GVariant* result;
#line 428 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 429 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:429: Interface 'update_blank' not implemented");
#line 430 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = NULL;
#line 430 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 936 "tracker-connection.c"
}

GVariant*
tracker_sparql_connection_update_blank (TrackerSparqlConnection* self,
                                        const gchar* sparql,
                                        gint priority,
                                        GCancellable* cancellable,
                                        GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 428 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 428 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 428 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_blank) {
#line 428 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->update_blank (self, sparql, priority, cancellable, error);
#line 955 "tracker-connection.c"
	}
#line 428 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 959 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_variant_unref0 (_data_->result);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionUpdateBlankAsyncData, _data_);
#line 977 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self,
                                                   const gchar* sparql,
                                                   gint priority,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (sparql != NULL);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateBlankAsyncData);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_update_blank_async_data_free);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = g_strdup (sparql);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql = _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->priority = priority;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp2_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_update_blank_async_co (_data_);
#line 1020 "tracker-connection.c"
}

static GVariant*
tracker_sparql_connection_real_update_blank_finish (TrackerSparqlConnection* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GVariant* result;
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return NULL;
#line 1036 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = _data_->result;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1044 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_update_blank_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation, and returns
 * the URNs of the generated nodes, if any.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* _data_)
{
#line 462 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 462 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 1068 "tracker-connection.c"
		goto _state_0;
		default:
#line 462 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 1073 "tracker-connection.c"
	}
	_state_0:
#line 463 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:463: Interface 'update_blank_async' not implem" \
"ented");
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1088 "tracker-connection.c"
		}
	}
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 464 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 1095 "tracker-connection.c"
}

void
tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self,
                                              const gchar* sparql,
                                              gint priority,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_blank_async) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->update_blank_async (self, sparql, priority, cancellable, _callback_, _user_data_);
#line 1113 "tracker-connection.c"
	}
}

GVariant*
tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->update_blank_finish) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->update_blank_finish (self, _res_, error);
#line 1129 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 1133 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_load:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Loads a Turtle file (TTL) into the store. The API call is completely
 * synchronous, so it may block.
 *
 * Since: 0.10
 */
static void
tracker_sparql_connection_real_load (TrackerSparqlConnection* self,
                                     GFile* file,
                                     GCancellable* cancellable,
                                     GError** error)
{
#line 479 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (file != NULL);
#line 480 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:480: Interface 'load' not implemented");
#line 1158 "tracker-connection.c"
}

void
tracker_sparql_connection_load (TrackerSparqlConnection* self,
                                GFile* file,
                                GCancellable* cancellable,
                                GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 479 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (self != NULL);
#line 479 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 479 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->load) {
#line 479 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->load (self, file, cancellable, error);
#line 1176 "tracker-connection.c"
	}
}

static void
tracker_sparql_connection_real_load_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionLoadAsyncData* _data_;
	_data_ = _data;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->file);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionLoadAsyncData, _data_);
#line 1193 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self,
                                           GFile* file,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerSparqlConnectionLoadAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (file != NULL);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionLoadAsyncData);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_load_async_data_free);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->file);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->file = _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp2_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_load_async_co (_data_);
#line 1233 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_load_finish (TrackerSparqlConnection* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	TrackerSparqlConnectionLoadAsyncData* _data_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return;
#line 1248 "tracker-connection.c"
	}
}

/**
 * tracker_sparql_connection_load_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous load of the Turtle file.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* _data_)
{
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 1269 "tracker-connection.c"
		goto _state_0;
		default:
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 1274 "tracker-connection.c"
	}
	_state_0:
#line 508 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:508: Interface 'load_async' not implemented");
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1287 "tracker-connection.c"
		}
	}
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 507 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 1294 "tracker-connection.c"
}

void
tracker_sparql_connection_load_async (TrackerSparqlConnection* self,
                                      GFile* file,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->load_async) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->load_async (self, file, cancellable, _callback_, _user_data_);
#line 1311 "tracker-connection.c"
	}
}

void
tracker_sparql_connection_load_finish (TrackerSparqlConnection* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->load_finish) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->load_finish (self, _res_, error);
#line 1327 "tracker-connection.c"
	}
}

/**
 * tracker_sparql_connection_statistics:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Retrieves the statistics from the Store. The API call is completely
 * synchronous, so it may block.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 *
 * Since: 0.10
 */
static TrackerSparqlCursor*
tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self,
                                           GCancellable* cancellable,
                                           GError** error)
{
	TrackerSparqlCursor* result;
#line 527 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:527: Interface 'statistics' not implemented");
#line 528 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = NULL;
#line 528 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1358 "tracker-connection.c"
}

TrackerSparqlCursor*
tracker_sparql_connection_statistics (TrackerSparqlConnection* self,
                                      GCancellable* cancellable,
                                      GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 526 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 526 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 526 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->statistics) {
#line 526 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->statistics (self, cancellable, error);
#line 1375 "tracker-connection.c"
	}
#line 526 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 1379 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_statistics_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	_data_ = _data;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->result);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionStatisticsAsyncData, _data_);
#line 1395 "tracker-connection.c"
}

static void
tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionStatisticsAsyncData);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_statistics_async_data_free);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp1_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_statistics_async_co (_data_);
#line 1425 "tracker-connection.c"
}

static TrackerSparqlCursor*
tracker_sparql_connection_real_statistics_finish (TrackerSparqlConnection* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	TrackerSparqlCursor* result;
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return NULL;
#line 1441 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = _data_->result;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1449 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_statistics_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous retrieval of statistics from the Store.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 *
 * Since: 0.10
 */
static gboolean
tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* _data_)
{
#line 558 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 558 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 1473 "tracker-connection.c"
		goto _state_0;
		default:
#line 558 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 1478 "tracker-connection.c"
	}
	_state_0:
#line 559 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:559: Interface 'statistics_async' not implemen" \
"ted");
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1493 "tracker-connection.c"
		}
	}
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 560 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 1500 "tracker-connection.c"
}

void
tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->statistics_async) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		_klass_->statistics_async (self, cancellable, _callback_, _user_data_);
#line 1516 "tracker-connection.c"
	}
}

TrackerSparqlCursor*
tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->statistics_finish) {
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->statistics_finish (self, _res_, error);
#line 1532 "tracker-connection.c"
	}
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 1536 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_get_namespace_manager:
 * @self: a #TrackerSparqlConnection
 *
 * Retrieves a #TrackerNamespaceManager that contains all
 * prefixes in the ontology of @self.
 *
 * Returns: (transfer none): a #TrackerNamespaceManager for this
 * connection. This object is owned by @self and must not be freed.
 *
 * Since: 2.0
 */
static TrackerNamespaceManager*
tracker_sparql_connection_real_get_namespace_manager (TrackerSparqlConnection* self)
{
	TrackerNamespaceManager* result;
#line 576 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:576: Not implemented");
#line 577 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = NULL;
#line 577 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1561 "tracker-connection.c"
}

TrackerNamespaceManager*
tracker_sparql_connection_get_namespace_manager (TrackerSparqlConnection* self)
{
	TrackerSparqlConnectionClass* _klass_;
#line 575 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 575 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 575 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->get_namespace_manager) {
#line 575 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->get_namespace_manager (self);
#line 1576 "tracker-connection.c"
	}
#line 575 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 1580 "tracker-connection.c"
}

/**
 * tracker_sparql_connection_set_domain:
 * @domain: The domain name for the default connection
 *
 * Sets the domain (usually a DBus name or application ID) that
 * will be used on on the connection obtained by
 * tracker_sparql_connection_get(). See the "Isolating tracker-store
 * clients" section in the docs for this library.
 *
 * This function must be called before any tracker_sparql_connection_get()
 * calls happen.
 *
 * Since: 2.0
 */
/**
 * tracker_sparql_connection_get_domain:
 *
 * Gets the domain (usually a DBus name or application ID) that
 * will be used on on the connection obtained by
 * tracker_sparql_connection_get().
 * See tracker_sparql_connection_set_domain() for more information.
 *
 * Returns: (transfer full): The domain string, or %NULL if none is set
 *
 * Since: 2.0
 */
/**
 * tracker_sparql_connection_set_dbus_connection:
 * @dbus_connection: A #GDBusConnection to a suitable message bus.
 *
 * By default, a connection is opened to the session-wide Tracker services
 * running on the D-Bus session bus. This function allows you to connect to
 * Tracker services that are running on a different bus.
 *
 * This function must be called before any tracker_sparql_connection_get()
 * calls happen.
 *
 * See also: the TRACKER_IPC_BUS environment variable.
 *
 * Since: 2.2
 */
/**
 * tracker_sparql_connection_get_dbus_connection:
 *
 * Gets the D-Bus connection that is used to contact the Tracker services.
 *
 * Returns: (transfer none): A #GDBusConnection instance, or %NULL if the
 *                           default is being used.
 *
 * Since: 2.0
 */
/**
 * tracker_sparql_connection_query_statement:
 * @self: a #TrackerSparqlConnection
 * @sparql: the SPARQL query
 * @cancellable: a #GCancellable used to cancel the operation, or %NULL
 * @error: a #TrackerSparqlError or %NULL if no error occured
 *
 * Prepares the given @sparql as a #TrackerSparqlStatement.
 *
 * Since: 2.2
 */
static TrackerSparqlStatement*
tracker_sparql_connection_real_query_statement (TrackerSparqlConnection* self,
                                                const gchar* sparql,
                                                GCancellable* cancellable,
                                                GError** error)
{
	TrackerSparqlStatement* result;
#line 650 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 651 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:651: Interface 'query_statement' not implement" \
"ed");
#line 652 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	result = NULL;
#line 652 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1660 "tracker-connection.c"
}

TrackerSparqlStatement*
tracker_sparql_connection_query_statement (TrackerSparqlConnection* self,
                                           const gchar* sparql,
                                           GCancellable* cancellable,
                                           GError** error)
{
	TrackerSparqlConnectionClass* _klass_;
#line 650 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 650 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	_klass_ = TRACKER_SPARQL_CONNECTION_GET_CLASS (self);
#line 650 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_klass_->query_statement) {
#line 650 "../tracker/src/libtracker-sparql/tracker-connection.vala"
		return _klass_->query_statement (self, sparql, cancellable, error);
#line 1678 "tracker-connection.c"
	}
#line 650 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 1682 "tracker-connection.c"
}

TrackerSparqlConnection*
tracker_sparql_connection_construct (GType object_type)
{
	TrackerSparqlConnection * self = NULL;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	self = (TrackerSparqlConnection*) g_object_new (object_type, NULL);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	return self;
#line 1693 "tracker-connection.c"
}

static void
tracker_sparql_connection_class_init (TrackerSparqlConnectionClass * klass,
                                      gpointer klass_data)
{
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_parent_class = g_type_class_peek_parent (klass);
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_sparql_connection_real_query;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_connection_real_update;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_update_async;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_connection_real_update_finish;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection*, gchar**, gint, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_update_array_async;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_connection_real_update_array_finish;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_connection_real_update_blank;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_update_blank_async;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_connection_real_update_blank_finish;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection*, GFile*, GCancellable*, GError**)) tracker_sparql_connection_real_load;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection*, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_load_async;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_connection_real_load_finish;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GCancellable*, GError**)) tracker_sparql_connection_real_statistics;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (void (*) (TrackerSparqlConnection*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_statistics_async;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_sparql_connection_real_statistics_finish;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->get_namespace_manager = (TrackerNamespaceManager* (*) (TrackerSparqlConnection*)) tracker_sparql_connection_real_get_namespace_manager;
#line 89 "../tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->query_statement = (TrackerSparqlStatement* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_sparql_connection_real_query_statement;
#line 1736 "tracker-connection.c"
}

static void
tracker_sparql_connection_instance_init (TrackerSparqlConnection * self,
                                         gpointer klass)
{
}

/**
 * TrackerSparqlConnection:
 *
 * The <structname>TrackerSparqlConnection</structname> object represents a
 * connection with the Tracker store or databases depending on direct or
 * non-direct requests.
 */
static GType
tracker_sparql_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlConnection), 0, (GInstanceInitFunc) tracker_sparql_connection_instance_init, NULL };
	GType tracker_sparql_connection_type_id;
	tracker_sparql_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlConnection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return tracker_sparql_connection_type_id;
}

GType
tracker_sparql_connection_get_type (void)
{
	static volatile gsize tracker_sparql_connection_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_connection_type_id__once)) {
		GType tracker_sparql_connection_type_id;
		tracker_sparql_connection_type_id = tracker_sparql_connection_get_type_once ();
		g_once_init_leave (&tracker_sparql_connection_type_id__once, tracker_sparql_connection_type_id);
	}
	return tracker_sparql_connection_type_id__once;
}

