/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public final class InputStreamToXInputStreamAdapter
implements XInputStream {
    private final InputStream iIn;

    public InputStreamToXInputStreamAdapter(InputStream in) {
        this.iIn = in;
    }

    @Override
    public int available() throws IOException {
        int bytesAvail;
        try {
            bytesAvail = this.iIn.available();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        return bytesAvail;
    }

    @Override
    public void closeInput() throws IOException {
        try {
            this.iIn.close();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readBytes(byte[][] b, int len) throws IOException {
        try {
            long bytesRead;
            int totalBytesRead = 0;
            if (b[0] == null || b[0].length < len) {
                b[0] = new byte[len];
            }
            while (len > 0 && (bytesRead = (long)this.iIn.read(b[0], totalBytesRead, len)) > 0L) {
                totalBytesRead += (int)bytesRead;
                len -= (int)bytesRead;
            }
            if (totalBytesRead < b[0].length) {
                byte[] out = new byte[totalBytesRead];
                System.arraycopy(b[0], 0, out, 0, totalBytesRead);
                b[0] = out;
            }
            return totalBytesRead;
        }
        catch (java.io.IOException e) {
            throw new IOException("reader error", (Object)e);
        }
    }

    @Override
    public int readSomeBytes(byte[][] b, int len) throws IOException {
        try {
            long bytesRead;
            if (b[0] == null || b[0].length < len) {
                b[0] = new byte[len];
            }
            if ((bytesRead = len > this.iIn.available() ? (long)this.iIn.read(b[0], 0, this.iIn.available()) : (long)this.iIn.read(b[0], 0, len)) < (long)b[0].length) {
                int outSize = bytesRead > 0L ? (int)bytesRead : 0;
                byte[] out = new byte[outSize];
                System.arraycopy(b[0], 0, out, 0, outSize);
                b[0] = out;
            }
            if (bytesRead <= 0L) {
                return 0;
            }
            return (int)bytesRead;
        }
        catch (java.io.IOException e) {
            throw new IOException("reader error", (Object)e);
        }
    }

    @Override
    public void skipBytes(int n) throws IOException {
        try {
            this.iIn.available();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        do {
            try {
                n = (int)((long)n - this.iIn.skip(n));
            }
            catch (java.io.IOException e) {
                throw new IOException(e);
            }
        } while (n > 0);
    }
}

