/*
 * Decompiled with CFR 0.152.
 */
package mediathek.x11;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.JMenuItem;
import mediathek.config.MVConfig;
import mediathek.gui.actions.ChangeGlobalFontSetting;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.LinuxNotificationCenter;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGuiX11
extends MediathekGui {
    private static final Logger logger = LogManager.getLogger(MediathekGuiX11.class);

    public MediathekGuiX11() {
        this.setupX11WindowManagerClassName();
    }

    private void setupX11WindowManagerClassName() {
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "MediathekView");
        }
        catch (Exception e) {
            logger.error("Could not set awtAppClassName", (Throwable)e);
        }
    }

    @Override
    protected void installChangeGlobalFontSettingMenuEntry() {
        this.jMenuHilfe.addSeparator();
        ChangeGlobalFontSetting action = new ChangeGlobalFontSetting();
        JMenuItem item = this.jMenuHilfe.add(action);
        action.setMenuItem(item);
    }

    @Override
    protected INotificationCenter getNotificationCenter() {
        LinuxNotificationCenter notificationCenter = new LinuxNotificationCenter();
        if (notificationCenter.hasNativeSupport()) {
            return notificationCenter;
        }
        return new GenericNotificationCenter();
    }

    @Override
    protected void shutdownComputer() {
        String strShutdownCommand;
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_FREE_BSD) {
            strShutdownCommand = MVConfig.get(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN);
            if (strShutdownCommand.isEmpty()) {
                strShutdownCommand = "shutdown -h now";
                MVConfig.add(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "shutdown -h now");
            }
        } else {
            logger.error("shutdown command is unknown for this operating system");
            return;
        }
        try {
            logger.info("Shutdown: {}", (Object)strShutdownCommand);
            Runtime.getRuntime().exec(strShutdownCommand);
        }
        catch (IOException ex) {
            logger.error(ex);
        }
    }
}

