# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
UnitsAPI module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_unitsapi.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _UnitsAPI
else:
    import _UnitsAPI

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _UnitsAPI.delete_SwigPyIterator

    def value(self):
        return _UnitsAPI.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _UnitsAPI.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _UnitsAPI.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _UnitsAPI.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _UnitsAPI.SwigPyIterator_equal(self, x)

    def copy(self):
        return _UnitsAPI.SwigPyIterator_copy(self)

    def next(self):
        return _UnitsAPI.SwigPyIterator_next(self)

    def __next__(self):
        return _UnitsAPI.SwigPyIterator___next__(self)

    def previous(self):
        return _UnitsAPI.SwigPyIterator_previous(self)

    def advance(self, n):
        return _UnitsAPI.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _UnitsAPI.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _UnitsAPI.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _UnitsAPI.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _UnitsAPI.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _UnitsAPI.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _UnitsAPI.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _UnitsAPI:
_UnitsAPI.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _UnitsAPI.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Units
import OCC.Core.TCollection
import OCC.Core.TColStd

from enum import IntEnum
from OCC.Core.Exception import *

UnitsAPI_DEFAULT = _UnitsAPI.UnitsAPI_DEFAULT
UnitsAPI_SI = _UnitsAPI.UnitsAPI_SI
UnitsAPI_MDTV = _UnitsAPI.UnitsAPI_MDTV


class UnitsAPI_SystemUnits(IntEnum):
	UnitsAPI_DEFAULT = 0
	UnitsAPI_SI = 1
	UnitsAPI_MDTV = 2
UnitsAPI_DEFAULT = UnitsAPI_SystemUnits.UnitsAPI_DEFAULT
UnitsAPI_SI = UnitsAPI_SystemUnits.UnitsAPI_SI
UnitsAPI_MDTV = UnitsAPI_SystemUnits.UnitsAPI_MDTV

class unitsapi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AnyFromLS(*args):
        r"""
        Converts the local system units value to the local unit value. example: anyfromls(25.4,'in.') returns 1. if the localsystem is mdtv. note: aunit is also used to identify the type of physical quantity to convert.

        Parameters
        ----------
        aData: float
        aUnit: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_AnyFromLS(*args)

    @staticmethod
    def AnyFromSI(*args):
        r"""
        Converts the si system units value to the local unit value. example: anyfromsi(0.0254,'in.') returns 0.001 note: aunit is also used to identify the type of physical quantity to convert.

        Parameters
        ----------
        aData: float
        aUnit: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_AnyFromSI(*args)

    @staticmethod
    def AnyToAny(*args):
        r"""
        Converts the local unit value to another local unit value. example: anytoany(0.0254,'in.','millimeter') returns 1. ;.

        Parameters
        ----------
        aData: float
        aUnit1: char *
        aUnit2: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_AnyToAny(*args)

    @staticmethod
    def AnyToLS(*args):
        r"""
        Converts the local unit value to the local system units value. example: anytols(1.,'in.') returns 25.4 if the localsystem is mdtv.

        Parameters
        ----------
        aData: float
        aUnit: char *

        Returns
        -------
        float
        Converts the local unit value to the local system units value. and gives the associated dimension of the unit.

        Parameters
        ----------
        aData: float
        aUnit: char *
        aDim: Units_Dimensions

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_AnyToLS(*args)

    @staticmethod
    def AnyToSI(*args):
        r"""
        Converts the local unit value to the si system units value. example: anytosi(1.,'in.') returns 0.0254.

        Parameters
        ----------
        aData: float
        aUnit: char *

        Returns
        -------
        float
        Converts the local unit value to the si system units value. and gives the associated dimension of the unit.

        Parameters
        ----------
        aData: float
        aUnit: char *
        aDim: Units_Dimensions

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_AnyToSI(*args)

    @staticmethod
    def Check(*args):
        r"""
        Checks the coherence between the quantity <aquantity> and the unit <aunits> in the current system and returns false when it's wrong.

        Parameters
        ----------
        aQuantity: char *
        aUnit: char *

        Returns
        -------
        bool

        """
        return _UnitsAPI.unitsapi_Check(*args)

    @staticmethod
    def CurrentFromAny(*args):
        r"""
        Converts the adata value expressed in the unit aunit, into the current unit for the working environment, as defined for the physical quantity aquantity by the last call to the setcurrentunit function.

        Parameters
        ----------
        aData: float
        aQuantity: char *
        aUnit: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_CurrentFromAny(*args)

    @staticmethod
    def CurrentFromLS(*args):
        r"""
        Converts the local system units value to the current unit value. example: currentfromls(1000.,'length') returns 1. if current length unit is meter and localsystem is mdtv.

        Parameters
        ----------
        aData: float
        aQuantity: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_CurrentFromLS(*args)

    @staticmethod
    def CurrentFromSI(*args):
        r"""
        Converts the si system units value to the current unit value. example: currentfromsi(0.001,'length') returns 1 if current length unit is millimeter.

        Parameters
        ----------
        aData: float
        aQuantity: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_CurrentFromSI(*args)

    @staticmethod
    def CurrentToAny(*args):
        r"""
        Converts the adata value expressed in the current unit for the working environment, as defined for the physical quantity aquantity by the last call to the setcurrentunit function, into the unit aunit.

        Parameters
        ----------
        aData: float
        aQuantity: char *
        aUnit: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_CurrentToAny(*args)

    @staticmethod
    def CurrentToLS(*args):
        r"""
        Converts the current unit value to the local system units value. example: currenttols(1.,'length') returns 1000. if the current length unit is meter and localsystem is mdtv.

        Parameters
        ----------
        aData: float
        aQuantity: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_CurrentToLS(*args)

    @staticmethod
    def CurrentToSI(*args):
        r"""
        Converts the current unit value to the si system units value. example: currenttosi(1.,'length') returns 0.001 if current length unit is millimeter.

        Parameters
        ----------
        aData: float
        aQuantity: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_CurrentToSI(*args)

    @staticmethod
    def CurrentUnit(*args):
        r"""
        Returns the current unit dimension <aunit> from the unit quantity <aquantity>.

        Parameters
        ----------
        aQuantity: char *

        Returns
        -------
        char *

        """
        return _UnitsAPI.unitsapi_CurrentUnit(*args)

    @staticmethod
    def DimensionAmountOfSubstance(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionAmountOfSubstance(*args)

    @staticmethod
    def DimensionElectricCurrent(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionElectricCurrent(*args)

    @staticmethod
    def DimensionLength(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionLength(*args)

    @staticmethod
    def DimensionLess(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionLess(*args)

    @staticmethod
    def DimensionLuminousIntensity(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionLuminousIntensity(*args)

    @staticmethod
    def DimensionMass(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionMass(*args)

    @staticmethod
    def DimensionPlaneAngle(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionPlaneAngle(*args)

    @staticmethod
    def DimensionSolidAngle(*args):
        r"""
        Returns the basic dimensions.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionSolidAngle(*args)

    @staticmethod
    def DimensionThermodynamicTemperature(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionThermodynamicTemperature(*args)

    @staticmethod
    def DimensionTime(*args):
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_DimensionTime(*args)

    @staticmethod
    def Dimensions(*args):
        r"""
        Return the dimension associated to the quantity.

        Parameters
        ----------
        aQuantity: char *

        Returns
        -------
        opencascade::handle<Units_Dimensions>

        """
        return _UnitsAPI.unitsapi_Dimensions(*args)

    @staticmethod
    def LSToSI(*args):
        r"""
        Converts the local system units value to the si system unit value. example: lstosi(1.,'length') returns 0.001 if the local system length unit is millimeter.

        Parameters
        ----------
        aData: float
        aQuantity: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_LSToSI(*args)

    @staticmethod
    def LocalSystem(*args):
        r"""
        Returns the current local system units.

        Returns
        -------
        UnitsAPI_SystemUnits

        """
        return _UnitsAPI.unitsapi_LocalSystem(*args)

    @staticmethod
    def Reload(*args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _UnitsAPI.unitsapi_Reload(*args)

    @staticmethod
    def SIToLS(*args):
        r"""
        Converts the si system unit value to the local system units value. example: sitols(1.,'length') returns 1000. if the local system length unit is millimeter.

        Parameters
        ----------
        aData: float
        aQuantity: char *

        Returns
        -------
        float

        """
        return _UnitsAPI.unitsapi_SIToLS(*args)

    @staticmethod
    def Save(*args):
        r"""
        Saves the units in the file .currentunits of the directory pointed by the csf_currentunitsuserdefaults environment variable.

        Returns
        -------
        None

        """
        return _UnitsAPI.unitsapi_Save(*args)

    @staticmethod
    def SetCurrentUnit(*args):
        r"""
        Sets the current unit dimension <aunit> to the unit quantity <aquantity>. example: setcurrentunit('length','millimeter').

        Parameters
        ----------
        aQuantity: char *
        aUnit: char *

        Returns
        -------
        None

        """
        return _UnitsAPI.unitsapi_SetCurrentUnit(*args)

    @staticmethod
    def SetLocalSystem(*args):
        r"""
        Sets the local system units. example: setlocalsystem(unitsapi_mdtv).

        Parameters
        ----------
        aSystemUnit: UnitsAPI_SystemUnits,optional
        	default value is UnitsAPI_SI

        Returns
        -------
        None

        """
        return _UnitsAPI.unitsapi_SetLocalSystem(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _UnitsAPI.unitsapi_swiginit(self, _UnitsAPI.new_unitsapi())
    __swig_destroy__ = _UnitsAPI.delete_unitsapi

# Register unitsapi in _UnitsAPI:
_UnitsAPI.unitsapi_swigregister(unitsapi)



