/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.resthandler;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.observability.metrics.Metrics;
import org.opensearch.observability.model.BaseResponse;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestToXContentListener;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/observability/resthandler/RestResponseToXContentListener;", "Response", "Lorg/opensearch/observability/model/BaseResponse;", "Lorg/opensearch/rest/action/RestToXContentListener;", "channel", "Lorg/opensearch/rest/RestChannel;", "(Lorg/opensearch/rest/RestChannel;)V", "buildResponse", "Lorg/opensearch/rest/RestResponse;", "response", "builder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "(Lorg/opensearch/observability/model/BaseResponse;Lorg/opensearch/core/xcontent/XContentBuilder;)Lorg/opensearch/rest/RestResponse;", "getStatus", "Lorg/opensearch/rest/RestStatus;", "(Lorg/opensearch/observability/model/BaseResponse;)Lorg/opensearch/rest/RestStatus;", "opensearch-observability"})
public final class RestResponseToXContentListener<Response extends BaseResponse>
extends RestToXContentListener<Response> {
    public RestResponseToXContentListener(@NotNull RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(channel);
    }

    @NotNull
    public RestResponse buildResponse(@NotNull Response response, @Nullable XContentBuilder builder) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        super.buildResponse((ToXContentObject)response, builder);
        Metrics.REQUEST_TOTAL.getCounter().increment();
        Metrics.REQUEST_INTERVAL_COUNT.getCounter().increment();
        RestStatus restStatus = ((BaseResponse)((Object)response)).getStatus();
        int n = WhenMappings.$EnumSwitchMapping$0[restStatus.ordinal()];
        RestStatus restStatus2 = RestStatus.OK;
        boolean bl = restStatus.compareTo((Object)RestStatus.MULTI_STATUS) <= 0 ? 0 <= restStatus.compareTo((Object)restStatus2) : false;
        if (bl) {
            Metrics.REQUEST_SUCCESS.getCounter().increment();
        } else if (n == 1) {
            Metrics.OBSERVABILITY_SECURITY_PERMISSION_ERROR.getCounter().increment();
        } else {
            restStatus2 = RestStatus.UNAUTHORIZED;
            boolean bl2 = restStatus.compareTo((Object)RestStatus.TOO_MANY_REQUESTS) <= 0 ? 0 <= restStatus.compareTo((Object)restStatus2) : false;
            if (bl2) {
                Metrics.REQUEST_USER_ERROR.getCounter().increment();
            } else {
                Metrics.REQUEST_SYSTEM_ERROR.getCounter().increment();
            }
        }
        return (RestResponse)new BytesRestResponse(this.getStatus(response), builder);
    }

    @NotNull
    protected RestStatus getStatus(@NotNull Response response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        return ((BaseResponse)((Object)response)).getStatus();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestStatus.values().length];
            nArray[RestStatus.FORBIDDEN.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

