# This file has been autogenerated by the pywayland scanner

# Copyright © 2012, 2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .zwp_text_input_v1 import ZwpTextInputV1


class ZwpTextInputManagerV1(Interface):
    """Text input manager

    A factory for text_input objects. This object is a global singleton.
    """

    name = "zwp_text_input_manager_v1"
    version = 1


class ZwpTextInputManagerV1Proxy(Proxy[ZwpTextInputManagerV1]):
    interface = ZwpTextInputManagerV1

    @ZwpTextInputManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpTextInputV1),
    )
    def create_text_input(self) -> Proxy[ZwpTextInputV1]:
        """Create text input

        Creates a new text_input object.

        :returns:
            :class:`~pywayland.protocol.text_input_unstable_v1.ZwpTextInputV1`
        """
        id = self._marshal_constructor(0, ZwpTextInputV1)
        return id


class ZwpTextInputManagerV1Resource(Resource):
    interface = ZwpTextInputManagerV1


class ZwpTextInputManagerV1Global(Global):
    interface = ZwpTextInputManagerV1


ZwpTextInputManagerV1._gen_c()
ZwpTextInputManagerV1.proxy_class = ZwpTextInputManagerV1Proxy
ZwpTextInputManagerV1.resource_class = ZwpTextInputManagerV1Resource
ZwpTextInputManagerV1.global_class = ZwpTextInputManagerV1Global
