/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.constant.CommonValue;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.model.DataByFeatureId;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.model.ExpectedValueList;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class AnomalyResult
implements ToXContentObject,
Writeable {
    private static final Logger LOG = LogManager.getLogger(ThresholdingResult.class);
    public static final String PARSE_FIELD_NAME = "AnomalyResult";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(AnomalyResult.class, new ParseField("AnomalyResult", new String[0]), it -> AnomalyResult.parse(it));
    public static final String DETECTOR_ID_FIELD = "detector_id";
    public static final String ANOMALY_SCORE_FIELD = "anomaly_score";
    public static final String ANOMALY_GRADE_FIELD = "anomaly_grade";
    public static final String CONFIDENCE_FIELD = "confidence";
    public static final String FEATURE_DATA_FIELD = "feature_data";
    public static final String DATA_START_TIME_FIELD = "data_start_time";
    public static final String DATA_END_TIME_FIELD = "data_end_time";
    public static final String EXECUTION_START_TIME_FIELD = "execution_start_time";
    public static final String EXECUTION_END_TIME_FIELD = "execution_end_time";
    public static final String ERROR_FIELD = "error";
    public static final String ENTITY_FIELD = "entity";
    public static final String USER_FIELD = "user";
    public static final String TASK_ID_FIELD = "task_id";
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String APPROX_ANOMALY_START_FIELD = "approx_anomaly_start_time";
    public static final String RELEVANT_ATTRIBUTION_FIELD = "relevant_attribution";
    public static final String PAST_VALUES_FIELD = "past_values";
    public static final String EXPECTED_VALUES_FIELD = "expected_values";
    public static final String THRESHOLD_FIELD = "threshold";
    public static final String IS_ANOMALY_FIELD = "is_anomaly";
    private final String detectorId;
    private final String taskId;
    private final Double anomalyScore;
    private final Double anomalyGrade;
    private final Double confidence;
    private final List<FeatureData> featureData;
    private final Instant dataStartTime;
    private final Instant dataEndTime;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String error;
    private final Entity entity;
    private User user;
    private final Integer schemaVersion;
    private final String modelId;
    private final Instant approxAnomalyStartTime;
    private final List<DataByFeatureId> relevantAttribution;
    private final List<DataByFeatureId> pastValues;
    private final List<ExpectedValueList> expectedValuesList;
    private final Double threshold;

    public AnomalyResult(String detectorId, String taskId, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Entity entity, User user, Integer schemaVersion, String modelId) {
        this(detectorId, taskId, Double.NaN, Double.NaN, Double.NaN, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, modelId, null, null, null, null, null);
    }

    public AnomalyResult(String detectorId, String taskId, Double anomalyScore, Double anomalyGrade, Double confidence, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Entity entity, User user, Integer schemaVersion, String modelId, Instant approxAnomalyStartTime, List<DataByFeatureId> relevantAttribution, List<DataByFeatureId> pastValues, List<ExpectedValueList> expectedValuesList, Double threshold) {
        this.detectorId = detectorId;
        this.taskId = taskId;
        this.anomalyScore = anomalyScore;
        this.anomalyGrade = anomalyGrade;
        this.confidence = confidence;
        this.featureData = featureData;
        this.dataStartTime = dataStartTime;
        this.dataEndTime = dataEndTime;
        this.executionStartTime = executionStartTime;
        this.executionEndTime = executionEndTime;
        this.error = error;
        this.entity = entity;
        this.user = user;
        this.schemaVersion = schemaVersion;
        this.modelId = modelId;
        this.approxAnomalyStartTime = approxAnomalyStartTime;
        this.relevantAttribution = relevantAttribution;
        this.pastValues = pastValues;
        this.expectedValuesList = expectedValuesList;
        this.threshold = threshold;
    }

    public static AnomalyResult fromRawTRCFResult(String detectorId, long intervalMillis, String taskId, Double rcfScore, Double grade, Double confidence, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Entity entity, User user, Integer schemaVersion, String modelId, double[] relevantAttribution, Integer relativeIndex, double[] pastValues, double[][] expectedValuesList, double[] likelihoodOfValues, Double threshold) {
        ArrayList<DataByFeatureId> convertedRelevantAttribution = null;
        ArrayList<DataByFeatureId> convertedPastValuesList = null;
        ArrayList<ExpectedValueList> convertedExpectedValues = null;
        if (grade > 0.0) {
            int j;
            int featureSize = featureData.size();
            if (relevantAttribution != null) {
                if (relevantAttribution.length == featureSize) {
                    convertedRelevantAttribution = new ArrayList<DataByFeatureId>(featureSize);
                    for (j = 0; j < featureSize; ++j) {
                        convertedRelevantAttribution.add(new DataByFeatureId(featureData.get(j).getFeatureId(), relevantAttribution[j]));
                    }
                } else {
                    LOG.error((Message)new ParameterizedMessage("Attribution array size does not match.  Expected [{}] but got [{}]", (Object)featureSize, (Object)relevantAttribution.length));
                }
            }
            if (pastValues != null) {
                if (pastValues.length == featureSize) {
                    convertedPastValuesList = new ArrayList<DataByFeatureId>(featureSize);
                    for (j = 0; j < featureSize; ++j) {
                        convertedPastValuesList.add(new DataByFeatureId(featureData.get(j).getFeatureId(), pastValues[j]));
                    }
                } else {
                    LOG.error((Message)new ParameterizedMessage("Past value array size does not match.  Expected [{}] but got [{}]", (Object)featureSize, (Object)pastValues.length));
                }
            }
            if (expectedValuesList != null && expectedValuesList.length > 0) {
                int numberOfExpectedLists = expectedValuesList.length;
                int numberOfExpectedVals = expectedValuesList[0].length;
                if (numberOfExpectedVals == featureSize && likelihoodOfValues.length == numberOfExpectedLists) {
                    convertedExpectedValues = new ArrayList<ExpectedValueList>(numberOfExpectedLists);
                    for (int j2 = 0; j2 < numberOfExpectedLists; ++j2) {
                        ArrayList<DataByFeatureId> valueList = new ArrayList<DataByFeatureId>(featureSize);
                        for (int k = 0; k < featureSize; ++k) {
                            valueList.add(new DataByFeatureId(featureData.get(k).getFeatureId(), expectedValuesList[j2][k]));
                        }
                        convertedExpectedValues.add(new ExpectedValueList(likelihoodOfValues[j2], valueList));
                    }
                } else if (numberOfExpectedVals != featureSize) {
                    LOG.error((Message)new ParameterizedMessage("expected value array mismatch.  Expected [{}] actual [{}].", (Object)featureSize, (Object)numberOfExpectedVals));
                } else {
                    LOG.error((Message)new ParameterizedMessage("likelihood and expected array mismatch: Likelihood [{}] expected value [{}].", (Object)likelihoodOfValues.length, (Object)numberOfExpectedLists));
                }
            }
        }
        return new AnomalyResult(detectorId, taskId, rcfScore, grade, confidence, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, modelId, relativeIndex == null || dataStartTime == null ? null : Instant.ofEpochMilli(dataStartTime.toEpochMilli() + (long)relativeIndex.intValue() * intervalMillis), convertedRelevantAttribution, convertedPastValuesList, convertedExpectedValues, threshold);
    }

    public AnomalyResult(StreamInput input) throws IOException {
        this.detectorId = input.readString();
        this.anomalyScore = input.readDouble();
        this.anomalyGrade = input.readDouble();
        this.confidence = input.readDouble();
        int featureSize = input.readVInt();
        this.featureData = new ArrayList<FeatureData>(featureSize);
        for (int i = 0; i < featureSize; ++i) {
            this.featureData.add(new FeatureData(input));
        }
        this.dataStartTime = input.readInstant();
        this.dataEndTime = input.readInstant();
        this.executionStartTime = input.readInstant();
        this.executionEndTime = input.readInstant();
        this.error = input.readOptionalString();
        this.entity = input.readBoolean() ? new Entity(input) : null;
        this.user = input.readBoolean() ? new User(input) : null;
        this.schemaVersion = input.readInt();
        this.taskId = input.readOptionalString();
        this.modelId = input.readOptionalString();
        this.approxAnomalyStartTime = input.readOptionalInstant();
        int attributeNumber = input.readVInt();
        if (attributeNumber <= 0) {
            this.relevantAttribution = null;
        } else {
            this.relevantAttribution = new ArrayList<DataByFeatureId>(attributeNumber);
            for (int i = 0; i < attributeNumber; ++i) {
                this.relevantAttribution.add(new DataByFeatureId(input));
            }
        }
        int pastValueNumber = input.readVInt();
        if (pastValueNumber <= 0) {
            this.pastValues = null;
        } else {
            this.pastValues = new ArrayList<DataByFeatureId>(pastValueNumber);
            for (int i = 0; i < pastValueNumber; ++i) {
                this.pastValues.add(new DataByFeatureId(input));
            }
        }
        int expectedValuesNumber = input.readVInt();
        if (expectedValuesNumber <= 0) {
            this.expectedValuesList = null;
        } else {
            this.expectedValuesList = new ArrayList<ExpectedValueList>();
            for (int i = 0; i < expectedValuesNumber; ++i) {
                this.expectedValuesList.add(new ExpectedValueList(input));
            }
        }
        this.threshold = input.readOptionalDouble();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(DETECTOR_ID_FIELD, this.detectorId).field("schema_version", this.schemaVersion);
        if (this.dataStartTime != null) {
            xContentBuilder.field(DATA_START_TIME_FIELD, this.dataStartTime.toEpochMilli());
        }
        if (this.dataEndTime != null) {
            xContentBuilder.field(DATA_END_TIME_FIELD, this.dataEndTime.toEpochMilli());
        }
        if (this.featureData != null) {
            xContentBuilder.field(FEATURE_DATA_FIELD, (Object)this.featureData.toArray());
        }
        if (this.executionStartTime != null) {
            xContentBuilder.field(EXECUTION_START_TIME_FIELD, this.executionStartTime.toEpochMilli());
        }
        if (this.executionEndTime != null) {
            xContentBuilder.field(EXECUTION_END_TIME_FIELD, this.executionEndTime.toEpochMilli());
        }
        if (this.anomalyScore != null && !this.anomalyScore.isNaN()) {
            xContentBuilder.field(ANOMALY_SCORE_FIELD, this.anomalyScore);
        }
        if (this.anomalyGrade != null && !this.anomalyGrade.isNaN()) {
            xContentBuilder.field(ANOMALY_GRADE_FIELD, this.anomalyGrade);
        }
        if (this.confidence != null && !this.confidence.isNaN()) {
            xContentBuilder.field(CONFIDENCE_FIELD, this.confidence);
        }
        if (this.error != null) {
            xContentBuilder.field(ERROR_FIELD, this.error);
        }
        if (this.entity != null) {
            xContentBuilder.field(ENTITY_FIELD, (ToXContent)this.entity);
        }
        if (this.user != null) {
            xContentBuilder.field(USER_FIELD, (ToXContent)this.user);
        }
        if (this.taskId != null) {
            xContentBuilder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.modelId != null) {
            xContentBuilder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.anomalyGrade != null && this.anomalyGrade > 0.0) {
            if (this.approxAnomalyStartTime != null) {
                xContentBuilder.field(APPROX_ANOMALY_START_FIELD, this.approxAnomalyStartTime.toEpochMilli());
            }
            if (this.relevantAttribution != null) {
                xContentBuilder.array(RELEVANT_ATTRIBUTION_FIELD, this.relevantAttribution.toArray());
            }
            if (this.pastValues != null) {
                xContentBuilder.array(PAST_VALUES_FIELD, this.pastValues.toArray());
            }
            if (this.expectedValuesList != null) {
                xContentBuilder.array(EXPECTED_VALUES_FIELD, this.expectedValuesList.toArray());
            }
        }
        if (this.threshold != null && !this.threshold.isNaN()) {
            xContentBuilder.field(THRESHOLD_FIELD, this.threshold);
        }
        return xContentBuilder.endObject();
    }

    public static AnomalyResult parse(XContentParser parser) throws IOException {
        String detectorId = null;
        Double anomalyScore = null;
        Double anomalyGrade = null;
        Double confidence = null;
        ArrayList<FeatureData> featureData = new ArrayList<FeatureData>();
        Instant dataStartTime = null;
        Instant dataEndTime = null;
        Instant executionStartTime = null;
        Instant executionEndTime = null;
        String error = null;
        Entity entity = null;
        User user = null;
        Integer schemaVersion = CommonValue.NO_SCHEMA_VERSION;
        String taskId = null;
        String modelId = null;
        Instant approAnomalyStartTime = null;
        ArrayList<DataByFeatureId> relavantAttribution = new ArrayList<DataByFeatureId>();
        ArrayList<DataByFeatureId> pastValues = new ArrayList<DataByFeatureId>();
        ArrayList<ExpectedValueList> expectedValues = new ArrayList<ExpectedValueList>();
        Double threshold = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block44: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "detector_id": {
                    detectorId = parser.text();
                    continue block44;
                }
                case "anomaly_score": {
                    anomalyScore = parser.doubleValue();
                    continue block44;
                }
                case "anomaly_grade": {
                    anomalyGrade = parser.doubleValue();
                    continue block44;
                }
                case "confidence": {
                    confidence = parser.doubleValue();
                    continue block44;
                }
                case "feature_data": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        featureData.add(FeatureData.parse(parser));
                    }
                    continue block44;
                }
                case "data_start_time": {
                    dataStartTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "data_end_time": {
                    dataEndTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "execution_start_time": {
                    executionStartTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "execution_end_time": {
                    executionEndTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "error": {
                    error = parser.text();
                    continue block44;
                }
                case "entity": {
                    entity = Entity.parse(parser);
                    continue block44;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block44;
                }
                case "schema_version": {
                    schemaVersion = parser.intValue();
                    continue block44;
                }
                case "task_id": {
                    taskId = parser.text();
                    continue block44;
                }
                case "model_id": {
                    modelId = parser.text();
                    continue block44;
                }
                case "approx_anomaly_start_time": {
                    approAnomalyStartTime = ParseUtils.toInstant(parser);
                    continue block44;
                }
                case "relevant_attribution": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        relavantAttribution.add(DataByFeatureId.parse(parser));
                    }
                    continue block44;
                }
                case "past_values": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        pastValues.add(DataByFeatureId.parse(parser));
                    }
                    continue block44;
                }
                case "expected_values": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        expectedValues.add(ExpectedValueList.parse(parser));
                    }
                    continue block44;
                }
                case "threshold": {
                    threshold = parser.doubleValue();
                    continue block44;
                }
            }
            parser.skipChildren();
        }
        return new AnomalyResult(detectorId, taskId, anomalyScore, anomalyGrade, confidence, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, modelId, approAnomalyStartTime, relavantAttribution, pastValues, expectedValues, threshold);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyResult that = (AnomalyResult)o;
        return Objects.equal((Object)this.detectorId, (Object)that.detectorId) && Objects.equal((Object)this.taskId, (Object)that.taskId) && Objects.equal((Object)this.anomalyScore, (Object)that.anomalyScore) && Objects.equal((Object)this.anomalyGrade, (Object)that.anomalyGrade) && Objects.equal((Object)this.confidence, (Object)that.confidence) && Objects.equal(this.featureData, that.featureData) && Objects.equal((Object)this.dataStartTime, (Object)that.dataStartTime) && Objects.equal((Object)this.dataEndTime, (Object)that.dataEndTime) && Objects.equal((Object)this.executionStartTime, (Object)that.executionStartTime) && Objects.equal((Object)this.executionEndTime, (Object)that.executionEndTime) && Objects.equal((Object)this.error, (Object)that.error) && Objects.equal((Object)this.entity, (Object)that.entity) && Objects.equal((Object)this.modelId, (Object)that.modelId) && Objects.equal((Object)this.approxAnomalyStartTime, (Object)that.approxAnomalyStartTime) && Objects.equal(this.relevantAttribution, that.relevantAttribution) && Objects.equal(this.pastValues, that.pastValues) && Objects.equal(this.expectedValuesList, that.expectedValuesList) && Objects.equal((Object)this.threshold, (Object)that.threshold);
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.detectorId, this.taskId, this.anomalyScore, this.anomalyGrade, this.confidence, this.featureData, this.dataStartTime, this.dataEndTime, this.executionStartTime, this.executionEndTime, this.error, this.entity, this.modelId, this.approxAnomalyStartTime, this.relevantAttribution, this.pastValues, this.expectedValuesList, this.threshold});
    }

    @Generated
    public String toString() {
        return new ToStringBuilder((Object)this).append("detectorId", (Object)this.detectorId).append("taskId", (Object)this.taskId).append("anomalyScore", (Object)this.anomalyScore).append("anomalyGrade", (Object)this.anomalyGrade).append(CONFIDENCE_FIELD, (Object)this.confidence).append("featureData", this.featureData).append("dataStartTime", (Object)this.dataStartTime).append("dataEndTime", (Object)this.dataEndTime).append("executionStartTime", (Object)this.executionStartTime).append("executionEndTime", (Object)this.executionEndTime).append(ERROR_FIELD, (Object)this.error).append(ENTITY_FIELD, (Object)this.entity).append("modelId", (Object)this.modelId).append("approAnomalyStartTime", (Object)this.approxAnomalyStartTime).append("relavantAttribution", this.relevantAttribution).append("pastValues", this.pastValues).append("expectedValuesList", (Object)StringUtils.join(this.expectedValuesList, (String)"|")).append(THRESHOLD_FIELD, (Object)this.threshold).toString();
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Double getAnomalyScore() {
        return this.anomalyScore;
    }

    public Double getAnomalyGrade() {
        return this.anomalyGrade;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public List<FeatureData> getFeatureData() {
        return this.featureData;
    }

    public Instant getDataStartTime() {
        return this.dataStartTime;
    }

    public Instant getDataEndTime() {
        return this.dataEndTime;
    }

    public Instant getExecutionStartTime() {
        return this.executionStartTime;
    }

    public Instant getExecutionEndTime() {
        return this.executionEndTime;
    }

    public String getError() {
        return this.error;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getModelId() {
        return this.modelId;
    }

    public Instant getApproAnomalyStartTime() {
        return this.approxAnomalyStartTime;
    }

    public List<DataByFeatureId> getRelavantAttribution() {
        return this.relevantAttribution;
    }

    public List<DataByFeatureId> getPastValues() {
        return this.pastValues;
    }

    public List<ExpectedValueList> getExpectedValuesList() {
        return this.expectedValuesList;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public boolean isHighPriority() {
        return this.getAnomalyGrade() != null && this.getAnomalyGrade() > 0.0 || this.getError() != null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorId);
        out.writeDouble(this.anomalyScore.doubleValue());
        out.writeDouble(this.anomalyGrade.doubleValue());
        out.writeDouble(this.confidence.doubleValue());
        out.writeVInt(this.featureData.size());
        for (FeatureData featureData : this.featureData) {
            featureData.writeTo(out);
        }
        out.writeInstant(this.dataStartTime);
        out.writeInstant(this.dataEndTime);
        out.writeInstant(this.executionStartTime);
        out.writeInstant(this.executionEndTime);
        out.writeOptionalString(this.error);
        if (this.entity != null) {
            out.writeBoolean(true);
            this.entity.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.schemaVersion.intValue());
        out.writeOptionalString(this.taskId);
        out.writeOptionalString(this.modelId);
        out.writeOptionalInstant(this.approxAnomalyStartTime);
        if (this.relevantAttribution != null) {
            out.writeVInt(this.relevantAttribution.size());
            for (DataByFeatureId dataByFeatureId : this.relevantAttribution) {
                dataByFeatureId.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.pastValues != null) {
            out.writeVInt(this.pastValues.size());
            for (DataByFeatureId dataByFeatureId : this.pastValues) {
                dataByFeatureId.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.expectedValuesList != null) {
            out.writeVInt(this.expectedValuesList.size());
            for (ExpectedValueList expectedValueList : this.expectedValuesList) {
                expectedValueList.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeOptionalDouble(this.threshold);
    }

    public static AnomalyResult getDummyResult() {
        return new AnomalyResult("dummy_detector_id", null, null, null, null, null, null, null, null, null, CommonValue.NO_SCHEMA_VERSION, null);
    }
}

