/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Map;
import org.opensearch.ad.model.DetectorValidationIssueType;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.model.ValidationAspect;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class DetectorValidationIssue
implements ToXContentObject,
Writeable {
    private static final String MESSAGE_FIELD = "message";
    private static final String SUGGESTED_FIELD_NAME = "suggested_value";
    private static final String SUB_ISSUES_FIELD_NAME = "sub_issues";
    private final ValidationAspect aspect;
    private final DetectorValidationIssueType type;
    private final String message;
    private Map<String, String> subIssues;
    private IntervalTimeConfiguration intervalSuggestion;

    public ValidationAspect getAspect() {
        return this.aspect;
    }

    public DetectorValidationIssueType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getSubIssues() {
        return this.subIssues;
    }

    public IntervalTimeConfiguration getIntervalSuggestion() {
        return this.intervalSuggestion;
    }

    public DetectorValidationIssue(ValidationAspect aspect, DetectorValidationIssueType type, String message, Map<String, String> subIssues, IntervalTimeConfiguration intervalSuggestion) {
        this.aspect = aspect;
        this.type = type;
        this.message = message;
        this.subIssues = subIssues;
        this.intervalSuggestion = intervalSuggestion;
    }

    public DetectorValidationIssue(ValidationAspect aspect, DetectorValidationIssueType type, String message) {
        this(aspect, type, message, null, null);
    }

    public DetectorValidationIssue(StreamInput input) throws IOException {
        this.aspect = (ValidationAspect)input.readEnum(ValidationAspect.class);
        this.type = (DetectorValidationIssueType)input.readEnum(DetectorValidationIssueType.class);
        this.message = input.readString();
        if (input.readBoolean()) {
            this.subIssues = input.readMap(StreamInput::readString, StreamInput::readString);
        }
        if (input.readBoolean()) {
            this.intervalSuggestion = IntervalTimeConfiguration.readFrom(input);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.aspect);
        out.writeEnum((Enum)this.type);
        out.writeString(this.message);
        if (this.subIssues != null && !this.subIssues.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.subIssues, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.intervalSuggestion != null) {
            out.writeBoolean(true);
            this.intervalSuggestion.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().startObject(this.type.getName());
        xContentBuilder.field(MESSAGE_FIELD, this.message);
        if (this.subIssues != null) {
            XContentBuilder subIssuesBuilder = xContentBuilder.startObject(SUB_ISSUES_FIELD_NAME);
            for (Map.Entry<String, String> entry : this.subIssues.entrySet()) {
                subIssuesBuilder.field(entry.getKey(), entry.getValue());
            }
            subIssuesBuilder.endObject();
        }
        if (this.intervalSuggestion != null) {
            xContentBuilder.field(SUGGESTED_FIELD_NAME, (ToXContent)this.intervalSuggestion);
        }
        return xContentBuilder.endObject().endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectorValidationIssue anotherIssue = (DetectorValidationIssue)o;
        return Objects.equal((Object)this.getAspect(), (Object)anotherIssue.getAspect()) && Objects.equal((Object)this.getMessage(), (Object)anotherIssue.getMessage()) && Objects.equal(this.getSubIssues(), anotherIssue.getSubIssues()) && Objects.equal((Object)this.getIntervalSuggestion(), (Object)anotherIssue.getIntervalSuggestion()) && Objects.equal((Object)this.getType(), (Object)anotherIssue.getType());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.aspect, this.message, this.subIssues, this.subIssues, this.type});
    }
}

