/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest.handler;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ad.common.exception.ADValidationException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.feature.SearchFeatureDao;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.DetectorValidationIssueType;
import org.opensearch.ad.model.Feature;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.model.MergeableList;
import org.opensearch.ad.model.TimeConfiguration;
import org.opensearch.ad.model.ValidationAspect;
import org.opensearch.ad.rest.handler.AbstractAnomalyDetectorActionHandler;
import org.opensearch.ad.rest.handler.AnomalyDetectorActionHandler;
import org.opensearch.ad.transport.ValidateAnomalyDetectorResponse;
import org.opensearch.ad.util.MultiResponsesDelegateActionListener;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.SecurityClientUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregatorBuilders;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortOrder;

public class ModelValidationActionHandler {
    protected static final String AGG_NAME_TOP = "top_agg";
    protected static final String AGGREGATION = "agg";
    protected final AnomalyDetector anomalyDetector;
    protected final ClusterService clusterService;
    protected final Logger logger = LogManager.getLogger(AbstractAnomalyDetectorActionHandler.class);
    protected final TimeValue requestTimeout;
    protected final AnomalyDetectorActionHandler handler = new AnomalyDetectorActionHandler();
    protected final Client client;
    protected final SecurityClientUtil clientUtil;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ActionListener<ValidateAnomalyDetectorResponse> listener;
    protected final SearchFeatureDao searchFeatureDao;
    protected final Clock clock;
    protected final String validationType;
    protected final Settings settings;
    protected final User user;

    public ModelValidationActionHandler(ClusterService clusterService, Client client, SecurityClientUtil clientUtil, ActionListener<ValidateAnomalyDetectorResponse> listener, AnomalyDetector anomalyDetector, TimeValue requestTimeout, NamedXContentRegistry xContentRegistry, SearchFeatureDao searchFeatureDao, String validationType, Clock clock, Settings settings, User user) {
        this.clusterService = clusterService;
        this.client = client;
        this.clientUtil = clientUtil;
        this.listener = listener;
        this.anomalyDetector = anomalyDetector;
        this.requestTimeout = requestTimeout;
        this.xContentRegistry = xContentRegistry;
        this.searchFeatureDao = searchFeatureDao;
        this.validationType = validationType;
        this.clock = clock;
        this.settings = settings;
        this.user = user;
    }

    public void checkIfMultiEntityDetector() {
        ActionListener recommendationListener = ActionListener.wrap(topEntity -> this.getLatestDateForValidation((Map<String, Object>)topEntity), exception -> {
            this.listener.onFailure(exception);
            this.logger.error("Failed to get top entity for categorical field", (Throwable)exception);
        });
        if (this.anomalyDetector.isMultientityDetector()) {
            this.getTopEntity((ActionListener<Map<String, Object>>)recommendationListener);
        } else {
            recommendationListener.onResponse(Collections.emptyMap());
        }
    }

    private void getTopEntity(ActionListener<Map<String, Object>> topEntityListener) {
        long maxIntervalInMinutes = Math.max(60L, this.anomalyDetector.getDetectorIntervalInMinutes());
        LongBounds timeRangeBounds = this.getTimeRangeBounds(Instant.now().toEpochMilli(), new IntervalTimeConfiguration(maxIntervalInMinutes, ChronoUnit.MINUTES));
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(this.anomalyDetector.getTimeField()).from((Object)timeRangeBounds.getMin()).to((Object)timeRangeBounds.getMax());
        HashMap topKeys = new HashMap();
        Object bucketAggs = this.anomalyDetector.getCategoryField().size() == 1 ? ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_NAME_TOP).field(this.anomalyDetector.getCategoryField().get(0))).order(BucketOrder.count((boolean)true)) : AggregationBuilders.composite((String)AGG_NAME_TOP, this.anomalyDetector.getCategoryField().stream().map(f -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(f).field(f)).collect(Collectors.toList())).size(1000).subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSort((String)"bucketSort", Collections.singletonList((FieldSortBuilder)new FieldSortBuilder("_count").order(SortOrder.DESC))).size(Integer.valueOf(1)));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)rangeQuery).aggregation((AggregationBuilder)bucketAggs).trackTotalHits(false).size(0);
        SearchRequest searchRequest = new SearchRequest().indices(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> {
            Aggregations aggs = response.getAggregations();
            if (aggs == null) {
                topEntityListener.onResponse(Collections.emptyMap());
                return;
            }
            if (this.anomalyDetector.getCategoryField().size() == 1) {
                Terms entities = (Terms)aggs.get(AGG_NAME_TOP);
                Object key = entities.getBuckets().stream().max(Comparator.comparingInt(entry -> (int)entry.getDocCount())).map(MultiBucketsAggregation.Bucket::getKeyAsString).orElse(null);
                topKeys.put(this.anomalyDetector.getCategoryField().get(0), key);
            } else {
                CompositeAggregation compositeAgg = (CompositeAggregation)aggs.get(AGG_NAME_TOP);
                topKeys.putAll(compositeAgg.getBuckets().stream().flatMap(bucket -> bucket.getKey().entrySet().stream()).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue())));
            }
            for (Map.Entry entry2 : topKeys.entrySet()) {
                if (entry2.getValue() != null) continue;
                topEntityListener.onResponse(Collections.emptyMap());
                return;
            }
            topEntityListener.onResponse((Object)topKeys);
        }, arg_0 -> topEntityListener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
    }

    private void getLatestDateForValidation(Map<String, Object> topEntity) {
        ActionListener latestTimeListener = ActionListener.wrap(latest -> this.getSampleRangesForValidationChecks((Optional<Long>)latest, this.anomalyDetector, this.listener, topEntity), exception -> {
            this.listener.onFailure(exception);
            this.logger.error("Failed to create search request for last data point", (Throwable)exception);
        });
        this.searchFeatureDao.getLatestDataTime(this.anomalyDetector, (ActionListener<Optional<Long>>)latestTimeListener);
    }

    private void getSampleRangesForValidationChecks(Optional<Long> latestTime, AnomalyDetector detector, ActionListener<ValidateAnomalyDetectorResponse> listener, Map<String, Object> topEntity) {
        if (!latestTime.isPresent() || latestTime.get() <= 0L) {
            listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.TIME_FIELD_NOT_ENOUGH_HISTORICAL_DATA, DetectorValidationIssueType.TIMEFIELD_FIELD, ValidationAspect.MODEL));
            return;
        }
        long timeRangeEnd = Math.min(Instant.now().toEpochMilli(), latestTime.get());
        try {
            this.getBucketAggregates(timeRangeEnd, listener, topEntity);
        }
        catch (IOException e) {
            listener.onFailure((Exception)new EndRunException(detector.getDetectorId(), "Invalid search query.", e, true));
        }
    }

    private void getBucketAggregates(long latestTime, ActionListener<ValidateAnomalyDetectorResponse> listener, Map<String, Object> topEntity) throws IOException {
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime, (IntervalTimeConfiguration)this.anomalyDetector.getDetectionInterval());
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.anomalyDetector.getFilterQuery());
        if (this.anomalyDetector.isMultientityDetector()) {
            if (topEntity.isEmpty()) {
                listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.CATEGORY_FIELD_TOO_SPARSE, DetectorValidationIssueType.CATEGORY, ValidationAspect.MODEL));
                return;
            }
            for (Map.Entry<String, Object> entry : topEntity.entrySet()) {
                query.filter((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).aggregation(aggregation).size(0).timeout(this.requestTimeout);
        SearchRequest searchRequest = new SearchRequest(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener intervalListener = ActionListener.wrap(interval -> this.processIntervalRecommendation((IntervalTimeConfiguration)interval, latestTime), exception -> {
            listener.onFailure(exception);
            this.logger.error("Failed to get interval recommendation", (Throwable)exception);
        });
        DetectorIntervalRecommendationListener searchResponseListener = new DetectorIntervalRecommendationListener((ActionListener<IntervalTimeConfiguration>)intervalListener, searchRequest.source(), (IntervalTimeConfiguration)this.anomalyDetector.getDetectionInterval(), this.clock.millis() + 10000L, latestTime, false, 10);
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
    }

    private double processBucketAggregationResults(Histogram buckets) {
        int docCountOverOne = 0;
        for (Histogram.Bucket entry : buckets.getBuckets()) {
            if (entry.getDocCount() <= 0L) continue;
            ++docCountOverOne;
        }
        return (double)docCountOverOne / (double)this.getNumberOfSamples();
    }

    private void processIntervalRecommendation(IntervalTimeConfiguration interval, long latestTime) {
        if (interval == null) {
            this.checkRawDataSparsity(latestTime);
        } else {
            if (interval.equals(this.anomalyDetector.getDetectionInterval())) {
                this.logger.info("Using the current interval there is enough dense data ");
                if (Instant.now().toEpochMilli() - latestTime > this.timeConfigToMilliSec(this.anomalyDetector.getWindowDelay())) {
                    this.sendWindowDelayRec(latestTime);
                    return;
                }
                this.listener.onResponse(null);
                return;
            }
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.DETECTOR_INTERVAL_REC + interval.getInterval(), DetectorValidationIssueType.DETECTION_INTERVAL, ValidationAspect.MODEL, interval));
        }
    }

    private AggregationBuilder getBucketAggregation(long latestTime, IntervalTimeConfiguration detectorInterval) {
        return ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)AGGREGATION).field(this.anomalyDetector.getTimeField())).minDocCount(1L).hardBounds(this.getTimeRangeBounds(latestTime, detectorInterval)).fixedInterval(DateHistogramInterval.minutes((int)((int)IntervalTimeConfiguration.getIntervalInMinute(detectorInterval))));
    }

    private SearchSourceBuilder getSearchSourceBuilder(QueryBuilder query, AggregationBuilder aggregation) {
        return new SearchSourceBuilder().query(query).aggregation(aggregation).size(0).timeout(this.requestTimeout);
    }

    private void checkRawDataSparsity(long latestTime) {
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime, (IntervalTimeConfiguration)this.anomalyDetector.getDetectionInterval());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().aggregation(aggregation).size(0).timeout(this.requestTimeout);
        SearchRequest searchRequest = new SearchRequest(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> this.processRawDataResults((SearchResponse)response, latestTime), arg_0 -> this.listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
    }

    private Histogram checkBucketResultErrors(SearchResponse response) {
        Aggregations aggs = response.getAggregations();
        if (aggs == null) {
            this.logger.warn("Unexpected null aggregation.");
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.MODEL_VALIDATION_FAILED_UNEXPECTEDLY, DetectorValidationIssueType.AGGREGATION, ValidationAspect.MODEL));
            return null;
        }
        Histogram aggregate = (Histogram)aggs.get(AGGREGATION);
        if (aggregate == null) {
            this.listener.onFailure((Exception)new IllegalArgumentException("Failed to find valid aggregation result"));
            return null;
        }
        return aggregate;
    }

    private void processRawDataResults(SearchResponse response, long latestTime) {
        Histogram aggregate = this.checkBucketResultErrors(response);
        if (aggregate == null) {
            return;
        }
        double fullBucketRate = this.processBucketAggregationResults(aggregate);
        if (fullBucketRate < 0.75) {
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.RAW_DATA_TOO_SPARSE, DetectorValidationIssueType.INDICES, ValidationAspect.MODEL));
        } else {
            this.checkDataFilterSparsity(latestTime);
        }
    }

    private void checkDataFilterSparsity(long latestTime) {
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime, (IntervalTimeConfiguration)this.anomalyDetector.getDetectionInterval());
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.anomalyDetector.getFilterQuery());
        SearchSourceBuilder searchSourceBuilder = this.getSearchSourceBuilder((QueryBuilder)query, aggregation);
        SearchRequest searchRequest = new SearchRequest(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> this.processDataFilterResults((SearchResponse)response, latestTime), arg_0 -> this.listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
    }

    private void processDataFilterResults(SearchResponse response, long latestTime) {
        Histogram aggregate = this.checkBucketResultErrors(response);
        if (aggregate == null) {
            return;
        }
        double fullBucketRate = this.processBucketAggregationResults(aggregate);
        if (fullBucketRate < 0.25) {
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.FILTER_QUERY_TOO_SPARSE, DetectorValidationIssueType.FILTER_QUERY, ValidationAspect.MODEL));
        } else if (this.anomalyDetector.isMultientityDetector()) {
            this.getTopEntityForCategoryField(latestTime);
        } else {
            try {
                this.checkFeatureQueryDelegate(latestTime);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
                this.listener.onFailure(ex);
            }
        }
    }

    private void getTopEntityForCategoryField(long latestTime) {
        ActionListener getTopEntityListener = ActionListener.wrap(topEntity -> this.checkCategoryFieldSparsity((Map<String, Object>)topEntity, latestTime), exception -> {
            this.listener.onFailure(exception);
            this.logger.error("Failed to get top entity for categorical field", (Throwable)exception);
        });
        this.getTopEntity((ActionListener<Map<String, Object>>)getTopEntityListener);
    }

    private void checkCategoryFieldSparsity(Map<String, Object> topEntity, long latestTime) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.anomalyDetector.getFilterQuery());
        for (Map.Entry<String, Object> entry : topEntity.entrySet()) {
            query.filter((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (Object)entry.getValue()));
        }
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime, (IntervalTimeConfiguration)this.anomalyDetector.getDetectionInterval());
        SearchSourceBuilder searchSourceBuilder = this.getSearchSourceBuilder((QueryBuilder)query, aggregation);
        SearchRequest searchRequest = new SearchRequest(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> this.processTopEntityResults((SearchResponse)response, latestTime), arg_0 -> this.listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
    }

    private void processTopEntityResults(SearchResponse response, long latestTime) {
        Histogram aggregate = this.checkBucketResultErrors(response);
        if (aggregate == null) {
            return;
        }
        double fullBucketRate = this.processBucketAggregationResults(aggregate);
        if (fullBucketRate < 0.25) {
            this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.CATEGORY_FIELD_TOO_SPARSE, DetectorValidationIssueType.CATEGORY, ValidationAspect.MODEL));
        } else {
            try {
                this.checkFeatureQueryDelegate(latestTime);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
                this.listener.onFailure(ex);
            }
        }
    }

    private void checkFeatureQueryDelegate(long latestTime) throws IOException {
        ActionListener validateFeatureQueriesListener = ActionListener.wrap(response -> this.windowDelayRecommendation(latestTime), exception -> this.listener.onFailure((Exception)new ADValidationException(exception.getMessage(), DetectorValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.MODEL)));
        MultiResponsesDelegateActionListener multiFeatureQueriesResponseListener = new MultiResponsesDelegateActionListener(validateFeatureQueriesListener, this.anomalyDetector.getFeatureAttributes().size(), CommonErrorMessages.FEATURE_QUERY_TOO_SPARSE, false);
        for (Feature feature : this.anomalyDetector.getFeatureAttributes()) {
            AggregationBuilder aggregation = this.getBucketAggregation(latestTime, (IntervalTimeConfiguration)this.anomalyDetector.getDetectionInterval());
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.anomalyDetector.getFilterQuery());
            List<String> featureFields = ParseUtils.getFieldNamesForFeature(feature, this.xContentRegistry);
            for (String featureField : featureFields) {
                query.filter((QueryBuilder)QueryBuilders.existsQuery((String)featureField));
            }
            SearchSourceBuilder searchSourceBuilder = this.getSearchSourceBuilder((QueryBuilder)query, aggregation);
            SearchRequest searchRequest = new SearchRequest(this.anomalyDetector.getIndices().toArray(new String[0])).source(searchSourceBuilder);
            ActionListener searchResponseListener = ActionListener.wrap(response -> {
                Histogram aggregate = this.checkBucketResultErrors((SearchResponse)response);
                if (aggregate == null) {
                    return;
                }
                double fullBucketRate = this.processBucketAggregationResults(aggregate);
                if (fullBucketRate < 0.25) {
                    multiFeatureQueriesResponseListener.onFailure(new ADValidationException(CommonErrorMessages.FEATURE_QUERY_TOO_SPARSE, DetectorValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.MODEL));
                } else {
                    multiFeatureQueriesResponseListener.onResponse(new MergeableList<double[]>(new ArrayList<double[]>(Collections.singletonList(new double[]{fullBucketRate}))));
                }
            }, e -> {
                this.logger.error(e);
                multiFeatureQueriesResponseListener.onFailure((Exception)new OpenSearchStatusException(CommonErrorMessages.FEATURE_QUERY_TOO_SPARSE, RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
            });
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, searchResponseListener);
        }
    }

    private void sendWindowDelayRec(long latestTimeInMillis) {
        long minutesSinceLastStamp = (long)Math.ceil((double)(Instant.now().toEpochMilli() - latestTimeInMillis) / 60000.0);
        this.listener.onFailure((Exception)new ADValidationException(String.format(Locale.ROOT, CommonErrorMessages.WINDOW_DELAY_REC, minutesSinceLastStamp, minutesSinceLastStamp), DetectorValidationIssueType.WINDOW_DELAY, ValidationAspect.MODEL, new IntervalTimeConfiguration(minutesSinceLastStamp, ChronoUnit.MINUTES)));
    }

    private void windowDelayRecommendation(long latestTime) {
        if (Instant.now().toEpochMilli() - latestTime > this.timeConfigToMilliSec(this.anomalyDetector.getWindowDelay())) {
            this.sendWindowDelayRec(latestTime);
            return;
        }
        this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.RAW_DATA_TOO_SPARSE, DetectorValidationIssueType.INDICES, ValidationAspect.MODEL));
    }

    private LongBounds getTimeRangeBounds(long endMillis, IntervalTimeConfiguration detectorIntervalInMinutes) {
        Long detectorInterval = this.timeConfigToMilliSec(detectorIntervalInMinutes);
        Long startMillis = endMillis - (long)this.getNumberOfSamples() * detectorInterval;
        return new LongBounds(startMillis, Long.valueOf(endMillis));
    }

    private int getNumberOfSamples() {
        long interval = this.anomalyDetector.getDetectorIntervalInMilliseconds();
        return Math.max((int)(Duration.ofHours(24L).toMillis() / interval), 512);
    }

    private Long timeConfigToMilliSec(TimeConfiguration config) {
        return Optional.ofNullable((IntervalTimeConfiguration)config).map(t -> t.toDuration().toMillis()).orElse(0L);
    }

    class DetectorIntervalRecommendationListener
    implements ActionListener<SearchResponse> {
        private final ActionListener<IntervalTimeConfiguration> intervalListener;
        SearchSourceBuilder searchSourceBuilder;
        IntervalTimeConfiguration detectorInterval;
        private final long expirationEpochMs;
        private final long latestTime;
        boolean decreasingInterval;
        int numTimesDecreasing;

        DetectorIntervalRecommendationListener(ActionListener<IntervalTimeConfiguration> intervalListener, SearchSourceBuilder searchSourceBuilder, IntervalTimeConfiguration detectorInterval, long expirationEpochMs, long latestTime, boolean decreasingInterval, int numTimesDecreasing) {
            this.intervalListener = intervalListener;
            this.searchSourceBuilder = searchSourceBuilder;
            this.detectorInterval = detectorInterval;
            this.expirationEpochMs = expirationEpochMs;
            this.latestTime = latestTime;
            this.decreasingInterval = decreasingInterval;
            this.numTimesDecreasing = numTimesDecreasing;
        }

        public void onResponse(SearchResponse response) {
            try {
                Histogram aggregate = ModelValidationActionHandler.this.checkBucketResultErrors(response);
                if (aggregate == null) {
                    return;
                }
                long newIntervalMinute = this.decreasingInterval ? (long)Math.floor((double)IntervalTimeConfiguration.getIntervalInMinute(this.detectorInterval) * 0.8) : (long)Math.ceil((double)IntervalTimeConfiguration.getIntervalInMinute(this.detectorInterval) * 1.2);
                double fullBucketRate = ModelValidationActionHandler.this.processBucketAggregationResults(aggregate);
                if (fullBucketRate > 0.75) {
                    this.intervalListener.onResponse((Object)this.detectorInterval);
                } else if (this.expirationEpochMs < ModelValidationActionHandler.this.clock.millis()) {
                    ModelValidationActionHandler.this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.TIMEOUT_ON_INTERVAL_REC, DetectorValidationIssueType.TIMEOUT, ValidationAspect.MODEL));
                    ModelValidationActionHandler.this.logger.info(CommonErrorMessages.TIMEOUT_ON_INTERVAL_REC);
                } else if (newIntervalMinute < 60L && !this.decreasingInterval) {
                    this.searchWithDifferentInterval(newIntervalMinute);
                } else if (newIntervalMinute >= 60L && !this.decreasingInterval) {
                    IntervalTimeConfiguration givenInterval = (IntervalTimeConfiguration)ModelValidationActionHandler.this.anomalyDetector.getDetectionInterval();
                    this.detectorInterval = new IntervalTimeConfiguration((long)Math.floor((double)IntervalTimeConfiguration.getIntervalInMinute(givenInterval) * 0.8), ChronoUnit.MINUTES);
                    if (this.detectorInterval.getInterval() <= 0L) {
                        this.intervalListener.onResponse(null);
                        return;
                    }
                    this.decreasingInterval = true;
                    --this.numTimesDecreasing;
                    SearchSourceBuilder updatedSearchSourceBuilder = ModelValidationActionHandler.this.getSearchSourceBuilder(this.searchSourceBuilder.query(), ModelValidationActionHandler.this.getBucketAggregation(this.latestTime, new IntervalTimeConfiguration(newIntervalMinute, ChronoUnit.MINUTES)));
                    ModelValidationActionHandler.this.clientUtil.asyncRequestWithInjectedSecurity(new SearchRequest().indices(ModelValidationActionHandler.this.anomalyDetector.getIndices().toArray(new String[0])).source(updatedSearchSourceBuilder), (arg_0, arg_1) -> ((Client)ModelValidationActionHandler.this.client).search(arg_0, arg_1), ModelValidationActionHandler.this.user, ModelValidationActionHandler.this.client, this);
                } else if (this.numTimesDecreasing >= 0 && newIntervalMinute > 0L) {
                    --this.numTimesDecreasing;
                    this.searchWithDifferentInterval(newIntervalMinute);
                } else {
                    this.intervalListener.onResponse(null);
                }
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        private void searchWithDifferentInterval(long newIntervalMinuteValue) {
            this.detectorInterval = new IntervalTimeConfiguration(newIntervalMinuteValue, ChronoUnit.MINUTES);
            SearchSourceBuilder updatedSearchSourceBuilder = ModelValidationActionHandler.this.getSearchSourceBuilder(this.searchSourceBuilder.query(), ModelValidationActionHandler.this.getBucketAggregation(this.latestTime, new IntervalTimeConfiguration(newIntervalMinuteValue, ChronoUnit.MINUTES)));
            ModelValidationActionHandler.this.clientUtil.asyncRequestWithInjectedSecurity(new SearchRequest().indices(ModelValidationActionHandler.this.anomalyDetector.getIndices().toArray(new String[0])).source(updatedSearchSourceBuilder), (arg_0, arg_1) -> ((Client)ModelValidationActionHandler.this.client).search(arg_0, arg_1), ModelValidationActionHandler.this.user, ModelValidationActionHandler.this.client, this);
        }

        public void onFailure(Exception e) {
            ModelValidationActionHandler.this.logger.error("Failed to recommend new interval", (Throwable)e);
            ModelValidationActionHandler.this.listener.onFailure((Exception)new ADValidationException(CommonErrorMessages.MODEL_VALIDATION_FAILED_UNEXPECTEDLY, DetectorValidationIssueType.AGGREGATION, ValidationAspect.MODEL));
        }
    }
}

