/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.transport;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.util.ThreadIDUtil;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportResponse;

public class PerformanceAnalyzerTransportChannel
implements TransportChannel,
MetricsProcessor {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerTransportChannel.class);
    private static final int KEYS_PATH_LENGTH = 3;
    private static final AtomicLong UNIQUE_ID = new AtomicLong(0L);
    private TransportChannel original;
    private String indexName;
    private int shardId;
    private boolean primary;
    private String id;
    private String threadID;

    void set(TransportChannel original, long startTime, String indexName, int shardId, int itemCount, boolean bPrimary) {
        this.original = original;
        this.id = String.valueOf(UNIQUE_ID.getAndIncrement());
        this.indexName = indexName;
        this.shardId = shardId;
        this.primary = bPrimary;
        this.threadID = String.valueOf(ThreadIDUtil.INSTANCE.getNativeCurrentThreadId());
        StringBuilder value = new StringBuilder().append(PerformanceAnalyzerMetrics.getCurrentTimeMetric()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkMetric.START_TIME.toString()).append(":").append(startTime).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkMetric.ITEM_COUNT.toString()).append(":").append(itemCount).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.INDEX_NAME.toString()).append(":").append(indexName).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.SHARD_ID.toString()).append(":").append(shardId).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.PRIMARY.toString()).append(":").append(bPrimary);
        this.saveMetricValues(value.toString(), startTime, new String[]{this.threadID, this.id, "start"});
    }

    public String getProfileName() {
        return "PerformanceAnalyzerTransportChannelProfile";
    }

    public String getChannelType() {
        return "PerformanceAnalyzerTransportChannelType";
    }

    public void sendResponse(TransportResponse response) throws IOException {
        this.emitMetricsFinish(null);
        this.original.sendResponse(response);
    }

    public void sendResponse(Exception exception) throws IOException {
        this.emitMetricsFinish(exception);
        this.original.sendResponse(exception);
    }

    private void emitMetricsFinish(Exception exception) {
        long currTime = System.currentTimeMillis();
        StringBuilder value = new StringBuilder().append(PerformanceAnalyzerMetrics.getCurrentTimeMetric()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkMetric.FINISH_TIME.toString()).append(":").append(currTime).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.INDEX_NAME.toString()).append(":").append(this.indexName).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.SHARD_ID.toString()).append(":").append(this.shardId).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.PRIMARY.toString()).append(":").append(this.primary);
        if (exception != null) {
            value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.EXCEPTION.toString()).append(":").append(exception.getClass().getName());
            value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.FAILED.toString()).append(":").append(true);
        } else {
            value.append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor).append(AllMetrics.ShardBulkDimension.FAILED.toString()).append(":").append(false);
        }
        this.saveMetricValues(value.toString(), currTime, new String[]{this.threadID, this.id, "finish"});
    }

    public TransportChannel getInnerChannel() {
        return this.original;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 3) {
            throw new RuntimeException("keys length should be 3");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"threads", keysPath[0], "shardbulk", keysPath[1], keysPath[2]});
    }
}

