info = {
    "name": "hr",
    "date_order": "DMY",
    "january": [
        "sij",
        "siječanj",
        "siječnja"
    ],
    "february": [
        "velj",
        "veljača",
        "veljače"
    ],
    "march": [
        "ožu",
        "ožujak",
        "ožujka"
    ],
    "april": [
        "tra",
        "travanj",
        "travnja"
    ],
    "may": [
        "svi",
        "svibanj",
        "svibnja"
    ],
    "june": [
        "lip",
        "lipanj",
        "lipnja"
    ],
    "july": [
        "srp",
        "srpanj",
        "srpnja"
    ],
    "august": [
        "kol",
        "kolovoz",
        "kolovoza"
    ],
    "september": [
        "ruj",
        "rujan",
        "rujna"
    ],
    "october": [
        "lis",
        "listopad",
        "listopada"
    ],
    "november": [
        "stu",
        "studeni",
        "studenoga"
    ],
    "december": [
        "pro",
        "prosinac",
        "prosinca"
    ],
    "monday": [
        "pon",
        "ponedjeljak"
    ],
    "tuesday": [
        "uto",
        "utorak"
    ],
    "wednesday": [
        "sri",
        "srijeda"
    ],
    "thursday": [
        "čet",
        "četvrtak"
    ],
    "friday": [
        "pet",
        "petak"
    ],
    "saturday": [
        "sub",
        "subota"
    ],
    "sunday": [
        "ned",
        "nedjelja"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "g",
        "godina"
    ],
    "month": [
        "m",
        "mj",
        "mjesec"
    ],
    "week": [
        "tj",
        "tjedan"
    ],
    "day": [
        "d",
        "dan"
    ],
    "hour": [
        "h",
        "sat"
    ],
    "minute": [
        "min",
        "minuta"
    ],
    "second": [
        "s",
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "danas"
        ],
        "0 hour ago": [
            "ovaj sat"
        ],
        "0 minute ago": [
            "ova minuta"
        ],
        "0 month ago": [
            "ovaj mj",
            "ovaj mjesec"
        ],
        "0 second ago": [
            "sad"
        ],
        "0 week ago": [
            "ovaj tj",
            "ovaj tjedan"
        ],
        "0 year ago": [
            "ove g",
            "ove god",
            "ove godine"
        ],
        "1 day ago": [
            "jučer"
        ],
        "1 month ago": [
            "prošli mj",
            "prošli mjesec"
        ],
        "1 week ago": [
            "prošli tj",
            "prošli tjedan"
        ],
        "1 year ago": [
            "prošle g",
            "prošle god",
            "prošle godine"
        ],
        "in 1 day": [
            "sutra"
        ],
        "in 1 month": [
            "sljedeći mj",
            "sljedeći mjesec"
        ],
        "in 1 week": [
            "sljedeći tj",
            "sljedeći tjedan"
        ],
        "in 1 year": [
            "sljedeće g",
            "sljedeće god",
            "sljedeće godine"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "prije (\\d+) d",
            "prije (\\d+) dan",
            "prije (\\d+) dana"
        ],
        "\\1 hour ago": [
            "prije (\\d+) h",
            "prije (\\d+) sat",
            "prije (\\d+) sati"
        ],
        "\\1 minute ago": [
            "prije (\\d+) min",
            "prije (\\d+) minuta",
            "prije (\\d+) minutu"
        ],
        "\\1 month ago": [
            "prije (\\d+) mj",
            "prije (\\d+) mjesec",
            "prije (\\d+) mjeseci"
        ],
        "\\1 second ago": [
            "prije (\\d+) s",
            "prije (\\d+) sekundi",
            "prije (\\d+) sekundu"
        ],
        "\\1 week ago": [
            "prije (\\d+) tj",
            "prije (\\d+) tjedan",
            "prije (\\d+) tjedana"
        ],
        "\\1 year ago": [
            "prije (\\d+) g",
            "prije (\\d+) godina",
            "prije (\\d+) godinu"
        ],
        "in \\1 day": [
            "za (\\d+) d",
            "za (\\d+) dan",
            "za (\\d+) dana"
        ],
        "in \\1 hour": [
            "za (\\d+) h",
            "za (\\d+) sat",
            "za (\\d+) sati"
        ],
        "in \\1 minute": [
            "za (\\d+) min",
            "za (\\d+) minuta",
            "za (\\d+) minutu"
        ],
        "in \\1 month": [
            "za (\\d+) mj",
            "za (\\d+) mjesec",
            "za (\\d+) mjeseci"
        ],
        "in \\1 second": [
            "za (\\d+) s",
            "za (\\d+) sekundi",
            "za (\\d+) sekundu"
        ],
        "in \\1 week": [
            "za (\\d+) tj",
            "za (\\d+) tjedan",
            "za (\\d+) tjedana"
        ],
        "in \\1 year": [
            "za (\\d+) g",
            "za (\\d+) godina",
            "za (\\d+) godinu"
        ]
    },
    "locale_specific": {
        "hr-BA": {
            "name": "hr-BA"
        }
    },
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
