/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleFrame;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RType;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

final class RObjectProperties {
    RObjectProperties() {
    }

    public static class ReferencesProvider
    extends TruffleObjectPropertyProvider.References<RObject, RType, RHeapFragment, RLanguage> {
        public ReferencesProvider() {
            super(Bundle.RObjectProperties_References(), RLanguage.instance(), false);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("r_") && !viewID.endsWith("_attributes");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            return node instanceof RNodes.RNode && !(node instanceof RNodes.RObjectFieldNode);
        }

        @Override
        protected HeapViewerNode createObjectReferenceNode(RObject object, String type, FieldValue field) {
            return new RNodes.RObjectReferenceNode(object, type, field);
        }

        @Override
        protected HeapViewerNode createForeignReferenceNode(Instance instance, FieldValue field, Heap heap) {
            List references = instance.getReferences();
            for (Value reference : references) {
                instance = reference.getDefiningInstance();
                if (!((RLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) continue;
                RObject robj = ((RLanguage)((Object)this.getLanguage())).createObject(instance);
                return new RNodes.RObjectAttributeReferenceNode(robj, robj.getType(), field);
            }
            return super.createForeignReferenceNode(instance, field, heap);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(RObject object, Heap heap) throws InterruptedException {
            HeapOperations.initializeReferences((Heap)heap);
            return object.getReferences();
        }
    }

    public static class ItemsProvider
    extends TruffleObjectPropertyProvider.Fields<RObject, RType, RHeapFragment, RLanguage> {
        public ItemsProvider() {
            super(Bundle.RObjectProperties_Items(), RLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("r_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            if (node instanceof RNodes.RNode && !(node instanceof RNodes.RObjectReferenceNode) && !(node instanceof RNodes.RObjectAttributeReferenceNode)) {
                RObject robject;
                TruffleObject object = (TruffleObject)HeapViewerNode.getValue((HeapViewerNode)node, TruffleObject.DATA_TYPE, (Heap)heap);
                RObject rObject = robject = object instanceof RObject ? (RObject)object : null;
                if (robject != null) {
                    if (robject.getFieldValues().isEmpty()) {
                        TruffleFrame frame = robject.getFrame();
                        return frame != null && frame.isTruffleFrame();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(RObject object, String type, FieldValue field) {
            return new RNodes.RObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(RObject object, Heap heap) {
            List<FieldValue> fields = object.getFieldValues();
            if (fields.isEmpty()) {
                TruffleFrame frame = object.getFrame();
                fields = frame == null ? null : frame.getLocalFieldValues();
            }
            return fields;
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("com.oracle.truffle.r.runtime.data.");
        }

        @Override
        protected String getMergedPropertiesKey() {
            return null;
        }
    }

    public static class AttributesProvider
    extends TruffleObjectPropertyProvider.Fields<RObject, RType, RHeapFragment, RLanguage> {
        public AttributesProvider() {
            super(Bundle.RObjectProperties_Properties(), RLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("r_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            if (node instanceof RNodes.RNode && !(node instanceof RNodes.RObjectReferenceNode) && !(node instanceof RNodes.RObjectAttributeReferenceNode)) {
                RObject robject;
                TruffleObject object = (TruffleObject)HeapViewerNode.getValue((HeapViewerNode)node, TruffleObject.DATA_TYPE, (Heap)heap);
                RObject rObject = robject = object instanceof RObject ? (RObject)object : null;
                if (robject != null && robject.getAttributes() != null) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(RObject object, String type, FieldValue field) {
            return new RNodes.RObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(RObject object, Heap heap) {
            DynamicObject attributes = object.getAttributes();
            if (attributes == null) {
                return null;
            }
            ArrayList<FieldValue> fields = new ArrayList<FieldValue>();
            fields.addAll(attributes.getFieldValues());
            fields.addAll(attributes.getStaticFieldValues());
            return fields;
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("com.oracle.truffle.api.strings.");
        }
    }
}

