/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer;

import java.nio.channels.Channel;
import org.jcodings.Encoding;
import org.jruby.RubyArray;
import org.jruby.RubyEncoding;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.lexer.LexerSource;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.IOInputStream;
import org.jruby.util.io.ChannelHelper;

public class GetsLexerSource
extends LexerSource {
    private IRubyObject io;
    private Encoding encoding;
    private int offset;

    public GetsLexerSource(String sourceName, int line, IRubyObject io2, RubyArray scriptLines, Encoding encoding2) {
        super(sourceName, line, scriptLines);
        this.io = io2;
        this.encoding = encoding2;
    }

    public GetsLexerSource(String sourceName, int line, IRubyObject io2, RubyArray scriptLines) {
        this(sourceName, line, io2, scriptLines, GetsLexerSource.frobnicateEncoding(io2));
    }

    public static final Encoding frobnicateEncoding(IRubyObject io2) {
        if (!io2.respondsTo("encoding")) {
            return io2.getRuntime().getDefaultExternalEncoding();
        }
        IRubyObject encodingObject = io2.callMethod(io2.getRuntime().getCurrentContext(), "encoding");
        return encodingObject instanceof RubyEncoding ? ((RubyEncoding)encodingObject).getEncoding() : io2.getRuntime().getDefaultExternalEncoding();
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(Encoding encoding2) {
        this.encoding = encoding2;
        this.encodeExistingScriptLines(encoding2);
    }

    @Override
    public ByteList gets() {
        IRubyObject result2 = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "gets");
        if (result2.isNil()) {
            return null;
        }
        ByteList bytelist = result2.convertToString().getByteList();
        this.offset += bytelist.getRealSize();
        bytelist.setEncoding(this.encoding);
        if (this.scriptLines != null) {
            this.scriptLines.append(RubyString.newString(this.scriptLines.getRuntime(), bytelist));
        }
        return bytelist;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Channel getRemainingAsChannel() {
        if (this.io instanceof RubyIO) {
            return ((RubyIO)this.io).getChannel();
        }
        return ChannelHelper.readableChannel(new IOInputStream(this.io));
    }

    @Override
    public IRubyObject getRemainingAsIO() {
        return this.io;
    }
}

