/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.replication.task.ReplicationState;
import org.opensearch.replication.task.shard.CompletedState;
import org.opensearch.replication.task.shard.FailedState;
import org.opensearch.replication.task.shard.FollowingState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u0082\u0001\u0003\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationState;", "Lorg/opensearch/persistent/PersistentTaskState;", "state", "Lorg/opensearch/replication/task/ReplicationState;", "(Lorg/opensearch/replication/task/ReplicationState;)V", "getState", "()Lorg/opensearch/replication/task/ReplicationState;", "setState", "getWriteableName", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Builder", "Companion", "Lorg/opensearch/replication/task/shard/FollowingState;", "Lorg/opensearch/replication/task/shard/CompletedState;", "Lorg/opensearch/replication/task/shard/FailedState;", "opensearch-cross-cluster-replication"})
public abstract class ShardReplicationState
implements PersistentTaskState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ReplicationState state;
    @NotNull
    public static final String NAME = "cluster:indices/shards/replication";
    @NotNull
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:indices/shards/replication", true, ShardReplicationState::PARSER$lambda-0);

    @NotNull
    public final ReplicationState getState() {
        return this.state;
    }

    public final void setState(@NotNull ReplicationState replicationState) {
        Intrinsics.checkNotNullParameter((Object)((Object)replicationState), (String)"<set-?>");
        this.state = replicationState;
    }

    private ShardReplicationState(ReplicationState state) {
        this.state = state;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeEnum((Enum)this.state);
    }

    @NotNull
    public String getWriteableName() {
        return NAME;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        XContentBuilder xContentBuilder = builder.startObject().field("state", (ToXContent)this.state).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026             .endObject()");
        return xContentBuilder;
    }

    private static final Builder PARSER$lambda-0() {
        return new Builder();
    }

    public /* synthetic */ ShardReplicationState(ReplicationState state, DefaultConstructorMarker $constructor_marker) {
        this(state);
    }

    static {
        PARSER.declareString(Builder::setShardTaskState, new ParseField("state", new String[0]));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationState$Companion;", "", "()V", "NAME", "", "PARSER", "Lorg/opensearch/core/xcontent/ObjectParser;", "Lorg/opensearch/replication/task/shard/ShardReplicationState$Builder;", "Ljava/lang/Void;", "fromXContent", "Lorg/opensearch/replication/task/shard/ShardReplicationState;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "reader", "inp", "Lorg/opensearch/common/io/stream/StreamInput;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShardReplicationState reader(@NotNull StreamInput inp) {
            ShardReplicationState shardReplicationState;
            Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
            Enum enum_ = inp.readEnum(ReplicationState.class);
            Intrinsics.checkNotNull((Object)enum_);
            ReplicationState state = (ReplicationState)enum_;
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    throw new IllegalStateException("INIT - Illegal state for shard replication task");
                }
                case 2: {
                    throw new IllegalStateException("RESTORING - Illegal state for shard replication task");
                }
                case 3: {
                    throw new IllegalStateException("INIT_FOLLOW - Illegal state for shard replication task");
                }
                case 4: {
                    shardReplicationState = FollowingState.INSTANCE;
                    break;
                }
                case 5: {
                    shardReplicationState = new FailedState(inp);
                    break;
                }
                case 6: {
                    shardReplicationState = CompletedState.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)state) + " - Not a valid state for shard replication task");
                }
            }
            return shardReplicationState;
        }

        @NotNull
        public final ShardReplicationState fromXContent(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return ((Builder)PARSER.parse(parser, null)).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReplicationState.values().length];
                nArray[ReplicationState.INIT.ordinal()] = 1;
                nArray[ReplicationState.RESTORING.ordinal()] = 2;
                nArray[ReplicationState.INIT_FOLLOW.ordinal()] = 3;
                nArray[ReplicationState.FOLLOWING.ordinal()] = 4;
                nArray[ReplicationState.FAILED.ordinal()] = 5;
                nArray[ReplicationState.COMPLETED.ordinal()] = 6;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationState$Builder;", "", "()V", "state", "", "getState", "()Ljava/lang/String;", "setState", "(Ljava/lang/String;)V", "build", "Lorg/opensearch/replication/task/shard/ShardReplicationState;", "setShardTaskState", "", "opensearch-cross-cluster-replication"})
    public static final class Builder {
        public String state;

        @NotNull
        public final String getState() {
            String string = this.state;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
            return null;
        }

        public final void setState(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.state = string;
        }

        public final void setShardTaskState(@NotNull String state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.setState(state);
        }

        @NotNull
        public final ShardReplicationState build() {
            ShardReplicationState shardReplicationState;
            this.setState(this.state == null ? ReplicationState.FOLLOWING.name() : this.getState());
            String string = this.getState();
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.INIT.name())) {
                throw new IllegalArgumentException("INIT - Illegal state for shard replication task");
            }
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.RESTORING.name())) {
                throw new IllegalArgumentException("RESTORING - Illegal state for shard replication task");
            }
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.INIT_FOLLOW.name())) {
                throw new IllegalArgumentException("INIT_FOLLOW - Illegal state for shard replication task");
            }
            if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.FOLLOWING.name())) {
                shardReplicationState = FollowingState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.COMPLETED.name())) {
                shardReplicationState = CompletedState.INSTANCE;
            } else if (Intrinsics.areEqual((Object)string, (Object)ReplicationState.FAILED.name())) {
                shardReplicationState = new FailedState(null);
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)this.getState(), (Object)" - Not a valid state for shard replication task"));
            }
            return shardReplicationState;
        }
    }
}

