/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections;

import com.strobel.collections.Cache;
import com.strobel.collections.SatelliteCache;

final class ThreadLocalCache<K, V>
extends Cache<K, V> {
    private final Cache<K, V> _parent;
    private final ThreadLocal<SatelliteCache<K, V>> _threadCaches = new ThreadLocal<SatelliteCache<K, V>>(){

        @Override
        protected SatelliteCache<K, V> initialValue() {
            return new SatelliteCache(ThreadLocalCache.this._parent);
        }
    };

    public ThreadLocalCache() {
        this._parent = null;
    }

    @Override
    public Cache<K, V> getSatelliteCache() {
        return this._threadCaches.get();
    }

    @Override
    public boolean replace(K key, V expectedValue, V updatedValue) {
        return this._threadCaches.get().replace(key, expectedValue, updatedValue);
    }

    public ThreadLocalCache(Cache<K, V> parent) {
        this._parent = parent;
    }

    @Override
    public V cache(K key, V value) {
        return this._threadCaches.get().cache(key, value);
    }

    @Override
    public V get(K key) {
        return this._threadCaches.get().get(key);
    }
}

