/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import tim.prune.data.DataPoint;
import tim.prune.data.FileInfo;
import tim.prune.data.SourceInfo;
import tim.prune.save.xml.GpxCacher;

public class GpxCacherList {
    private final GpxCacher[] _cacherList;

    public GpxCacherList(FileInfo fileInfo) {
        int n = fileInfo.getNumFiles();
        this._cacherList = new GpxCacher[n];
        int n2 = 0;
        while (n2 < n) {
            SourceInfo sourceInfo = fileInfo.getSource(n2);
            if (sourceInfo.getFileType() == SourceInfo.FILE_TYPE.GPX) {
                this._cacherList[n2] = new GpxCacher(sourceInfo);
            }
            ++n2;
        }
    }

    public String getSourceString(DataPoint dataPoint) {
        GpxCacher[] gpxCacherArray = this._cacherList;
        int n = this._cacherList.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            GpxCacher gpxCacher = gpxCacherArray[n2];
            String string2 = string = gpxCacher == null ? null : gpxCacher.getSourceString(dataPoint);
            if (string != null) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    public String getFirstHeader() {
        GpxCacher[] gpxCacherArray = this._cacherList;
        int n = this._cacherList.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            GpxCacher gpxCacher = gpxCacherArray[n2];
            String string2 = string = gpxCacher == null ? null : gpxCacher.getHeaderString();
            if (string != null && !string.isEmpty()) {
                return string;
            }
            ++n2;
        }
        return null;
    }
}

