/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.model.transport;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.io.stream.StreamInput;

public class DeleteDataSourceActionRequest
extends ActionRequest {
    private String dataSourceName;

    public DeleteDataSourceActionRequest(StreamInput in) throws IOException {
        super(in);
    }

    public DeleteDataSourceActionRequest(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public ActionRequestValidationException validate() {
        if (StringUtils.isEmpty((CharSequence)this.dataSourceName)) {
            ActionRequestValidationException exception = new ActionRequestValidationException();
            exception.addValidationError("Datasource Name cannot be empty or null");
            return exception;
        }
        if (this.dataSourceName.equals("@opensearch")) {
            ActionRequestValidationException exception = new ActionRequestValidationException();
            exception.addValidationError("Not allowed to delete datasource with name : @opensearch");
            return exception;
        }
        return null;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }
}

