/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001d\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0015H\u0082\bJ2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f0\u0015H\u0016J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f0\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "doesPackageExist", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "doesPlatformSpecificPackageExist", "forEachNonKotlinPsiElementFinder", "", "action", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElementFinder;", "getPlatformSpecificSubPackagesFqNames", "", "Lorg/jetbrains/kotlin/name/Name;", "nameFilter", "getSubPackageFqNames", "Companion", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinPackageProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n80#1,9:96\n80#1,7:105\n88#1:113\n1#2:112\n*S KotlinDebug\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase\n*L\n32#1:96,9\n63#1:105,7\n63#1:113\n*E\n"})
public abstract class KotlinPackageProviderBase
extends KotlinPackageProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public KotlinPackageProviderBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        this.project = project;
        this.searchScope = searchScope;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Override
    public boolean doesPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        return this.doesPlatformSpecificPackageExist(packageFqName, platform) || this.doesKotlinOnlyPackageExist(packageFqName);
    }

    @Override
    public boolean doesPlatformSpecificPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        if (JvmPlatformKt.isJvm(platform)) {
            String string2 = packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "packageFqName.asString()");
            String fqNameString = string2;
            KotlinPackageProviderBase this_$iv = this;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint(this_$iv.project).getExtensionList()) {
                if (Intrinsics.areEqual(finder$iv.getClass().getName(), "org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNullExpressionValue(finder$iv, "finder");
                PsiElementFinder finder = finder$iv;
                boolean bl = false;
                PsiPackage psiPackage = finder.findPackage(fqNameString);
                if (psiPackage == null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<Name> getSubPackageFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Set set;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        Intrinsics.checkNotNullParameter(nameFilter2, "nameFilter");
        Set $this$getSubPackageFqNames_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getSubPackageFqNames_u24lambda_u241.addAll(this.getKotlinOnlySubPackagesFqNames(packageFqName, nameFilter2));
        $this$getSubPackageFqNames_u24lambda_u241.addAll(this.getPlatformSpecificSubPackagesFqNames(packageFqName, platform, nameFilter2));
        return SetsKt.build(set);
    }

    @Override
    @NotNull
    public Set<Name> getPlatformSpecificSubPackagesFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Set<Name> set;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        Intrinsics.checkNotNullParameter(nameFilter2, "nameFilter");
        if (JvmPlatformKt.isJvm(platform)) {
            Set<Object> set2;
            String string2 = packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "packageFqName.asString()");
            String fqNameString = string2;
            Set<Object> $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            KotlinPackageProviderBase this_$iv = this;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint(this_$iv.project).getExtensionList()) {
                PsiPackage[] psiPackageArray;
                PsiPackage psiPackage;
                if (Intrinsics.areEqual(finder$iv.getClass().getName(), "org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNullExpressionValue(finder$iv, "finder");
                PsiElementFinder finder = finder$iv;
                boolean bl2 = false;
                if (finder.findPackage(fqNameString) == null) continue;
                Intrinsics.checkNotNullExpressionValue(psiPackage, "finder.findPackage(fqNam\u2026NonKotlinPsiElementFinder");
                Intrinsics.checkNotNullExpressionValue(finder.getSubPackages(psiPackage, this.searchScope), "finder.getSubPackages(psiPackage, searchScope)");
                for (PsiPackage subPackage : psiPackageArray) {
                    Object object = subPackage.getName();
                    if (object == null) continue;
                    String p0 = object;
                    boolean bl3 = false;
                    Name name2 = Name.identifierIfValid(p0);
                    object = name2;
                    if (name2 == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue(object, "subPackage.name?.let(Nam\u2026ifierIfValid) ?: continue");
                    Object name3 = object;
                    if (!nameFilter2.invoke((Name)name3).booleanValue()) continue;
                    $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243.add(name3);
                }
            }
            set = SetsKt.build(set2);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase$Companion;", "", "()V", "KOTLIN_JAVA_ELEMENT_FINDER_CLASS_NAME", "", "analysis-api-providers"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

