/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.statistics.file;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.CompileStatisticsData;
import org.jetbrains.kotlin.build.report.statistics.FormattingUtilsKt;
import org.jetbrains.kotlin.build.report.statistics.file.FileReportService;
import org.jetbrains.kotlin.build.report.statistics.file.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.build.report.statistics.file.Printer;
import org.jetbrains.kotlin.build.report.statistics.file.TextTable;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 /2\u00020\u0001:\u0001/B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001c\u0010\u0016\u001a\u00020\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J,\u0010\u001b\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001c\u0010\u001e\u001a\u00020\f2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J4\u0010!\u001a\u00020\f2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0018H\u0002Jx\u0010\u0004\u001a\u00020\f2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001a0\u00182\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\u0016\b\u0002\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00182\b\b\u0002\u0010'\u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010,\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eH\u0002J\u0016\u0010-\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0014H\u0002J,\u0010.\u001a\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/file/FileReportService;", "Ljava/io/Serializable;", "outputFile", "Ljava/io/File;", "printMetrics", "", "logger", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "(Ljava/io/File;ZLorg/jetbrains/kotlin/compilerRunner/KotlinLogger;)V", "p", "Lorg/jetbrains/kotlin/build/report/statistics/file/Printer;", "printBuildAttributes", "", "buildAttributes", "", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "printBuildInfo", "startParameters", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "failureMessages", "", "", "printBuildPerformanceMetrics", "buildMetrics", "", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "", "printBuildReport", "statisticsData", "Lorg/jetbrains/kotlin/build/report/statistics/CompileStatisticsData;", "printBuildTimes", "buildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "printGcMetrics", "gcTimeMetrics", "gcCountMetrics", "buildTimesMetrics", "performanceMetrics", "nonIncrementalAttributes", "aggregatedMetric", "printSizeMetric", "sizeMetric", "value", "printTaskLog", "printTaskOverview", "printTasksLog", "process", "Companion", "kotlin-build-statistics"})
@SourceDebugExtension(value={"SMAP\nFileReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileReportService.kt\norg/jetbrains/kotlin/build/report/statistics/file/FileReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Printer.kt\norg/jetbrains/kotlin/build/report/statistics/file/Printer\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,298:1\n1549#2:299\n1620#2,3:300\n2661#2,5:303\n1271#2,2:308\n1285#2,4:310\n2667#2:314\n1549#2:315\n1620#2,3:316\n2661#2,5:319\n1271#2,2:324\n1285#2,4:326\n2667#2:330\n1549#2:331\n1620#2,3:332\n2661#2,7:335\n1536#2:394\n1477#2:402\n1502#2,3:403\n1505#2,3:413\n1179#2,2:416\n1253#2,4:418\n1855#2,2:441\n1855#2,2:453\n1855#2,2:457\n60#3,10:342\n60#3,7:353\n59#3,11:360\n68#3,2:371\n59#3,11:373\n60#3,10:384\n60#3,7:395\n68#3,2:422\n60#3,10:424\n60#3,7:434\n68#3,2:443\n59#3,8:445\n68#3,2:455\n1#4:352\n372#5,7:406\n*S KotlinDebug\n*F\n+ 1 FileReportService.kt\norg/jetbrains/kotlin/build/report/statistics/file/FileReportService\n*L\n83#1:299\n83#1:300,3\n83#1:303,5\n84#1:308,2\n84#1:310,4\n83#1:314\n86#1:315\n86#1:316,3\n86#1:319,5\n87#1:324,2\n87#1:326,4\n86#1:330\n89#1:331\n89#1:332,3\n89#1:335,7\n224#1:394\n226#1:402\n226#1:403,3\n226#1:413,3\n228#1:416,2\n228#1:418,4\n289#1:441,2\n171#1:453,2\n175#1:457,2\n99#1:342,10\n147#1:353,7\n150#1:360,11\n147#1:371,2\n162#1:373,11\n190#1:384,10\n225#1:395,7\n225#1:422,2\n282#1:424,10\n288#1:434,7\n288#1:443,2\n170#1:445,8\n170#1:455,2\n226#1:406,7\n*E\n"})
public final class FileReportService
implements Serializable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final File outputFile;
    private final boolean printMetrics;
    @NotNull
    private final KotlinLogger logger;
    private Printer p;
    @NotNull
    private static final SimpleDateFormat formatter;

    public FileReportService(@NotNull File outputFile, boolean printMetrics, @NotNull KotlinLogger logger) {
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.outputFile = outputFile;
        this.printMetrics = printMetrics;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull List<CompileStatisticsData> statisticsData, @NotNull BuildStartParameters startParameters, @NotNull List<String> failureMessages) {
        Intrinsics.checkNotNullParameter(statisticsData, "statisticsData");
        Intrinsics.checkNotNullParameter(startParameters, "startParameters");
        Intrinsics.checkNotNullParameter(failureMessages, "failureMessages");
        String string2 = this.outputFile.toPath().toUri().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "outputFile.toPath().toUri().toString()");
        String buildReportPath = string2;
        try {
            this.outputFile.getParentFile().mkdirs();
            if (!this.outputFile.getParentFile().exists() || !this.outputFile.getParentFile().isDirectory()) {
                KotlinLogger.error$default(this.logger, "Kotlin build report cannot be created: '" + this.outputFile + ".parentFile' is a file or do not have permissions to create", null, 2, null);
                return;
            }
            Object object = this.outputFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                this.p = new Printer(writer, null, null, 6, null);
                this.printBuildReport(statisticsData, startParameters, failureMessages);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            this.logger.lifecycle("Kotlin build report is written to " + buildReportPath);
        }
        catch (Exception e) {
            this.logger.error("Could not write Kotlin build report to " + buildReportPath, e);
        }
    }

    public static /* synthetic */ void process$default(FileReportService fileReportService, List list2, BuildStartParameters buildStartParameters, List list3, int n, Object object) {
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        fileReportService.process(list2, buildStartParameters, list3);
    }

    /*
     * WARNING - void declaration
     */
    private final void printBuildReport(List<CompileStatisticsData> statisticsData, BuildStartParameters startParameters, List<String> failureMessages) {
        this.printBuildInfo(startParameters, failureMessages);
        if (this.printMetrics && !((Collection)statisticsData).isEmpty()) {
            Object object;
            Object object2;
            Long l;
            BuildPerformanceMetric it;
            Map map;
            Object t;
            Object element$iv$iv;
            Iterator iterator2;
            boolean $i$f$associateWithTo;
            Object $this$associateWithTo$iv$iv;
            LinkedHashMap result$iv;
            boolean $i$f$associateWith;
            Object $this$associateWith$iv;
            Object agg;
            Iterable $this$reduce$iv;
            void it2;
            Object object3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = statisticsData;
            FileReportService fileReportService = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CompileStatisticsData compileStatisticsData = (CompileStatisticsData)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object3.add(it2.getBuildTimesMetrics());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value2;
                Map $i$f$mapTo2 = (Map)iterator$iv.next();
                agg = (Map)accumulator$iv;
                boolean bl = false;
                $this$associateWith$iv = SetsKt.plus(agg.keySet(), value2.keySet());
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                iterator2 = $this$associateWithTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    BuildTime buildTime = (BuildTime)element$iv$iv;
                    t = element$iv$iv;
                    map = result$iv;
                    boolean bl2 = false;
                    Long l2 = (Long)agg.get(it);
                    Long l3 = (Long)value2.get(it);
                    l = (l2 != null ? l2 : 0L) + (l3 != null ? l3 : 0L);
                    map.put(t, l);
                }
                accumulator$iv = result$iv;
            }
            $this$reduce$iv = statisticsData;
            object3 = (Map)accumulator$iv;
            $i$f$map = false;
            iterator$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $this$associateWith$iv = (CompileStatisticsData)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(it2.getPerformanceMetrics());
            }
            object2 = (List)destination$iv$iv;
            $this$map$iv = (Iterable)object2;
            $i$f$reduce = false;
            iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value3;
                Map $i$f$mapTo3 = (Map)iterator$iv.next();
                agg = (Map)accumulator$iv;
                boolean bl = false;
                $this$associateWith$iv = SetsKt.plus(agg.keySet(), value3.keySet());
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                iterator2 = $this$associateWithTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    it = (BuildPerformanceMetric)element$iv$iv;
                    t = element$iv$iv;
                    map = result$iv;
                    boolean bl3 = false;
                    Long l4 = (Long)agg.get(it);
                    Long l5 = (Long)value3.get(it);
                    l = (l4 != null ? l4 : 0L) + (l5 != null ? l5 : 0L);
                    map.put(t, l);
                }
                accumulator$iv = result$iv;
            }
            object2 = accumulator$iv;
            $this$reduce$iv = statisticsData;
            object2 = (Map)object2;
            $i$f$map = false;
            iterator$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $this$associateWith$iv = (CompileStatisticsData)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(CollectionsKt.asSequence((Iterable)it2.getNonIncrementalAttributes()));
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Iterable)object;
            $i$f$reduce = false;
            iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value4;
                Sequence $i$f$mapTo4 = (Sequence)iterator$iv.next();
                agg = (Sequence)accumulator$iv;
                boolean bl = false;
                accumulator$iv = SequencesKt.plus(agg, value4);
            }
            object = accumulator$iv;
            FileReportService.printMetrics$default(fileReportService, (Map)object3, (Map)object2, SequencesKt.toList((Sequence)object), null, null, true, 24, null);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            printer.println(new String[0]);
        }
        this.printTaskOverview((Collection<CompileStatisticsData>)statisticsData);
        this.printTasksLog(statisticsData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildStartParameters startParameters, List<String> failureMessages) {
        void this_$iv;
        String[] stringArray = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            stringArray = null;
        }
        String[] stringArray2 = stringArray;
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        Object object = new String[]{headLine$iv};
        this_$iv.println((String)object);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            BuildStartParameters it = startParameters;
            boolean bl2 = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            String[] stringArray3 = new String[]{"tasks = " + it.getTasks()};
            printer.println(stringArray3);
            Printer printer2 = this.p;
            if (printer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer2 = null;
            }
            stringArray3 = new String[]{"excluded tasks = " + it.getExcludedTasks()};
            printer2.println(stringArray3);
            Printer printer3 = this.p;
            if (printer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer3 = null;
            }
            stringArray3 = new String[]{"current dir = " + it.getCurrentDir()};
            printer3.println(stringArray3);
            Printer printer4 = this.p;
            if (printer4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer4 = null;
            }
            stringArray3 = new String[]{"project properties args = " + it.getProjectProperties()};
            printer4.println(stringArray3);
            Printer printer5 = this.p;
            if (printer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer5 = null;
            }
            stringArray3 = new String[]{"system properties args = " + it.getSystemProperties()};
            printer5.println(stringArray3);
            object = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer = null;
        }
        printer.println(new String[0]);
        if (!((Collection)failureMessages).isEmpty()) {
            Printer printer6 = this.p;
            if (printer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer6 = null;
            }
            stringArray2 = new String[]{"Build failed: " + failureMessages};
            printer6.println(stringArray2);
            Printer printer7 = this.p;
            if (printer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer7 = null;
            }
            printer7.println(new String[0]);
        }
    }

    private final void printMetrics(Map<BuildTime, Long> buildTimesMetrics, Map<BuildPerformanceMetric, Long> performanceMetrics, Collection<? extends BuildAttribute> nonIncrementalAttributes, Map<String, Long> gcTimeMetrics, Map<String, Long> gcCountMetrics, boolean aggregatedMetric) {
        this.printBuildTimes(buildTimesMetrics);
        if (aggregatedMetric) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            printer.println(new String[0]);
        }
        this.printBuildPerformanceMetrics(performanceMetrics);
        if (aggregatedMetric) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            printer.println(new String[0]);
        }
        this.printBuildAttributes(nonIncrementalAttributes);
        if (!aggregatedMetric) {
            this.printGcMetrics(gcTimeMetrics, gcCountMetrics);
        }
    }

    static /* synthetic */ void printMetrics$default(FileReportService fileReportService, Map map, Map map2, Collection collection, Map map3, Map map4, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            map4 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        fileReportService.printMetrics(map, map2, collection, map3, map4, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printGcMetrics(Map<String, Long> gcTimeMetrics, Map<String, Long> gcCountMetrics) {
        void this_$iv;
        Object object;
        Map<String, Long> it;
        Map<String, Long> map;
        HashSet keys2 = new HashSet();
        Map<String, Long> map2 = gcCountMetrics;
        if (map2 != null && (map2 = map2.keySet()) != null) {
            it = map = map2;
            boolean bl = false;
            keys2.addAll((Collection)((Object)it));
        }
        if ((object = gcTimeMetrics) != null && (object = object.keySet()) != null) {
            it = map = object;
            boolean bl = false;
            keys2.addAll((Collection)((Object)it));
        }
        if (keys2.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer = null;
        }
        Printer printer2 = printer;
        String headLine$iv = "GC metrics:";
        boolean $i$f$withIndent = false;
        Object object2 = new String[]{headLine$iv};
        this_$iv.println((String)object2);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            for (String key : keys2) {
                Printer printer3 = this.p;
                if (printer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer3 = null;
                }
                String[] stringArray = new String[]{key + ':'};
                printer3.println(stringArray);
                Printer printer4 = this.p;
                if (printer4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer4 = null;
                }
                Printer $this$iv = printer4;
                Object headLine$iv2 = null;
                boolean $i$f$withIndent2 = false;
                $this$iv.pushIndent();
                try {
                    Map<String, Long> map3;
                    Object object3;
                    String[] stringArray2;
                    long it2;
                    Map<String, Long> map4;
                    boolean bl2 = false;
                    Map<String, Long> map5 = gcCountMetrics;
                    if (map5 != null && (map5 = map5.get(key)) != null) {
                        map4 = map5;
                        it2 = ((Number)((Object)map4)).longValue();
                        boolean bl3 = false;
                        Printer printer5 = this.p;
                        if (printer5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("p");
                            printer5 = null;
                        }
                        stringArray2 = new String[]{"GC count: " + it2};
                        printer5.println(stringArray2);
                    }
                    if ((object3 = gcTimeMetrics) != null && (object3 = object3.get(key)) != null) {
                        map4 = object3;
                        it2 = ((Number)((Object)map4)).longValue();
                        boolean bl4 = false;
                        Printer printer6 = this.p;
                        if (printer6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("p");
                            printer6 = null;
                        }
                        stringArray2 = new String[]{"GC time: " + FormattingUtilsKt.formatTime(it2)};
                        printer6.println(stringArray2);
                        map3 = map4;
                    } else {
                        map3 = null;
                    }
                    Map<String, Long> map6 = map3;
                }
                finally {
                    $this$iv.popIndent();
                }
            }
            object2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printBuildTimes(Map<BuildTime, Long> buildTimes) {
        if (buildTimes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer = null;
        }
        String[] stringArray = new String[]{"Time metrics:"};
        printer.println(stringArray);
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer2 = null;
        }
        Printer $this$iv = printer2;
        Object headLine$iv = null;
        boolean $i$f$withIndent = false;
        $this$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet<BuildTime> visitedBuildTimes = new HashSet<BuildTime>();
            for (BuildTime buildTime : BuildTime.values()) {
                if (buildTime.getParent() != null) continue;
                FileReportService.printBuildTimes$lambda$20$printBuildTime(visitedBuildTimes, buildTimes, this, buildTime);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            $this$iv.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildPerformanceMetrics(Map<BuildPerformanceMetric, Long> buildMetrics) {
        void this_$iv;
        if (buildMetrics.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer = null;
        }
        Printer printer2 = printer;
        String headLine$iv = "Size metrics:";
        boolean $i$f$withIndent = false;
        Object object = new String[]{headLine$iv};
        this_$iv.println((String)object);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            for (BuildPerformanceMetric metric : BuildPerformanceMetric.values()) {
                Long l = buildMetrics.get(metric);
                if (l == null) continue;
                long it = ((Number)l).longValue();
                boolean bl2 = false;
                this.printSizeMetric(metric, it);
            }
            object = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    private final void printSizeMetric(BuildPerformanceMetric sizeMetric, long value2) {
        int it;
        int n;
        int indentLevel = FileReportService.printSizeMetric$numberOfAncestors(sizeMetric);
        for (n = 0; n < indentLevel; ++n) {
            it = n;
            boolean bl = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            printer.pushIndent();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[sizeMetric.getType().ordinal()]) {
            case 1: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + FormattingUtilsKt.formatSize(value2)};
                printer.println(bl);
                break;
            }
            case 2: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + value2};
                printer.println(bl);
                break;
            }
            case 3: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + value2};
                printer.println(bl);
                break;
            }
            case 4: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + FormattingUtilsKt.formatTime(value2)};
                printer.println(bl);
                break;
            }
            case 5: {
                Printer printer = this.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer = null;
                }
                String[] bl = new String[]{sizeMetric.getReadableString() + ": " + formatter.format(value2)};
                printer.println(bl);
            }
        }
        for (n = 0; n < indentLevel; ++n) {
            it = n;
            boolean bl = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            printer.popIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(Collection<? extends BuildAttribute> buildAttributes) {
        void this_$iv;
        if (buildAttributes.isEmpty()) {
            return;
        }
        Object $this$groupingBy$iv = buildAttributes;
        boolean $i$f$groupingBy = false;
        Map buildAttributesMap = GroupingKt.eachCount((Grouping)new Grouping<BuildAttribute, BuildAttribute>((Iterable)$this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<BuildAttribute> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                BuildAttribute it = (BuildAttribute)element;
                boolean bl = false;
                return var2_2;
            }
        });
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer = null;
        }
        $this$groupingBy$iv = printer;
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        Object object = new String[]{headLine$iv};
        this_$iv.println((String)object);
        this_$iv.pushIndent();
        try {
            List list$iv$iv;
            void $this$groupByTo$iv$iv;
            boolean bl = false;
            Iterable $this$groupBy$iv = buildAttributesMap.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap(destination$iv$iv);
            for (Map.Entry entry : ((Map)attributesByKind).entrySet()) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                BuildAttributeKind kind = (BuildAttributeKind)entry.getKey();
                List attributesCounts = (List)entry.getValue();
                Printer printer2 = this.p;
                if (printer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer2 = null;
                }
                String string2 = kind.name();
                Intrinsics.checkNotNullExpressionValue(attributesCounts, "attributesCounts");
                Iterable $i$f$groupByTo2 = attributesCounts;
                String string3 = string2;
                Printer printer3 = printer2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                list$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv2;
                    Object object3 = (Map.Entry)element$iv$iv;
                    boolean bl4 = false;
                    BuildAttribute k = (BuildAttribute)object3.getKey();
                    int v = ((Number)object3.getValue()).intValue();
                    object3 = TuplesKt.to(k.getReadableString(), v);
                    map.put(((Pair)object3).getFirst(), ((Pair)object3).getSecond());
                }
                Map map = destination$iv$iv2;
                PlainTextBuildReportWriterKt.printMap(printer3, string3, map);
            }
            object = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
    }

    private final void printTaskOverview(Collection<CompileStatisticsData> statisticsData) {
        long allTasksTimeMs = 0L;
        long kotlinTotalTimeMs = 0L;
        ArrayList<CompileStatisticsData> kotlinTasks = new ArrayList<CompileStatisticsData>();
        for (CompileStatisticsData compileStatisticsData : statisticsData) {
            long taskTimeMs = compileStatisticsData.getDurationMs();
            allTasksTimeMs += taskTimeMs;
            if (!Intrinsics.areEqual(compileStatisticsData.getFromKotlinPlugin(), true)) continue;
            kotlinTotalTimeMs += taskTimeMs;
            kotlinTasks.add(compileStatisticsData);
        }
        if (kotlinTasks.isEmpty()) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            String[] stringArray = new String[]{"No Kotlin task was run"};
            printer.println(stringArray);
            return;
        }
        String ktTaskPercent = FormattingUtilsKt.asString((double)kotlinTotalTimeMs / (double)allTasksTimeMs * (double)100, 1);
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer = null;
        }
        String[] stringArray = new String[]{"Total time for Kotlin tasks: " + FormattingUtilsKt.formatTime(kotlinTotalTimeMs) + " (" + ktTaskPercent + " % of all tasks time)"};
        printer.println(stringArray);
        String[] stringArray2 = new String[]{"Time", "% of Kotlin time", "Task"};
        TextTable textTable = new TextTable(stringArray2);
        Function1[] function1Array = new Function1[]{printTaskOverview.1.INSTANCE, printTaskOverview.2.INSTANCE};
        for (CompileStatisticsData task3 : CollectionsKt.sortedWith((Iterable)kotlinTasks, ComparisonsKt.compareBy(function1Array))) {
            long timeMs = task3.getDurationMs();
            String percent = FormattingUtilsKt.asString((double)timeMs / (double)kotlinTotalTimeMs * (double)100, 1);
            String[] stringArray3 = new String[]{FormattingUtilsKt.formatTime(timeMs), percent + " %", task3.getTaskName()};
            textTable.addRow(stringArray3);
        }
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer2 = null;
        }
        textTable.printTo(printer2);
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("p");
            printer3 = null;
        }
        printer3.println(new String[0]);
    }

    private final void printTasksLog(List<CompileStatisticsData> statisticsData) {
        Function1[] function1Array = new Function1[]{printTasksLog.1.INSTANCE, printTasksLog.2.INSTANCE};
        for (CompileStatisticsData task : CollectionsKt.sortedWith((Iterable)statisticsData, ComparisonsKt.compareBy(function1Array))) {
            this.printTaskLog(task);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            printer.println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(CompileStatisticsData statisticsData) {
        Object object;
        String skipMessage = statisticsData.getSkipMessage();
        if (skipMessage != null) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            object = new String[]{"Task '" + statisticsData.getTaskName() + "' was skipped: " + skipMessage};
            printer.println((String)object);
        } else {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            object = new String[]{"Task '" + statisticsData.getTaskName() + "' finished in " + FormattingUtilsKt.formatTime(statisticsData.getDurationMs())};
            printer.println((String)object);
        }
        String string2 = statisticsData.getKotlinLanguageVersion();
        if (string2 != null) {
            void this_$iv;
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            Printer printer2 = printer;
            String headLine$iv = "Task info:";
            boolean $i$f$withIndent = false;
            Object object2 = new String[]{headLine$iv};
            this_$iv.println((String[])object2);
            this_$iv.pushIndent();
            try {
                boolean bl2 = false;
                Printer printer3 = this.p;
                if (printer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer3 = null;
                }
                String[] stringArray = new String[]{"Kotlin language version: " + it};
                printer3.println(stringArray);
                object2 = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        if (!((Collection)statisticsData.getIcLogLines()).isEmpty()) {
            void this_$iv;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException("p");
                printer = null;
            }
            object = printer;
            String headLine$iv = "Compilation log for task '" + statisticsData.getTaskName() + "':";
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                String[] stringArray = new String[]{headLine$iv};
                this_$iv.println(stringArray);
            }
            this_$iv.pushIndent();
            try {
                boolean bl = false;
                Iterable $this$forEach$iv = statisticsData.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Printer printer4 = this.p;
                    if (printer4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("p");
                        printer4 = null;
                    }
                    String[] stringArray = new String[]{it};
                    printer4.println(stringArray);
                }
                Unit unit2 = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        if (this.printMetrics) {
            FileReportService.printMetrics$default(this, statisticsData.getBuildTimesMetrics(), statisticsData.getPerformanceMetrics(), statisticsData.getNonIncrementalAttributes(), statisticsData.getGcTimeMetrics(), statisticsData.getGcCountMetrics(), false, 32, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void printBuildTimes$lambda$20$printBuildTime(HashSet<BuildTime> visitedBuildTimes, Map<BuildTime, Long> $buildTimes, FileReportService this$0, BuildTime buildTime) {
        block11: {
            if (!visitedBuildTimes.add(buildTime)) {
                return;
            }
            Long timeMs = $buildTimes.get(buildTime);
            if (timeMs != null) {
                Printer printer = this$0.p;
                if (printer == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer = null;
                }
                String[] stringArray = new String[]{buildTime.getReadableString() + ": " + FormattingUtilsKt.formatTime(timeMs)};
                printer.println(stringArray);
                Printer printer2 = this$0.p;
                if (printer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("p");
                    printer2 = null;
                }
                Printer $this$iv = printer2;
                Object headLine$iv = null;
                boolean $i$f$withIndent = false;
                $this$iv.pushIndent();
                try {
                    Unit unit2;
                    boolean bl = false;
                    List<BuildTime> list2 = BuildTime.Companion.getChildren().get(buildTime);
                    if (list2 != null) {
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BuildTime it = (BuildTime)element$iv;
                            boolean bl2 = false;
                            FileReportService.printBuildTimes$lambda$20$printBuildTime(visitedBuildTimes, $buildTimes, this$0, it);
                        }
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    Unit unit3 = unit2;
                }
                finally {
                    $this$iv.popIndent();
                }
            }
            List<BuildTime> list3 = BuildTime.Companion.getChildren().get(buildTime);
            if (list3 == null) break block11;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BuildTime it = (BuildTime)element$iv;
                boolean bl = false;
                FileReportService.printBuildTimes$lambda$20$printBuildTime(visitedBuildTimes, $buildTimes, this$0, it);
            }
        }
    }

    private static final int printSizeMetric$numberOfAncestors(BuildPerformanceMetric $this$printSizeMetric_u24numberOfAncestors) {
        int count = 0;
        for (BuildPerformanceMetric parent2 = $this$printSizeMetric_u24numberOfAncestors.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            ++count;
        }
        return count;
    }

    static {
        SimpleDateFormat simpleDateFormat;
        Companion = new Companion(null);
        SimpleDateFormat it = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        boolean bl = false;
        it.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter = simpleDateFormat;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/build/report/statistics/file/FileReportService$Companion;", "", "()V", "formatter", "Ljava/text/SimpleDateFormat;", "reportBuildStatInFile", "", "buildReportDir", "Ljava/io/File;", "projectName", "", "includeMetricsInReport", "", "buildData", "", "Lorg/jetbrains/kotlin/build/report/statistics/CompileStatisticsData;", "startParameters", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "failureMessages", "logger", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "kotlin-build-statistics"})
    public static final class Companion {
        private Companion() {
        }

        public final void reportBuildStatInFile(@NotNull File buildReportDir, @NotNull String projectName, boolean includeMetricsInReport, @NotNull List<CompileStatisticsData> buildData, @NotNull BuildStartParameters startParameters, @NotNull List<String> failureMessages, @NotNull KotlinLogger logger) {
            Intrinsics.checkNotNullParameter(buildReportDir, "buildReportDir");
            Intrinsics.checkNotNullParameter(projectName, "projectName");
            Intrinsics.checkNotNullParameter(buildData, "buildData");
            Intrinsics.checkNotNullParameter(startParameters, "startParameters");
            Intrinsics.checkNotNullParameter(failureMessages, "failureMessages");
            Intrinsics.checkNotNullParameter(logger, "logger");
            String ts = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(Calendar.getInstance().getTime());
            File reportFile = FilesKt.resolve(buildReportDir, projectName + "-build-" + ts + ".txt");
            new FileReportService(reportFile, includeMetricsInReport, logger).process(buildData, startParameters, failureMessages);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NANOSECONDS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

