/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.scraper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Pair;
import org.apache.solr.prometheus.collector.MetricSamples;
import org.apache.solr.prometheus.exporter.MetricsQuery;
import org.apache.solr.prometheus.exporter.SolrClientFactory;
import org.apache.solr.prometheus.scraper.SolrScraper;

public class SolrCloudScraper
extends SolrScraper {
    private final CloudSolrClient solrClient;
    private final SolrClientFactory solrClientFactory;
    private Cache<String, HttpSolrClient> hostClientCache = CacheBuilder.newBuilder().build();

    public SolrCloudScraper(CloudSolrClient solrClient, ExecutorService executor, SolrClientFactory solrClientFactory) {
        super(executor);
        this.solrClient = solrClient;
        this.solrClientFactory = solrClientFactory;
    }

    @Override
    public Map<String, MetricSamples> pingAllCores(MetricsQuery query) throws IOException {
        Map<String, HttpSolrClient> httpSolrClients = this.createHttpSolrClients();
        Map collectionState = this.solrClient.getClusterStateProvider().getClusterState().getCollectionsMap();
        List replicas = collectionState.values().stream().map(DocCollection::getReplicas).flatMap(Collection::stream).collect(Collectors.toList());
        List<String> coreNames = replicas.stream().map(Replica::getCoreName).collect(Collectors.toList());
        Map<String, HttpSolrClient> coreToClient = replicas.stream().map(replica -> new Pair((Object)replica.getCoreName(), (Object)((HttpSolrClient)httpSolrClients.get(replica.getBaseUrl())))).collect(Collectors.toMap(Pair::first, Pair::second));
        return this.sendRequestsInParallel(coreNames, core -> {
            try {
                return this.request((SolrClient)coreToClient.get(core), query.withCore((String)core));
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private Map<String, HttpSolrClient> createHttpSolrClients() throws IOException {
        return this.getBaseUrls().stream().map(url -> {
            try {
                return (HttpSolrClient)this.hostClientCache.get(url, () -> this.solrClientFactory.createStandaloneSolrClient((String)url));
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(HttpSolrClient::getBaseURL, Function.identity()));
    }

    @Override
    public Map<String, MetricSamples> pingAllCollections(MetricsQuery query) throws IOException {
        return this.sendRequestsInParallel(this.getCollections(), collection -> {
            try {
                return this.request((SolrClient)this.solrClient, query.withCollection((String)collection));
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    @Override
    public Map<String, MetricSamples> metricsForAllHosts(MetricsQuery query) throws IOException {
        Map<String, HttpSolrClient> httpSolrClients = this.createHttpSolrClients();
        return this.sendRequestsInParallel(httpSolrClients.keySet(), baseUrl -> {
            try {
                return this.request((SolrClient)httpSolrClients.get(baseUrl), query);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    @Override
    public MetricSamples search(MetricsQuery query) throws IOException {
        return this.request((SolrClient)this.solrClient, query);
    }

    @Override
    public MetricSamples collections(MetricsQuery metricsQuery) throws IOException {
        return this.request((SolrClient)this.solrClient, metricsQuery);
    }

    private Set<String> getBaseUrls() throws IOException {
        return this.solrClient.getClusterStateProvider().getClusterState().getCollectionsMap().values().stream().map(DocCollection::getReplicas).flatMap(Collection::stream).map(Replica::getBaseUrl).collect(Collectors.toSet());
    }

    private Set<String> getCollections() throws IOException {
        return this.solrClient.getClusterStateProvider().getClusterState().getCollectionStates().keySet();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.solrClient);
        this.hostClientCache.asMap().values().forEach(IOUtils::closeQuietly);
    }
}

