/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.api.CustomContainerPlugins;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientContextBuilder;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.autoscaling.AutoScalingHandler;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoreSorter;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCoreInitializationException;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.core.TracerConfigurator;
import org.apache.solr.core.TransientSolrCoreCache;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.BackupRepositoryFactory;
import org.apache.solr.filestore.PackageStoreAPI;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.CollectionBackupsAPI;
import org.apache.solr.handler.CollectionsAPI;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.AutoscalingHistoryHandler;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.admin.ContainerPluginsApi;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.HealthCheckHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.admin.MetricsCollectorHandler;
import org.apache.solr.handler.admin.MetricsHandler;
import org.apache.solr.handler.admin.MetricsHistoryHandler;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.handler.admin.SecurityConfHandlerLocal;
import org.apache.solr.handler.admin.SecurityConfHandlerZk;
import org.apache.solr.handler.admin.ZookeeperInfoHandler;
import org.apache.solr.handler.admin.ZookeeperReadAPI;
import org.apache.solr.handler.admin.ZookeeperStatusHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.designer.SchemaDesignerAPI;
import org.apache.solr.handler.sql.CalciteSolrDriver;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.pkg.PackageLoader;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.SolrFieldCacheBean;
import org.apache.solr.security.AuditLoggerPlugin;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.PKIAuthenticationPlugin;
import org.apache.solr.security.PublicKeyHandler;
import org.apache.solr.security.SecurityPluginHolder;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.OrderedExecutor;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrCores solrCores = new SolrCores(this);
    private volatile PluginBag<SolrRequestHandler> containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
    public final Supplier<SolrZkClient> zkClientSupplier = () -> this.getZkController().getZkClient();
    private final CustomContainerPlugins customContainerPlugins = new CustomContainerPlugins(this, this.containerHandlers.getApiBag());
    protected final Map<String, CoreLoadFailure> coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
    protected volatile CoreAdminHandler coreAdminHandler = null;
    protected volatile CollectionsHandler collectionsHandler = null;
    protected volatile HealthCheckHandler healthCheckHandler = null;
    private volatile InfoHandler infoHandler;
    protected volatile ConfigSetsHandler configSetsHandler = null;
    private volatile PKIAuthenticationPlugin pkiAuthenticationPlugin;
    protected volatile Properties containerProperties;
    private volatile ConfigSetService coreConfigService;
    protected final ZkContainer zkSys = new ZkContainer();
    protected volatile ShardHandlerFactory shardHandlerFactory;
    private volatile UpdateShardHandler updateShardHandler;
    private volatile ExecutorService coreContainerWorkExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("coreContainerWorkExecutor"));
    private final OrderedExecutor replayUpdatesExecutor;
    protected volatile LogWatcher logging = null;
    private volatile CloserThread backgroundCloser = null;
    protected final NodeConfig cfg;
    protected final SolrResourceLoader loader;
    protected final Path solrHome;
    protected final CoresLocator coresLocator;
    private volatile String hostName;
    private final BlobRepository blobRepository = new BlobRepository(this);
    private volatile boolean asyncSolrCoreLoad;
    protected volatile SecurityConfHandler securityConfHandler;
    private volatile SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin;
    private volatile SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin;
    private volatile SecurityPluginHolder<AuditLoggerPlugin> auditloggerPlugin;
    private volatile BackupRepositoryFactory backupRepoFactory;
    protected volatile SolrMetricManager metricManager;
    protected volatile String metricTag = SolrMetricProducer.getUniqueMetricTag(this, null);
    protected volatile SolrMetricsContext solrMetricsContext;
    protected MetricsHandler metricsHandler;
    protected volatile MetricsHistoryHandler metricsHistoryHandler;
    protected volatile MetricsCollectorHandler metricsCollectorHandler;
    protected volatile AutoscalingHistoryHandler autoscalingHistoryHandler;
    private volatile SolrClientCache solrClientCache;
    private final ObjectCache objectCache = new ObjectCache();
    private PackageStoreAPI packageStoreAPI;
    private PackageLoader packageLoader;
    private Set<Path> allowPaths;
    public static final long LOAD_COMPLETE = 1L;
    public static final long CORE_DISCOVERY_COMPLETE = 2L;
    public static final long INITIAL_CORE_LOAD_COMPLETE = 4L;
    private volatile long status = 0L;
    protected volatile AutoScalingHandler autoScalingHandler;
    private ExecutorService coreContainerAsyncTaskExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((String)"Core Container Async Task");
    private volatile boolean isShutDown;
    final Set<String> inFlightCreations;

    public BackupRepository newBackupRepository(Optional<String> repositoryName) {
        BackupRepository repository = repositoryName.isPresent() ? this.backupRepoFactory.newInstance(this.getResourceLoader(), repositoryName.get()) : this.backupRepoFactory.newInstance(this.getResourceLoader());
        return repository;
    }

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.zkSys.getCoreZkRegisterExecutorService();
    }

    public SolrRequestHandler getRequestHandler(String path) {
        return RequestHandlerBase.getRequestHandler(path, this.containerHandlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.containerHandlers;
    }

    public CoreContainer(Path solrHome, Properties properties) {
        this(SolrXmlConfig.fromSolrHome(solrHome, properties));
    }

    public CoreContainer(NodeConfig config) {
        this(config, new CorePropertiesLocator(config.getCoreRootDirectory()));
    }

    public CoreContainer(NodeConfig config, boolean asyncSolrCoreLoad) {
        this(config, new CorePropertiesLocator(config.getCoreRootDirectory()), asyncSolrCoreLoad);
    }

    public CoreContainer(NodeConfig config, CoresLocator locator) {
        this(config, locator, false);
    }

    public CoreContainer(NodeConfig config, CoresLocator locator, boolean asyncSolrCoreLoad) {
        if (log.isDebugEnabled()) {
            log.debug("New CoreContainer {}", (Object)System.identityHashCode(this));
        }
        this.isShutDown = false;
        this.inFlightCreations = ConcurrentHashMap.newKeySet();
        this.loader = config.getSolrResourceLoader();
        this.solrHome = config.getSolrHome();
        this.cfg = Objects.requireNonNull(config);
        this.containerHandlers.put("/admin/info/key", new PublicKeyHandler());
        if (null != this.cfg.getBooleanQueryMaxClauseCount()) {
            BooleanQuery.setMaxClauseCount((int)this.cfg.getBooleanQueryMaxClauseCount());
        }
        this.coresLocator = locator;
        this.containerProperties = new Properties(config.getSolrProperties());
        this.asyncSolrCoreLoad = asyncSolrCoreLoad;
        this.replayUpdatesExecutor = new OrderedExecutor(this.cfg.getReplayUpdatesThreads(), ExecutorUtil.newMDCAwareCachedThreadPool((int)this.cfg.getReplayUpdatesThreads(), (ThreadFactory)new SolrNamedThreadFactory("replayUpdatesExecutor")));
        this.allowPaths = new HashSet<Path>();
        this.allowPaths.add(this.cfg.getSolrHome());
        this.allowPaths.add(this.cfg.getCoreRootDirectory());
        if (this.cfg.getSolrDataHome() != null) {
            this.allowPaths.add(this.cfg.getSolrDataHome());
        }
        if (!this.cfg.getAllowPaths().isEmpty()) {
            this.allowPaths.addAll(this.cfg.getAllowPaths());
            if (log.isInfoEnabled()) {
                log.info("Allowing use of paths: {}", this.cfg.getAllowPaths());
            }
        }
        Path userFilesPath = this.getUserFilesPath();
        try {
            Files.createDirectories(userFilesPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            log.warn("Unable to create [{}].  Features requiring this directory may fail.", (Object)userFilesPath, (Object)e);
        }
    }

    private synchronized void initializeAuthorizationPlugin(Map<String, Object> authorizationConf) {
        authorizationConf = Utils.getDeepCopy(authorizationConf, (int)4);
        int newVersion = CoreContainer.readVersion(authorizationConf);
        SecurityPluginHolder<AuthorizationPlugin> old = this.authorizationPlugin;
        SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin = null;
        if (authorizationConf != null) {
            String klas = (String)authorizationConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for authorization plugin");
            }
            if (old != null && old.getZnodeVersion() == newVersion && newVersion > 0) {
                log.debug("Authorization config not modified");
                return;
            }
            log.info("Initializing authorization plugin: {}", (Object)klas);
            authorizationPlugin = new SecurityPluginHolder<AuthorizationPlugin>(newVersion, this.getResourceLoader().newInstance(klas, AuthorizationPlugin.class, null, new Class[]{CoreContainer.class}, new Object[]{this}));
            ((AuthorizationPlugin)authorizationPlugin.plugin).init(authorizationConf);
        } else {
            log.debug("Security conf doesn't exist. Skipping setup for authorization module.");
        }
        this.authorizationPlugin = authorizationPlugin;
        if (old != null) {
            try {
                ((AuthorizationPlugin)old.plugin).close();
            }
            catch (Exception e) {
                log.error("Exception while attempting to close old authorization plugin", (Throwable)e);
            }
        }
    }

    private void initializeAuditloggerPlugin(Map<String, Object> auditConf) {
        auditConf = Utils.getDeepCopy(auditConf, (int)4);
        int newVersion = CoreContainer.readVersion(auditConf);
        SecurityPluginHolder<AuditLoggerPlugin> old = this.auditloggerPlugin;
        SecurityPluginHolder<AuditLoggerPlugin> newAuditloggerPlugin = null;
        if (auditConf != null) {
            String klas = (String)auditConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for auditlogger plugin");
            }
            if (old != null && old.getZnodeVersion() == newVersion && newVersion > 0) {
                log.debug("Auditlogger config not modified");
                return;
            }
            log.info("Initializing auditlogger plugin: {}", (Object)klas);
            newAuditloggerPlugin = new SecurityPluginHolder<AuditLoggerPlugin>(newVersion, this.getResourceLoader().newInstance(klas, AuditLoggerPlugin.class));
            ((AuditLoggerPlugin)newAuditloggerPlugin.plugin).init(auditConf);
            ((AuditLoggerPlugin)newAuditloggerPlugin.plugin).initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "/auditlogging");
        } else {
            log.debug("Security conf doesn't exist. Skipping setup for audit logging module.");
        }
        this.auditloggerPlugin = newAuditloggerPlugin;
        if (old != null) {
            try {
                ((AuditLoggerPlugin)old.plugin).close();
            }
            catch (Exception e) {
                log.error("Exception while attempting to close old auditlogger plugin", (Throwable)e);
            }
        }
    }

    private synchronized void initializeAuthenticationPlugin(Map<String, Object> authenticationConfig) {
        authenticationConfig = Utils.getDeepCopy(authenticationConfig, (int)4);
        int newVersion = CoreContainer.readVersion(authenticationConfig);
        String pluginClassName = null;
        if (authenticationConfig != null) {
            if (authenticationConfig.containsKey("class")) {
                pluginClassName = String.valueOf(authenticationConfig.get("class"));
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'class' specified for authentication in ZK.");
            }
        }
        if (pluginClassName != null) {
            log.debug("Authentication plugin class obtained from security.json: {}", pluginClassName);
        } else if (System.getProperty("authenticationPlugin") != null) {
            pluginClassName = System.getProperty("authenticationPlugin");
            log.debug("Authentication plugin class obtained from system property '{}': {}", (Object)"authenticationPlugin", (Object)pluginClassName);
        } else {
            log.debug("No authentication plugin used.");
        }
        SecurityPluginHolder<AuthenticationPlugin> old = this.authenticationPlugin;
        SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin = null;
        if (old != null && old.getZnodeVersion() == newVersion && newVersion > 0) {
            log.debug("Authentication config not modified");
            return;
        }
        if (pluginClassName != null) {
            log.info("Initializing authentication plugin: {}", (Object)pluginClassName);
            authenticationPlugin = new SecurityPluginHolder<AuthenticationPlugin>(newVersion, this.getResourceLoader().newInstance(pluginClassName, AuthenticationPlugin.class, null, new Class[]{CoreContainer.class}, new Object[]{this}));
        }
        if (authenticationPlugin != null) {
            ((AuthenticationPlugin)authenticationPlugin.plugin).init(authenticationConfig);
            this.setupHttpClientForAuthPlugin(authenticationPlugin.plugin);
            ((AuthenticationPlugin)authenticationPlugin.plugin).initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "/authentication");
        }
        this.authenticationPlugin = authenticationPlugin;
        try {
            if (old != null) {
                ((AuthenticationPlugin)old.plugin).close();
            }
        }
        catch (Exception e) {
            log.error("Exception while attempting to close old authentication plugin", (Throwable)e);
        }
    }

    private void setupHttpClientForAuthPlugin(Object authcPlugin) {
        if (authcPlugin instanceof HttpClientBuilderPlugin) {
            HttpClientBuilderPlugin builderPlugin = (HttpClientBuilderPlugin)authcPlugin;
            final SolrHttpClientBuilder builder = builderPlugin.getHttpClientBuilder(HttpClientUtil.getHttpClientBuilder());
            this.shardHandlerFactory.setSecurityBuilder(builderPlugin);
            this.updateShardHandler.setSecurityBuilder(builderPlugin);
            log.debug("Reconfiguring HttpClient settings.");
            SolrHttpClientContextBuilder httpClientBuilder = new SolrHttpClientContextBuilder();
            if (builder.getCredentialsProviderProvider() != null) {
                httpClientBuilder.setDefaultCredentialsProvider(new SolrHttpClientContextBuilder.CredentialsProviderProvider(){

                    public CredentialsProvider getCredentialsProvider() {
                        return builder.getCredentialsProviderProvider().getCredentialsProvider();
                    }
                });
            }
            if (builder.getAuthSchemeRegistryProvider() != null) {
                httpClientBuilder.setAuthSchemeRegistryProvider(new SolrHttpClientContextBuilder.AuthSchemeRegistryProvider(){

                    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
                        return builder.getAuthSchemeRegistryProvider().getAuthSchemeRegistry();
                    }
                });
            }
            HttpClientUtil.setHttpClientRequestContextBuilder((SolrHttpClientContextBuilder)httpClientBuilder);
        }
        if (this.pkiAuthenticationPlugin != null && !this.pkiAuthenticationPlugin.isInterceptorRegistered()) {
            this.pkiAuthenticationPlugin.getHttpClientBuilder(HttpClientUtil.getHttpClientBuilder());
            this.shardHandlerFactory.setSecurityBuilder(this.pkiAuthenticationPlugin);
            this.updateShardHandler.setSecurityBuilder(this.pkiAuthenticationPlugin);
        }
    }

    private static int readVersion(Map<String, Object> conf) {
        if (conf == null) {
            return -1;
        }
        Map meta = (Map)conf.get("");
        if (meta == null) {
            return -1;
        }
        Number v = (Number)meta.get("v");
        return v == null ? -1 : v.intValue();
    }

    protected CoreContainer(Object testConstructor) {
        if (log.isDebugEnabled()) {
            log.debug("New CoreContainer {}", (Object)System.identityHashCode(this));
        }
        this.isShutDown = false;
        this.inFlightCreations = ConcurrentHashMap.newKeySet();
        this.solrHome = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
        this.containerProperties = null;
        this.replayUpdatesExecutor = null;
    }

    public static CoreContainer createAndLoad(Path solrHome) {
        return CoreContainer.createAndLoad(solrHome, solrHome.resolve("solr.xml"));
    }

    public static CoreContainer createAndLoad(Path solrHome, Path configFile) {
        CoreContainer cc = new CoreContainer(SolrXmlConfig.fromFile(solrHome, configFile, new Properties()));
        try {
            cc.load();
        }
        catch (Exception e) {
            cc.shutdown();
            throw e;
        }
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    public PKIAuthenticationPlugin getPkiAuthenticationPlugin() {
        return this.pkiAuthenticationPlugin;
    }

    public SolrMetricManager getMetricManager() {
        return this.metricManager;
    }

    public MetricsHandler getMetricsHandler() {
        return this.metricsHandler;
    }

    public MetricsHistoryHandler getMetricsHistoryHandler() {
        return this.metricsHistoryHandler;
    }

    public OrderedExecutor getReplayUpdatesExecutor() {
        return this.replayUpdatesExecutor;
    }

    public PackageLoader getPackageLoader() {
        return this.packageLoader;
    }

    public PackageStoreAPI getPackageStoreAPI() {
        return this.packageStoreAPI;
    }

    public SolrClientCache getSolrClientCache() {
        return this.solrClientCache;
    }

    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (log.isDebugEnabled()) {
            log.debug("Loading cores into CoreContainer [instanceDir={}]", (Object)this.getSolrHome());
        }
        LinkedHashSet<String> libDirs = new LinkedHashSet<String>();
        libDirs.add("lib");
        if (!StringUtils.isBlank((CharSequence)this.cfg.getSharedLibDirectory())) {
            List<String> sharedLibs = Arrays.asList(this.cfg.getSharedLibDirectory().split("\\s*,\\s*"));
            libDirs.addAll(sharedLibs);
        }
        boolean modified = false;
        for (String libDir : libDirs) {
            Path libPath = Paths.get(this.getSolrHome(), new String[0]).resolve(libDir);
            if (!Files.exists(libPath, new LinkOption[0])) continue;
            try {
                this.loader.addToClassLoader(SolrResourceLoader.getURLs(libPath));
                modified = true;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Couldn't load libs: " + e, (Throwable)e);
            }
        }
        if (modified) {
            this.loader.reloadLuceneSPI();
        }
        this.packageStoreAPI = new PackageStoreAPI(this);
        this.containerHandlers.getApiBag().registerObject(this.packageStoreAPI.readAPI);
        this.containerHandlers.getApiBag().registerObject(this.packageStoreAPI.writeAPI);
        this.metricManager = new SolrMetricManager(this.loader, this.cfg.getMetricsConfig());
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]);
        this.solrMetricsContext = new SolrMetricsContext(this.metricManager, registryName, this.metricTag);
        this.coreContainerWorkExecutor = MetricUtils.instrumentedExecutorService(this.coreContainerWorkExecutor, null, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])), SolrMetricManager.mkName("coreContainerWorkExecutor", SolrInfoBean.Category.CONTAINER.toString(), "threadPool"));
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        if (this.shardHandlerFactory instanceof SolrMetricProducer) {
            SolrMetricProducer metricProducer = (SolrMetricProducer)((Object)this.shardHandlerFactory);
            metricProducer.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "httpShardHandler");
        }
        this.updateShardHandler = new UpdateShardHandler(this.cfg.getUpdateShardHandlerConfig());
        this.updateShardHandler.initializeMetrics(this.solrMetricsContext, "updateShardHandler");
        this.solrClientCache = new SolrClientCache(this.updateShardHandler.getDefaultHttpClient());
        CalciteSolrDriver.INSTANCE.setSolrClientCache(this.solrClientCache);
        this.solrCores.load(this.loader);
        this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
        this.hostName = this.cfg.getNodeName();
        this.zkSys.initZooKeeper(this, this.cfg.getCloudConfig());
        if (this.isZooKeeperAware()) {
            this.pkiAuthenticationPlugin = new PKIAuthenticationPlugin(this, this.zkSys.getZkController().getNodeName(), (PublicKeyHandler)this.containerHandlers.get("/admin/info/key"));
            this.pkiAuthenticationPlugin.initializeMetrics(this.solrMetricsContext.metricManager, this.solrMetricsContext.registry, this.solrMetricsContext.tag, "/authentication/pki");
            TracerConfigurator.loadTracer(this.loader, this.cfg.getTracerConfiguratorPluginInfo(), this.getZkController().getZkStateReader());
            this.packageLoader = new PackageLoader(this);
            this.containerHandlers.getApiBag().registerObject(this.packageLoader.getPackageAPI().editAPI);
            this.containerHandlers.getApiBag().registerObject(this.packageLoader.getPackageAPI().readAPI);
            ZookeeperReadAPI zookeeperReadAPI = new ZookeeperReadAPI(this);
            this.containerHandlers.getApiBag().registerObject(zookeeperReadAPI);
        }
        MDCLoggingContext.setNode(this);
        this.securityConfHandler = this.isZooKeeperAware() ? new SecurityConfHandlerZk(this) : new SecurityConfHandlerLocal(this);
        this.reloadSecurityProperties();
        this.warnUsersOfInsecureSettings();
        this.backupRepoFactory = new BackupRepositoryFactory(this.cfg.getBackupRepositoryPlugins());
        this.createHandler("/admin/zookeeper", ZookeeperInfoHandler.class.getName(), ZookeeperInfoHandler.class);
        this.createHandler("/admin/zookeeper/status", ZookeeperStatusHandler.class.getName(), ZookeeperStatusHandler.class);
        this.collectionsHandler = this.createHandler("/admin/collections", this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
        CollectionsAPI collectionsAPI = new CollectionsAPI(this.collectionsHandler);
        this.containerHandlers.getApiBag().registerObject(collectionsAPI);
        CollectionBackupsAPI collectionBackupsAPI = new CollectionBackupsAPI(this.collectionsHandler);
        this.containerHandlers.getApiBag().registerObject(collectionBackupsAPI);
        this.configSetsHandler = this.createHandler("/admin/configs", this.cfg.getConfigSetsHandlerClass(), ConfigSetsHandler.class);
        ClusterAPI clusterAPI = new ClusterAPI(this.collectionsHandler, this.configSetsHandler);
        this.containerHandlers.getApiBag().registerObject(clusterAPI);
        this.containerHandlers.getApiBag().registerObject(clusterAPI.commands);
        this.containerHandlers.getApiBag().registerObject(clusterAPI.configSetCommands);
        if (this.isZooKeeperAware()) {
            this.containerHandlers.getApiBag().registerObject(new SchemaDesignerAPI(this));
        }
        this.healthCheckHandler = this.loader.newInstance(this.cfg.getHealthCheckHandlerClass(), HealthCheckHandler.class, null, new Class[]{CoreContainer.class}, new Object[]{this});
        this.infoHandler = this.createHandler("/admin/info", this.cfg.getInfoHandlerClass(), InfoHandler.class);
        this.coreAdminHandler = this.createHandler("/admin/cores", this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
        this.metricsHandler = new MetricsHandler(this);
        this.containerHandlers.put("/admin/metrics", this.metricsHandler);
        this.metricsHandler.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "/admin/metrics");
        this.createMetricsHistoryHandler();
        this.autoscalingHistoryHandler = this.createHandler("/admin/autoscaling/history", AutoscalingHistoryHandler.class.getName(), AutoscalingHistoryHandler.class);
        if (this.cfg.getMetricsConfig().isEnabled()) {
            this.metricsCollectorHandler = this.createHandler("/admin/metrics/collector", MetricsCollectorHandler.class.getName(), MetricsCollectorHandler.class);
            this.metricsCollectorHandler.init(null);
        }
        this.containerHandlers.put("/admin/authorization", this.securityConfHandler);
        this.securityConfHandler.initializeMetrics(this.solrMetricsContext, "/admin/authorization");
        this.containerHandlers.put("/admin/authentication", this.securityConfHandler);
        PluginInfo[] metricReporters = this.cfg.getMetricsConfig().getMetricReporters();
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.node, new String[0]);
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.jvm, new String[0]);
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.jetty, new String[0]);
        this.coreConfigService = ConfigSetService.createConfigSetService(this.cfg, this.loader, this.zkSys.zkController);
        this.containerProperties.putAll((Map<?, ?>)this.cfg.getSolrProperties());
        this.solrMetricsContext.gauge(null, this.solrCores::getNumLoadedPermanentCores, true, "loaded", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        this.solrMetricsContext.gauge(null, this.solrCores::getNumLoadedTransientCores, true, "lazy", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        this.solrMetricsContext.gauge(null, this.solrCores::getNumUnloadedCores, true, "unloaded", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        Path dataHome = this.cfg.getSolrDataHome() != null ? this.cfg.getSolrDataHome() : this.cfg.getCoreRootDirectory();
        this.solrMetricsContext.gauge(null, () -> dataHome.toFile().getTotalSpace(), true, "totalSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(null, () -> dataHome.toFile().getUsableSpace(), true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(null, () -> dataHome.toAbsolutePath().toString(), true, "path", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(null, () -> {
            try {
                return IOUtils.spins((Path)dataHome.toAbsolutePath());
            }
            catch (IOException e) {
                return true;
            }
        }, true, "spins", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.solrMetricsContext.gauge(null, () -> this.cfg.getCoreRootDirectory().toFile().getTotalSpace(), true, "totalSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(null, () -> this.cfg.getCoreRootDirectory().toFile().getUsableSpace(), true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(null, () -> this.cfg.getCoreRootDirectory().toAbsolutePath().toString(), true, "path", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(null, () -> {
            try {
                return IOUtils.spins((Path)this.cfg.getCoreRootDirectory().toAbsolutePath());
            }
            catch (IOException e) {
                return true;
            }
        }, true, "spins", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.solrMetricsContext.gauge(null, () -> this.getClass().getPackage().getSpecificationVersion(), true, "specification", SolrInfoBean.Category.CONTAINER.toString(), "version");
        this.solrMetricsContext.gauge(null, () -> this.getClass().getPackage().getImplementationVersion(), true, "implementation", SolrInfoBean.Category.CONTAINER.toString(), "version");
        SolrFieldCacheBean fieldCacheBean = new SolrFieldCacheBean();
        fieldCacheBean.initializeMetrics(this.solrMetricsContext, null);
        if (this.isZooKeeperAware()) {
            this.metricManager.loadClusterReporters(metricReporters, this);
        }
        ExecutorService coreLoadExecutor = MetricUtils.instrumentedExecutorService(ExecutorUtil.newMDCAwareFixedThreadPool((int)this.cfg.getCoreLoadThreadCount(this.isZooKeeperAware()), (ThreadFactory)new SolrNamedThreadFactory("coreLoadExecutor")), null, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])), SolrMetricManager.mkName("coreLoadExecutor", SolrInfoBean.Category.CONTAINER.toString(), "threadPool"));
        ArrayList<Future<SolrCore>> futures = new ArrayList<Future<SolrCore>>();
        try {
            List<CoreDescriptor> cds = this.coresLocator.discover(this);
            cds = CoreSorter.sortCores(this, cds);
            CoreContainer.checkForDuplicateCoreNames(cds);
            this.status |= 2L;
            for (CoreDescriptor cd : cds) {
                if (cd.isTransient() || !cd.isLoadOnStartup()) {
                    this.solrCores.addCoreDescriptor(cd);
                } else if (this.asyncSolrCoreLoad) {
                    this.solrCores.markCoreAsLoading(cd);
                }
                if (!cd.isLoadOnStartup()) continue;
                futures.add(coreLoadExecutor.submit(() -> {
                    SolrCore core;
                    try {
                        if (this.zkSys.getZkController() != null) {
                            this.zkSys.getZkController().throwErrorIfReplicaReplaced(cd);
                        }
                        this.solrCores.waitAddPendingCoreOps(cd.getName());
                        core = this.createFromDescriptor(cd, false, false);
                    }
                    finally {
                        this.solrCores.removeFromPendingOps(cd.getName());
                        if (this.asyncSolrCoreLoad) {
                            this.solrCores.markCoreAsNotLoading(cd);
                        }
                    }
                    try {
                        this.zkSys.registerInZk(core, true, false);
                    }
                    catch (RuntimeException e) {
                        SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)e);
                    }
                    return core;
                }));
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (this.asyncSolrCoreLoad && futures != null) {
                this.coreContainerWorkExecutor.submit(() -> {
                    try {
                        for (Future future : futures) {
                            try {
                                future.get();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                log.error("Error waiting for SolrCore to be loaded on startup", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
                    }
                });
            } else {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
        if (this.isZooKeeperAware()) {
            this.customContainerPlugins.refresh();
            this.getZkController().zkStateReader.registerClusterPropertiesListener((ClusterPropertiesListener)this.customContainerPlugins);
            ContainerPluginsApi containerPluginsApi = new ContainerPluginsApi(this);
            this.containerHandlers.getApiBag().registerObject(containerPluginsApi.readAPI);
            this.containerHandlers.getApiBag().registerObject(containerPluginsApi.editAPI);
            this.zkSys.getZkController().checkOverseerDesignate();
            this.autoScalingHandler = new AutoScalingHandler(this.getZkController().getSolrCloudManager(), this.loader);
            this.containerHandlers.put("/admin/autoscaling", this.autoScalingHandler);
            this.autoScalingHandler.initializeMetrics(this.solrMetricsContext, "/admin/autoscaling");
        }
        this.status |= 5L;
    }

    private void createMetricsHistoryHandler() {
        EmbeddedSolrServer client;
        SolrCloudManager cloudManager;
        String name;
        Map<String, Object> initArgs;
        PluginInfo plugin = this.cfg.getMetricsConfig().getHistoryHandler();
        if (plugin != null && "__noop__".equals(plugin.className)) {
            plugin = null;
        }
        if (plugin != null && plugin.initArgs != null) {
            initArgs = plugin.initArgs.asMap(5);
            initArgs.putIfAbsent("enable", plugin.isEnabled());
        } else {
            initArgs = new HashMap();
        }
        if (this.isZooKeeperAware()) {
            name = this.getZkController().getNodeName();
            cloudManager = this.getZkController().getSolrCloudManager();
            client = ((CloudSolrClient.Builder)((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(Collections.singletonList(this.getZkController().getZkServerAddress()), Optional.empty()).withSocketTimeout(30000)).withConnectionTimeout(15000)).withHttpClient(this.updateShardHandler.getDefaultHttpClient())).build();
        } else {
            name = this.getNodeConfig().getNodeName();
            if (name == null || name.isEmpty()) {
                name = "localhost";
            }
            cloudManager = null;
            client = new EmbeddedSolrServer(this, null);
            initArgs.putIfAbsent("enableNodes", true);
            initArgs.putIfAbsent("enableReplicas", true);
        }
        this.metricsHistoryHandler = new MetricsHistoryHandler(name, this.metricsHandler, client, cloudManager, initArgs);
        this.containerHandlers.put("/admin/metrics/history", this.metricsHistoryHandler);
        this.metricsHistoryHandler.initializeMetrics(this.solrMetricsContext, "/admin/metrics/history");
    }

    public void securityNodeChanged() {
        log.info("Security node changed, reloading security.json");
        this.reloadSecurityProperties();
    }

    private void reloadSecurityProperties() {
        SecurityConfHandler.SecurityConfig securityConfig = this.securityConfHandler.getSecurityConfig(false);
        this.initializeAuthorizationPlugin((Map)securityConfig.getData().get("authorization"));
        this.initializeAuthenticationPlugin((Map)securityConfig.getData().get("authentication"));
        this.initializeAuditloggerPlugin((Map)securityConfig.getData().get("auditlogging"));
    }

    private void warnUsersOfInsecureSettings() {
        if (this.authenticationPlugin == null || this.authorizationPlugin == null) {
            log.warn("Not all security plugins configured!  authentication={} authorization={}.  Solr is only as secure as you make it. Consider configuring authentication/authorization before exposing Solr to users internal or external.  See https://s.apache.org/solrsecurity for more info", (Object)(this.authenticationPlugin != null ? "enabled" : "disabled"), (Object)(this.authorizationPlugin != null ? "enabled" : "disabled"));
        }
        if (this.authenticationPlugin != null && StringUtils.isEmpty((CharSequence)System.getProperty("solr.jetty.https.port"))) {
            log.warn("Solr authentication is enabled, but SSL is off.  Consider enabling SSL to protect user credentials and data with encryption.");
        }
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap addedCores = Maps.newHashMap();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        ZkController zkController = this.getZkController();
        if (zkController != null) {
            OverseerTaskQueue overseerCollectionQueue = zkController.getOverseerCollectionQueue();
            overseerCollectionQueue.allowOverseerPendingTasksToComplete();
        }
        if (log.isInfoEnabled()) {
            log.info("Shutting down CoreContainer instance={}", (Object)System.identityHashCode(this));
        }
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerAsyncTaskExecutor);
        ExecutorService customThreadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("closeThreadPool"));
        this.isShutDown = true;
        try {
            block69: {
                if (this.isZooKeeperAware()) {
                    this.cancelCoreRecoveries();
                    this.zkSys.zkController.preClose();
                }
                this.pauseUpdatesAndAwaitInflightRequests();
                if (this.isZooKeeperAware()) {
                    this.zkSys.zkController.tryCancelAllElections();
                }
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerWorkExecutor);
                Object object = this.solrCores.getModifyLock();
                // MONITORENTER : object
                this.solrCores.getModifyLock().notifyAll();
                // MONITOREXIT : object
                if (this.backgroundCloser != null) {
                    try {
                        while (true) {
                            this.backgroundCloser.join(15000L);
                            if (this.backgroundCloser.isAlive()) {
                                object = this.solrCores.getModifyLock();
                                // MONITORENTER : object
                                this.solrCores.getModifyLock().notifyAll();
                                // MONITOREXIT : object
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block69;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            this.objectCache.clear();
            Object e = this.solrCores.getModifyLock();
            // MONITORENTER : e
            this.solrCores.getModifyLock().notifyAll();
            // MONITOREXIT : e
            customThreadPool.submit(() -> this.replayUpdatesExecutor.shutdownAndAwaitTermination());
            if (this.metricsHistoryHandler != null) {
                this.metricsHistoryHandler.close();
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)this.metricsHistoryHandler.getSolrClient());
            }
            if (this.metricManager != null) {
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]));
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]));
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jetty, new String[0]));
                this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]), this.metricTag);
                this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]), this.metricTag);
                this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jetty, new String[0]), this.metricTag);
            }
            if (this.isZooKeeperAware()) {
                this.cancelCoreRecoveries();
                if (this.metricManager != null) {
                    this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.cluster, new String[0]));
                }
            }
            try {
                if (this.coreAdminHandler != null) {
                    customThreadPool.submit(() -> this.coreAdminHandler.shutdown());
                }
            }
            catch (Exception e2) {
                log.warn("Error shutting down CoreAdminHandler. Continuing to close CoreContainer.", (Throwable)e2);
            }
            if (this.solrClientCache != null) {
                this.solrClientCache.close();
            }
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    customThreadPool.submit(() -> this.shardHandlerFactory.close());
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        customThreadPool.submit(this.updateShardHandler::close);
                    }
                }
                finally {
                    try {
                        this.zkSys.close();
                    }
                    finally {
                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)customThreadPool);
                    }
                }
            }
        }
        try {
            if (this.authorizationPlugin != null) {
                ((AuthorizationPlugin)this.authorizationPlugin.plugin).close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while closing authorization plugin.", (Throwable)e);
        }
        try {
            if (this.authenticationPlugin != null) {
                ((AuthenticationPlugin)this.authenticationPlugin.plugin).close();
                this.authenticationPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing authentication plugin.", (Throwable)e);
        }
        try {
            if (this.auditloggerPlugin != null) {
                ((AuditLoggerPlugin)this.auditloggerPlugin.plugin).close();
                this.auditloggerPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing auditlogger plugin.", (Throwable)e);
        }
        if (this.packageLoader != null) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.packageLoader});
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    private void pauseUpdatesAndAwaitInflightRequests() {
        this.getCores().parallelStream().forEach(solrCore -> {
            SolrCoreState solrCoreState = solrCore.getSolrCoreState();
            try {
                solrCoreState.pauseUpdatesAndAwaitInflightRequests();
            }
            catch (TimeoutException e) {
                log.warn("Timed out waiting for in-flight update requests to complete for core: {}", (Object)solrCore.getName());
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for in-flight update requests to complete for core: {}", (Object)solrCore.getName());
                Thread.currentThread().interrupt();
            }
        });
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not close prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance={}", (Object)System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    protected SolrCore registerCore(CoreDescriptor cd, SolrCore core, boolean registerInZk, boolean skipRecovery) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been closed");
        }
        assert (core.getName().equals(cd.getName())) : "core name " + core.getName() + " != cd " + cd.getName();
        SolrCore old = this.solrCores.putCore(cd, core);
        this.coreInitFailures.remove(cd.getName());
        if (old == null || old == core) {
            if (log.isDebugEnabled()) {
                log.debug("registering core: {}", (Object)cd.getName());
            }
            if (registerInZk) {
                this.zkSys.registerInZk(core, false, skipRecovery);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("replacing core: {}", (Object)cd.getName());
        }
        old.close();
        if (registerInZk) {
            this.zkSys.registerInZk(core, false, skipRecovery);
        }
        return old;
    }

    public SolrCore create(String coreName, Map<String, String> parameters) {
        return this.create(coreName, this.cfg.getCoreRootDirectory().resolve(coreName), parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore create(String coreName, Path instancePath, Map<String, String> parameters, boolean newCollection) {
        boolean iAdded = false;
        try {
            iAdded = this.inFlightCreations.add(coreName);
            if (!iAdded) {
                String msg = "Already creating a core with name '" + coreName + "', call aborted '";
                log.warn(msg);
                throw new SolrException(SolrException.ErrorCode.CONFLICT, msg);
            }
            CoreDescriptor cd = new CoreDescriptor(coreName, instancePath, parameters, this.getContainerProperties(), this.getZkController());
            if (this.getCoreDescriptor(coreName) != null) {
                log.warn("Creating a core with existing name is not allowed: '{}'", (Object)coreName);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with name '" + coreName + "' already exists.");
            }
            this.assertPathAllowed(cd.getInstanceDir());
            this.assertPathAllowed(Paths.get(cd.getDataDir(), new String[0]));
            boolean preExisitingZkEntry = false;
            try {
                SolrCore core;
                if (this.getZkController() != null) {
                    if (!Overseer.isLegacy(this.getZkController().getZkStateReader()) && cd.getCloudDescriptor().getCoreNodeName() == null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "non legacy mode coreNodeName missing " + parameters.toString());
                    }
                    preExisitingZkEntry = this.getZkController().checkIfCoreNodeNameAlreadyExists(cd);
                }
                this.coresLocator.create(this, cd);
                try {
                    this.solrCores.waitAddPendingCoreOps(cd.getName());
                    core = this.createFromDescriptor(cd, true, newCollection);
                    this.coresLocator.persist(this, cd);
                }
                finally {
                    this.solrCores.removeFromPendingOps(cd.getName());
                }
                SolrCore solrCore = core;
                return solrCore;
            }
            catch (Exception ex) {
                this.coresLocator.delete(this, cd);
                if (this.isZooKeeperAware() && !preExisitingZkEntry) {
                    try {
                        this.getZkController().unregister(coreName, cd);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        SolrException.log((Logger)log, null, (Throwable)e);
                    }
                    catch (KeeperException e) {
                        SolrException.log((Logger)log, null, (Throwable)e);
                    }
                    catch (Exception e) {
                        SolrException.log((Logger)log, null, (Throwable)e);
                    }
                }
                Throwable tc = ex;
                Throwable c = null;
                do {
                    if ((tc = tc.getCause()) == null) continue;
                    c = tc;
                } while (tc != null);
                String rootMsg = "";
                if (c != null) {
                    rootMsg = " Caused by: " + c.getMessage();
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error CREATEing SolrCore '" + coreName + "': " + ex.getMessage() + rootMsg, (Throwable)ex);
            }
        }
        finally {
            if (iAdded) {
                this.inFlightCreations.remove(coreName);
            }
        }
    }

    public void assertPathAllowed(Path pathToAssert) throws SolrException {
        SolrPaths.assertPathAllowed(pathToAssert, this.allowPaths);
    }

    @VisibleForTesting
    public Set<Path> getAllowPaths() {
        return this.allowPaths;
    }

    private SolrCore createFromDescriptor(CoreDescriptor dcore, boolean publishState, boolean newCollection) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has been shutdown.");
        }
        SolrCore core = null;
        try {
            MDCLoggingContext.setCoreDescriptor(this, dcore);
            SolrIdentifierValidator.validateCoreName((String)dcore.getName());
            if (this.zkSys.getZkController() != null) {
                this.zkSys.getZkController().preRegister(dcore, publishState);
            }
            ConfigSet coreConfig = this.coreConfigService.loadConfigSet(dcore);
            dcore.setConfigSetTrusted(coreConfig.isTrusted());
            if (log.isInfoEnabled()) {
                log.info("Creating SolrCore '{}' using configuration from {}, trusted={}", new Object[]{dcore.getName(), coreConfig.getName(), dcore.isConfigSetTrusted()});
            }
            try {
                core = new SolrCore(this, dcore, coreConfig);
            }
            catch (SolrException e) {
                core = this.processCoreCreateException(e, dcore, coreConfig);
            }
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            this.registerCore(dcore, core, publishState, newCollection);
            SolrCore e = core;
            return e;
        }
        catch (Exception e) {
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, e));
            if (e instanceof ZkController.NotInClusterStateException && !newCollection) {
                this.unload(dcore.getName(), true, true, true);
                throw e;
            }
            this.solrCores.removeCoreDescriptor(dcore);
            SolrException solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create core [" + dcore.getName() + "]", (Throwable)e);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw solrException;
        }
        catch (Throwable t) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM Error creating core [" + dcore.getName() + "]: " + t.getMessage(), t);
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, (Exception)((Object)e)));
            this.solrCores.removeCoreDescriptor(dcore);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw t;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public boolean isSharedFs(CoreDescriptor cd) {
        try (SolrCore core = this.getCore(cd.getName());){
            if (core != null) {
                boolean bl = core.getDirectoryFactory().isSharedStorage();
                return bl;
            }
            ConfigSet configSet = this.coreConfigService.loadConfigSet(cd);
            boolean bl = DirectoryFactory.loadDirectoryFactory(configSet.getSolrConfig(), this, null).isSharedStorage();
            return bl;
        }
    }

    private SolrCore processCoreCreateException(SolrException original, CoreDescriptor dcore, ConfigSet coreConfig) {
        Throwable cause = original;
        while ((cause = cause.getCause()) != null && !(cause instanceof CorruptIndexException)) {
        }
        if (cause == null) {
            throw original;
        }
        CoreInitFailedAction action = CoreInitFailedAction.valueOf(System.getProperty(CoreInitFailedAction.class.getSimpleName(), "none"));
        log.debug("CorruptIndexException while creating core, will attempt to repair via {}", (Object)action);
        switch (action) {
            case fromleader: {
                if (this.isZooKeeperAware()) {
                    CloudDescriptor desc = dcore.getCloudDescriptor();
                    try {
                        Replica leader = this.getZkController().getClusterState().getCollection(desc.getCollectionName()).getSlice(desc.getShardId()).getLeader();
                        if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                            log.info("Found active leader, will attempt to create fresh core and recover.");
                            this.resetIndexDirectory(dcore, coreConfig);
                            this.getZkController().getShardTerms(desc.getCollectionName(), desc.getShardId()).setTermToZero(desc.getCoreNodeName());
                            return new SolrCore(this, dcore, coreConfig);
                        }
                    }
                    catch (SolrException se) {
                        se.addSuppressed((Throwable)original);
                        throw se;
                    }
                }
                throw original;
            }
            case none: {
                throw original;
            }
        }
        log.warn("Failed to create core, and did not recognize specified 'CoreInitFailedAction': [{}]. Valid options are {}.", (Object)action, Arrays.asList(CoreInitFailedAction.values()));
        throw original;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetIndexDirectory(CoreDescriptor dcore, ConfigSet coreConfig) {
        SolrConfig config = coreConfig.getSolrConfig();
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, dcore.getName());
        DirectoryFactory df = DirectoryFactory.loadDirectoryFactory(config, this, registryName);
        String dataDir = SolrCore.findDataDir(df, null, config, dcore);
        String tmpIdxDirName = "index." + new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(new Date());
        SolrCore.modifyIndexProps(df, dataDir, config, tmpIdxDirName);
        Directory dir = null;
        try {
            dir = df.get(dataDir, DirectoryFactory.DirContext.META_DATA, config.indexConfig.lockType);
        }
        catch (IOException e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    df.release(dir);
                    df.doneWithDirectory(dir);
                    throw throwable;
                }
                catch (IOException e2) {
                    SolrException.log((Logger)log, (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            df.release(dir);
            df.doneWithDirectory(dir);
            return;
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (Throwable)e);
            return;
        }
    }

    public List<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public List<String> getLoadedCoreNames() {
        return this.solrCores.getLoadedCoreNames();
    }

    public List<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    public int getNumAllCores() {
        return this.solrCores.getNumAllCores();
    }

    public Map<String, CoreLoadFailure> getCoreInitFailures() {
        return ImmutableMap.copyOf(this.coreInitFailures);
    }

    private CoreDescriptor reloadCoreDescriptor(CoreDescriptor oldDesc) {
        if (oldDesc == null) {
            return null;
        }
        CorePropertiesLocator cpl = new CorePropertiesLocator(null);
        CoreDescriptor ret = cpl.buildCoreDescriptor(oldDesc.getInstanceDir().resolve("core.properties"), this);
        if (ret == null) {
            oldDesc.loadExtraProperties();
            return oldDesc;
        }
        if (ret.getCloudDescriptor() != null) {
            ret.getCloudDescriptor().reload(oldDesc.getCloudDescriptor());
        }
        return ret;
    }

    public void reload(String name) {
        this.reload(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name, UUID coreId) {
        if (this.isShutDown) {
            throw new AlreadyClosedException();
        }
        SolrCore newCore = null;
        SolrCore core = this.solrCores.getCoreFromAnyList(name, false, coreId);
        if (core != null) {
            CoreDescriptor cd = this.reloadCoreDescriptor(core.getCoreDescriptor());
            this.solrCores.addCoreDescriptor(cd);
            Object oldCore = null;
            boolean success = false;
            try {
                RefCounted<IndexWriter> iwRef;
                this.solrCores.waitAddPendingCoreOps(cd.getName());
                ConfigSet coreConfig = this.coreConfigService.loadConfigSet(cd);
                if (log.isInfoEnabled()) {
                    log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
                }
                newCore = core.reload(coreConfig);
                DocCollection docCollection = null;
                if (this.getZkController() != null && (docCollection = this.getZkController().getClusterState().getCollection(cd.getCollectionName())).getBool("readOnly", false)) {
                    newCore.readOnly = true;
                }
                this.registerCore(cd, newCore, false, false);
                if (newCore.readOnly && (iwRef = core.getSolrCoreState().getIndexWriter(null)) != null) {
                    IndexWriter iw = iwRef.get();
                    core.readOnly = true;
                    try {
                        if (iw != null) {
                            iw.commit();
                        }
                    }
                    finally {
                        iwRef.decref();
                    }
                }
                if (docCollection != null) {
                    Replica replica = docCollection.getReplica(cd.getCloudDescriptor().getCoreNodeName());
                    assert (replica != null);
                    if (replica.getType() == Replica.Type.TLOG) {
                        this.getZkController().stopReplicationFromLeader(core.getName());
                        if (!cd.getCloudDescriptor().isLeader()) {
                            this.getZkController().startReplicationFromLeader(newCore.getName(), true);
                        }
                    } else if (replica.getType() == Replica.Type.PULL) {
                        this.getZkController().stopReplicationFromLeader(core.getName());
                        this.getZkController().startReplicationFromLeader(newCore.getName(), false);
                    }
                }
                success = true;
            }
            catch (SolrCoreState.CoreIsClosedException e) {
                throw e;
            }
            catch (Exception e) {
                this.coreInitFailures.put(cd.getName(), new CoreLoadFailure(cd, e));
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to reload core [" + cd.getName() + "]", (Throwable)e);
            }
            finally {
                if (!success && newCore != null && newCore.getOpenCount() > 0) {
                    org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)newCore);
                }
                this.solrCores.removeFromPendingOps(cd.getName());
            }
        }
        if (coreId != null) {
            return;
        }
        CoreLoadFailure clf = this.coreInitFailures.get(name);
        if (clf != null) {
            try {
                this.solrCores.waitAddPendingCoreOps(clf.cd.getName());
                this.createFromDescriptor(clf.cd, true, false);
            }
            finally {
                this.solrCores.removeFromPendingOps(clf.cd.getName());
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
    }

    public void swap(String n0, String n1) {
        this.apiAssumeStandalone();
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: {} with {}", (Object)n0, (Object)n1);
    }

    public void unload(String name) {
        this.unload(name, false, false, false);
    }

    public void unload(String name, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        CoreLoadFailure loadFailure;
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        if (name != null && (loadFailure = this.coreInitFailures.remove(name)) != null) {
            SolrCore.deleteUnloadedCore(loadFailure.cd, deleteDataDir, deleteInstanceDir);
            if (cd != null) {
                this.solrCores.removeCoreDescriptor(cd);
                this.coresLocator.delete(this, cd);
            }
            return;
        }
        if (cd == null) {
            log.warn("Cannot unload non-existent core '{}'", (Object)name);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot unload non-existent core [" + name + "]");
        }
        boolean close = this.solrCores.isLoadedNotPendingClose(name);
        SolrCore core = this.solrCores.remove(name);
        this.solrCores.removeCoreDescriptor(cd);
        this.coresLocator.delete(this, cd);
        if (core == null) {
            SolrCore.deleteUnloadedCore(cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        this.metricManager.removeRegistry(core.getCoreMetricManager().getRegistryName());
        if (this.zkSys.getZkController() != null) {
            core.getSolrCoreState().cancelRecovery();
            if (cd.getCloudDescriptor().getReplicaType() == Replica.Type.PULL || cd.getCloudDescriptor().getReplicaType() == Replica.Type.TLOG) {
                this.zkSys.getZkController().stopReplicationFromLeader(name);
            }
        }
        core.unloadOnClose(cd, deleteIndexDir, deleteDataDir, deleteInstanceDir);
        if (close) {
            core.closeAndWait();
        }
        if (this.zkSys.getZkController() != null) {
            try {
                this.zkSys.getZkController().unregister(name, cd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while unregistering core [" + name + "] from cloud state");
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
        }
    }

    public void rename(String name, String toName) {
        this.apiAssumeStandalone();
        SolrIdentifierValidator.validateCoreName((String)toName);
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                String oldRegistryName = core.getCoreMetricManager().getRegistryName();
                String newRegistryName = SolrCoreMetricManager.createRegistryName(core, toName);
                this.metricManager.swapRegistries(oldRegistryName, newRegistryName);
                CoreDescriptor cd = core.getCoreDescriptor();
                this.solrCores.removeCoreDescriptor(cd);
                cd.setProperty("name", toName);
                this.solrCores.addCoreDescriptor(cd);
                core.setName(toName);
                this.registerCore(cd, core, true, false);
                SolrCore old = this.solrCores.remove(name);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    private void apiAssumeStandalone() {
        if (this.getZkController() != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not supported in SolrCloud");
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        return this.solrCores.getCoreDescriptor(coreName);
    }

    public Path getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    public SolrCore getCore(String name) {
        return this.getCore(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name, UUID id) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, true, id);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getCoreDescriptor(name);
        CoreLoadFailure loadFailure = this.getCoreInitFailures().get(name);
        if (null != loadFailure) {
            throw new SolrCoreInitializationException(name, loadFailure.exception);
        }
        if (desc == null || this.zkSys.getZkController() != null) {
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.zkSys.getZkController().throwErrorIfReplicaReplaced(desc);
                }
                core = this.createFromDescriptor(desc, true, false);
            }
            core.open();
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    public BlobRepository getBlobRepository() {
        return this.blobRepository;
    }

    public void waitForLoadingCoresToFinish(long timeoutMs) {
        this.solrCores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public void waitForLoadingCore(String name, long timeoutMs) {
        this.solrCores.waitForLoadingCoreToFinish(name, timeoutMs);
    }

    protected <T> T createHandler(String path, String handlerClass, Class<T> clazz) {
        T handler = this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
        if (handler instanceof SolrRequestHandler) {
            this.containerHandlers.put(path, (SolrRequestHandler)handler);
        }
        if (handler instanceof SolrMetricProducer) {
            ((SolrMetricProducer)handler).initializeMetrics(this.solrMetricsContext.metricManager, this.solrMetricsContext.registry, this.solrMetricsContext.tag, path);
        }
        return handler;
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public HealthCheckHandler getHealthCheckHandler() {
        return this.healthCheckHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public ConfigSetsHandler getConfigSetsHandler() {
        return this.configSetsHandler;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public boolean isLoadedNotPendingClose(String name) {
        return this.solrCores.isLoadedNotPendingClose(name);
    }

    public void queueCoreToClose(SolrCore coreToClose) {
        this.solrCores.queueCoreToClose(coreToClose);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    public String getSolrHome() {
        return this.solrHome.toString();
    }

    public Path getUserFilesPath() {
        return this.solrHome.resolve("userfiles");
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public NodeConfig getConfig() {
        return this.cfg;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public boolean isCoreLoading(String name) {
        return this.solrCores.isCoreLoading(name);
    }

    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin == null ? null : (AuthorizationPlugin)this.authorizationPlugin.plugin;
    }

    public AuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin == null ? null : (AuthenticationPlugin)this.authenticationPlugin.plugin;
    }

    public AuditLoggerPlugin getAuditLoggerPlugin() {
        return this.auditloggerPlugin == null ? null : (AuditLoggerPlugin)this.auditloggerPlugin.plugin;
    }

    public NodeConfig getNodeConfig() {
        return this.cfg;
    }

    public long getStatus() {
        return this.status;
    }

    public TransientSolrCoreCache getTransientCache() {
        return this.solrCores.getTransientCacheHandler();
    }

    public boolean repairCoreProperty(CoreDescriptor cd, String prop) {
        if (!"coreNodeName".equals(prop)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "The only supported property for repair is currently [%s]", "coreNodeName"));
        }
        String coreName = cd.getName();
        DocCollection coll = this.getZkController().getZkStateReader().getClusterState().getCollection(cd.getCollectionName());
        for (Replica rep : coll.getReplicas()) {
            if (!coreName.equals(rep.getCoreName())) continue;
            log.warn("Core properties file for node {} found with no coreNodeName, attempting to repair with value {}. See SOLR-11503. {}", new Object[]{"This message should only appear if upgrading from collections created Solr 6.6.1 through 7.1.", rep.getCoreName(), rep.getName()});
            cd.getCloudDescriptor().setCoreNodeName(rep.getName());
            this.coresLocator.persist(this, cd);
            return true;
        }
        log.error("Could not repair coreNodeName in core.properties file for core {}", (Object)coreName);
        return false;
    }

    public boolean checkTragicException(SolrCore solrCore) {
        Throwable tragicException;
        try {
            tragicException = solrCore.getSolrCoreState().getTragicException();
        }
        catch (IOException e) {
            tragicException = e;
        }
        if (tragicException != null && this.isZooKeeperAware()) {
            this.getZkController().giveupLeadership(solrCore.getCoreDescriptor());
            try {
                solrCore.getSolrCoreState().newIndexWriter(solrCore, false);
            }
            catch (IOException e) {
                log.warn("Could not roll index writer after tragedy");
            }
        }
        return tragicException != null;
    }

    public CustomContainerPlugins getCustomContainerPlugins() {
        return this.customContainerPlugins;
    }

    public void runAsync(Runnable r) {
        this.coreContainerAsyncTaskExecutor.submit(r);
    }

    static {
        ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)SolrRequestInfo.getInheritableThreadLocalProvider());
    }

    public static class CoreLoadFailure {
        public final CoreDescriptor cd;
        public final Exception exception;

        public CoreLoadFailure(CoreDescriptor cd, Exception loadFailure) {
            this.cd = new CoreDescriptor(cd.getName(), cd);
            this.exception = loadFailure;
        }
    }

    private static enum CoreInitFailedAction {
        fromleader,
        none;

    }
}

