/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCircuitBreaker
extends CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private boolean enabled;
    private final long heapMemoryThreshold;
    private static final ThreadLocal<Long> seenMemory = ThreadLocal.withInitial(() -> 0L);
    private static final ThreadLocal<Long> allowedMemory = ThreadLocal.withInitial(() -> 0L);

    public MemoryCircuitBreaker(CircuitBreaker.CircuitBreakerConfig config) {
        super(config);
        this.enabled = config.getMemCBEnabled();
        long currentMaxHeap = MEMORY_MX_BEAN.getHeapMemoryUsage().getMax();
        if (currentMaxHeap <= 0L) {
            throw new IllegalArgumentException("Invalid JVM state for the max heap usage");
        }
        int thresholdValueInPercentage = config.getMemCBThreshold();
        double thresholdInFraction = (double)thresholdValueInPercentage / 100.0;
        this.heapMemoryThreshold = (long)((double)currentMaxHeap * thresholdInFraction);
        if (this.heapMemoryThreshold <= 0L) {
            throw new IllegalStateException("Memory limit cannot be less than or equal to zero");
        }
    }

    @Override
    public boolean isTripped() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        long localAllowedMemory = this.getCurrentMemoryThreshold();
        long localSeenMemory = this.calculateLiveMemoryUsage();
        allowedMemory.set(localAllowedMemory);
        seenMemory.set(localSeenMemory);
        return localSeenMemory >= localAllowedMemory;
    }

    @Override
    public String getDebugInfo() {
        if (seenMemory.get() == 0L || allowedMemory.get() == 0L) {
            log.warn("MemoryCircuitBreaker's monitored values (seenMemory, allowedMemory) not set");
        }
        return "seenMemory=" + seenMemory.get() + " allowedMemory=" + allowedMemory.get();
    }

    @Override
    public String getErrorMessage() {
        return "Memory Circuit Breaker triggered as JVM heap usage values are greater than allocated threshold.Seen JVM heap memory usage " + seenMemory.get() + " and allocated threshold " + allowedMemory.get();
    }

    private long getCurrentMemoryThreshold() {
        return this.heapMemoryThreshold;
    }

    protected long calculateLiveMemoryUsage() {
        return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
    }
}

