(* blackbox *)
module EHXPLLJ (
    input CLKI, CLKFB,
    input PHASESEL1, PHASESEL0, PHASEDIR, PHASESTEP, 
    input LOADREG, STDBY, PLLWAKESYNC, RST, RESETM, RESETC, RESETD, 
    input ENCLKOP, ENCLKOS, ENCLKOS2, ENCLKOS3, PLLCLK, PLLRST, PLLSTB, PLLWE, 
    input PLLDATI7, PLLDATI6, PLLDATI5, PLLDATI4, PLLDATI3, PLLDATI2, PLLDATI1, PLLDATI0, 
    input PLLADDR4, PLLADDR3, PLLADDR2, PLLADDR1, PLLADDR0,
    output CLKOP, CLKOS, CLKOS2, CLKOS3, LOCK, INTLOCK, REFCLK, 
    output PLLDATO7, PLLDATO6, PLLDATO5, PLLDATO4, PLLDATO3, PLLDATO2, PLLDATO1, PLLDATO0, PLLACK, 
    output DPHSRC, CLKINTFB
);
    parameter CLKI_DIV = 1;
    parameter CLKFB_DIV = 1;
    parameter CLKOP_DIV = 8;
    parameter CLKOS_DIV = 8;
    parameter CLKOS2_DIV = 8;
    parameter CLKOS3_DIV = 8;
    parameter CLKOP_ENABLE = "ENABLED";
    parameter CLKOS_ENABLE = "ENABLED";
    parameter CLKOS2_ENABLE = "ENABLED";
    parameter CLKOS3_ENABLE = "ENABLED";
    parameter VCO_BYPASS_A0 = "DISABLED";
    parameter VCO_BYPASS_B0 = "DISABLED";
    parameter VCO_BYPASS_C0 = "DISABLED";
    parameter VCO_BYPASS_D0 = "DISABLED";
    parameter CLKOP_CPHASE = 0;
    parameter CLKOS_CPHASE = 0;
    parameter CLKOS2_CPHASE = 0;
    parameter CLKOS3_CPHASE = 0;
    parameter CLKOP_FPHASE = 0;
    parameter CLKOS_FPHASE = 0;
    parameter CLKOS2_FPHASE = 0;
    parameter CLKOS3_FPHASE = 0;
    parameter FEEDBK_PATH = "CLKOP";
    parameter FRACN_ENABLE = "DISABLED";
    parameter FRACN_DIV = 0;
    parameter CLKOP_TRIM_POL = "RISING";
    parameter CLKOP_TRIM_DELAY = 0;
    parameter CLKOS_TRIM_POL = "RISING";
    parameter CLKOS_TRIM_DELAY = 0;
    parameter PLL_USE_WB = "DISABLED";
    parameter PREDIVIDER_MUXA1 = 0;
    parameter PREDIVIDER_MUXB1 = 0;
    parameter PREDIVIDER_MUXC1 = 0;
    parameter PREDIVIDER_MUXD1 = 0;
    parameter OUTDIVIDER_MUXA2 = "DIVA";
    parameter OUTDIVIDER_MUXB2 = "DIVB";
    parameter OUTDIVIDER_MUXC2 = "DIVC";
    parameter OUTDIVIDER_MUXD2 = "DIVD";
    parameter PLL_LOCK_MODE = 0;
    parameter STDBY_ENABLE = "DISABLED";
    parameter DPHASE_SOURCE = "DISABLED";
    parameter PLLRST_ENA = "DISABLED";
    parameter MRST_ENA = "DISABLED";
    parameter DCRST_ENA = "DISABLED";
    parameter DDRST_ENA = "DISABLED";
    parameter INTFB_WAKE = "DISABLED";
endmodule

(* blackbox *)
module OSCH #(
	parameter NOM_FREQ = "2.08"
) (
	input STDBY,
	output OSC,
	output SEDSTDBY
);
endmodule

(* blackbox *)
module DCCA (
	input CLKI,
	input CE,
	output CLKO
);
endmodule

(* blackbox *)
module DCMA (
	input CLK0,
	input CLK1,
	input SEL,
	output DCMOUT
);
endmodule

(* blackbox *)
module PDPW8KC (
    input DI17, DI16, DI15, DI14, DI13, DI12, DI11, DI10, DI9, DI8, DI7, DI6, DI5, DI4, DI3, DI2, DI1, DI0,
    input ADW8, ADW7, ADW6, ADW5, ADW4, ADW3, ADW2, ADW1, ADW0,
    input BE1, BE0,
    input CEW, CLKW, CSW2, CSW1, CSW0,
    input ADR12, ADR11, ADR10, ADR9, ADR8, ADR7, ADR6, ADR5, ADR4,  ADR3,  ADR2, ADR1, ADR0,
    input CER, OCER, CLKR, CSR2, CSR1, CSR0, RST,
    output DO17, DO16, DO15, DO14, DO13, DO12, DO11, DO10, DO9, DO8, DO7, DO6, DO5, DO4, DO3, DO2, DO1, DO0
);
    parameter DATA_WIDTH_W = 18;
    parameter DATA_WIDTH_R = 9;

    parameter GSR = "ENABLED";

    parameter REGMODE = "NOREG";

    parameter RESETMODE = "SYNC";
    parameter ASYNC_RESET_RELEASE = "SYNC";

    parameter CSDECODE_W = "0b000";
    parameter CSDECODE_R = "0b000";

    parameter INITVAL_00 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_01 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_02 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_03 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_04 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_05 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_06 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_07 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_08 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_09 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_10 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_11 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_12 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_13 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_14 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_15 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_16 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_17 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_18 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_19 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_DATA = "STATIC";

endmodule

(* blackbox *)
module SP8KC (
    input DI8, DI7, DI6, DI5, DI4, DI3, DI2, DI1, DI0,
    input AD12, AD11, AD10, AD9, AD8, AD7, AD6, AD5, AD4, AD3, AD2, AD1, AD0,
    input CE, OCE, CLK, WE, CS2, CS1, CS0, RST,
    output DO8, DO7, DO6, DO5, DO4, DO3, DO2, DO1, DO0
);
    parameter DATA_WIDTH = 9;
    parameter GSR = "ENABLED";

    parameter REGMODE = "NOREG";

    parameter RESETMODE = "SYNC";
    parameter ASYNC_RESET_RELEASE = "SYNC";

    parameter CSDECODE = "0b000";

    parameter WRITEMODE = "NORMAL";

    parameter INITVAL_00 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_01 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_02 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_03 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_04 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_05 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_06 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_07 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_08 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_09 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_0F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_10 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_11 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_12 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_13 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_14 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_15 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_16 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_17 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_18 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_19 = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1A = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1B = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1C = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1D = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1E = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INITVAL_1F = 320'h00000000000000000000000000000000000000000000000000000000000000000000000000000000;
    parameter INIT_DATA = "STATIC";
endmodule

(* blackbox *)
module FIFO8KB (
    input DI0, DI1, DI2, DI3, DI4, DI5, DI6, DI7, DI8, DI9, DI10, DI11, DI12, DI13, DI14, DI15, DI16, DI17,
    input CSW0, CSW1, CSR0, CSR1, WE, RE, ORE, CLKW, CLKR, RST, RPRST, FULLI, EMPTYI,
    output DO0, DO1, DO2, DO3, DO4, DO5, DO6, DO7, DO8, DO9, DO10, DO11, DO12, DO13, DO14, DO15, DO16, DO17,
    input EF, AEF, AFF, FF
);
    parameter DATA_WIDTH_W = 18;
    parameter DATA_WIDTH_R = 18;

    parameter GSR = "DISABLED";

    parameter REGMODE = "NOREG";

    parameter RESETMODE = "ASYNC";
    parameter ASYNC_RESET_RELEASE = "SYNC";

    parameter CSDECODE_W = "0b00";
    parameter CSDECODE_R = "0b00";

    parameter AEPOINTER    = "0b00000000000000";
    parameter AEPOINTER1   = "0b00000000000000";
    parameter AFPOINTER    = "0b00000000000000";
    parameter AFPOINTER1   = "0b00000000000000";
    parameter FULLPOINTER  = "0b00000000000000";
    parameter FULLPOINTER1 = "0b00000000000000";
endmodule
