/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import java.io.IOException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.ModelProfile;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class ModelProfileOnNode
implements Writeable,
ToXContent {
    public static final String NODE_ID = "node_id";
    private final String nodeId;
    private final ModelProfile modelProfile;

    public ModelProfileOnNode(String nodeId, ModelProfile modelProfile) {
        this.nodeId = nodeId;
        this.modelProfile = modelProfile;
    }

    public ModelProfileOnNode(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.modelProfile = new ModelProfile(in);
    }

    public String getModelId() {
        return this.modelProfile.getModelId();
    }

    public long getModelSize() {
        return this.modelProfile.getModelSizeInBytes();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public ModelProfile getModelProfile() {
        return this.modelProfile;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.modelProfile.toXContent(builder, params);
        builder.field(NODE_ID, this.nodeId);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        this.modelProfile.writeTo(out);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof ModelProfileOnNode) {
            ModelProfileOnNode other = (ModelProfileOnNode)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.modelProfile, (Object)other.modelProfile);
            equalsBuilder.append((Object)this.nodeId, (Object)other.nodeId);
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.modelProfile).append((Object)this.nodeId).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("model", (Object)this.modelProfile);
        builder.append(NODE_ID, (Object)this.nodeId);
        return builder.toString();
    }
}

