/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.transport;

import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionRequest;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionResponse;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportDeleteDataSourceAction
extends HandledTransportAction<DeleteDataSourceActionRequest, DeleteDataSourceActionResponse> {
    public static final String NAME = "cluster:admin/opensearch/ql/datasources/delete";
    public static final ActionType<DeleteDataSourceActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/ql/datasources/delete", DeleteDataSourceActionResponse::new);
    private DataSourceService dataSourceService;

    @Inject
    public TransportDeleteDataSourceAction(TransportService transportService, ActionFilters actionFilters, DataSourceServiceImpl dataSourceService) {
        super(NAME, transportService, actionFilters, DeleteDataSourceActionRequest::new);
        this.dataSourceService = dataSourceService;
    }

    protected void doExecute(Task task, DeleteDataSourceActionRequest request, ActionListener<DeleteDataSourceActionResponse> actionListener) {
        try {
            this.dataSourceService.deleteDataSource(request.getDataSourceName());
            actionListener.onResponse((Object)new DeleteDataSourceActionResponse("Deleted DataSource with name " + request.getDataSourceName()));
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }
}

