/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.JvmMemory;
import io.micrometer.core.instrument.distribution.TimeWindowSum;
import io.micrometer.core.lang.NonNull;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class JvmHeapPressureMetrics
implements MeterBinder,
AutoCloseable {
    private final Iterable<Tag> tags;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();
    private final long startOfMonitoring = System.nanoTime();
    private final Duration lookback;
    private final TimeWindowSum gcPauseSum;
    private final AtomicReference<Double> lastOldGenUsageAfterGc = new AtomicReference<Double>(0.0);
    private String oldGenPoolName;

    public JvmHeapPressureMetrics() {
        this(Collections.emptyList(), Duration.ofMinutes(5L), Duration.ofMinutes(1L));
    }

    public JvmHeapPressureMetrics(Iterable<Tag> tags, Duration lookback, Duration testEvery) {
        this.tags = tags;
        this.lookback = lookback;
        this.gcPauseSum = new TimeWindowSum((int)lookback.dividedBy(testEvery.toMillis()).toMillis(), testEvery);
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (!JvmMemory.isOldGenPool(name)) continue;
            this.oldGenPoolName = name;
            break;
        }
        this.monitor();
    }

    @Override
    public void bindTo(@NonNull MeterRegistry registry) {
        Gauge.builder("jvm.memory.usage.after.gc", this.lastOldGenUsageAfterGc, AtomicReference::get).tags(this.tags).tag("area", "heap").tag("generation", "old").description("The percentage of old gen heap used after the last GC event, in the range [0..1]").baseUnit("percent").register(registry);
        Gauge.builder("jvm.gc.overhead", this.gcPauseSum, pauseSum -> {
            double overIntervalMillis = (double)Math.min(System.nanoTime() - this.startOfMonitoring, this.lookback.toNanos()) / 1000000.0;
            return this.gcPauseSum.poll() / overIntervalMillis;
        }).tags(this.tags).description("An approximation of the percent of CPU time used by GC activities over the last lookback period or since monitoring began, whichever is shorter, in the range [0..1]").baseUnit("percent").register(registry);
    }

    private void monitor() {
        double maxOldGen = JvmMemory.getOldGen().map(mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getMax)).orElse(0.0);
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                if (!notification.getType().equals("com.sun.management.gc.notification")) {
                    return;
                }
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                if (!JvmMemory.isConcurrentPhase(gcCause)) {
                    this.gcPauseSum.record(duration);
                }
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                if (this.oldGenPoolName != null) {
                    long oldAfter = after.get(this.oldGenPoolName).getUsed();
                    this.lastOldGenUsageAfterGc.set((double)oldAfter / maxOldGen);
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, null, null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }
}

