/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.PathTrie;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.servlet.SolrRequestParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V2HttpCall
extends HttpSolrCall {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Api api;
    List<String> pieces;
    private String prefix;
    HashMap<String, String> parts = new HashMap();
    static final Set<String> knownPrefixes = ImmutableSet.of((Object)"cluster", (Object)"node", (Object)"collections", (Object)"cores", (Object)"c");

    public V2HttpCall(SolrDispatchFilter solrDispatchFilter, CoreContainer cc, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        super(solrDispatchFilter, cc, request, response, retry);
    }

    @Override
    protected void init() throws Exception {
        String path = this.path;
        String fullPath = path = path.substring(7);
        try {
            this.pieces = PathTrie.getPathSegments((String)path);
            if (this.pieces.size() == 0 || this.pieces.size() == 1 && path.endsWith("/_introspect")) {
                this.api = new Api(null){

                    @Override
                    public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                        rsp.add("documentation", "https://lucene.apache.org/solr/guide/v2-api.html");
                        rsp.add("description", "V2 API root path");
                    }
                };
                this.initAdminRequest(path);
                return;
            }
            this.prefix = this.pieces.get(0);
            boolean isCompositeApi = false;
            if (knownPrefixes.contains(this.prefix)) {
                this.api = V2HttpCall.getApiInfo(this.cores.getRequestHandlers(), path, this.req.getMethod(), fullPath, this.parts);
                if (this.api != null && !(isCompositeApi = this.api instanceof CompositeApi)) {
                    this.initAdminRequest(path);
                    return;
                }
            }
            if ("c".equals(this.prefix) || "collections".equals(this.prefix)) {
                this.origCorename = this.pieces.get(1);
                DocCollection collection = this.resolveDocCollection(this.queryParams.get("collection", this.origCorename));
                if (collection == null) {
                    if (!path.endsWith("/_introspect")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no such collection or alias");
                    }
                } else {
                    boolean isPreferLeader = path.endsWith("/update") || path.contains("/update/");
                    this.core = this.getCoreByCollection(collection.getName(), isPreferLeader);
                    if (this.core == null) {
                        this.extractRemotePath(collection.getName(), collection.getName());
                        if (this.action == SolrDispatchFilter.Action.REMOTEQUERY) {
                            this.coreUrl = this.coreUrl.replace("/solr/", "/solr/____v2/c/");
                            this.path = path = path.substring(this.prefix.length() + collection.getName().length() + 2);
                            return;
                        }
                    }
                }
            } else if ("cores".equals(this.prefix)) {
                this.origCorename = this.pieces.get(1);
                this.core = this.cores.getCore(this.origCorename);
            } else {
                this.api = V2HttpCall.getApiInfo(this.cores.getRequestHandlers(), path, this.req.getMethod(), fullPath, this.parts);
                if (this.api != null) {
                    this.initAdminRequest(path);
                    return;
                }
            }
            if (this.core == null) {
                log.error(">> path: '{}'", (Object)path);
                if (path.endsWith("/_introspect")) {
                    this.initAdminRequest(path);
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "no core retrieved for " + this.origCorename);
            }
            this.path = path = path.substring(this.prefix.length() + this.pieces.get(1).length() + 2);
            Api apiInfo = V2HttpCall.getApiInfo(this.core.getRequestHandlers(), path, this.req.getMethod(), fullPath, this.parts);
            if (isCompositeApi && apiInfo instanceof CompositeApi) {
                ((CompositeApi)this.api).add(apiInfo);
            } else {
                this.api = apiInfo == null ? this.api : apiInfo;
            }
            this.parseRequest();
            this.addCollectionParamIfNeeded(this.getCollectionsList());
            this.action = SolrDispatchFilter.Action.PROCESS;
        }
        catch (RuntimeException rte) {
            log.error("Error in init()", (Throwable)rte);
            throw rte;
        }
        finally {
            if (this.action == null && this.api == null) {
                this.action = SolrDispatchFilter.Action.PROCESS;
            }
            if (this.solrReq != null) {
                this.solrReq.getContext().put("path", path);
            }
        }
    }

    private void initAdminRequest(String path) throws Exception {
        this.solrReq = SolrRequestParsers.DEFAULT.parse(null, path, this.req);
        this.solrReq.getContext().put(CoreContainer.class.getName(), this.cores);
        this.requestType = AuthorizationContext.RequestType.ADMIN;
        this.action = SolrDispatchFilter.Action.ADMIN;
    }

    protected void parseRequest() throws Exception {
        this.config = this.core.getSolrConfig();
        SolrRequestParsers parser = this.config.getRequestParsers();
        if (this.solrReq == null) {
            this.solrReq = parser.parse(this.core, this.path, this.req);
        }
    }

    protected DocCollection resolveDocCollection(String collectionStr) {
        if (!this.cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr not running in cloud mode ");
        }
        ZkStateReader zkStateReader = this.cores.getZkController().getZkStateReader();
        Supplier<DocCollection> logic = () -> {
            this.collectionsList = this.resolveCollectionListOrAlias(collectionStr);
            if (this.collectionsList.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request must be sent to a single collection or an alias that points to a single collection, but '" + collectionStr + "' resolves to " + this.collectionsList);
            }
            String collectionName = (String)this.collectionsList.get(0);
            return zkStateReader.getClusterState().getCollectionOrNull(collectionName);
        };
        DocCollection docCollection = logic.get();
        if (docCollection != null) {
            return docCollection;
        }
        try {
            zkStateReader.aliasesManager.update();
            zkStateReader.forceUpdateCollection((String)this.collectionsList.get(0));
        }
        catch (Exception e) {
            log.error("Error trying to update state while resolving collection.", (Throwable)e);
        }
        return logic.get();
    }

    public static Api getApiInfo(PluginBag<SolrRequestHandler> requestHandlers, String path, String method, String fullPath, Map<String, String> parts) {
        fullPath = fullPath == null ? path : fullPath;
        Api api = requestHandlers.v2lookup(path, method, parts);
        if (api == null && path.endsWith("/_introspect")) {
            api = requestHandlers.v2lookup(path, null, parts);
        }
        if (api == null) {
            return V2HttpCall.getSubPathApi(requestHandlers, path, fullPath, new CompositeApi(null));
        }
        if (api instanceof ApiBag.IntrospectApi) {
            final LinkedHashMap<String, Api> apis = new LinkedHashMap<String, Api>();
            for (String m : SolrRequest.SUPPORTED_METHODS) {
                Api x = requestHandlers.v2lookup(path, m, parts);
                if (x == null) continue;
                apis.put(m, x);
            }
            api = new CompositeApi(new Api(ApiBag.EMPTY_SPEC){

                @Override
                public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                    String method = req.getParams().get("method");
                    HashSet<Api> added = new HashSet<Api>();
                    for (Map.Entry e : apis.entrySet()) {
                        if (method != null && !((String)e.getKey()).equals(method) || added.contains(e.getValue())) continue;
                        ((Api)e.getValue()).call(req, rsp);
                        added.add((Api)e.getValue());
                    }
                    RequestHandlerUtils.addExperimentalFormatWarning(rsp);
                }
            });
            V2HttpCall.getSubPathApi(requestHandlers, path, fullPath, (CompositeApi)api);
        }
        return api;
    }

    private static CompositeApi getSubPathApi(PluginBag<SolrRequestHandler> requestHandlers, String path, final String fullPath, CompositeApi compositeApi) {
        String newPath = path.endsWith("/_introspect") ? path.substring(0, path.length() - "/_introspect".length()) : path;
        LinkedHashMap<String, Set<String>> subpaths = new LinkedHashMap<String, Set<String>>();
        V2HttpCall.getSubPaths(newPath, requestHandlers.getApiBag(), subpaths);
        final LinkedHashMap<String, Set<String>> subPaths = subpaths;
        if (subPaths.isEmpty()) {
            return null;
        }
        return compositeApi.add(new Api(() -> ValidatingJsonMap.EMPTY){

            @Override
            public void call(SolrQueryRequest req1, SolrQueryResponse rsp) {
                String prefix = null;
                prefix = fullPath.endsWith("/_introspect") ? fullPath.substring(0, fullPath.length() - "/_introspect".length()) : fullPath;
                LinkedHashMap<String, Set> result = new LinkedHashMap<String, Set>(subPaths.size());
                for (Map.Entry e : subPaths.entrySet()) {
                    if (((String)e.getKey()).endsWith("/_introspect")) continue;
                    result.put(prefix + (String)e.getKey(), (Set)e.getValue());
                }
                Map m = (Map)rsp.getValues().get("availableSubPaths");
                if (m != null) {
                    m.putAll(result);
                } else {
                    rsp.add("availableSubPaths", result);
                }
            }
        });
    }

    private static void getSubPaths(String path, ApiBag bag, Map<String, Set<String>> pathsVsMethod) {
        for (SolrRequest.METHOD m : SolrRequest.METHOD.values()) {
            PathTrie<Api> registry = bag.getRegistry(m.toString());
            if (registry == null) continue;
            HashSet subPaths = new HashSet();
            registry.lookup(path, new HashMap(), subPaths);
            for (String subPath : subPaths) {
                Set<String> supportedMethods = pathsVsMethod.get(subPath);
                if (supportedMethods == null) {
                    supportedMethods = new HashSet<String>();
                    pathsVsMethod.put(subPath, supportedMethods);
                }
                supportedMethods.add(m.toString());
            }
        }
    }

    @Override
    protected void handleAdmin(SolrQueryResponse solrResp) {
        try {
            this.api.call(this.solrReq, solrResp);
        }
        catch (Exception e) {
            solrResp.setException(e);
        }
    }

    @Override
    protected void execute(SolrQueryResponse rsp) {
        SolrCore.preDecorateResponse(this.solrReq, rsp);
        if (this.api == null) {
            rsp.setException((Exception)new SolrException(SolrException.ErrorCode.NOT_FOUND, "Cannot find correspond api for the path : " + this.solrReq.getContext().get("path")));
        } else {
            try {
                this.api.call(this.solrReq, rsp);
            }
            catch (Exception e) {
                rsp.setException(e);
            }
        }
        SolrCore.postDecorateResponse(this.handler, this.solrReq, rsp);
    }

    @Override
    protected Object _getHandler() {
        return this.api;
    }

    public Map<String, String> getUrlParts() {
        return this.parts;
    }

    @Override
    protected ValidatingJsonMap getSpec() {
        return this.api == null ? null : this.api.getSpec();
    }

    @Override
    protected Map<String, JsonSchemaValidator> getValidators() {
        return this.api == null ? null : this.api.getCommandSchema();
    }

    public static class CompositeApi
    extends Api {
        private LinkedList<Api> apis = new LinkedList();

        public CompositeApi(Api api) {
            super(ApiBag.EMPTY_SPEC);
            if (api != null) {
                this.apis.add(api);
            }
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            for (Api api : this.apis) {
                api.call(req, rsp);
            }
        }

        public CompositeApi add(Api api) {
            this.apis.add(api);
            return this;
        }
    }
}

