/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SetValueEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public SetValueEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 3 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values[0] instanceof Tuple) {
            Tuple tuple = (Tuple)values[0];
            String key = (String)values[1];
            Object value = values[2];
            if (value instanceof String) {
                value = ((String)value).replace("\"", "");
            }
            key = key.replace("\"", "");
            Tuple newTuple = tuple.clone();
            newTuple.put(key, value);
            return newTuple;
        }
        throw new IOException("The setValue function expects a Tuple as the first parameter");
    }
}

