/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.grouping.GroupReducer;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;

public class SecondPassGroupingCollector<T>
extends SimpleCollector {
    protected final GroupSelector<T> groupSelector;
    protected final Collection<SearchGroup<T>> groups;
    protected final GroupReducer<T, ?> groupReducer;
    protected int totalHitCount;
    protected int totalGroupedHitCount;

    public SecondPassGroupingCollector(GroupSelector<T> groupSelector, Collection<SearchGroup<T>> groups, GroupReducer<T, ?> reducer) {
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("no groups to collect (groups is empty)");
        }
        this.groupSelector = Objects.requireNonNull(groupSelector);
        this.groupSelector.setGroups(groups);
        this.groups = Objects.requireNonNull(groups);
        this.groupReducer = reducer;
        reducer.setGroups(groups);
    }

    public GroupSelector<T> getGroupSelector() {
        return this.groupSelector;
    }

    public ScoreMode scoreMode() {
        return this.groupReducer.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public void setScorer(Scorable scorer) throws IOException {
        this.groupSelector.setScorer(scorer);
        this.groupReducer.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        ++this.totalHitCount;
        if (this.groupSelector.advanceTo(doc) == GroupSelector.State.SKIP) {
            return;
        }
        ++this.totalGroupedHitCount;
        T value = this.groupSelector.currentValue();
        this.groupReducer.collect(value, doc);
    }

    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        this.groupReducer.setNextReader(readerContext);
        this.groupSelector.setNextReader(readerContext);
    }
}

