/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.client.solrj.cloud.ShardTerms;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveringCoreTermWatcher
implements ZkShardTerms.CoreTermWatcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreDescriptor coreDescriptor;
    private final CoreContainer coreContainer;
    private final AtomicLong lastTermDoRecovery;

    RecoveringCoreTermWatcher(CoreDescriptor coreDescriptor, CoreContainer coreContainer) {
        this.coreDescriptor = coreDescriptor;
        this.coreContainer = coreContainer;
        this.lastTermDoRecovery = new AtomicLong(-1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onTermChanged(ShardTerms terms) {
        if (this.coreContainer.isShutDown()) {
            return false;
        }
        try (SolrCore solrCore = this.coreContainer.getCore(this.coreDescriptor.getName());){
            if (solrCore == null || solrCore.isClosed()) {
                boolean bl = false;
                return bl;
            }
            if (solrCore.getCoreDescriptor() == null || solrCore.getCoreDescriptor().getCloudDescriptor() == null) {
                boolean bl = true;
                return bl;
            }
            String coreNodeName = solrCore.getCoreDescriptor().getCloudDescriptor().getCoreNodeName();
            if (terms.haveHighestTermValue(coreNodeName)) {
                boolean bl = true;
                return bl;
            }
            if (this.lastTermDoRecovery.get() >= terms.getTerm(coreNodeName)) return true;
            log.info("Start recovery on {} because core's term is less than leader's term", (Object)coreNodeName);
            this.lastTermDoRecovery.set(terms.getTerm(coreNodeName));
            solrCore.getUpdateHandler().getSolrCoreState().doRecovery(solrCore.getCoreContainer(), solrCore.getCoreDescriptor());
            return true;
        }
        catch (Exception e) {
            if (!log.isInfoEnabled()) return false;
            log.info("Failed to watch term of core {}", (Object)this.coreDescriptor.getName(), (Object)e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoveringCoreTermWatcher that = (RecoveringCoreTermWatcher)o;
        return this.coreDescriptor.getName().equals(that.coreDescriptor.getName());
    }

    public int hashCode() {
        return this.coreDescriptor.getName().hashCode();
    }
}

