/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.domain.S3Exception;
import com.adobe.testing.s3mock.dto.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class S3MockExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(S3MockExceptionHandler.class);

    @ExceptionHandler
    public ResponseEntity<ErrorResponse> handleS3Exception(S3Exception s3Exception) {
        LOG.info("Responding with status {}: {}", (Object)s3Exception.getStatus(), (Object)s3Exception.getMessage());
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setCode(s3Exception.getCode());
        errorResponse.setMessage(s3Exception.getMessage());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)s3Exception.getStatus()).headers(headers)).body((Object)errorResponse);
    }
}

