/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.my;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_my extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000 \u1021\u1001\u103b\u102d\u1014\u103a",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u1019\u1031\u102c\u103a\u1005\u1000\u102d\u102f \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "MST",
               "\u1019\u1031\u102c\u103a\u1005\u1000\u102d\u102f \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "MST",
               "\u1019\u1031\u102c\u103a\u1005\u1000\u102d\u102f \u1021\u1001\u103b\u102d\u1014\u103a",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u1002\u103b\u1015\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "JST",
               "\u1002\u103b\u1015\u1014\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "JDT",
               "\u1002\u103b\u1015\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "PT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u1021\u101c\u101a\u103a\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "ACWST",
               "\u1021\u101c\u101a\u103a\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "ACWDT",
               "\u1021\u101c\u101a\u103a\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u1025\u101b\u1031\u102c\u1015 \u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "CEST",
               "\u1025\u101b\u1031\u102c\u1015 \u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "CEST",
               "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "CET",
            };
        final String[] Paraguay = new String[] {
               "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "PT",
            };
        final String[] Malaysia = new String[] {
               "\u1019\u101c\u1031\u1038\u101b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "EST",
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "EDT",
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000 \u1021\u1001\u103b\u102d\u1014\u103a",
               "ET",
            };
        final String[] New_Zealand = new String[] {
               "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "NZST",
               "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "NZDT",
               "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u1021\u102d\u1014\u1039\u1012\u103c\u102d\u101a \u101e\u1019\u102f\u1012\u1039\u1012\u101b\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000 \u1021\u1001\u103b\u102d\u1014\u103a",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1010\u102e\u1019\u1031\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1025\u101b\u1031\u102c\u1015 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "EEST",
               "\u1021\u101b\u103e\u1031\u1037\u1025\u101b\u1031\u102c\u1015 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "EEST",
               "\u101b\u102d\u102f\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u1014\u101a\u1030\u1038\u1016\u1031\u102c\u1004\u103a\u101c\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "NST",
               "\u1014\u101a\u1030\u1038\u1016\u1031\u102c\u1004\u103a\u101c\u1014\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "NDT",
               "\u1014\u101a\u1030\u1038\u1016\u1031\u102c\u1004\u103a\u101c\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u1021\u102c\u1016\u1002\u1014\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Hong_Kong = new String[] {
               "\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "HKST",
               "\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "HKST",
               "\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "WAST",
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "WAST",
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u1021\u1010\u1039\u1011\u101c\u1014\u103a\u1010\u1005\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u1010\u1039\u1011\u101c\u1014\u103a\u1010\u1005\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "ADT",
               "\u1021\u1010\u1039\u1011\u101c\u1014\u103a\u1010\u1005\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "\u1018\u102d\u102f\u101c\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Indochina = new String[] {
               "\u1021\u1004\u103a\u1012\u102d\u102f\u1001\u103b\u102d\u102f\u1004\u103a\u1038\u1014\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Israel = new String[] {
               "\u1021\u1005\u1039\u1005\u101b\u1031\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "IST",
               "\u1021\u1005\u1039\u1005\u101b\u1031\u1038 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "IDT",
               "\u1021\u1005\u1039\u1005\u101b\u1031\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u1016\u101b\u102d\u1000 \u1021\u1001\u103b\u102d\u1014\u103a",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Uzbekistan = new String[] {
               "\u1025\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "UST",
               "\u1025\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "UST",
               "\u1025\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "UT",
            };
        final String[] Uruguay = new String[] {
               "\u1025\u101b\u102f\u1002\u103d\u1031\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "UST",
               "\u1025\u101b\u102f\u1002\u103d\u1031\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "UST",
               "\u1025\u101b\u102f\u1002\u103d\u1031\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "UT",
            };
        final String[] Nepal = new String[] {
               "\u1014\u102e\u1015\u1031\u102b \u1021\u1001\u103b\u102d\u1014\u103a",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] America_Central = new String[] {
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "CDT",
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1019\u1031\u101b\u102d\u1000 \u1021\u1001\u103b\u102d\u1014\u103a",
               "CT",
            };
        final String[] Falkland = new String[] {
               "\u1016\u1031\u102c\u1004\u103a\u1000\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "FIST",
               "\u1016\u1031\u102c\u1004\u103a\u1000\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "FIST",
               "\u1016\u1031\u102c\u1004\u103a\u1000\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f \u1021\u1001\u103b\u102d\u1014\u103a",
               "FIT",
            };
        final String[] Singapore = new String[] {
               "\u1005\u1004\u103a\u1039\u1000\u102c\u1015\u1030 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Bhutan = new String[] {
               "\u1018\u1030\u1010\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Myanmar = new String[] {
               "\u1019\u103c\u1014\u103a\u1019\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1000\u102c\u1007\u1000\u103a\u1005\u1010\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Argentina = new String[] {
               "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "AT",
            };
        final String[] Venezuela = new String[] {
               "\u1017\u1004\u103a\u1014\u102e\u1007\u103d\u1032\u101c\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Australia_Central = new String[] {
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "ACST",
               "\u1021\u101c\u101a\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "ACDT",
               "\u1021\u101c\u101a\u103a\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "\u1015\u1005\u102d\u1016\u102d\u1010\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u1005\u102d\u1016\u102d\u1010\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "PDT",
               "\u1015\u1005\u102d\u1016\u102d\u1010\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "WEST",
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "WEST",
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1025\u101b\u1031\u102c\u1015 \u1021\u1001\u103b\u102d\u1014\u103a",
               "WET",
            };
        final String[] Azerbaijan = new String[] {
               "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "AT",
            };
        final String[] Cuba = new String[] {
               "\u1000\u103b\u1030\u1038\u1018\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1000\u103b\u1030\u1038\u1018\u102c\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "CDT",
               "\u1000\u103b\u1030\u1038\u1018\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "WAST",
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "WAST",
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u102c\u1016\u101b\u102d\u1000 \u1021\u1001\u103b\u102d\u1014\u103a",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u1002\u101b\u1004\u103a\u1038\u1014\u1005\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "PT",
            };
        final String[] South_Georgia = new String[] {
               "\u1010\u1031\u102c\u1004\u103a\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Brunei = new String[] {
               "\u1018\u101b\u1030\u1014\u102d\u102f\u1004\u103a\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Iran = new String[] {
               "\u1021\u102e\u101b\u1014\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "IST",
               "\u1021\u102e\u101b\u1014\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "IDT",
               "\u1021\u102e\u101b\u1014\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "IT",
            };
        final String[] Bangladesh = new String[] {
               "\u1018\u1004\u103a\u1039\u1002\u101c\u102c\u1038\u1012\u1031\u1037\u101b\u103e\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "BST",
               "Bangladesh Summer Time",
               "BST",
               "Bangladesh Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "\u1015\u102e\u101b\u1030\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u102e\u101b\u1030\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "PST",
               "\u1015\u102e\u101b\u1030\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "WGST",
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "WGST",
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u1021\u102e\u1000\u103d\u1031\u1012\u1031\u102b \u1021\u1001\u103b\u102d\u1014\u103a",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "EGST",
               "\u1021\u101b\u103e\u1031\u1037\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "EGST",
               "\u1021\u101b\u103e\u1031\u1037\u1002\u101b\u1004\u103a\u1038\u101c\u1014\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u1015\u1004\u103a\u101c\u101a\u103a\u1002\u103d\u1031\u1037 \u1021\u1001\u103b\u102d\u1014\u103a",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "\u1000\u102d\u102f\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "KST",
               "\u1000\u102d\u102f\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "KDT",
               "\u1000\u102d\u102f\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AWST",
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "AWDT",
               "\u1021\u1014\u1031\u102c\u1000\u103a \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u1021\u1014\u1031\u102c\u1000\u103a\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AEST",
               "\u1021\u101b\u103e\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "AEDT",
               "\u1021\u101b\u103e\u1031\u1037\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b\u103e\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1002\u102e\u101a\u102c\u1014\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u1001\u103b\u102e\u101c\u102e \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1001\u103b\u102e\u101c\u102e \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1001\u103b\u102e\u101c\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "\u1021\u1019\u1031\u101b\u102d\u1000 \u1010\u1031\u102c\u1004\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "MST",
               "\u1021\u1019\u1031\u101b\u102d\u1000 \u1010\u1031\u102c\u1004\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "MDT",
               "\u1021\u1019\u1031\u101b\u102d\u1000 \u1010\u1031\u102c\u1004\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "MT",
            };
        final String[] Arabian = new String[] {
               "\u1021\u102c\u101b\u1031\u1017\u103b \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u102c\u101b\u1031\u1017\u103b \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "ADT",
               "\u1021\u102c\u101b\u1031\u1017\u103b \u1021\u1001\u103b\u102d\u1014\u103a",
               "AT",
            };
        final String[] Georgia = new String[] {
               "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "GST",
               "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "GST",
               "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u1021\u1001\u103b\u102d\u1014\u103a",
               "GT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u1015\u102b\u1015\u1030\u101b\u102c\u1014\u101a\u1030\u1038\u1002\u102e\u1014\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Brasilia = new String[] {
               "\u1018\u101b\u102c\u1007\u102e\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "BST",
               "\u1018\u101b\u102c\u1007\u102e\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "BST",
               "\u1018\u101b\u102c\u1007\u102e\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "BT",
            };
        final String[] China = new String[] {
               "\u1010\u101b\u102f\u1010\u103a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "CST",
               "\u1010\u101b\u102f\u1010\u103a \u1014\u1031\u1037\u1015\u102d\u102f\u1004\u103a\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "CDT",
               "\u1010\u101b\u102f\u1010\u103a \u1021\u1001\u103b\u102d\u1014\u103a",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u1021\u102c\u1019\u1031\u1014\u102e\u1038\u101a\u102c\u1038 \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u102c\u1019\u1031\u1014\u102e\u1038\u101a\u102c\u1038 \u1014\u103d\u1031\u101b\u102c\u101e\u102e \u1021\u1001\u103b\u102d\u1014\u103a",
               "AST",
               "\u1021\u102c\u1019\u1031\u1014\u102e\u1038\u101a\u102c\u1038 \u1021\u1001\u103b\u102d\u1014\u103a",
               "AT",
            };
        final String[] India = new String[] {
               "\u1021\u102d\u1014\u1039\u1012\u103c\u102d\u101a \u1005\u1036\u1010\u1031\u102c\u103a\u1001\u103b\u102d\u1014\u103a",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Halifax", Atlantic },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Antarctica/McMurdo", New_Zealand },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "America/Louisville", America_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "America/Yellowknife", America_Mountain },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
