from datetime import datetime
from typing import Any, Dict, Optional, Union

from github.Event import Event
from github.Gist import Gist
from github.GithubObject import CompletableGithubObject, _NotSetType
from github.Membership import Membership
from github.Organization import Organization
from github.PaginatedList import PaginatedList
from github.Permissions import Permissions
from github.Plan import Plan
from github.Project import Project
from github.Repository import Repository
from github.UserKey import UserKey

class NamedUser(CompletableGithubObject):
    def __eq__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    @property
    def _identity(self) -> str: ...
    def _initAttributes(self) -> None: ...
    def _useAttributes(self, attributes: Dict[str, Any]) -> None: ...
    @property
    def avatar_url(self) -> str: ...
    @property
    def bio(self) -> Optional[str]: ...
    @property
    def blog(self) -> str: ...
    @property
    def collaborators(self) -> Optional[int]: ...
    @property
    def company(self) -> str: ...
    @property
    def contributions(self) -> int: ...
    @property
    def created_at(self) -> datetime: ...
    @property
    def disk_usage(self) -> Optional[int]: ...
    @property
    def email(self) -> str: ...
    @property
    def events_url(self) -> str: ...
    @property
    def followers(self) -> int: ...
    @property
    def followers_url(self) -> str: ...
    @property
    def following(self) -> int: ...
    @property
    def following_url(self) -> str: ...
    def get_events(self) -> PaginatedList[Event]: ...
    def get_followers(self) -> PaginatedList[NamedUser]: ...
    def get_following(self) -> PaginatedList[NamedUser]: ...
    def get_gists(
        self, since: Union[_NotSetType, datetime] = ...
    ) -> PaginatedList[Gist]: ...
    def get_keys(self) -> PaginatedList[UserKey]: ...
    def get_organization_membership(self, org: int) -> Membership: ...
    def get_orgs(self) -> PaginatedList[Organization]: ...
    def get_projects(self, state: str = ...) -> PaginatedList[Project]: ...
    def get_public_events(self) -> PaginatedList[Event]: ...
    def get_public_received_events(self) -> PaginatedList[Event]: ...
    def get_received_events(self) -> PaginatedList[Event]: ...
    def get_repo(self, name: str) -> Repository: ...
    def get_repos(
        self,
        type: Union[str, _NotSetType] = ...,
        sort: Union[str, _NotSetType] = ...,
        direction: Union[str, _NotSetType] = ...,
    ) -> PaginatedList[Repository]: ...
    def get_starred(self) -> PaginatedList[Repository]: ...
    def get_subscriptions(self) -> PaginatedList[Repository]: ...
    def get_watched(self) -> PaginatedList[Repository]: ...
    @property
    def gists_url(self) -> str: ...
    @property
    def gravatar_id(self) -> str: ...
    def has_in_following(self, following: NamedUser) -> bool: ...
    @property
    def hireable(self) -> bool: ...
    @property
    def html_url(self) -> str: ...
    @property
    def id(self) -> int: ...
    @property
    def invitation_teams_url(self) -> str: ...
    @property
    def inviter(self) -> NamedUser: ...
    @property
    def location(self) -> str: ...
    @property
    def login(self) -> str: ...
    @property
    def name(self) -> Optional[str]: ...
    @property
    def node_id(self) -> str: ...
    @property
    def organizations_url(self) -> str: ...
    @property
    def owned_private_repos(self) -> Optional[int]: ...
    @property
    def permissions(self) -> Permissions: ...
    @property
    def plan(self) -> Optional[Plan]: ...
    @property
    def private_gists(self) -> Optional[int]: ...
    @property
    def public_gists(self) -> int: ...
    @property
    def public_repos(self) -> int: ...
    @property
    def received_events_url(self) -> str: ...
    @property
    def repos_url(self) -> str: ...
    @property
    def role(self) -> str: ...
    @property
    def site_admin(self) -> bool: ...
    @property
    def starred_url(self) -> str: ...
    @property
    def subscriptions_url(self) -> str: ...
    @property
    def suspended_at(self) -> Optional[datetime]: ...
    @property
    def team_count(self) -> int: ...
    @property
    def total_private_repos(self) -> Optional[int]: ...
    @property
    def twitter_username(self) -> str: ...
    @property
    def type(self) -> str: ...
    @property
    def updated_at(self) -> datetime: ...
    @property
    def url(self) -> str: ...
