/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyRange;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Range
extends ImmutableLiteral {
    private final ImmutableLiteral begin;
    private final ImmutableLiteral end;
    private final boolean exclusive;

    public Range(ImmutableLiteral begin2, ImmutableLiteral end2, boolean exclusive2) {
        this.begin = begin2;
        this.end = end2;
        this.exclusive = exclusive2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.RANGE;
    }

    public Object createCacheObject(ThreadContext context) {
        IRubyObject begin2 = (IRubyObject)this.begin.cachedObject(context);
        IRubyObject end2 = (IRubyObject)this.end.cachedObject(context);
        if (this.exclusive) {
            return RubyRange.newExclusiveRange(context, begin2, end2);
        }
        return RubyRange.newInclusiveRange(context, begin2, end2);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        this.begin.encode(e);
        this.end.encode(e);
        e.encode(this.exclusive);
    }

    public static Range decode(IRReaderDecoder d) {
        return new Range((ImmutableLiteral)d.decodeOperand(), (ImmutableLiteral)d.decodeOperand(), d.decodeBoolean());
    }

    public String toString() {
        return "Range:" + this.begin + (this.exclusive ? "..." : "..") + this.end;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Range(this);
    }

    public ImmutableLiteral getBegin() {
        return this.begin;
    }

    public ImmutableLiteral getEnd() {
        return this.end;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

