/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.BlobStoreException;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.repositories.s3.AmazonS3Reference;
import org.opensearch.repositories.s3.S3BlobContainer;
import org.opensearch.repositories.s3.S3Service;
import org.opensearch.repositories.s3.StatsMetricPublisher;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.StorageClass;

class S3BlobStore
implements BlobStore {
    private static final Logger logger = LogManager.getLogger(S3BlobStore.class);
    private final S3Service service;
    private final String bucket;
    private final ByteSizeValue bufferSize;
    private final boolean serverSideEncryption;
    private final ObjectCannedACL cannedACL;
    private final StorageClass storageClass;
    private final RepositoryMetadata repositoryMetadata;
    private final StatsMetricPublisher statsMetricPublisher = new StatsMetricPublisher();

    S3BlobStore(S3Service service, String bucket, boolean serverSideEncryption, ByteSizeValue bufferSize, String cannedACL, String storageClass, RepositoryMetadata repositoryMetadata) {
        this.service = service;
        this.bucket = bucket;
        this.serverSideEncryption = serverSideEncryption;
        this.bufferSize = bufferSize;
        this.cannedACL = S3BlobStore.initCannedACL(cannedACL);
        this.storageClass = S3BlobStore.initStorageClass(storageClass);
        this.repositoryMetadata = repositoryMetadata;
    }

    public String toString() {
        return this.bucket;
    }

    public AmazonS3Reference clientReference() {
        return this.service.client(this.repositoryMetadata);
    }

    int getMaxRetries() {
        return this.service.settings((RepositoryMetadata)this.repositoryMetadata).maxRetries;
    }

    public String bucket() {
        return this.bucket;
    }

    public boolean serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public long bufferSizeInBytes() {
        return this.bufferSize.getBytes();
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new S3BlobContainer(path, this);
    }

    public void close() throws IOException {
        this.service.close();
    }

    public Map<String, Long> stats() {
        return this.statsMetricPublisher.getStats().toMap();
    }

    public ObjectCannedACL getCannedACL() {
        return this.cannedACL;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public StatsMetricPublisher getStatsMetricPublisher() {
        return this.statsMetricPublisher;
    }

    public static StorageClass initStorageClass(String storageClassStringValue) {
        if (storageClassStringValue == null || storageClassStringValue.equals("")) {
            return StorageClass.STANDARD;
        }
        StorageClass storageClass = StorageClass.fromValue((String)storageClassStringValue.toUpperCase(Locale.ENGLISH));
        if (storageClass.equals((Object)StorageClass.GLACIER)) {
            throw new BlobStoreException("Glacier storage class is not supported");
        }
        if (storageClass == StorageClass.UNKNOWN_TO_SDK_VERSION) {
            throw new BlobStoreException("`" + storageClassStringValue + "` is not a valid S3 Storage Class.");
        }
        return storageClass;
    }

    public static ObjectCannedACL initCannedACL(String cannedACL) {
        if (cannedACL == null || cannedACL.equals("")) {
            return ObjectCannedACL.PRIVATE;
        }
        for (ObjectCannedACL cur : ObjectCannedACL.values()) {
            if (!cur.toString().equalsIgnoreCase(cannedACL)) continue;
            return cur;
        }
        throw new BlobStoreException("cannedACL is not valid: [" + cannedACL + "]");
    }
}

