/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class DetectionDateRange
implements ToXContentObject,
Writeable {
    public static final String START_TIME_FIELD = "start_time";
    public static final String END_TIME_FIELD = "end_time";
    private final Instant startTime;
    private final Instant endTime;

    public DetectionDateRange(Instant startTime, Instant endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.validate();
    }

    public DetectionDateRange(StreamInput in) throws IOException {
        this.startTime = in.readInstant();
        this.endTime = in.readInstant();
        this.validate();
    }

    private void validate() {
        if (this.startTime == null) {
            throw new IllegalArgumentException("Detection data range's start time must not be null");
        }
        if (this.endTime == null) {
            throw new IllegalArgumentException("Detection data range's end time must not be null");
        }
        if (this.startTime.isAfter(this.endTime)) {
            throw new IllegalArgumentException("Detection data range's end time must be after start time");
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(START_TIME_FIELD, this.startTime.toEpochMilli());
        xContentBuilder.field(END_TIME_FIELD, this.endTime.toEpochMilli());
        return xContentBuilder.endObject();
    }

    public static DetectionDateRange parse(XContentParser parser) throws IOException {
        Instant startTime = null;
        Instant endTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "start_time": {
                    startTime = ParseUtils.toInstant(parser);
                    continue block8;
                }
                case "end_time": {
                    endTime = ParseUtils.toInstant(parser);
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new DetectionDateRange(startTime, endTime);
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectionDateRange that = (DetectionDateRange)o;
        return Objects.equal((Object)this.getStartTime(), (Object)that.getStartTime()) && Objects.equal((Object)this.getEndTime(), (Object)that.getEndTime());
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getStartTime(), this.getEndTime()});
    }

    @Generated
    public String toString() {
        return new ToStringBuilder((Object)this).append("startTime", (Object)this.startTime).append("endTime", (Object)this.endTime).toString();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.startTime);
        out.writeInstant(this.endTime);
    }
}

