/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestBuilderListener;
import org.opensearch.sql.legacy.antlr.semantic.SemanticAnalysisException;

public class GetIndexRequestRestListener
extends RestBuilderListener<GetIndexResponse> {
    private GetIndexRequest getIndexRequest;

    public GetIndexRequestRestListener(RestChannel channel, GetIndexRequest getIndexRequest) {
        super(channel);
        this.getIndexRequest = getIndexRequest;
    }

    public RestResponse buildResponse(GetIndexResponse getIndexResponse, XContentBuilder builder) throws Exception {
        GetIndexRequest.Feature[] features = this.getIndexRequest.features();
        String[] indices = getIndexResponse.indices();
        builder.startObject();
        for (String index : indices) {
            builder.startObject(index);
            block6: for (GetIndexRequest.Feature feature : features) {
                switch (feature) {
                    case ALIASES: {
                        this.writeAliases((List)getIndexResponse.aliases().get(index), builder, (ToXContent.Params)this.channel.request());
                        continue block6;
                    }
                    case MAPPINGS: {
                        this.writeMappings((MappingMetadata)getIndexResponse.mappings().get(index), builder, (ToXContent.Params)this.channel.request());
                        continue block6;
                    }
                    case SETTINGS: {
                        this.writeSettings((Settings)getIndexResponse.settings().get(index), builder, (ToXContent.Params)this.channel.request());
                        continue block6;
                    }
                    default: {
                        throw new SemanticAnalysisException("Unsupported feature: " + feature);
                    }
                }
            }
            builder.endObject();
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    private void writeAliases(List<AliasMetadata> aliases, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("aliases");
        if (aliases != null) {
            for (AliasMetadata alias : aliases) {
                AliasMetadata.Builder.toXContent((AliasMetadata)alias, (XContentBuilder)builder, (ToXContent.Params)params);
            }
        }
        builder.endObject();
    }

    private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("settings");
        settings.toXContent(builder, params);
        builder.endObject();
    }

    private void writeMappings(MappingMetadata mappingMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (mappingMetadata != null) {
            builder.field("mappings");
            builder.map(mappingMetadata.getSourceAsMap());
        }
    }

    static class Fields {
        static final String ALIASES = "aliases";
        static final String MAPPINGS = "mappings";
        static final String SETTINGS = "settings";
        static final String WARMERS = "warmers";

        Fields() {
        }
    }
}

