"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAdapter = void 0;
var webdav_1 = require("webdav");
var NOOP = function () { };
var TYPE_KEY = "@@fsType";
function __convertStat(data) {
    return {
        isDirectory: function () {
            return data.type === "directory";
        },
        isFile: function () {
            return data.type === "file";
        },
        mtime: new Date(data.lastmod).getTime(),
        name: data.basename,
        size: data.size || 0
    };
}
function __executeCallbackAsync(callback) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    if (typeof setImmediate !== "undefined") {
        setImmediate(function () {
            callback.apply.apply(callback, __spreadArray([null], args, false));
        });
    }
    else {
        setTimeout(function () {
            callback.apply.apply(callback, __spreadArray([null], args, false));
        }, 0);
    }
}
function createAdapter(webDAVEndpoint, options) {
    var _a;
    if (options === void 0) { options = {}; }
    var client = (0, webdav_1.createClient)(webDAVEndpoint, options);
    return _a = {},
        _a[TYPE_KEY] = "webdav-fs",
        _a.createReadStream = function (filePath, options) {
            var clientOptions = {};
            if (options) {
                if (typeof options.headers === "object") {
                    clientOptions.headers = options.headers;
                }
                if (typeof options.start === "number") {
                    clientOptions.range = { start: options.start, end: options.end };
                }
            }
            return client.createReadStream(filePath, clientOptions);
        },
        _a.createWriteStream = function (filePath, options) {
            var clientOptions = {};
            if (options) {
                if (typeof options.headers === "object") {
                    clientOptions.headers = options.headers;
                }
            }
            return client.createWriteStream(filePath, clientOptions);
        },
        _a.mkdir = function (dirPath, callback) {
            client
                .createDirectory(dirPath)
                .then(function () {
                __executeCallbackAsync(callback, [null]);
            })
                .catch(callback);
        },
        _a.readdir = function (dirPath, modeOrCallback, callback) {
            var mode = typeof modeOrCallback === "string" ? modeOrCallback : "node";
            var callbackReal = NOOP;
            if (typeof modeOrCallback === "function") {
                callbackReal = modeOrCallback;
            }
            else if (callback !== undefined && typeof callback == "function") {
                callbackReal = callback;
            }
            client
                .getDirectoryContents(dirPath)
                .then(function (contents) {
                var results;
                if (mode === "node") {
                    results = contents.map(function (statItem) {
                        return statItem.basename;
                    });
                }
                else if (mode === "stat") {
                    results = contents.map(__convertStat);
                }
                else {
                    throw new Error("Unknown mode: " + mode);
                }
                __executeCallbackAsync(callbackReal, [null, results]);
            })
                .catch(callbackReal);
        },
        _a.readFile = function (filename, encodingOrCallback, callback) {
            var encoding = typeof encodingOrCallback === "string" ? encodingOrCallback : "text";
            var callbackReal = NOOP;
            if (typeof encodingOrCallback === "function") {
                callbackReal = encodingOrCallback;
            }
            else if (callback !== undefined && typeof callback === "function") {
                callbackReal = callback;
            }
            encoding = encoding === "utf8" ? "text" : encoding;
            client
                .getFileContents(filename, { format: encoding })
                .then(function (data) {
                __executeCallbackAsync(callbackReal, [null, data]);
            })
                .catch(callbackReal);
        },
        _a.rename = function (filePath, targetPath, callback) {
            client
                .moveFile(filePath, targetPath)
                .then(function () {
                __executeCallbackAsync(callback, [null]);
            })
                .catch(callback);
        },
        _a.rmdir = function (targetPath, callback) {
            client
                .deleteFile(targetPath)
                .then(function () {
                __executeCallbackAsync(callback, [null]);
            })
                .catch(callback);
        },
        _a.stat = function (remotePath, callback) {
            client
                .stat(remotePath)
                .then(function (stat) {
                __executeCallbackAsync(callback, [null, __convertStat(stat)]);
            })
                .catch(callback);
        },
        _a.unlink = function (targetPath, callback) {
            client
                .deleteFile(targetPath)
                .then(function () {
                __executeCallbackAsync(callback, [null]);
            })
                .catch(callback);
        },
        _a.writeFile = function (filename, data, encodingOrCallback, callback) {
            var encoding = typeof encodingOrCallback === "string" ? encodingOrCallback : "text";
            var callbackReal = NOOP;
            if (typeof encodingOrCallback === "function") {
                callbackReal = encodingOrCallback;
            }
            else if (callback !== undefined && typeof callback === "function") {
                callbackReal = callback;
            }
            encoding = encoding === "utf8" ? "text" : encoding;
            client
                .putFileContents(filename, data /*{ format: encoding }*/)
                .then(function () {
                __executeCallbackAsync(callbackReal, [null]);
            })
                .catch(callbackReal);
        },
        _a;
}
exports.createAdapter = createAdapter;
//# sourceMappingURL=data:application/json;base64,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