/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.GuiGridLayout;

public class ProjectCircle
extends GenericFunction {
    private JDialog _dialog = null;
    private JLabel _distanceDescLabel = null;
    private DecimalNumberField _distanceField = null;
    private boolean _distanceIsMetric = true;
    private JButton _okButton = null;

    public ProjectCircle(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.projectcircle";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._distanceField.setText("");
        this.setLabelText();
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.projectcircle.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._distanceField = new DecimalNumberField(false);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ProjectCircle.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    ProjectCircle.this._dialog.dispose();
                } else if (keyEvent.getKeyCode() == 10 && ProjectCircle.this._okButton.isEnabled()) {
                    ProjectCircle.this.finish();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ProjectCircle.this.enableOK();
            }
        };
        this._distanceField.addKeyListener(keyAdapter);
        this._distanceField.addMouseListener(mouseAdapter);
        this._distanceDescLabel = new JLabel(String.valueOf(I18nManager.getText("fieldname.distance")) + " (ft)");
        this._distanceDescLabel.setHorizontalAlignment(4);
        guiGridLayout.add(this._distanceDescLabel);
        guiGridLayout.add(this._distanceField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> {
            if (this._okButton.isEnabled()) {
                this.finish();
            }
        });
        this._okButton.setEnabled(false);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void setLabelText() {
        Unit unit = Config.getUnitSet().getDistanceUnit();
        this._distanceIsMetric = unit == UnitSetLibrary.UNITS_METRES || unit == UnitSetLibrary.UNITS_KILOMETRES;
        unit = this._distanceIsMetric ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        String string = unit.getShortnameKey();
        this._distanceDescLabel.setText(String.valueOf(I18nManager.getText("fieldname.distance")) + " (" + I18nManager.getText(string) + ")");
    }

    private void enableOK() {
        boolean bl = this._distanceField.getValue() > 0.0;
        this._okButton.setEnabled(bl);
    }

    private void finish() {
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        Unit unit = this._distanceIsMetric ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        double d = Distance.convertDistanceToRadians(this._distanceField.getValue(), unit);
        double d2 = Math.toRadians(dataPoint.getLatitude().getDouble());
        double d3 = Math.toRadians(dataPoint.getLongitude().getDouble());
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        int n = 0;
        while (n <= 24) {
            double d4 = (double)(n % 24) * 2.0 * Math.PI / 24.0;
            double d5 = Math.asin(Math.sin(d2) * Math.cos(d) + Math.cos(d2) * Math.sin(d) * Math.cos(d4));
            double d6 = d3 + Math.atan2(Math.sin(d4) * Math.sin(d) * Math.cos(d2), Math.cos(d) - Math.sin(d2) * Math.sin(d5));
            DataPoint dataPoint2 = new DataPoint(new Latitude("" + Math.toDegrees(d5)), new Longitude("" + Math.toDegrees(d6)), null);
            dataPoint2.setSegmentStart(n == 0);
            arrayList.add(dataPoint2);
            ++n;
        }
        AppendRangeCmd appendRangeCmd = new AppendRangeCmd(arrayList);
        appendRangeCmd.setDescription(this.getName());
        appendRangeCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.pointsadded", arrayList.size()));
        this._app.execute(appendRangeCmd);
        this._dialog.dispose();
    }
}

