/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.metadata;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"INDEX_REPLICATION_BLOCK", "Lorg/opensearch/cluster/block/ClusterBlock;", "getINDEX_REPLICATION_BLOCK", "()Lorg/opensearch/cluster/block/ClusterBlock;", "checkIfIndexBlockedWithLevel", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexName", "", "clusterBlockLevel", "Lorg/opensearch/cluster/block/ClusterBlockLevel;", "opensearch-cross-cluster-replication"})
public final class UpdateIndexBlockTaskKt {
    @NotNull
    private static final ClusterBlock INDEX_REPLICATION_BLOCK = new ClusterBlock(1000, "index read-only(cross-cluster-replication)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of((Enum)ClusterBlockLevel.WRITE, (Enum)ClusterBlockLevel.METADATA_WRITE));

    @NotNull
    public static final ClusterBlock getINDEX_REPLICATION_BLOCK() {
        return INDEX_REPLICATION_BLOCK;
    }

    public static final void checkIfIndexBlockedWithLevel(@NotNull ClusterService clusterService, @NotNull String indexName, @NotNull ClusterBlockLevel clusterBlockLevel) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)clusterBlockLevel, (String)"clusterBlockLevel");
        IndexRoutingTable indexRoutingTable = clusterService.state().getRoutingTable().index(indexName);
        if (indexRoutingTable == null) {
            throw new IndexNotFoundException("Index with name:" + indexName + " doesn't exist");
        }
        Map map = clusterService.state().blocks().indices(clusterBlockLevel);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"clusterService.state().b\u2026ndices(clusterBlockLevel)");
        Map writeIndexBlockMap = map;
        if (!writeIndexBlockMap.containsKey(indexName)) {
            return;
        }
        Set set = Collections.emptySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"emptySet()");
        Set clusterBlocksSet = writeIndexBlockMap.getOrDefault(indexName, set);
        if (clusterBlocksSet.contains(INDEX_REPLICATION_BLOCK) && clusterBlocksSet.size() > 1) {
            throw new ClusterBlockException(clusterBlocksSet);
        }
    }
}

