# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtSvg, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtSvg`

import PySide6.QtSvg
import PySide6.QtCore
import PySide6.QtGui

import enum
from typing import ClassVar, Optional, Union, overload
from PySide6.QtCore import Signal


NoneType = type(None)


class QIntList(object): ...


class QSvgGenerator(PySide6.QtGui.QPaintDevice):

    class SvgVersion(enum.Enum):

        SvgTiny12                : QSvgGenerator.SvgVersion = ... # 0x0
        Svg11                    : QSvgGenerator.SvgVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, version: PySide6.QtSvg.QSvgGenerator.SvgVersion) -> None: ...

    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def outputDevice(self) -> PySide6.QtCore.QIODevice: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def resolution(self) -> int: ...
    def setDescription(self, description: str) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setOutputDevice(self, outputDevice: PySide6.QtCore.QIODevice) -> None: ...
    def setResolution(self, dpi: int) -> None: ...
    def setSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setTitle(self, title: str) -> None: ...
    @overload
    def setViewBox(self, viewBox: PySide6.QtCore.QRect) -> None: ...
    @overload
    def setViewBox(self, viewBox: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def svgVersion(self) -> PySide6.QtSvg.QSvgGenerator.SvgVersion: ...
    def title(self) -> str: ...
    def viewBox(self) -> PySide6.QtCore.QRect: ...
    def viewBoxF(self) -> PySide6.QtCore.QRectF: ...


class QSvgRenderer(PySide6.QtCore.QObject):

    repaintNeeded            : ClassVar[Signal] = ... # repaintNeeded()

    @overload
    def __init__(self, contents: PySide6.QtCore.QXmlStreamReader, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, contents: Union[PySide6.QtCore.QByteArray, bytes], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, filename: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def animated(self) -> bool: ...
    def animationDuration(self) -> int: ...
    def aspectRatioMode(self) -> PySide6.QtCore.Qt.AspectRatioMode: ...
    def boundsOnElement(self, id: str) -> PySide6.QtCore.QRectF: ...
    def currentFrame(self) -> int: ...
    def defaultSize(self) -> PySide6.QtCore.QSize: ...
    def elementExists(self, id: str) -> bool: ...
    def framesPerSecond(self) -> int: ...
    def isValid(self) -> bool: ...
    @overload
    def load(self, contents: PySide6.QtCore.QXmlStreamReader) -> bool: ...
    @overload
    def load(self, contents: Union[PySide6.QtCore.QByteArray, bytes]) -> bool: ...
    @overload
    def load(self, filename: str) -> bool: ...
    @overload
    def render(self, p: PySide6.QtGui.QPainter) -> None: ...
    @overload
    def render(self, p: PySide6.QtGui.QPainter, bounds: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def render(self, p: PySide6.QtGui.QPainter, elementId: str, bounds: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> None: ...
    def setAspectRatioMode(self, mode: PySide6.QtCore.Qt.AspectRatioMode) -> None: ...
    def setCurrentFrame(self, arg__1: int) -> None: ...
    def setFramesPerSecond(self, num: int) -> None: ...
    @overload
    def setViewBox(self, viewbox: PySide6.QtCore.QRect) -> None: ...
    @overload
    def setViewBox(self, viewbox: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def transformForElement(self, id: str) -> PySide6.QtGui.QTransform: ...
    def viewBox(self) -> PySide6.QtCore.QRect: ...
    def viewBoxF(self) -> PySide6.QtCore.QRectF: ...


# eof
