/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "e-dbus-address-book-view.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.evolution.dataserver.AddressBookView
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:EDBusAddressBookView
 * @title: EDBusAddressBookView
 * @short_description: Generated C code for the org.gnome.evolution.dataserver.AddressBookView D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.evolution.dataserver.AddressBookView ---- */

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_view_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_view_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_method_info_set_flags_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_method_info_set_flags_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_view_method_info_set_flags_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_view_method_info_set_flags =
{
  {
    -1,
    (gchar *) "SetFlags",
    (GDBusArgInfo **) &_e_dbus_address_book_view_method_info_set_flags_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-flags",
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_method_info_set_fields_of_interest_IN_ARG_only_fields =
{
  {
    -1,
    (gchar *) "only_fields",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_method_info_set_fields_of_interest_IN_ARG_pointers[] =
{
  &_e_dbus_address_book_view_method_info_set_fields_of_interest_IN_ARG_only_fields.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_view_method_info_set_fields_of_interest =
{
  {
    -1,
    (gchar *) "SetFieldsOfInterest",
    (GDBusArgInfo **) &_e_dbus_address_book_view_method_info_set_fields_of_interest_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-fields-of-interest",
  FALSE
};

static const _ExtendedGDBusMethodInfo _e_dbus_address_book_view_method_info_dispose =
{
  {
    -1,
    (gchar *) "Dispose",
    NULL,
    NULL,
    NULL
  },
  "handle-dispose",
  FALSE
};

static const GDBusMethodInfo * const _e_dbus_address_book_view_method_info_pointers[] =
{
  &_e_dbus_address_book_view_method_info_start.parent_struct,
  &_e_dbus_address_book_view_method_info_stop.parent_struct,
  &_e_dbus_address_book_view_method_info_set_flags.parent_struct,
  &_e_dbus_address_book_view_method_info_set_fields_of_interest.parent_struct,
  &_e_dbus_address_book_view_method_info_dispose.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_objects_added_ARG_objects =
{
  {
    -1,
    (gchar *) "objects",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_signal_info_objects_added_ARG_pointers[] =
{
  &_e_dbus_address_book_view_signal_info_objects_added_ARG_objects.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _e_dbus_address_book_view_signal_info_objects_added =
{
  {
    -1,
    (gchar *) "ObjectsAdded",
    (GDBusArgInfo **) &_e_dbus_address_book_view_signal_info_objects_added_ARG_pointers,
    NULL
  },
  "objects-added"
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_objects_modified_ARG_objects =
{
  {
    -1,
    (gchar *) "objects",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_signal_info_objects_modified_ARG_pointers[] =
{
  &_e_dbus_address_book_view_signal_info_objects_modified_ARG_objects.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _e_dbus_address_book_view_signal_info_objects_modified =
{
  {
    -1,
    (gchar *) "ObjectsModified",
    (GDBusArgInfo **) &_e_dbus_address_book_view_signal_info_objects_modified_ARG_pointers,
    NULL
  },
  "objects-modified"
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_objects_removed_ARG_uids =
{
  {
    -1,
    (gchar *) "uids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_signal_info_objects_removed_ARG_pointers[] =
{
  &_e_dbus_address_book_view_signal_info_objects_removed_ARG_uids.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _e_dbus_address_book_view_signal_info_objects_removed =
{
  {
    -1,
    (gchar *) "ObjectsRemoved",
    (GDBusArgInfo **) &_e_dbus_address_book_view_signal_info_objects_removed_ARG_pointers,
    NULL
  },
  "objects-removed"
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_progress_ARG_percent =
{
  {
    -1,
    (gchar *) "percent",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_progress_ARG_message =
{
  {
    -1,
    (gchar *) "message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_signal_info_progress_ARG_pointers[] =
{
  &_e_dbus_address_book_view_signal_info_progress_ARG_percent.parent_struct,
  &_e_dbus_address_book_view_signal_info_progress_ARG_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _e_dbus_address_book_view_signal_info_progress =
{
  {
    -1,
    (gchar *) "Progress",
    (GDBusArgInfo **) &_e_dbus_address_book_view_signal_info_progress_ARG_pointers,
    NULL
  },
  "progress"
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_complete_ARG_error_name =
{
  {
    -1,
    (gchar *) "error_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _e_dbus_address_book_view_signal_info_complete_ARG_error_message =
{
  {
    -1,
    (gchar *) "error_message",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _e_dbus_address_book_view_signal_info_complete_ARG_pointers[] =
{
  &_e_dbus_address_book_view_signal_info_complete_ARG_error_name.parent_struct,
  &_e_dbus_address_book_view_signal_info_complete_ARG_error_message.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _e_dbus_address_book_view_signal_info_complete =
{
  {
    -1,
    (gchar *) "Complete",
    (GDBusArgInfo **) &_e_dbus_address_book_view_signal_info_complete_ARG_pointers,
    NULL
  },
  "complete"
};

static const GDBusSignalInfo * const _e_dbus_address_book_view_signal_info_pointers[] =
{
  &_e_dbus_address_book_view_signal_info_objects_added.parent_struct,
  &_e_dbus_address_book_view_signal_info_objects_modified.parent_struct,
  &_e_dbus_address_book_view_signal_info_objects_removed.parent_struct,
  &_e_dbus_address_book_view_signal_info_progress.parent_struct,
  &_e_dbus_address_book_view_signal_info_complete.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _e_dbus_address_book_view_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.evolution.dataserver.AddressBookView",
    (GDBusMethodInfo **) &_e_dbus_address_book_view_method_info_pointers,
    (GDBusSignalInfo **) &_e_dbus_address_book_view_signal_info_pointers,
    NULL,
    NULL
  },
  "address-book-view",
};


/**
 * e_dbus_address_book_view_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 *
 * Since: 3.32
 */
GDBusInterfaceInfo *
e_dbus_address_book_view_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_e_dbus_address_book_view_interface_info.parent_struct;
}

/**
 * e_dbus_address_book_view_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #EDBusAddressBookView interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 *
 * Since: 3.32
 */
guint
e_dbus_address_book_view_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * EDBusAddressBookView:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link>.
 *
 * Since: 3.32
 */

/**
 * EDBusAddressBookViewIface:
 * @parent_iface: The parent interface.
 * @handle_dispose: Handler for the #EDBusAddressBookView::handle-dispose signal.
 * @handle_set_fields_of_interest: Handler for the #EDBusAddressBookView::handle-set-fields-of-interest signal.
 * @handle_set_flags: Handler for the #EDBusAddressBookView::handle-set-flags signal.
 * @handle_start: Handler for the #EDBusAddressBookView::handle-start signal.
 * @handle_stop: Handler for the #EDBusAddressBookView::handle-stop signal.
 * @complete: Handler for the #EDBusAddressBookView::complete signal.
 * @objects_added: Handler for the #EDBusAddressBookView::objects-added signal.
 * @objects_modified: Handler for the #EDBusAddressBookView::objects-modified signal.
 * @objects_removed: Handler for the #EDBusAddressBookView::objects-removed signal.
 * @progress: Handler for the #EDBusAddressBookView::progress signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link>.
 *
 * Since: 3.32
 */

typedef EDBusAddressBookViewIface EDBusAddressBookViewInterface;
G_DEFINE_INTERFACE (EDBusAddressBookView, e_dbus_address_book_view, G_TYPE_OBJECT)

static void
e_dbus_address_book_view_default_init (EDBusAddressBookViewIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * EDBusAddressBookView::handle-start:
   * @object: A #EDBusAddressBookView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_view_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.32
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * EDBusAddressBookView::handle-stop:
   * @object: A #EDBusAddressBookView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_view_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.32
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * EDBusAddressBookView::handle-set-flags:
   * @object: A #EDBusAddressBookView.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFlags">SetFlags()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_view_complete_set_flags() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.32
   */
  g_signal_new ("handle-set-flags",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, handle_set_flags),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * EDBusAddressBookView::handle-set-fields-of-interest:
   * @object: A #EDBusAddressBookView.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_only_fields: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFieldsOfInterest">SetFieldsOfInterest()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_view_complete_set_fields_of_interest() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.32
   */
  g_signal_new ("handle-set-fields-of-interest",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, handle_set_fields_of_interest),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * EDBusAddressBookView::handle-dispose:
   * @object: A #EDBusAddressBookView.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Dispose">Dispose()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call e_dbus_address_book_view_complete_dispose() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   *
   * Since: 3.32
   */
  g_signal_new ("handle-dispose",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, handle_dispose),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * EDBusAddressBookView::objects-added:
   * @object: A #EDBusAddressBookView.
   * @arg_objects: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.ObjectsAdded">"ObjectsAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Since: 3.32
   */
  g_signal_new ("objects-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, objects_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRV);

  /**
   * EDBusAddressBookView::objects-modified:
   * @object: A #EDBusAddressBookView.
   * @arg_objects: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.ObjectsModified">"ObjectsModified"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Since: 3.32
   */
  g_signal_new ("objects-modified",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, objects_modified),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRV);

  /**
   * EDBusAddressBookView::objects-removed:
   * @object: A #EDBusAddressBookView.
   * @arg_uids: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.ObjectsRemoved">"ObjectsRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Since: 3.32
   */
  g_signal_new ("objects-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, objects_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRV);

  /**
   * EDBusAddressBookView::progress:
   * @object: A #EDBusAddressBookView.
   * @arg_percent: Argument.
   * @arg_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.Progress">"Progress"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Since: 3.32
   */
  g_signal_new ("progress",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, progress),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * EDBusAddressBookView::complete:
   * @object: A #EDBusAddressBookView.
   * @arg_error_name: Argument.
   * @arg_error_message: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.Complete">"Complete"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   *
   * Since: 3.32
   */
  g_signal_new ("complete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (EDBusAddressBookViewIface, complete),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * e_dbus_address_book_view_emit_objects_added:
 * @object: A #EDBusAddressBookView.
 * @arg_objects: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.ObjectsAdded">"ObjectsAdded"</link> D-Bus signal.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_emit_objects_added (
    EDBusAddressBookView *object,
    const gchar *const *arg_objects)
{
  g_signal_emit_by_name (object, "objects-added", arg_objects);
}

/**
 * e_dbus_address_book_view_emit_objects_modified:
 * @object: A #EDBusAddressBookView.
 * @arg_objects: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.ObjectsModified">"ObjectsModified"</link> D-Bus signal.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_emit_objects_modified (
    EDBusAddressBookView *object,
    const gchar *const *arg_objects)
{
  g_signal_emit_by_name (object, "objects-modified", arg_objects);
}

/**
 * e_dbus_address_book_view_emit_objects_removed:
 * @object: A #EDBusAddressBookView.
 * @arg_uids: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.ObjectsRemoved">"ObjectsRemoved"</link> D-Bus signal.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_emit_objects_removed (
    EDBusAddressBookView *object,
    const gchar *const *arg_uids)
{
  g_signal_emit_by_name (object, "objects-removed", arg_uids);
}

/**
 * e_dbus_address_book_view_emit_progress:
 * @object: A #EDBusAddressBookView.
 * @arg_percent: Argument to pass with the signal.
 * @arg_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.Progress">"Progress"</link> D-Bus signal.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_emit_progress (
    EDBusAddressBookView *object,
    guint arg_percent,
    const gchar *arg_message)
{
  g_signal_emit_by_name (object, "progress", arg_percent, arg_message);
}

/**
 * e_dbus_address_book_view_emit_complete:
 * @object: A #EDBusAddressBookView.
 * @arg_error_name: Argument to pass with the signal.
 * @arg_error_message: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-evolution-dataserver-AddressBookView.Complete">"Complete"</link> D-Bus signal.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_emit_complete (
    EDBusAddressBookView *object,
    const gchar *arg_error_name,
    const gchar *arg_error_message)
{
  g_signal_emit_by_name (object, "complete", arg_error_name, arg_error_message);
}

/**
 * e_dbus_address_book_view_call_start:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_call_start_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_call_start_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_call_start (
    EDBusAddressBookView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_view_call_start_finish:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_view_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_start_finish (
    EDBusAddressBookView *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_start_sync:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_start_sync (
    EDBusAddressBookView *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_stop:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_call_stop_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_call_stop_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_call_stop (
    EDBusAddressBookView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_view_call_stop_finish:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_view_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_stop_finish (
    EDBusAddressBookView *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_stop_sync:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_stop_sync (
    EDBusAddressBookView *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_set_flags:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFlags">SetFlags()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_call_set_flags_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_call_set_flags_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_call_set_flags (
    EDBusAddressBookView *proxy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetFlags",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_view_call_set_flags_finish:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_call_set_flags().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_view_call_set_flags().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_set_flags_finish (
    EDBusAddressBookView *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_set_flags_sync:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFlags">SetFlags()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_call_set_flags() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_set_flags_sync (
    EDBusAddressBookView *proxy,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetFlags",
    g_variant_new ("(u)",
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_set_fields_of_interest:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @arg_only_fields: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFieldsOfInterest">SetFieldsOfInterest()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_call_set_fields_of_interest_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_call_set_fields_of_interest_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_call_set_fields_of_interest (
    EDBusAddressBookView *proxy,
    const gchar *const *arg_only_fields,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetFieldsOfInterest",
    g_variant_new ("(^as)",
                   arg_only_fields),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_view_call_set_fields_of_interest_finish:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_call_set_fields_of_interest().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_view_call_set_fields_of_interest().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_set_fields_of_interest_finish (
    EDBusAddressBookView *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_set_fields_of_interest_sync:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @arg_only_fields: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFieldsOfInterest">SetFieldsOfInterest()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_call_set_fields_of_interest() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_set_fields_of_interest_sync (
    EDBusAddressBookView *proxy,
    const gchar *const *arg_only_fields,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetFieldsOfInterest",
    g_variant_new ("(^as)",
                   arg_only_fields),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_dispose:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Dispose">Dispose()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_call_dispose_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_call_dispose_sync() for the synchronous, blocking version of this method.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_call_dispose (
    EDBusAddressBookView *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Dispose",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * e_dbus_address_book_view_call_dispose_finish:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_call_dispose().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with e_dbus_address_book_view_call_dispose().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_dispose_finish (
    EDBusAddressBookView *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_call_dispose_sync:
 * @proxy: A #EDBusAddressBookViewProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Dispose">Dispose()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_call_dispose() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 *
 * Since: 3.32
 */
gboolean
e_dbus_address_book_view_call_dispose_sync (
    EDBusAddressBookView *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Dispose",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * e_dbus_address_book_view_complete_start:
 * @object: A #EDBusAddressBookView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_complete_start (
    EDBusAddressBookView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_view_complete_stop:
 * @object: A #EDBusAddressBookView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_complete_stop (
    EDBusAddressBookView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_view_complete_set_flags:
 * @object: A #EDBusAddressBookView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFlags">SetFlags()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_complete_set_flags (
    EDBusAddressBookView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_view_complete_set_fields_of_interest:
 * @object: A #EDBusAddressBookView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.SetFieldsOfInterest">SetFieldsOfInterest()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_complete_set_fields_of_interest (
    EDBusAddressBookView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * e_dbus_address_book_view_complete_dispose:
 * @object: A #EDBusAddressBookView.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-evolution-dataserver-AddressBookView.Dispose">Dispose()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_complete_dispose (
    EDBusAddressBookView *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * EDBusAddressBookViewProxy:
 *
 * The #EDBusAddressBookViewProxy structure contains only private data and should only be accessed using the provided API.
 *
 * Since: 3.32
 */

/**
 * EDBusAddressBookViewProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EDBusAddressBookViewProxy.
 *
 * Since: 3.32
 */

struct _EDBusAddressBookViewProxyPrivate
{
  GData *qdata;
};

static void e_dbus_address_book_view_proxy_iface_init (EDBusAddressBookViewIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookViewProxy, e_dbus_address_book_view_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (EDBusAddressBookViewProxy)
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK_VIEW, e_dbus_address_book_view_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookViewProxy, e_dbus_address_book_view_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK_VIEW, e_dbus_address_book_view_proxy_iface_init))

#endif
static void
e_dbus_address_book_view_proxy_finalize (GObject *object)
{
  EDBusAddressBookViewProxy *proxy = E_DBUS_ADDRESS_BOOK_VIEW_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (e_dbus_address_book_view_proxy_parent_class)->finalize (object);
}

static void
e_dbus_address_book_view_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
e_dbus_address_book_view_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
e_dbus_address_book_view_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_e_dbus_address_book_view_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], E_DBUS_TYPE_ADDRESS_BOOK_VIEW);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, E_DBUS_TYPE_ADDRESS_BOOK_VIEW);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
e_dbus_address_book_view_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  EDBusAddressBookViewProxy *proxy = E_DBUS_ADDRESS_BOOK_VIEW_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_view_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_view_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
e_dbus_address_book_view_proxy_init (EDBusAddressBookViewProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = e_dbus_address_book_view_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, E_DBUS_TYPE_ADDRESS_BOOK_VIEW_PROXY, EDBusAddressBookViewProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), e_dbus_address_book_view_interface_info ());
}

static void
e_dbus_address_book_view_proxy_class_init (EDBusAddressBookViewProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = e_dbus_address_book_view_proxy_finalize;
  gobject_class->get_property = e_dbus_address_book_view_proxy_get_property;
  gobject_class->set_property = e_dbus_address_book_view_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = e_dbus_address_book_view_proxy_g_signal;
  proxy_class->g_properties_changed = e_dbus_address_book_view_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EDBusAddressBookViewProxyPrivate));
#endif
}

static void
e_dbus_address_book_view_proxy_iface_init (EDBusAddressBookViewIface *iface G_GNUC_UNUSED)
{
}

/**
 * e_dbus_address_book_view_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_proxy_new_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_proxy_new_sync() for the synchronous, blocking version of this constructor.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (E_DBUS_TYPE_ADDRESS_BOOK_VIEW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBookView", NULL);
}

/**
 * e_dbus_address_book_view_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with e_dbus_address_book_view_proxy_new().
 *
 * Returns: (transfer full) (type EDBusAddressBookViewProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.32
 */
EDBusAddressBookView *
e_dbus_address_book_view_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK_VIEW (ret);
  else
    return NULL;
}

/**
 * e_dbus_address_book_view_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EDBusAddressBookViewProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.32
 */
EDBusAddressBookView *
e_dbus_address_book_view_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (E_DBUS_TYPE_ADDRESS_BOOK_VIEW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBookView", NULL);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK_VIEW (ret);
  else
    return NULL;
}


/**
 * e_dbus_address_book_view_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like e_dbus_address_book_view_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call e_dbus_address_book_view_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See e_dbus_address_book_view_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 *
 * Since: 3.32
 */
void
e_dbus_address_book_view_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (E_DBUS_TYPE_ADDRESS_BOOK_VIEW_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBookView", NULL);
}

/**
 * e_dbus_address_book_view_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_dbus_address_book_view_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with e_dbus_address_book_view_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type EDBusAddressBookViewProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.32
 */
EDBusAddressBookView *
e_dbus_address_book_view_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK_VIEW (ret);
  else
    return NULL;
}

/**
 * e_dbus_address_book_view_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like e_dbus_address_book_view_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See e_dbus_address_book_view_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type EDBusAddressBookViewProxy): The constructed proxy object or %NULL if @error is set.
 *
 * Since: 3.32
 */
EDBusAddressBookView *
e_dbus_address_book_view_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (E_DBUS_TYPE_ADDRESS_BOOK_VIEW_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.evolution.dataserver.AddressBookView", NULL);
  if (ret != NULL)
    return E_DBUS_ADDRESS_BOOK_VIEW (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * EDBusAddressBookViewSkeleton:
 *
 * The #EDBusAddressBookViewSkeleton structure contains only private data and should only be accessed using the provided API.
 *
 * Since: 3.32
 */

/**
 * EDBusAddressBookViewSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #EDBusAddressBookViewSkeleton.
 *
 * Since: 3.32
 */

struct _EDBusAddressBookViewSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_e_dbus_address_book_view_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], E_DBUS_TYPE_ADDRESS_BOOK_VIEW);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, E_DBUS_TYPE_ADDRESS_BOOK_VIEW);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_e_dbus_address_book_view_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_view_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_e_dbus_address_book_view_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_e_dbus_address_book_view_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _e_dbus_address_book_view_skeleton_vtable =
{
  _e_dbus_address_book_view_skeleton_handle_method_call,
  _e_dbus_address_book_view_skeleton_handle_get_property,
  _e_dbus_address_book_view_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
e_dbus_address_book_view_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return e_dbus_address_book_view_interface_info ();
}

static GDBusInterfaceVTable *
e_dbus_address_book_view_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_e_dbus_address_book_view_skeleton_vtable;
}

static GVariant *
e_dbus_address_book_view_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_e_dbus_address_book_view_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _e_dbus_address_book_view_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _e_dbus_address_book_view_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _e_dbus_address_book_view_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBookView", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
e_dbus_address_book_view_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_e_dbus_address_book_view_on_signal_objects_added (
    EDBusAddressBookView *object,
    const gchar *const *arg_objects)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(^as)",
                   arg_objects));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBookView", "ObjectsAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_e_dbus_address_book_view_on_signal_objects_modified (
    EDBusAddressBookView *object,
    const gchar *const *arg_objects)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(^as)",
                   arg_objects));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBookView", "ObjectsModified",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_e_dbus_address_book_view_on_signal_objects_removed (
    EDBusAddressBookView *object,
    const gchar *const *arg_uids)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(^as)",
                   arg_uids));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBookView", "ObjectsRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_e_dbus_address_book_view_on_signal_progress (
    EDBusAddressBookView *object,
    guint arg_percent,
    const gchar *arg_message)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(us)",
                   arg_percent,
                   arg_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBookView", "Progress",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_e_dbus_address_book_view_on_signal_complete (
    EDBusAddressBookView *object,
    const gchar *arg_error_name,
    const gchar *arg_error_message)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_error_name,
                   arg_error_message));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.evolution.dataserver.AddressBookView", "Complete",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void e_dbus_address_book_view_skeleton_iface_init (EDBusAddressBookViewIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookViewSkeleton, e_dbus_address_book_view_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (EDBusAddressBookViewSkeleton)
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK_VIEW, e_dbus_address_book_view_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (EDBusAddressBookViewSkeleton, e_dbus_address_book_view_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (E_DBUS_TYPE_ADDRESS_BOOK_VIEW, e_dbus_address_book_view_skeleton_iface_init))

#endif
static void
e_dbus_address_book_view_skeleton_finalize (GObject *object)
{
  EDBusAddressBookViewSkeleton *skeleton = E_DBUS_ADDRESS_BOOK_VIEW_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (e_dbus_address_book_view_skeleton_parent_class)->finalize (object);
}

static void
e_dbus_address_book_view_skeleton_init (EDBusAddressBookViewSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = e_dbus_address_book_view_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, E_DBUS_TYPE_ADDRESS_BOOK_VIEW_SKELETON, EDBusAddressBookViewSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
e_dbus_address_book_view_skeleton_class_init (EDBusAddressBookViewSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = e_dbus_address_book_view_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = e_dbus_address_book_view_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = e_dbus_address_book_view_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = e_dbus_address_book_view_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = e_dbus_address_book_view_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (EDBusAddressBookViewSkeletonPrivate));
#endif
}

static void
e_dbus_address_book_view_skeleton_iface_init (EDBusAddressBookViewIface *iface)
{
  iface->objects_added = _e_dbus_address_book_view_on_signal_objects_added;
  iface->objects_modified = _e_dbus_address_book_view_on_signal_objects_modified;
  iface->objects_removed = _e_dbus_address_book_view_on_signal_objects_removed;
  iface->progress = _e_dbus_address_book_view_on_signal_progress;
  iface->complete = _e_dbus_address_book_view_on_signal_complete;
}

/**
 * e_dbus_address_book_view_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-evolution-dataserver-AddressBookView.top_of_page">org.gnome.evolution.dataserver.AddressBookView</link>.
 *
 * Returns: (transfer full) (type EDBusAddressBookViewSkeleton): The skeleton object.
 *
 * Since: 3.32
 */
EDBusAddressBookView *
e_dbus_address_book_view_skeleton_new (void)
{
  return E_DBUS_ADDRESS_BOOK_VIEW (g_object_new (E_DBUS_TYPE_ADDRESS_BOOK_VIEW_SKELETON, NULL));
}

