/* import-pidgin.c generated by valac 0.56.0, the Vala compiler
 * generated from import-pidgin.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <stdio.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FOLKS_TYPE_IMPORTER (folks_importer_get_type ())
#define FOLKS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORTER, FolksImporter))
#define FOLKS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORTER, FolksImporterClass))
#define FOLKS_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORTER))
#define FOLKS_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORTER))
#define FOLKS_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORTER, FolksImporterClass))

typedef struct _FolksImporter FolksImporter;
typedef struct _FolksImporterClass FolksImporterClass;
typedef struct _FolksImporterPrivate FolksImporterPrivate;

#define FOLKS_TYPE_IMPORT_ERROR (folks_import_error_get_type ())

#define FOLKS_IMPORTERS_TYPE_PIDGIN (folks_importers_pidgin_get_type ())
#define FOLKS_IMPORTERS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin))
#define FOLKS_IMPORTERS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))
#define FOLKS_IMPORTERS_IS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_IS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_PIDGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))

typedef struct _FolksImportersPidgin FolksImportersPidgin;
typedef struct _FolksImportersPidginClass FolksImportersPidginClass;
typedef struct _FolksImportersPidginPrivate FolksImportersPidginPrivate;
enum  {
	FOLKS_IMPORTERS_PIDGIN_0_PROPERTY,
	FOLKS_IMPORTERS_PIDGIN_NUM_PROPERTIES
};
static GParamSpec* folks_importers_pidgin_properties[FOLKS_IMPORTERS_PIDGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
typedef struct _FolksImportersPidginImportData FolksImportersPidginImportData;
typedef struct _FolksImportersPidginParseBlistData FolksImportersPidginParseBlistData;
typedef struct _FolksImportersPidginParseGroupData FolksImportersPidginParseGroupData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksImportersPidginParseContactData FolksImportersPidginParseContactData;

typedef enum  {
	FOLKS_IMPORT_ERROR_MALFORMED_INPUT
} FolksImportError;
#define FOLKS_IMPORT_ERROR folks_import_error_quark ()

struct _FolksImporter {
	GObject parent_instance;
	FolksImporterPrivate * priv;
};

struct _FolksImporterClass {
	GObjectClass parent_class;
	void (*import) (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*import_finish) (FolksImporter* self, GAsyncResult* _res_, GError** error);
};

struct _FolksImportersPidgin {
	FolksImporter parent_instance;
	FolksImportersPidginPrivate * priv;
};

struct _FolksImportersPidginClass {
	FolksImporterClass parent_class;
};

struct _FolksImportersPidginPrivate {
	FolksPersonaStore* destination_store;
	guint persona_count;
};

struct _FolksImportersPidginImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksImportersPidgin* self;
	FolksPersonaStore* destination_store;
	gchar* source_filename;
	guint result;
	FolksPersonaStore* _tmp0_;
	gchar* filename;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* file;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GFileInfo* file_info;
	GFileInfo* _tmp14_;
	GFile* _tmp15_;
	GFileInfo* _tmp16_;
	GFileInfo* _tmp17_;
	GError* e;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	xmlDoc* xml_doc;
	const gchar* _tmp25_;
	xmlDoc* _tmp26_;
	xmlDoc* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	xmlNode* root_node;
	xmlDoc* _tmp30_;
	xmlNode* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	xmlNode* _tmp34_;
	xmlNode* _tmp35_;
	const gchar* _tmp36_;
	xmlNode* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	xmlDoc* _tmp40_;
	const gchar* _tmp41_;
	GError* _tmp42_;
	xmlNode* iter;
	xmlNode* _tmp43_;
	xmlNode* _tmp44_;
	gboolean _tmp45_;
	xmlNode* _tmp46_;
	xmlNode* _tmp47_;
	xmlNode* _tmp48_;
	gboolean _tmp49_;
	xmlNode* _tmp50_;
	xmlNode* _tmp51_;
	const gchar* _tmp52_;
	xmlNode* _tmp53_;
	xmlDoc* _tmp54_;
	FILE* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	GError* _inner_error0_;
};

struct _FolksImportersPidginParseBlistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksImportersPidgin* self;
	xmlNode* blist_node;
	xmlNode* iter;
	xmlNode* _tmp0_;
	gboolean _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* _tmp4_;
	gboolean _tmp5_;
	xmlNode* _tmp6_;
	xmlNode* _tmp7_;
	const gchar* _tmp8_;
	xmlNode* _tmp9_;
};

struct _FolksImportersPidginParseGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksImportersPidgin* self;
	xmlNode* group_node;
	gchar* group_name;
	gchar* _tmp0_;
	xmlNode* iter;
	xmlNode* _tmp1_;
	gboolean _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* _tmp4_;
	xmlNode* _tmp5_;
	gboolean _tmp6_;
	xmlNode* _tmp7_;
	xmlNode* _tmp8_;
	const gchar* _tmp9_;
	FolksPersona* persona;
	xmlNode* _tmp10_;
	FolksPersona* _tmp11_;
	gboolean _tmp12_;
	FolksPersona* _tmp13_;
	FolksPersona* _tmp14_;
	FolksGroupDetails* group_details;
	FolksPersona* _tmp15_;
	FolksGroupDetails* _tmp16_;
	FolksGroupDetails* _tmp17_;
	const gchar* _tmp18_;
	GError* e;
	FILE* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	FolksPersona* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError* _inner_error0_;
};

struct _FolksImportersPidginParseContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksImportersPidgin* self;
	xmlNode* contact_node;
	FolksPersona* result;
	gchar* alias;
	GeeHashMultiMap* im_addresses;
	GeeHashMultiMap* _tmp0_;
	gchar* im_address_string;
	gchar* _tmp1_;
	xmlNode* iter;
	xmlNode* _tmp2_;
	gboolean _tmp3_;
	xmlNode* _tmp4_;
	xmlNode* _tmp5_;
	xmlNode* _tmp6_;
	gboolean _tmp7_;
	xmlNode* _tmp8_;
	xmlNode* _tmp9_;
	const gchar* _tmp10_;
	gchar* blist_protocol;
	xmlNode* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* tp_protocol;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	xmlNode* subiter;
	xmlNode* _tmp17_;
	xmlNode* _tmp18_;
	gboolean _tmp19_;
	xmlNode* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* _tmp22_;
	xmlNode* _tmp23_;
	xmlNode* _tmp24_;
	const gchar* _tmp25_;
	xmlNode* _tmp26_;
	gchar* _tmp27_;
	xmlNode* _tmp28_;
	const gchar* _tmp29_;
	gchar* im_address;
	xmlNode* _tmp30_;
	gchar* _tmp31_;
	GeeHashMultiMap* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	FolksImFieldDetails* _tmp35_;
	FolksImFieldDetails* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	GeeHashMultiMap* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	FILE* _tmp58_;
	const gchar* _tmp59_;
	GHashTable* details;
	GHashFunc _tmp60_;
	GEqualFunc _tmp61_;
	GHashTable* _tmp62_;
	GValue im_addresses_value;
	GValue _tmp63_;
	GeeHashMultiMap* _tmp64_;
	GHashTable* _tmp65_;
	gchar* _tmp66_;
	GValue _tmp67_;
	GValue _tmp68_;
	GValue* _tmp69_;
	FolksPersona* persona;
	FolksPersona* _tmp70_;
	FolksPersonaStore* _tmp71_;
	GHashTable* _tmp72_;
	FolksPersona* _tmp73_;
	FolksPersona* _tmp74_;
	GError* e;
	FILE* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	GError* _tmp78_;
	const gchar* _tmp79_;
	gboolean _tmp80_;
	const gchar* _tmp81_;
	FolksPersona* _tmp82_;
	FolksPersona* _tmp83_;
	const gchar* _tmp84_;
	FILE* _tmp85_;
	FolksPersona* _tmp86_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	guint _tmp91_;
	GError* _inner_error0_;
};

static gint FolksImportersPidgin_private_offset;
static gpointer folks_importers_pidgin_parent_class = NULL;

VALA_EXTERN GType folks_importer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksImporter, g_object_unref)
VALA_EXTERN GQuark folks_import_error_quark (void);
GType folks_import_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType folks_importers_pidgin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolksImportersPidgin, g_object_unref)
VALA_EXTERN void folks_importer_import (FolksImporter* self,
                            FolksPersonaStore* destination_store,
                            const gchar* source_filename,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN guint folks_importer_import_finish (FolksImporter* self,
                                    GAsyncResult* _res_,
                                    GError** error);
static void folks_importers_pidgin_real_import_data_free (gpointer _data);
static void folks_importers_pidgin_real_import (FolksImporter* base,
                                         FolksPersonaStore* destination_store,
                                         const gchar* source_filename,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean folks_importers_pidgin_real_import_co (FolksImportersPidginImportData* _data_);
static void folks_importers_pidgin_import_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void folks_importers_pidgin_parse_blist (FolksImportersPidgin* self,
                                         xmlNode* blist_node,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void folks_importers_pidgin_parse_blist_finish (FolksImportersPidgin* self,
                                                GAsyncResult* _res_);
static void folks_importers_pidgin_parse_blist_data_free (gpointer _data);
static gboolean folks_importers_pidgin_parse_blist_co (FolksImportersPidginParseBlistData* _data_);
static void folks_importers_pidgin_parse_group (FolksImportersPidgin* self,
                                         xmlNode* group_node,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void folks_importers_pidgin_parse_group_finish (FolksImportersPidgin* self,
                                                GAsyncResult* _res_);
static void folks_importers_pidgin_parse_blist_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void folks_importers_pidgin_parse_group_data_free (gpointer _data);
static gboolean folks_importers_pidgin_parse_group_co (FolksImportersPidginParseGroupData* _data_);
static void folks_importers_pidgin_parse_contact (FolksImportersPidgin* self,
                                           xmlNode* contact_node,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static FolksPersona* folks_importers_pidgin_parse_contact_finish (FolksImportersPidgin* self,
                                                           GAsyncResult* _res_);
static void folks_importers_pidgin_parse_group_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void folks_importers_pidgin_parse_contact_data_free (gpointer _data);
static gboolean folks_importers_pidgin_parse_contact_co (FolksImportersPidginParseContactData* _data_);
static gchar* folks_importers_pidgin_blist_protocol_to_tp_protocol (FolksImportersPidgin* self,
                                                             const gchar* blist_protocol);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void folks_importers_pidgin_parse_contact_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN FolksImportersPidgin* folks_importers_pidgin_new (void);
VALA_EXTERN FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type);
VALA_EXTERN FolksImporter* folks_importer_construct (GType object_type);
static void folks_importers_pidgin_finalize (GObject * obj);
static GType folks_importers_pidgin_get_type_once (void);

static inline gpointer
folks_importers_pidgin_get_instance_private (FolksImportersPidgin* self)
{
	return G_STRUCT_MEMBER_P (self, FolksImportersPidgin_private_offset);
}

static void
folks_importers_pidgin_real_import_data_free (gpointer _data)
{
	FolksImportersPidginImportData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->destination_store);
	_g_free0 (_data_->source_filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksImportersPidginImportData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_importers_pidgin_real_import (FolksImporter* base,
                                    FolksPersonaStore* destination_store,
                                    const gchar* source_filename,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksImportersPidgin * self;
	FolksImportersPidginImportData* _data_;
	FolksImportersPidgin* _tmp0_;
	FolksPersonaStore* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (destination_store != NULL);
	self = (FolksImportersPidgin*) base;
	_data_ = g_slice_new0 (FolksImportersPidginImportData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_importers_pidgin_real_import_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (destination_store);
	_g_object_unref0 (_data_->destination_store);
	_data_->destination_store = _tmp1_;
	_tmp2_ = g_strdup (source_filename);
	_g_free0 (_data_->source_filename);
	_data_->source_filename = _tmp2_;
	folks_importers_pidgin_real_import_co (_data_);
}

static guint
folks_importers_pidgin_import_finish (FolksImporter* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	guint result;
	FolksImportersPidginImportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		guint _tmp0_ = 0U;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
folks_importers_pidgin_import_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	FolksImportersPidginImportData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_importers_pidgin_real_import_co (_data_);
}

static gboolean
folks_importers_pidgin_real_import_co (FolksImportersPidginImportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _g_object_ref0 (_data_->destination_store);
	_g_object_unref0 (_data_->self->priv->destination_store);
	_data_->self->priv->destination_store = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup (_data_->source_filename);
	_data_->filename = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->filename;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->filename;
		_data_->_tmp5_ = string_strip (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp2_ = g_strcmp0 (_data_->_tmp6_, "") == 0;
		_g_free0 (_data_->_tmp6_);
	}
	if (_data_->_tmp2_) {
		_data_->_tmp7_ = g_get_home_dir ();
		_data_->_tmp8_ = g_build_filename (_data_->_tmp7_, ".purple", "blist.xml", NULL, NULL);
		_g_free0 (_data_->filename);
		_data_->filename = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->filename;
	_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
	_data_->file = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->file;
	if (!g_file_query_exists (_data_->_tmp11_, NULL)) {
		_data_->_tmp12_ = _data_->filename;
		_data_->_tmp13_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, _ ("File %s does not exist."), _data_->_tmp12_);
		_data_->_inner_error0_ = _data_->_tmp13_;
		if (_data_->_inner_error0_->domain == FOLKS_IMPORT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp15_ = _data_->file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp15_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, folks_importers_pidgin_import_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp16_ = g_file_query_info_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp14_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp17_ = _data_->_tmp14_;
		_data_->_tmp14_ = NULL;
		_g_object_unref0 (_data_->file_info);
		_data_->file_info = _data_->_tmp17_;
		_g_object_unref0 (_data_->_tmp14_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp18_ = _data_->filename;
		_data_->_tmp19_ = _data_->e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		_data_->_tmp21_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, _ ("Failed to get information about file %s: %s"), _data_->_tmp18_, _data_->_tmp20_);
		_data_->_inner_error0_ = _data_->_tmp21_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == FOLKS_IMPORT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp22_ = _data_->file_info;
	if (!g_file_info_get_attribute_boolean (_data_->_tmp22_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		_data_->_tmp23_ = _data_->filename;
		_data_->_tmp24_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, _ ("File %s is not readable."), _data_->_tmp23_);
		_data_->_inner_error0_ = _data_->_tmp24_;
		if (_data_->_inner_error0_->domain == FOLKS_IMPORT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp25_ = _data_->filename;
	_data_->_tmp26_ = xmlParseFile (_data_->_tmp25_);
	_data_->xml_doc = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->xml_doc;
	if (_data_->_tmp27_ == NULL) {
		_data_->_tmp28_ = _data_->filename;
		_data_->_tmp29_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, _ ("The Pidgin buddy list file ‘%s’ could not be loaded."), _data_->_tmp28_);
		_data_->_inner_error0_ = _data_->_tmp29_;
		if (_data_->_inner_error0_->domain == FOLKS_IMPORT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp30_ = _data_->xml_doc;
	_data_->_tmp31_ = xmlDocGetRootElement (_data_->_tmp30_);
	_data_->root_node = _data_->_tmp31_;
	_data_->_tmp34_ = _data_->root_node;
	if (_data_->_tmp34_ == NULL) {
		_data_->_tmp33_ = TRUE;
	} else {
		_data_->_tmp35_ = _data_->root_node;
		_data_->_tmp36_ = _data_->_tmp35_->name;
		_data_->_tmp33_ = g_strcmp0 (_data_->_tmp36_, "purple") != 0;
	}
	if (_data_->_tmp33_) {
		_data_->_tmp32_ = TRUE;
	} else {
		_data_->_tmp37_ = _data_->root_node;
		_data_->_tmp38_ = (gchar*) xmlGetProp (_data_->_tmp37_, (xmlChar*) "version");
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp32_ = g_strcmp0 (_data_->_tmp39_, "1.0") != 0;
		_g_free0 (_data_->_tmp39_);
	}
	if (_data_->_tmp32_) {
		_data_->_tmp40_ = _data_->xml_doc;
		_xmlFreeDoc0 (_data_->_tmp40_);
		_data_->_tmp41_ = _data_->filename;
		_data_->_tmp42_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, _ ("The Pidgin buddy list file ‘%s’ could not be loaded: the root element " \
"could not be found or was not recognized."), _data_->_tmp41_);
		_data_->_inner_error0_ = _data_->_tmp42_;
		if (_data_->_inner_error0_->domain == FOLKS_IMPORT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp43_ = _data_->root_node;
		_data_->_tmp44_ = _data_->_tmp43_->children;
		_data_->iter = _data_->_tmp44_;
		{
			_data_->_tmp45_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp45_) {
					_data_->_tmp46_ = _data_->iter;
					_data_->_tmp47_ = _data_->_tmp46_->next;
					_data_->iter = _data_->_tmp47_;
				}
				_data_->_tmp45_ = FALSE;
				_data_->_tmp48_ = _data_->iter;
				if (!(_data_->_tmp48_ != NULL)) {
					break;
				}
				_data_->_tmp50_ = _data_->iter;
				if (_data_->_tmp50_->type != XML_ELEMENT_NODE) {
					_data_->_tmp49_ = TRUE;
				} else {
					_data_->_tmp51_ = _data_->iter;
					_data_->_tmp52_ = _data_->_tmp51_->name;
					_data_->_tmp49_ = g_strcmp0 (_data_->_tmp52_, "blist") != 0;
				}
				if (_data_->_tmp49_) {
					continue;
				}
				_data_->_tmp53_ = _data_->iter;
				_data_->_state_ = 2;
				folks_importers_pidgin_parse_blist (_data_->self, _data_->_tmp53_, folks_importers_pidgin_import_ready, _data_);
				return FALSE;
				_state_2:
				folks_importers_pidgin_parse_blist_finish (_data_->self, _data_->_res_);
			}
		}
	}
	_data_->_tmp54_ = _data_->xml_doc;
	_xmlFreeDoc0 (_data_->_tmp54_);
	_data_->_tmp55_ = stdout;
	_data_->_tmp56_ = g_strconcat (ngettext ("Imported %u buddy from ‘%s’.", "Imported %u buddies from ‘%s’.", (gulong) _data_->self->priv->persona_count), "\n", NULL);
	_data_->_tmp57_ = _data_->_tmp56_;
	_data_->_tmp58_ = _data_->filename;
	fprintf (_data_->_tmp55_, _data_->_tmp57_, _data_->self->priv->persona_count, _data_->_tmp58_);
	_g_free0 (_data_->_tmp57_);
	_data_->result = _data_->self->priv->persona_count;
	_g_object_unref0 (_data_->file_info);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->filename);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_importers_pidgin_parse_blist_data_free (gpointer _data)
{
	FolksImportersPidginParseBlistData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksImportersPidginParseBlistData, _data_);
}

static void
folks_importers_pidgin_parse_blist (FolksImportersPidgin* self,
                                    xmlNode* blist_node,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksImportersPidginParseBlistData* _data_;
	FolksImportersPidgin* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksImportersPidginParseBlistData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_importers_pidgin_parse_blist_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->blist_node = blist_node;
	folks_importers_pidgin_parse_blist_co (_data_);
}

static void
folks_importers_pidgin_parse_blist_finish (FolksImportersPidgin* self,
                                           GAsyncResult* _res_)
{
	FolksImportersPidginParseBlistData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
folks_importers_pidgin_parse_blist_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	FolksImportersPidginParseBlistData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_importers_pidgin_parse_blist_co (_data_);
}

static gboolean
folks_importers_pidgin_parse_blist_co (FolksImportersPidginParseBlistData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->blist_node->children;
		_data_->iter = _data_->_tmp0_;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->iter;
					_data_->_tmp3_ = _data_->_tmp2_->next;
					_data_->iter = _data_->_tmp3_;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp4_ = _data_->iter;
				if (!(_data_->_tmp4_ != NULL)) {
					break;
				}
				_data_->_tmp6_ = _data_->iter;
				if (_data_->_tmp6_->type != XML_ELEMENT_NODE) {
					_data_->_tmp5_ = TRUE;
				} else {
					_data_->_tmp7_ = _data_->iter;
					_data_->_tmp8_ = _data_->_tmp7_->name;
					_data_->_tmp5_ = g_strcmp0 (_data_->_tmp8_, "group") != 0;
				}
				if (_data_->_tmp5_) {
					continue;
				}
				_data_->_tmp9_ = _data_->iter;
				_data_->_state_ = 1;
				folks_importers_pidgin_parse_group (_data_->self, _data_->_tmp9_, folks_importers_pidgin_parse_blist_ready, _data_);
				return FALSE;
				_state_1:
				folks_importers_pidgin_parse_group_finish (_data_->self, _data_->_res_);
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_importers_pidgin_parse_group_data_free (gpointer _data)
{
	FolksImportersPidginParseGroupData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksImportersPidginParseGroupData, _data_);
}

static void
folks_importers_pidgin_parse_group (FolksImportersPidgin* self,
                                    xmlNode* group_node,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksImportersPidginParseGroupData* _data_;
	FolksImportersPidgin* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksImportersPidginParseGroupData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_importers_pidgin_parse_group_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->group_node = group_node;
	folks_importers_pidgin_parse_group_co (_data_);
}

static void
folks_importers_pidgin_parse_group_finish (FolksImportersPidgin* self,
                                           GAsyncResult* _res_)
{
	FolksImportersPidginParseGroupData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
folks_importers_pidgin_parse_group_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	FolksImportersPidginParseGroupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_importers_pidgin_parse_group_co (_data_);
}

static gboolean
folks_importers_pidgin_parse_group_co (FolksImportersPidginParseGroupData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (gchar*) xmlGetProp (_data_->group_node, (xmlChar*) "name");
	_data_->group_name = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->group_node->children;
		_data_->iter = _data_->_tmp1_;
		{
			_data_->_tmp2_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp2_) {
					_data_->_tmp3_ = _data_->iter;
					_data_->_tmp4_ = _data_->_tmp3_->next;
					_data_->iter = _data_->_tmp4_;
				}
				_data_->_tmp2_ = FALSE;
				_data_->_tmp5_ = _data_->iter;
				if (!(_data_->_tmp5_ != NULL)) {
					break;
				}
				_data_->_tmp7_ = _data_->iter;
				if (_data_->_tmp7_->type != XML_ELEMENT_NODE) {
					_data_->_tmp6_ = TRUE;
				} else {
					_data_->_tmp8_ = _data_->iter;
					_data_->_tmp9_ = _data_->_tmp8_->name;
					_data_->_tmp6_ = g_strcmp0 (_data_->_tmp9_, "contact") != 0;
				}
				if (_data_->_tmp6_) {
					continue;
				}
				_data_->_tmp10_ = _data_->iter;
				_data_->_state_ = 1;
				folks_importers_pidgin_parse_contact (_data_->self, _data_->_tmp10_, folks_importers_pidgin_parse_group_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp11_ = folks_importers_pidgin_parse_contact_finish (_data_->self, _data_->_res_);
				_data_->persona = _data_->_tmp11_;
				_data_->_tmp13_ = _data_->persona;
				if (_data_->_tmp13_ == NULL) {
					_data_->_tmp12_ = TRUE;
				} else {
					_data_->_tmp14_ = _data_->persona;
					_data_->_tmp12_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, FOLKS_TYPE_GROUP_DETAILS);
				}
				if (_data_->_tmp12_) {
					_g_object_unref0 (_data_->persona);
					continue;
				}
				{
					_data_->_tmp15_ = _data_->persona;
					_data_->_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, FOLKS_TYPE_GROUP_DETAILS, FolksGroupDetails));
					_data_->group_details = _data_->_tmp16_;
					_data_->_tmp17_ = _data_->group_details;
					_data_->_tmp18_ = _data_->group_name;
					_data_->_state_ = 2;
					folks_group_details_change_group (_data_->_tmp17_, _data_->_tmp18_, TRUE, folks_importers_pidgin_parse_group_ready, _data_);
					return FALSE;
					_state_2:
					folks_group_details_change_group_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->group_details);
						goto __catch0_g_error;
					}
					_g_object_unref0 (_data_->group_details);
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp19_ = stderr;
					_data_->_tmp20_ = g_strconcat (_ ("Error changing group of contact ‘%s’: %s"), "\n", NULL);
					_data_->_tmp21_ = _data_->_tmp20_;
					_data_->_tmp22_ = _data_->persona;
					_data_->_tmp23_ = folks_persona_get_iid (_data_->_tmp22_);
					_data_->_tmp24_ = _data_->_tmp23_;
					_data_->_tmp25_ = _data_->e;
					_data_->_tmp26_ = _data_->_tmp25_->message;
					fprintf (_data_->_tmp19_, _data_->_tmp21_, _data_->_tmp24_, _data_->_tmp26_);
					_g_free0 (_data_->_tmp21_);
					_g_error_free0 (_data_->e);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->group_name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->persona);
			}
		}
	}
	_g_free0 (_data_->group_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_importers_pidgin_parse_contact_data_free (gpointer _data)
{
	FolksImportersPidginParseContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksImportersPidginParseContactData, _data_);
}

static void
folks_importers_pidgin_parse_contact (FolksImportersPidgin* self,
                                      xmlNode* contact_node,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FolksImportersPidginParseContactData* _data_;
	FolksImportersPidgin* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksImportersPidginParseContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_importers_pidgin_parse_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->contact_node = contact_node;
	folks_importers_pidgin_parse_contact_co (_data_);
}

static FolksPersona*
folks_importers_pidgin_parse_contact_finish (FolksImportersPidgin* self,
                                             GAsyncResult* _res_)
{
	FolksPersona* result;
	FolksImportersPidginParseContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
folks_importers_pidgin_parse_contact_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	FolksImportersPidginParseContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_importers_pidgin_parse_contact_co (_data_);
}

static gboolean
folks_importers_pidgin_parse_contact_co (FolksImportersPidginParseContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->alias = NULL;
	_data_->_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->im_addresses = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("");
	_data_->im_address_string = _data_->_tmp1_;
	{
		_data_->_tmp2_ = _data_->contact_node->children;
		_data_->iter = _data_->_tmp2_;
		{
			_data_->_tmp3_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp3_) {
					_data_->_tmp4_ = _data_->iter;
					_data_->_tmp5_ = _data_->_tmp4_->next;
					_data_->iter = _data_->_tmp5_;
				}
				_data_->_tmp3_ = FALSE;
				_data_->_tmp6_ = _data_->iter;
				if (!(_data_->_tmp6_ != NULL)) {
					break;
				}
				_data_->_tmp8_ = _data_->iter;
				if (_data_->_tmp8_->type != XML_ELEMENT_NODE) {
					_data_->_tmp7_ = TRUE;
				} else {
					_data_->_tmp9_ = _data_->iter;
					_data_->_tmp10_ = _data_->_tmp9_->name;
					_data_->_tmp7_ = g_strcmp0 (_data_->_tmp10_, "buddy") != 0;
				}
				if (_data_->_tmp7_) {
					continue;
				}
				_data_->_tmp11_ = _data_->iter;
				_data_->_tmp12_ = (gchar*) xmlGetProp (_data_->_tmp11_, (xmlChar*) "proto");
				_data_->blist_protocol = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->blist_protocol;
				if (_data_->_tmp13_ == NULL) {
					_g_free0 (_data_->blist_protocol);
					continue;
				}
				_data_->_tmp14_ = _data_->blist_protocol;
				_data_->_tmp15_ = folks_importers_pidgin_blist_protocol_to_tp_protocol (_data_->self, _data_->_tmp14_);
				_data_->tp_protocol = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->tp_protocol;
				if (_data_->_tmp16_ == NULL) {
					_g_free0 (_data_->tp_protocol);
					_g_free0 (_data_->blist_protocol);
					continue;
				}
				{
					_data_->_tmp17_ = _data_->iter;
					_data_->_tmp18_ = _data_->_tmp17_->children;
					_data_->subiter = _data_->_tmp18_;
					{
						_data_->_tmp19_ = TRUE;
						while (TRUE) {
							if (!_data_->_tmp19_) {
								_data_->_tmp20_ = _data_->subiter;
								_data_->_tmp21_ = _data_->_tmp20_->next;
								_data_->subiter = _data_->_tmp21_;
							}
							_data_->_tmp19_ = FALSE;
							_data_->_tmp22_ = _data_->subiter;
							if (!(_data_->_tmp22_ != NULL)) {
								break;
							}
							_data_->_tmp23_ = _data_->subiter;
							if (_data_->_tmp23_->type != XML_ELEMENT_NODE) {
								continue;
							}
							_data_->_tmp24_ = _data_->subiter;
							_data_->_tmp25_ = _data_->_tmp24_->name;
							if (g_strcmp0 (_data_->_tmp25_, "alias") == 0) {
								_data_->_tmp26_ = _data_->subiter;
								_data_->_tmp27_ = (gchar*) xmlNodeGetContent (_data_->_tmp26_);
								_g_free0 (_data_->alias);
								_data_->alias = _data_->_tmp27_;
							} else {
								_data_->_tmp28_ = _data_->subiter;
								_data_->_tmp29_ = _data_->_tmp28_->name;
								if (g_strcmp0 (_data_->_tmp29_, "name") == 0) {
									_data_->_tmp30_ = _data_->subiter;
									_data_->_tmp31_ = (gchar*) xmlNodeGetContent (_data_->_tmp30_);
									_data_->im_address = _data_->_tmp31_;
									_data_->_tmp32_ = _data_->im_addresses;
									_data_->_tmp33_ = _data_->tp_protocol;
									_data_->_tmp34_ = _data_->im_address;
									_data_->_tmp35_ = folks_im_field_details_new (_data_->_tmp34_, NULL);
									_data_->_tmp36_ = _data_->_tmp35_;
									gee_multi_map_set ((GeeMultiMap*) _data_->_tmp32_, _data_->_tmp33_, _data_->_tmp36_);
									_g_object_unref0 (_data_->_tmp36_);
									_data_->_tmp37_ = _data_->im_address_string;
									_data_->_tmp38_ = _data_->im_address;
									_data_->_tmp39_ = g_strdup_printf ("    %s\n", _data_->_tmp38_);
									_data_->_tmp40_ = _data_->_tmp39_;
									_data_->_tmp41_ = g_strconcat (_data_->_tmp37_, _data_->_tmp40_, NULL);
									_g_free0 (_data_->im_address_string);
									_data_->im_address_string = _data_->_tmp41_;
									_g_free0 (_data_->_tmp40_);
									_g_free0 (_data_->im_address);
								}
							}
						}
					}
				}
				_g_free0 (_data_->tp_protocol);
				_g_free0 (_data_->blist_protocol);
			}
		}
	}
	_data_->_tmp43_ = _data_->im_addresses;
	_data_->_tmp44_ = gee_multi_map_get_size ((GeeMultiMap*) _data_->_tmp43_);
	_data_->_tmp45_ = _data_->_tmp44_;
	if (_data_->_tmp45_ < 2) {
		_data_->_tmp48_ = _data_->alias;
		if (_data_->_tmp48_ == NULL) {
			_data_->_tmp47_ = TRUE;
		} else {
			_data_->_tmp49_ = _data_->alias;
			_data_->_tmp50_ = string_strip (_data_->_tmp49_);
			_data_->_tmp51_ = _data_->_tmp50_;
			_data_->_tmp47_ = g_strcmp0 (_data_->_tmp51_, "") == 0;
			_g_free0 (_data_->_tmp51_);
		}
		if (_data_->_tmp47_) {
			_data_->_tmp46_ = TRUE;
		} else {
			_data_->_tmp52_ = _data_->alias;
			_data_->_tmp53_ = string_strip (_data_->_tmp52_);
			_data_->_tmp54_ = _data_->_tmp53_;
			_data_->_tmp55_ = _data_->im_address_string;
			_data_->_tmp56_ = string_strip (_data_->_tmp55_);
			_data_->_tmp57_ = _data_->_tmp56_;
			_data_->_tmp46_ = g_strcmp0 (_data_->_tmp54_, _data_->_tmp57_) == 0;
			_g_free0 (_data_->_tmp57_);
			_g_free0 (_data_->_tmp54_);
		}
		_data_->_tmp42_ = _data_->_tmp46_;
	} else {
		_data_->_tmp42_ = FALSE;
	}
	if (_data_->_tmp42_) {
		_data_->_tmp58_ = stdout;
		_data_->_tmp59_ = _data_->im_address_string;
		fprintf (_data_->_tmp58_, _ ("Ignoring buddy with no alias and only one IM address:\n%s"), _data_->_tmp59_);
		_data_->result = NULL;
		_g_free0 (_data_->im_address_string);
		_g_object_unref0 (_data_->im_addresses);
		_g_free0 (_data_->alias);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp60_ = g_str_hash;
	_data_->_tmp61_ = g_str_equal;
	_data_->_tmp62_ = g_hash_table_new_full (_data_->_tmp60_, _data_->_tmp61_, _g_free0_, __vala_GValue_free0_);
	_data_->details = _data_->_tmp62_;
	memset (&_data_->_tmp63_, 0, sizeof (GValue));
	g_value_init (&_data_->_tmp63_, GEE_TYPE_MULTI_MAP);
	_data_->im_addresses_value = _data_->_tmp63_;
	_data_->_tmp64_ = _data_->im_addresses;
	g_value_set_object (&_data_->im_addresses_value, (GObject*) _data_->_tmp64_);
	_data_->_tmp65_ = _data_->details;
	_data_->_tmp66_ = g_strdup ("im-addresses");
	_data_->_tmp67_ = _data_->im_addresses_value;
	_data_->_tmp68_ = _data_->_tmp67_;
	_data_->_tmp69_ = __g_value_dup0 (&_data_->_tmp68_);
	g_hash_table_insert (_data_->_tmp65_, _data_->_tmp66_, _data_->_tmp69_);
	{
		_data_->_tmp71_ = _data_->self->priv->destination_store;
		_data_->_tmp72_ = _data_->details;
		_data_->_state_ = 1;
		folks_persona_store_add_persona_from_details (_data_->_tmp71_, _data_->_tmp72_, folks_importers_pidgin_parse_contact_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp73_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp71_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp70_ = _data_->_tmp73_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch0_folks_persona_store_error;
			}
			_g_object_unref0 (_data_->persona);
			G_IS_VALUE (&_data_->im_addresses_value) ? (g_value_unset (&_data_->im_addresses_value), NULL) : NULL;
			_g_hash_table_unref0 (_data_->details);
			_g_free0 (_data_->im_address_string);
			_g_object_unref0 (_data_->im_addresses);
			_g_free0 (_data_->alias);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp74_ = _data_->_tmp70_;
		_data_->_tmp70_ = NULL;
		_g_object_unref0 (_data_->persona);
		_data_->persona = _data_->_tmp74_;
		_g_object_unref0 (_data_->_tmp70_);
	}
	goto __finally0;
	__catch0_folks_persona_store_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp75_ = stderr;
		_data_->_tmp76_ = _data_->alias;
		_data_->_tmp77_ = _data_->im_address_string;
		_data_->_tmp78_ = _data_->e;
		_data_->_tmp79_ = _data_->_tmp78_->message;
		fprintf (_data_->_tmp75_, _ ("Failed to create new contact for buddy with alias ‘%s’ and IM addresse" \
"s:\n" \
"%s\n" \
"Error: %s\n"), _data_->_tmp76_, _data_->_tmp77_, _data_->_tmp79_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->persona);
		G_IS_VALUE (&_data_->im_addresses_value) ? (g_value_unset (&_data_->im_addresses_value), NULL) : NULL;
		_g_hash_table_unref0 (_data_->details);
		_g_free0 (_data_->im_address_string);
		_g_object_unref0 (_data_->im_addresses);
		_g_free0 (_data_->alias);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->persona);
		G_IS_VALUE (&_data_->im_addresses_value) ? (g_value_unset (&_data_->im_addresses_value), NULL) : NULL;
		_g_hash_table_unref0 (_data_->details);
		_g_free0 (_data_->im_address_string);
		_g_object_unref0 (_data_->im_addresses);
		_g_free0 (_data_->alias);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp81_ = _data_->alias;
	if (_data_->_tmp81_ != NULL) {
		_data_->_tmp82_ = _data_->persona;
		_data_->_tmp80_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp82_, FOLKS_TYPE_ALIAS_DETAILS);
	} else {
		_data_->_tmp80_ = FALSE;
	}
	if (_data_->_tmp80_) {
		_data_->_tmp83_ = _data_->persona;
		_data_->_tmp84_ = _data_->alias;
		folks_alias_details_set_alias (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp83_, FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetails), _data_->_tmp84_);
	}
	_data_->_tmp85_ = stdout;
	_data_->_tmp86_ = _data_->persona;
	_data_->_tmp87_ = folks_persona_get_uid (_data_->_tmp86_);
	_data_->_tmp88_ = _data_->_tmp87_;
	_data_->_tmp89_ = _data_->alias;
	_data_->_tmp90_ = _data_->im_address_string;
	fprintf (_data_->_tmp85_, _ ("Created contact ‘%s’ for buddy with alias ‘%s’ and IM addresses:\n" \
"%s"), _data_->_tmp88_, _data_->_tmp89_, _data_->_tmp90_);
	_data_->_tmp91_ = _data_->self->priv->persona_count;
	_data_->self->priv->persona_count = _data_->_tmp91_ + 1;
	_data_->result = _data_->persona;
	G_IS_VALUE (&_data_->im_addresses_value) ? (g_value_unset (&_data_->im_addresses_value), NULL) : NULL;
	_g_hash_table_unref0 (_data_->details);
	_g_free0 (_data_->im_address_string);
	_g_object_unref0 (_data_->im_addresses);
	_g_free0 (_data_->alias);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
folks_importers_pidgin_blist_protocol_to_tp_protocol (FolksImportersPidgin* self,
                                                      const gchar* blist_protocol)
{
	gchar* tp_protocol = NULL;
	gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (blist_protocol != NULL, NULL);
	_tmp0_ = g_strdup (blist_protocol);
	tp_protocol = _tmp0_;
	if (g_str_has_prefix (blist_protocol, "prpl-")) {
		gchar* _tmp1_;
		_tmp1_ = string_substring (blist_protocol, (glong) 5, (glong) -1);
		_g_free0 (tp_protocol);
		tp_protocol = _tmp1_;
	}
	_tmp2_ = tp_protocol;
	if (g_strcmp0 (_tmp2_, "bonjour") == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("local-xmpp");
		_g_free0 (tp_protocol);
		tp_protocol = _tmp3_;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = tp_protocol;
		if (g_strcmp0 (_tmp4_, "novell") == 0) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("groupwise");
			_g_free0 (tp_protocol);
			tp_protocol = _tmp5_;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = tp_protocol;
			if (g_strcmp0 (_tmp6_, "gg") == 0) {
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("gadugadu");
				_g_free0 (tp_protocol);
				tp_protocol = _tmp7_;
			} else {
				const gchar* _tmp8_;
				_tmp8_ = tp_protocol;
				if (g_strcmp0 (_tmp8_, "meanwhile") == 0) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("sametime");
					_g_free0 (tp_protocol);
					tp_protocol = _tmp9_;
				} else {
					const gchar* _tmp10_;
					_tmp10_ = tp_protocol;
					if (g_strcmp0 (_tmp10_, "simple") == 0) {
						gchar* _tmp11_;
						_tmp11_ = g_strdup ("sip");
						_g_free0 (tp_protocol);
						tp_protocol = _tmp11_;
					}
				}
			}
		}
	}
	result = tp_protocol;
	return result;
}

FolksImportersPidgin*
folks_importers_pidgin_construct (GType object_type)
{
	FolksImportersPidgin * self = NULL;
	self = (FolksImportersPidgin*) folks_importer_construct (object_type);
	return self;
}

FolksImportersPidgin*
folks_importers_pidgin_new (void)
{
	return folks_importers_pidgin_construct (FOLKS_IMPORTERS_TYPE_PIDGIN);
}

static void
folks_importers_pidgin_class_init (FolksImportersPidginClass * klass,
                                   gpointer klass_data)
{
	folks_importers_pidgin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksImportersPidgin_private_offset);
	((FolksImporterClass *) klass)->import = (void (*) (FolksImporter*, FolksPersonaStore*, const gchar*, GAsyncReadyCallback, gpointer)) folks_importers_pidgin_real_import;
	((FolksImporterClass *) klass)->import_finish = (guint (*) (FolksImporter*, GAsyncResult*, GError**)) folks_importers_pidgin_import_finish;
	G_OBJECT_CLASS (klass)->finalize = folks_importers_pidgin_finalize;
}

static void
folks_importers_pidgin_instance_init (FolksImportersPidgin * self,
                                      gpointer klass)
{
	self->priv = folks_importers_pidgin_get_instance_private (self);
	self->priv->persona_count = (guint) 0;
}

static void
folks_importers_pidgin_finalize (GObject * obj)
{
	FolksImportersPidgin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin);
	_g_object_unref0 (self->priv->destination_store);
	G_OBJECT_CLASS (folks_importers_pidgin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
folks_importers_pidgin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksImportersPidginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_importers_pidgin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImportersPidgin), 0, (GInstanceInitFunc) folks_importers_pidgin_instance_init, NULL };
	GType folks_importers_pidgin_type_id;
	folks_importers_pidgin_type_id = g_type_register_static (FOLKS_TYPE_IMPORTER, "FolksImportersPidgin", &g_define_type_info, 0);
	FolksImportersPidgin_private_offset = g_type_add_instance_private (folks_importers_pidgin_type_id, sizeof (FolksImportersPidginPrivate));
	return folks_importers_pidgin_type_id;
}

GType
folks_importers_pidgin_get_type (void)
{
	static volatile gsize folks_importers_pidgin_type_id__once = 0;
	if (g_once_init_enter (&folks_importers_pidgin_type_id__once)) {
		GType folks_importers_pidgin_type_id;
		folks_importers_pidgin_type_id = folks_importers_pidgin_get_type_once ();
		g_once_init_leave (&folks_importers_pidgin_type_id__once, folks_importers_pidgin_type_id);
	}
	return folks_importers_pidgin_type_id__once;
}

