# Commodore 64

a home computer with a synthesizer-grade sound chip of which people took decades to master. three oscillators with four selectable waveforms, ring modulation, oscillator sync, multi-mode filter and ADSR envelope.

very popular in Europe and mostly due to the demoscene, which stretched the machine's limbs to no end.

two versions of aforementioned chip exist - 6581 (original chip) and 8580 (improved version with working waveform mixing and somewhat more consistent filter curves).

# effects

- `10xx`: **change wave.** the following values are accepted:
  - `00`: nothing
  - `01`: triangle
  - `02`: saw
  - `03`: triangle and saw
  - `04`: pulse
  - `05`: pulse and triangle
  - `06`: pulse and saw
  - `07`: pulse and triangle and saw
  - `08`: noise
- `11xx`: **set coarse cutoff.** `xx` may be a value between `00` and `64`.
  - _this effect only exists for compatibility reasons, and its use is discouraged._
  - use effect `4xxx` instead.
- `12xx`: **set coarse duty cycle.** `xx` may be a value between `00` and `64`.
  - _this effect only exists for compatibility reasons, and its use is discouraged._
  - use effect `3xxx` instead.
- `13xx`: **set resonance.** `xx` may be a value between `00` and `0F`.
- `14xx`: **set filter mode.** the following values are accepted:
  - `00`: filter off
  - `01`: low pass
  - `02`: band pass
  - `03`: low+band pass
  - `04`: high pass
  - `05`: band reject/stop/notch
  - `06`: high+band pass
  - `07`: all pass
- `15xx`: **set envelope reset time.**
  - this is the amount of ticks the channel turns off before a note occurs in order to reset the envelope safely.
  - if `xx` is 0 or higher than the song speed, the envelope will not reset.
- `1Axx`: **disable envelope reset for this channel.**
- `1Bxy`: **reset cutoff**:
  - if `x` is not 0: on new note
  - if `y` is not 0: now
  - this effect is not necessary if the instrument's cutoff macro is absolute.
- `1Cxy`: **reset duty cycle**:
  - if `x` is not 0: on new note
  - if `y` is not 0: now
  - this effect is not necessary if the instrument's duty macro is absolute.
- `1Exy`: **change additional parameters.**
  - `x` may be one of the following:
    - `0`: attack (`y` from `0` to `F`)
    - `1`: decay (`y` from `0` to `F`)
    - `2`: sustain (`y` from `0` to `F`)
    - `3`: release (`y` from `0` to `F`)
    - `4`: ring modulation (`y` is `0` or `1`)
    - `5`: oscillator sync (`y` is `0` or `1`)
    - `6`: disable channel 3 (`y` is `0` or `1`)
- `3xxx`: **set duty cycle.** `xxx` range is `000` to `FFF`.
- `4xxx`: **set cutoff.** `xxx` range is `000` to `7FF`.

# info

this chip uses the [C64](../4-instrument/c64.md) instrument editor.
