# Yamaha YM2612

one of two chips that powered the Sega Genesis. it is a six-channel, four-operator FM synthesizer. channel #6 can be turned into 8-bit PCM player, that via software mixing, thanks to Z80 sound CPU, can play more than one channel of straight-shot samples at once. 
as of Furnace 0.6pre5, Furnace offers DualPCM, a Z80 driver that splits channel 6 into two individual PCM channels with variable pitch. using the console's Z80 processor, these are mixed together in software and streamed to channel 6 in PCM mode with a mix rate of 13750 Hz. VGM export requires the "direct stream mode" option to be enabled, and resulting files will be very large.

# effects

- `10xy`: **set LFO parameters.**
  - `x` toggles the LFO.
  - `y` sets its speed.
- `11xx`: **set feedback of channel.**
- `12xx`: **set operator 1 level.**
- `13xx`: **set operator 2 level.**
- `14xx`: **set operator 3 level.**
- `15xx`: **set operator 4 level.**
- `16xy`: **set multiplier of operator.**
  - `x` is the operator (1-4).
  - `y` is the multiplier.
- `17xx`: **toggle LEGACY sample mode.**
  - this only works on channel 6.
  - **this effect exists only for compatibility reasons! its use is NOT recommented. use Sample type instruments instead.**
- `18xx`: **toggle extended channel 3 mode.**
  - 0 disables it and 1 enables it.
  - only in extended channel 3 chip.
- `19xx`: **set attack of all operators.**
- `1Axx`: **set attack of operator 1.**
- `1Bxx`: **set attack of operator 2.**
- `1Cxx`: **set attack of operator 3.**
- `1Dxx`: **set attack of operator 4.**
- `30xx`: **enable envelope hard reset.**
  - this works by inserting a quick release and tiny delay before a new note.
- `50xy`: **set AM of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` determines whether AM is on.
- `51xy`: **set SL of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `52xy`: **set RR of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `53xy`: **set DT of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value:
    - `0`: -3
    - `1`: -2
    - `2`: -1
    - `3`: 0
    - `4`: 1
    - `5`: 2
    - `6`: 3
    - `7`: -0
- `54xy`: **set RS of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `55xy`: **set SSG-EG of operator.**
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value (0-8).
    - values between 0 and 7 set SSG-EG.
    - value 8 disables it.
- `56xx`: **set DR of all operators.**
- `57xx`: **set DR of operator 1.**
- `58xx`: **set DR of operator 2.**
- `59xx`: **set DR of operator 3.**
- `5Axx`: **set DR of operator 4.**
- `5Bxx`: **set D2R/SR of all operators.**
- `5Cxx`: **set D2R/SR of operator 1.**
- `5Dxx`: **set D2R/SR of operator 2.**
- `5Exx`: **set D2R/SR of operator 3.**
- `5Fxx`: **set D2R/SR of operator 4.**

# info

this chip uses the [FM (OPN)](../4-instrument/fm-opn.md) and [Generic Sample](../4-instrument/amiga.md) instrument editors.


## extended channel 3

in ExtCh mode, channel 3 is split into one column for each of its four operators. feedback and LFO levels are shared. the frequency of each operator may be controlled independently with notes and effects. this can be used for more polyphony or more complex sounds.

all four operators are still combined according to the algorithm in use. for example, algorithm 7 acts as four independent sine waves. algorithm 4 acts as two independent 2op sounds. even with algorithm 0, placing a note in any operator triggers that operator alone.

## CSM

CSM is short for "Composite Sinusoidal Modeling". CSM works by sending key-on and key-off commands to channel 3 at a specific frequency, controlled by the added "CSM Timer" channel. this can be used to create vocal formants (speech synthesis!) or other complex effects.

CSM is beyond the scope of this documentation. for more information, see this [brief SSG-EG and CSM video tutorial](https://www.youtube.com/watch?v=IKOR0TUlnWU).

## DualPCM

thanks to the Z80 sound CPU, DualPCM can play two samples at once! this mode splits channel 6 into two individual PCM channels with variable pitch. these are mixed together in software and streamed to channel 6 with a mix rate of 13750 Hz. VGM export requires the "direct stream mode" option to be enabled, and resulting files will be very large.
