/* contacts-contact-pane.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-contact-pane.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include "contacts.h"
#include <folks/folks.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define PROFILE_SIZE 128
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;

#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;

#define CONTACTS_TYPE_CONTACT_EDITOR (contacts_contact_editor_get_type ())
#define CONTACTS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor))
#define CONTACTS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))
#define CONTACTS_IS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_IS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_CONTACT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))

typedef struct _ContactsContactEditor ContactsContactEditor;
typedef struct _ContactsContactEditorClass ContactsContactEditorClass;

#define CONTACTS_TYPE_LINK_SUGGESTION_GRID (contacts_link_suggestion_grid_get_type ())
#define CONTACTS_LINK_SUGGESTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGrid))
#define CONTACTS_LINK_SUGGESTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGridClass))
#define CONTACTS_IS_LINK_SUGGESTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID))
#define CONTACTS_IS_LINK_SUGGESTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_SUGGESTION_GRID))
#define CONTACTS_LINK_SUGGESTION_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_SUGGESTION_GRID, ContactsLinkSuggestionGridClass))

typedef struct _ContactsLinkSuggestionGrid ContactsLinkSuggestionGrid;
typedef struct _ContactsLinkSuggestionGridClass ContactsLinkSuggestionGridClass;
enum  {
	CONTACTS_CONTACT_PANE_0_PROPERTY,
	CONTACTS_CONTACT_PANE_INDIVIDUAL_PROPERTY,
	CONTACTS_CONTACT_PANE_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsContactPaneApplyChangesData ContactsContactPaneApplyChangesData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsContactPaneCreateContactData ContactsContactPaneCreateContactData;
typedef struct _Block16Data Block16Data;
enum  {
	CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL,
	CONTACTS_CONTACT_PANE_DISPLAY_NAME_CHANGED_SIGNAL,
	CONTACTS_CONTACT_PANE_NUM_SIGNALS
};
static guint contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_NUM_SIGNALS] = {0};

struct _ContactsContactPane {
	AdwBin parent_instance;
	ContactsContactPanePrivate * priv;
	gboolean on_edit_mode;
};

struct _ContactsContactPaneClass {
	AdwBinClass parent_class;
};

struct _ContactsContactPanePrivate {
	ContactsMainWindow* main_window;
	ContactsStore* store;
	FolksIndividual* _individual;
	GtkStack* stack;
	AdwClamp* contact_sheet_clamp;
	ContactsContactSheet* sheet;
	GtkBox* contact_editor_box;
	ContactsContactEditor* editor;
	ContactsLinkSuggestionGrid* suggestion_grid;
};

struct _Block15Data {
	int _ref_count_;
	ContactsContactPane* self;
	FolksIndividual* i;
};

struct _ContactsContactPaneApplyChangesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContactPane* self;
	ContactsFakeIndividual* fake_individual;
	FolksIndividual* _tmp0_;
	ContactsFakeIndividual* _tmp1_;
	gboolean _tmp2_;
	ContactsFakeIndividual* _tmp3_;
	ContactsFakeIndividual* _tmp4_;
	FolksIndividual* _tmp5_;
	FolksIndividual* _tmp6_;
	ContactsFakeIndividual* _tmp7_;
	ContactsFakePersona* _tmp8_;
	ContactsFakePersona* _tmp9_;
	ContactsFakeIndividual* _tmp10_;
	ContactsFakeIndividual* _tmp11_;
	FolksIndividual* _tmp12_;
	FolksIndividual* _tmp13_;
};

struct _ContactsContactPaneCreateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContactPane* self;
	ContactsFakePersona* fake_persona;
	GHashTable* details;
	GHashTable* _tmp0_;
	ContactsStore* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* primary_store;
	ContactsStore* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	FolksIndividualAggregator* _tmp8_;
	FolksPersonaStore* _tmp9_;
	FolksPersonaStore* _tmp10_;
	FolksPersonaStore* _tmp11_;
	FolksPersona* persona;
	FolksPersona* _tmp12_;
	FolksPersonaStore* _tmp13_;
	GHashTable* _tmp14_;
	FolksPersona* _tmp15_;
	FolksPersona* _tmp16_;
	GError* e;
	GError* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ContactsMainWindow* _tmp21_;
	FolksIndividual* individual;
	FolksPersona* _tmp22_;
	FolksIndividual* _tmp23_;
	FolksIndividual* _tmp24_;
	FolksIndividual* _tmp25_;
	FolksIndividual* _tmp26_;
	ContactsMainWindow* _tmp27_;
	FolksIndividual* _tmp28_;
	ContactsMainWindow* _tmp29_;
	GError* _inner_error0_;
};

struct _Block16Data {
	int _ref_count_;
	ContactsContactPane* self;
	GtkMessageDialog* dialog;
};

static gint ContactsContactPane_private_offset;
static gpointer contacts_contact_pane_parent_class = NULL;

VALA_EXTERN GType contacts_contact_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactPane, g_object_unref)
VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
VALA_EXTERN GType contacts_contact_sheet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheet, g_object_unref)
VALA_EXTERN GType contacts_contact_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditor, g_object_unref)
VALA_EXTERN GType contacts_link_suggestion_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsLinkSuggestionGrid, g_object_unref)
VALA_EXTERN ContactsContactPane* contacts_contact_pane_new (ContactsMainWindow* main_window,
                                                ContactsStore* contacts_store);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_construct (GType object_type,
                                                      ContactsMainWindow* main_window,
                                                      ContactsStore* contacts_store);
VALA_EXTERN void contacts_contact_pane_add_suggestion (ContactsContactPane* self,
                                           FolksIndividual* i);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void contacts_contact_pane_remove_suggestion_grid (ContactsContactPane* self);
VALA_EXTERN ContactsLinkSuggestionGrid* contacts_link_suggestion_grid_new (FolksIndividual* individual);
VALA_EXTERN ContactsLinkSuggestionGrid* contacts_link_suggestion_grid_construct (GType object_type,
                                                                     FolksIndividual* individual);
static void __lambda47_ (Block15Data* _data15_);
VALA_EXTERN FolksIndividual* contacts_contact_pane_get_individual (ContactsContactPane* self);
static void ___lambda47__contacts_link_suggestion_grid_suggestion_accepted (ContactsLinkSuggestionGrid* _sender,
                                                                     gpointer self);
static void __lambda48_ (Block15Data* _data15_);
static void ___lambda48__contacts_link_suggestion_grid_suggestion_rejected (ContactsLinkSuggestionGrid* _sender,
                                                                     gpointer self);
VALA_EXTERN void contacts_contact_pane_show_contact (ContactsContactPane* self,
                                         FolksIndividual* individual);
VALA_EXTERN void contacts_contact_pane_set_individual (ContactsContactPane* self,
                                           FolksIndividual* value);
static void contacts_contact_pane_show_contact_sheet (ContactsContactPane* self);
static void contacts_contact_pane_remove_contact_sheet (ContactsContactPane* self);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_new (FolksIndividual* individual,
                                                  ContactsStore* store);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_construct (GType object_type,
                                                        FolksIndividual* individual,
                                                        ContactsStore* store);
static void contacts_contact_pane_create_contact_editor (ContactsContactPane* self);
static void contacts_contact_pane_remove_contact_editor (ContactsContactPane* self);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_new (FolksIndividual* individual,
                                                    FolksIndividualAggregator* aggregator);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_construct (GType object_type,
                                                          FolksIndividual* individual,
                                                          FolksIndividualAggregator* aggregator);
static void contacts_contact_pane_start_editing (ContactsContactPane* self);
VALA_EXTERN void contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                         gboolean cancel);
static void contacts_contact_pane_apply_changes (ContactsContactPane* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void contacts_contact_pane_apply_changes_finish (ContactsContactPane* self,
                                                 GAsyncResult* _res_);
static void contacts_contact_pane_apply_changes_data_free (gpointer _data);
static gboolean contacts_contact_pane_apply_changes_co (ContactsContactPaneApplyChangesData* _data_);
VALA_EXTERN void contacts_contact_pane_create_contact (ContactsContactPane* self,
                                           ContactsFakePersona* fake_persona,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void contacts_contact_pane_create_contact_finish (ContactsContactPane* self,
                                                  GAsyncResult* _res_);
static void contacts_contact_pane_apply_changes_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN void contacts_contact_pane_edit_contact (ContactsContactPane* self);
VALA_EXTERN void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void contacts_contact_pane_create_contact_data_free (gpointer _data);
static gboolean contacts_contact_pane_create_contact_co (ContactsContactPaneCreateContactData* _data_);
static void contacts_contact_pane_show_message_dialog (ContactsContactPane* self,
                                                const gchar* message);
static void contacts_contact_pane_create_contact_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN void contacts_main_window_set_shown_contact (ContactsMainWindow* self,
                                             FolksIndividual* i);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda49_ (Block16Data* _data16_,
                  gint _);
static void ___lambda49__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void contacts_contact_pane_finalize (GObject * obj);
static GType contacts_contact_pane_get_type_once (void);
static void _vala_contacts_contact_pane_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_contact_pane_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_contact_pane_get_instance_private (ContactsContactPane* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactPane_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContactsContactPane*
contacts_contact_pane_construct (GType object_type,
                                 ContactsMainWindow* main_window,
                                 ContactsStore* contacts_store)
{
	ContactsContactPane * self = NULL;
	ContactsMainWindow* _tmp0_;
	ContactsStore* _tmp1_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsContactPane*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (main_window);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp0_;
	_tmp1_ = _g_object_ref0 (contacts_store);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp1_;
	return self;
}

ContactsContactPane*
contacts_contact_pane_new (ContactsMainWindow* main_window,
                           ContactsStore* contacts_store)
{
	return contacts_contact_pane_construct (CONTACTS_TYPE_CONTACT_PANE, main_window, contacts_store);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ContactsContactPane* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->i);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda47_ (Block15Data* _data15_)
{
	ContactsContactPane* self;
	gchar* linked_contact = NULL;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeLinkedList* to_link = NULL;
	GeeLinkedList* _tmp4_;
	FolksIndividual* _tmp5_;
	ContactsLinkOperation* operation = NULL;
	ContactsStore* _tmp6_;
	ContactsLinkOperation* _tmp7_;
	self = _data15_->self;
	_tmp0_ = self->priv->_individual;
	_tmp1_ = folks_individual_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	linked_contact = _tmp3_;
	_tmp4_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	to_link = _tmp4_;
	_tmp5_ = self->priv->_individual;
	gee_abstract_collection_add ((GeeAbstractCollection*) to_link, _tmp5_);
	gee_abstract_collection_add ((GeeAbstractCollection*) to_link, _data15_->i);
	_tmp6_ = self->priv->store;
	_tmp7_ = contacts_link_operation_new (_tmp6_, to_link);
	operation = _tmp7_;
	contacts_operation_execute ((ContactsOperation*) operation, NULL, NULL);
	g_signal_emit (self, contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL], 0, NULL, linked_contact, operation);
	contacts_contact_pane_remove_suggestion_grid (self);
	_g_object_unref0 (operation);
	_g_object_unref0 (to_link);
	_g_free0 (linked_contact);
}

static void
___lambda47__contacts_link_suggestion_grid_suggestion_accepted (ContactsLinkSuggestionGrid* _sender,
                                                                gpointer self)
{
	__lambda47_ (self);
}

static void
__lambda48_ (Block15Data* _data15_)
{
	ContactsContactPane* self;
	ContactsStore* _tmp0_;
	FolksIndividual* _tmp1_;
	self = _data15_->self;
	_tmp0_ = self->priv->store;
	_tmp1_ = self->priv->_individual;
	contacts_store_add_no_suggest_link (_tmp0_, _tmp1_, _data15_->i);
	contacts_contact_pane_remove_suggestion_grid (self);
}

static void
___lambda48__contacts_link_suggestion_grid_suggestion_rejected (ContactsLinkSuggestionGrid* _sender,
                                                                gpointer self)
{
	__lambda48_ (self);
}

void
contacts_contact_pane_add_suggestion (ContactsContactPane* self,
                                      FolksIndividual* i)
{
	Block15Data* _data15_;
	FolksIndividual* _tmp0_;
	GtkOverlay* parent_overlay = NULL;
	GtkWidget* _tmp1_;
	ContactsLinkSuggestionGrid* _tmp2_;
	ContactsLinkSuggestionGrid* _tmp3_;
	ContactsLinkSuggestionGrid* _tmp4_;
	ContactsLinkSuggestionGrid* _tmp5_;
	ContactsLinkSuggestionGrid* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (i);
	_g_object_unref0 (_data15_->i);
	_data15_->i = _tmp0_;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
	parent_overlay = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_overlay_get_type ()) ? ((GtkOverlay*) _tmp1_) : NULL;
	contacts_contact_pane_remove_suggestion_grid (self);
	_tmp2_ = contacts_link_suggestion_grid_new (_data15_->i);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->suggestion_grid);
	self->priv->suggestion_grid = _tmp2_;
	_tmp3_ = self->priv->suggestion_grid;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_END);
	_tmp4_ = self->priv->suggestion_grid;
	gtk_overlay_add_overlay (parent_overlay, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->suggestion_grid;
	g_signal_connect_data (_tmp5_, "suggestion-accepted", (GCallback) ___lambda47__contacts_link_suggestion_grid_suggestion_accepted, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp6_ = self->priv->suggestion_grid;
	g_signal_connect_data (_tmp6_, "suggestion-rejected", (GCallback) ___lambda48__contacts_link_suggestion_grid_suggestion_rejected, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

void
contacts_contact_pane_show_contact (ContactsContactPane* self,
                                    FolksIndividual* individual)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ == individual) {
		return;
	}
	contacts_contact_pane_set_individual (self, individual);
	_tmp1_ = self->priv->_individual;
	if (_tmp1_ != NULL) {
		contacts_contact_pane_show_contact_sheet (self);
	} else {
		GtkStack* _tmp2_;
		contacts_contact_pane_remove_contact_sheet (self);
		_tmp2_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp2_, "none-selected-page");
	}
}

static void
contacts_contact_pane_show_contact_sheet (ContactsContactPane* self)
{
	FolksIndividual* _tmp0_;
	ContactsContactSheet* contacts_sheet = NULL;
	FolksIndividual* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsContactSheet* _tmp3_;
	ContactsContactSheet* _tmp4_;
	ContactsContactSheet* _tmp5_;
	AdwClamp* _tmp6_;
	ContactsContactSheet* _tmp7_;
	GtkStack* _tmp8_;
	GeeMap* matches = NULL;
	ContactsStore* _tmp9_;
	FolksIndividualAggregator* _tmp10_;
	FolksIndividualAggregator* _tmp11_;
	FolksIndividual* _tmp12_;
	GeeMap* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual;
	g_return_if_fail (_tmp0_ != NULL);
	contacts_contact_pane_remove_contact_sheet (self);
	_tmp1_ = self->priv->_individual;
	_tmp2_ = self->priv->store;
	_tmp3_ = contacts_contact_sheet_new (_tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	contacts_sheet = _tmp3_;
	_tmp4_ = contacts_sheet;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = contacts_sheet;
	self->priv->sheet = _tmp5_;
	_tmp6_ = self->priv->contact_sheet_clamp;
	_tmp7_ = self->priv->sheet;
	adw_clamp_set_child (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp8_, "contact-sheet-page");
	_tmp9_ = self->priv->store;
	_tmp10_ = contacts_store_get_aggregator (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_individual;
	_tmp13_ = folks_individual_aggregator_get_potential_matches (_tmp11_, _tmp12_, FOLKS_MATCH_RESULT_HIGH);
	matches = _tmp13_;
	{
		GeeIterator* _i_it = NULL;
		GeeMap* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_;
		GeeIterator* _tmp19_;
		_tmp14_ = matches;
		_tmp15_ = gee_map_get_keys (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_i_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp21_;
			gpointer _tmp22_;
			gboolean _tmp23_ = FALSE;
			FolksIndividual* _tmp24_;
			_tmp20_ = _i_it;
			if (!gee_iterator_next (_tmp20_)) {
				break;
			}
			_tmp21_ = _i_it;
			_tmp22_ = gee_iterator_get (_tmp21_);
			i = (FolksIndividual*) _tmp22_;
			_tmp24_ = i;
			if (_tmp24_ != NULL) {
				ContactsStore* _tmp25_;
				FolksIndividual* _tmp26_;
				FolksIndividual* _tmp27_;
				_tmp25_ = self->priv->store;
				_tmp26_ = self->priv->_individual;
				_tmp27_ = i;
				_tmp23_ = contacts_utils_suggest_link_to (_tmp25_, _tmp26_, _tmp27_);
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				FolksIndividual* _tmp28_;
				_tmp28_ = i;
				contacts_contact_pane_add_suggestion (self, _tmp28_);
				_g_object_unref0 (i);
				break;
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_g_object_unref0 (matches);
	_g_object_unref0 (contacts_sheet);
}

static void
contacts_contact_pane_remove_contact_sheet (ContactsContactPane* self)
{
	ContactsContactSheet* _tmp0_;
	AdwClamp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sheet;
	if (_tmp0_ == NULL) {
		return;
	}
	contacts_contact_pane_remove_suggestion_grid (self);
	_tmp1_ = self->priv->contact_sheet_clamp;
	adw_clamp_set_child (_tmp1_, NULL);
	self->priv->sheet = NULL;
}

static void
contacts_contact_pane_create_contact_editor (ContactsContactPane* self)
{
	ContactsContactEditor* contact_editor = NULL;
	FolksIndividual* _tmp0_;
	ContactsStore* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	ContactsContactEditor* _tmp4_;
	GtkBox* _tmp5_;
	ContactsContactEditor* _tmp6_;
	g_return_if_fail (self != NULL);
	contacts_contact_pane_remove_contact_editor (self);
	_tmp0_ = self->priv->_individual;
	_tmp1_ = self->priv->store;
	_tmp2_ = contacts_store_get_aggregator (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_contact_editor_new (_tmp0_, _tmp3_);
	g_object_ref_sink (_tmp4_);
	contact_editor = _tmp4_;
	self->priv->editor = contact_editor;
	_tmp5_ = self->priv->contact_editor_box;
	_tmp6_ = self->priv->editor;
	gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (contact_editor);
}

static void
contacts_contact_pane_remove_contact_editor (ContactsContactPane* self)
{
	ContactsContactEditor* _tmp0_;
	GtkBox* _tmp1_;
	ContactsContactEditor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->editor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->contact_editor_box;
	_tmp2_ = self->priv->editor;
	gtk_box_remove (_tmp1_, (GtkWidget*) _tmp2_);
	self->priv->editor = NULL;
}

static void
contacts_contact_pane_start_editing (ContactsContactPane* self)
{
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->on_edit_mode) {
		_tmp0_ = TRUE;
	} else {
		FolksIndividual* _tmp1_;
		_tmp1_ = self->priv->_individual;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	self->on_edit_mode = TRUE;
	contacts_contact_pane_create_contact_editor (self);
	_tmp2_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp2_, "contact-editor-page");
}

void
contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                    gboolean cancel)
{
	g_return_if_fail (self != NULL);
	if (!self->on_edit_mode) {
		return;
	}
	self->on_edit_mode = FALSE;
	contacts_contact_pane_remove_contact_editor (self);
	if (cancel) {
		ContactsFakeIndividual* fake_individual = NULL;
		FolksIndividual* _tmp0_;
		ContactsFakeIndividual* _tmp1_;
		gboolean _tmp2_ = FALSE;
		ContactsFakeIndividual* _tmp3_;
		_tmp0_ = self->priv->_individual;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_FAKE_INDIVIDUAL) ? ((ContactsFakeIndividual*) _tmp0_) : NULL);
		fake_individual = _tmp1_;
		_tmp3_ = fake_individual;
		if (_tmp3_ != NULL) {
			ContactsFakeIndividual* _tmp4_;
			FolksIndividual* _tmp5_;
			FolksIndividual* _tmp6_;
			_tmp4_ = fake_individual;
			_tmp5_ = contacts_fake_individual_get_real_individual (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp2_ = _tmp6_ != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ContactsFakeIndividual* _tmp7_;
			FolksIndividual* _tmp8_;
			FolksIndividual* _tmp9_;
			GtkStack* _tmp10_;
			_tmp7_ = fake_individual;
			_tmp8_ = contacts_fake_individual_get_real_individual (_tmp7_);
			_tmp9_ = _tmp8_;
			contacts_contact_pane_set_individual (self, _tmp9_);
			_tmp10_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp10_, "contact-sheet-page");
		} else {
			GtkStack* _tmp11_;
			_tmp11_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp11_, "none-selected-page");
		}
		_g_object_unref0 (fake_individual);
		return;
	}
	contacts_contact_pane_apply_changes (self, NULL, NULL);
}

static void
contacts_contact_pane_apply_changes_data_free (gpointer _data)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactPaneApplyChangesData, _data_);
}

static void
contacts_contact_pane_apply_changes (ContactsContactPane* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ContactsContactPaneApplyChangesData* _data_;
	ContactsContactPane* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsContactPaneApplyChangesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_pane_apply_changes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_contact_pane_apply_changes_co (_data_);
}

static void
contacts_contact_pane_apply_changes_finish (ContactsContactPane* self,
                                            GAsyncResult* _res_)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_contact_pane_apply_changes_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsContactPaneApplyChangesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_pane_apply_changes_co (_data_);
}

static gboolean
contacts_contact_pane_apply_changes_co (ContactsContactPaneApplyChangesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	contacts_contact_pane_show_contact_sheet (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->_individual;
	_data_->_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, CONTACTS_TYPE_FAKE_INDIVIDUAL) ? ((ContactsFakeIndividual*) _data_->_tmp0_) : NULL);
	_data_->fake_individual = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->fake_individual;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->fake_individual;
		_data_->_tmp5_ = contacts_fake_individual_get_real_individual (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp2_ = _data_->_tmp6_ == NULL;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp7_ = _data_->fake_individual;
		_data_->_tmp8_ = contacts_fake_individual_get_primary_persona (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_state_ = 1;
		contacts_contact_pane_create_contact (_data_->self, _data_->_tmp9_, contacts_contact_pane_apply_changes_ready, _data_);
		return FALSE;
		_state_1:
		contacts_contact_pane_create_contact_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp10_ = _data_->fake_individual;
		_data_->_state_ = 2;
		contacts_fake_individual_apply_changes_to_real (_data_->_tmp10_, contacts_contact_pane_apply_changes_ready, _data_);
		return FALSE;
		_state_2:
		contacts_fake_individual_apply_changes_to_real_finish (_data_->_tmp10_, _data_->_res_);
		_data_->_tmp11_ = _data_->fake_individual;
		_data_->_tmp12_ = contacts_fake_individual_get_real_individual (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		contacts_contact_pane_set_individual (_data_->self, _data_->_tmp13_);
	}
	contacts_contact_pane_show_contact_sheet (_data_->self);
	_g_object_unref0 (_data_->fake_individual);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
contacts_contact_pane_edit_contact (ContactsContactPane* self)
{
	FolksIndividual* _tmp0_;
	ContactsFakeIndividual* _tmp1_;
	ContactsFakeIndividual* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual;
	_tmp1_ = contacts_fake_individual_new_from_real (_tmp0_);
	_tmp2_ = _tmp1_;
	contacts_contact_pane_set_individual (self, (FolksIndividual*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	contacts_contact_pane_start_editing (self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
contacts_contact_pane_new_contact (ContactsContactPane* self)
{
	GHashTable* details = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar** writeable_properties = NULL;
	gint writeable_properties_length1 = 0;
	gint _writeable_properties_size_ = 0;
	ContactsStore* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksPersonaStore* _tmp6_;
	FolksPersonaStore* _tmp7_;
	ContactsFakePersona* fake_persona = NULL;
	ContactsFakePersonaStore* _tmp18_;
	ContactsFakePersonaStore* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GHashTable* _tmp21_;
	ContactsFakePersona* _tmp22_;
	ContactsFakePersona* _tmp23_;
	GeeHashSet* fake_personas = NULL;
	GeeHashSet* _tmp24_;
	ContactsFakeIndividual* _tmp25_;
	ContactsFakeIndividual* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_GValue_free0_);
	details = _tmp2_;
	_tmp3_ = self->priv->store;
	_tmp4_ = contacts_store_get_aggregator (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_individual_aggregator_get_primary_store (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ContactsStore* _tmp8_;
		FolksIndividualAggregator* _tmp9_;
		FolksIndividualAggregator* _tmp10_;
		FolksPersonaStore* _tmp11_;
		FolksPersonaStore* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_ = 0;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp16_;
		gint _tmp16__length1;
		_tmp8_ = self->priv->store;
		_tmp9_ = contacts_store_get_aggregator (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = folks_individual_aggregator_get_primary_store (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = folks_persona_store_get_always_writeable_properties (_tmp12_, &_tmp14_);
		_tmp13__length1 = _tmp14_;
		_tmp15_ = _tmp13_;
		_tmp15__length1 = _tmp13__length1;
		_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup1 (_tmp15_, _tmp15__length1) : _tmp15_;
		_tmp16__length1 = _tmp15__length1;
		writeable_properties = (_vala_array_free (writeable_properties, writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		writeable_properties = _tmp16_;
		writeable_properties_length1 = _tmp16__length1;
		_writeable_properties_size_ = writeable_properties_length1;
	} else {
		gchar** _tmp17_;
		_tmp17_ = g_new0 (gchar*, 0 + 1);
		writeable_properties = (_vala_array_free (writeable_properties, writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		writeable_properties = _tmp17_;
		writeable_properties_length1 = 0;
		_writeable_properties_size_ = writeable_properties_length1;
	}
	_tmp18_ = contacts_fake_persona_store_the_store ();
	_tmp19_ = _tmp18_;
	_tmp20_ = writeable_properties;
	_tmp20__length1 = writeable_properties_length1;
	_tmp21_ = details;
	_tmp22_ = contacts_fake_persona_new ((FolksPersonaStore*) _tmp19_, _tmp20_, _tmp20__length1, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp19_);
	fake_persona = _tmp23_;
	_tmp24_ = gee_hash_set_new (CONTACTS_TYPE_FAKE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	fake_personas = _tmp24_;
	gee_abstract_collection_add ((GeeAbstractCollection*) fake_personas, fake_persona);
	_tmp25_ = contacts_fake_individual_new ((GeeSet*) fake_personas);
	_tmp26_ = _tmp25_;
	contacts_contact_pane_set_individual (self, (FolksIndividual*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	contacts_contact_pane_start_editing (self);
	_g_object_unref0 (fake_personas);
	_g_object_unref0 (fake_persona);
	writeable_properties = (_vala_array_free (writeable_properties, writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (details);
}

static void
contacts_contact_pane_create_contact_data_free (gpointer _data)
{
	ContactsContactPaneCreateContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->fake_persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactPaneCreateContactData, _data_);
}

void
contacts_contact_pane_create_contact (ContactsContactPane* self,
                                      ContactsFakePersona* fake_persona,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ContactsContactPaneCreateContactData* _data_;
	ContactsContactPane* _tmp0_;
	ContactsFakePersona* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fake_persona != NULL);
	_data_ = g_slice_new0 (ContactsContactPaneCreateContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_pane_create_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (fake_persona);
	_g_object_unref0 (_data_->fake_persona);
	_data_->fake_persona = _tmp1_;
	contacts_contact_pane_create_contact_co (_data_);
}

void
contacts_contact_pane_create_contact_finish (ContactsContactPane* self,
                                             GAsyncResult* _res_)
{
	ContactsContactPaneCreateContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_contact_pane_create_contact_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	ContactsContactPaneCreateContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_pane_create_contact_co (_data_);
}

static gboolean
contacts_contact_pane_create_contact_co (ContactsContactPaneCreateContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_fake_persona_get_details (_data_->fake_persona);
	_data_->details = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->store;
	_data_->_tmp2_ = contacts_store_get_aggregator (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = folks_individual_aggregator_get_primary_store (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	if (_data_->_tmp5_ == NULL) {
		contacts_contact_pane_show_message_dialog (_data_->self, _ ("No primary addressbook configured"));
		_g_hash_table_unref0 (_data_->details);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->store;
	_data_->_tmp7_ = contacts_store_get_aggregator (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = folks_individual_aggregator_get_primary_store (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
	_data_->primary_store = _data_->_tmp11_;
	_data_->persona = NULL;
	{
		_data_->_tmp13_ = _data_->primary_store;
		_data_->_tmp14_ = _data_->details;
		_data_->_state_ = 1;
		folks_persona_store_add_persona_from_details (_data_->_tmp13_, _data_->_tmp14_, contacts_contact_pane_create_contact_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp15_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->_tmp12_;
		_data_->_tmp12_ = NULL;
		_g_object_unref0 (_data_->persona);
		_data_->persona = _data_->_tmp16_;
		_g_object_unref0 (_data_->_tmp12_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		_data_->_tmp19_ = g_strdup_printf (_ ("Unable to create new contacts: %s"), _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		contacts_contact_pane_show_message_dialog (_data_->self, _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
		_data_->_tmp21_ = _data_->self->priv->main_window;
		contacts_main_window_set_shown_contact (_data_->_tmp21_, NULL);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->persona);
		_g_object_unref0 (_data_->primary_store);
		_g_hash_table_unref0 (_data_->details);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->persona);
		_g_object_unref0 (_data_->primary_store);
		_g_hash_table_unref0 (_data_->details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = _data_->persona;
	_data_->_tmp23_ = folks_persona_get_individual (_data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = _g_object_ref0 (_data_->_tmp24_);
	_data_->individual = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->individual;
	if (_data_->_tmp26_ != NULL) {
		_data_->_tmp27_ = _data_->self->priv->main_window;
		_data_->_tmp28_ = _data_->individual;
		contacts_main_window_set_shown_contact (_data_->_tmp27_, _data_->_tmp28_);
	} else {
		contacts_contact_pane_show_message_dialog (_data_->self, _ ("Unable to find newly created contact"));
		_data_->_tmp29_ = _data_->self->priv->main_window;
		contacts_main_window_set_shown_contact (_data_->_tmp29_, NULL);
	}
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->primary_store);
	_g_hash_table_unref0 (_data_->details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ContactsContactPane* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda49_ (Block16Data* _data16_,
             gint _)
{
	ContactsContactPane* self;
	self = _data16_->self;
	g_signal_emit_by_name ((GtkDialog*) _data16_->dialog, "close");
}

static void
___lambda49__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda49_ (self, response_id);
}

static void
contacts_contact_pane_show_message_dialog (ContactsContactPane* self,
                                           const gchar* message)
{
	Block16Data* _data16_;
	ContactsMainWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", message);
	g_object_ref_sink (_tmp1_);
	_data16_->dialog = _tmp1_;
	g_signal_connect_data ((GtkDialog*) _data16_->dialog, "response", (GCallback) ___lambda49__gtk_dialog_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data16_->dialog);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static void
contacts_contact_pane_remove_suggestion_grid (ContactsContactPane* self)
{
	ContactsLinkSuggestionGrid* _tmp0_;
	GtkOverlay* parent_overlay = NULL;
	GtkWidget* _tmp1_;
	GtkOverlay* _tmp2_;
	ContactsLinkSuggestionGrid* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->suggestion_grid;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) self);
	parent_overlay = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_overlay_get_type ()) ? ((GtkOverlay*) _tmp1_) : NULL;
	_tmp2_ = parent_overlay;
	_tmp3_ = self->priv->suggestion_grid;
	gtk_overlay_remove_overlay (_tmp2_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (self->priv->suggestion_grid);
	self->priv->suggestion_grid = NULL;
}

FolksIndividual*
contacts_contact_pane_get_individual (ContactsContactPane* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

void
contacts_contact_pane_set_individual (ContactsContactPane* self,
                                      FolksIndividual* value)
{
	FolksIndividual* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_pane_get_individual (self);
	if (old_value != value) {
		FolksIndividual* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_individual);
		self->priv->_individual = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_INDIVIDUAL_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_OBJECT) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_object (param_values + 3), data2);
}

static void
contacts_contact_pane_class_init (ContactsContactPaneClass * klass,
                                  gpointer klass_data)
{
	contacts_contact_pane_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactPane_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_pane_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_pane_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_pane_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_PANE_INDIVIDUAL_PROPERTY, contacts_contact_pane_properties[CONTACTS_CONTACT_PANE_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-contact-pane.ui");
	contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_CONTACTS_LINKED_SIGNAL] = g_signal_new ("contacts-linked", CONTACTS_TYPE_CONTACT_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_OBJECT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, CONTACTS_TYPE_LINK_OPERATION);
	/**
	   * Passes the changed display name to all listeners after edit mode has been completed.
	   */
	contacts_contact_pane_signals[CONTACTS_CONTACT_PANE_DISPLAY_NAME_CHANGED_SIGNAL] = g_signal_new ("display-name-changed", CONTACTS_TYPE_CONTACT_PANE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_sheet_clamp", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, contact_sheet_clamp));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_editor_box", FALSE, ContactsContactPane_private_offset + G_STRUCT_OFFSET (ContactsContactPanePrivate, contact_editor_box));
}

static void
contacts_contact_pane_instance_init (ContactsContactPane * self,
                                     gpointer klass)
{
	self->priv = contacts_contact_pane_get_instance_private (self);
	self->priv->_individual = NULL;
	self->priv->sheet = NULL;
	self->priv->editor = NULL;
	self->on_edit_mode = FALSE;
	self->priv->suggestion_grid = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_contact_pane_finalize (GObject * obj)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->_individual);
	_g_object_unref0 (self->priv->suggestion_grid);
	G_OBJECT_CLASS (contacts_contact_pane_parent_class)->finalize (obj);
}

/**
 * The ContactPage is the right pane. It consists of 3 possible pages:
 * a page if nothing is selected, a ContactSheet to view contact information,
 * and a ContactEditor to edit contact information.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_pane_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactPaneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_pane_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactPane), 0, (GInstanceInitFunc) contacts_contact_pane_instance_init, NULL };
	GType contacts_contact_pane_type_id;
	contacts_contact_pane_type_id = g_type_register_static (adw_bin_get_type (), "ContactsContactPane", &g_define_type_info, 0);
	ContactsContactPane_private_offset = g_type_add_instance_private (contacts_contact_pane_type_id, sizeof (ContactsContactPanePrivate));
	return contacts_contact_pane_type_id;
}

GType
contacts_contact_pane_get_type (void)
{
	static volatile gsize contacts_contact_pane_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_pane_type_id__once)) {
		GType contacts_contact_pane_type_id;
		contacts_contact_pane_type_id = contacts_contact_pane_get_type_once ();
		g_once_init_leave (&contacts_contact_pane_type_id__once, contacts_contact_pane_type_id);
	}
	return contacts_contact_pane_type_id__once;
}

static void
_vala_contacts_contact_pane_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	switch (property_id) {
		case CONTACTS_CONTACT_PANE_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, contacts_contact_pane_get_individual (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_pane_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactPane * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane);
	switch (property_id) {
		case CONTACTS_CONTACT_PANE_INDIVIDUAL_PROPERTY:
		contacts_contact_pane_set_individual (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

