/* contacts-utils.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contacts.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>
#include <glib/gi18n-lib.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _ContactsUtilsSetIndividualPropertyData ContactsUtilsSetIndividualPropertyData;
typedef struct _ContactsUtilsSetPersonaPropertyData ContactsUtilsSetPersonaPropertyData;

#define CONTACTS_UTILS_TYPE_PROPERTY_DISPLAY_INFO (contacts_utils_property_display_info_get_type ())
typedef struct _ContactsUtilsPropertyDisplayInfo ContactsUtilsPropertyDisplayInfo;

struct _Block2Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _ContactsUtilsSetIndividualPropertyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksIndividual* individual;
	gchar* property_name;
	GValue value;
	FolksPersona** personas_copy;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint personas_copy_length1;
	gint _personas_copy_size_;
	FolksPersona** _tmp4_;
	gint _tmp4__length1;
	FolksPersona** p_collection;
	gint p_collection_length1;
	gint _p_collection_size_;
	gint p_it;
	FolksPersona* _tmp5_;
	FolksPersona* p;
	FolksPersona* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	FolksPersona* _tmp10_;
	GValue _tmp11_;
	GError* _inner_error0_;
};

struct _ContactsUtilsSetPersonaPropertyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPersona* persona;
	gchar* property_name;
	GValue new_value;
	const gchar* _tmp0_;
	GQuark _tmp2_;
	GValue _tmp3_;
	GValue _tmp4_;
	GValue _tmp5_;
	GValue _tmp6_;
	GValue _tmp7_;
	GValue _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_;
	GValue _tmp11_;
	GValue _tmp12_;
	GValue _tmp13_;
	GValue _tmp14_;
	GValue _tmp15_;
	GValue _tmp16_;
	GValue _tmp17_;
	GValue _tmp18_;
	GValue _tmp19_;
	GValue _tmp20_;
	GValue _tmp21_;
	GError* _inner_error0_;
};

struct _ContactsUtilsPropertyDisplayInfo {
	gchar* property_name;
	gchar* display_name;
	gchar* icon_name;
};

static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (FolksPersonaStore** * array,
                       gint* length,
                       gint* size,
                       FolksPersonaStore* value);
static void _vala_array_add3 (FolksPersonaStore** * array,
                       gint* length,
                       gint* size,
                       FolksPersonaStore* value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda19_ (Block2Data* _data2_);
static void ___lambda19__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN gboolean contacts_utils_non_linkable (FolksIndividual* individual);
VALA_EXTERN gboolean contacts_utils_has_mainable_persona (FolksIndividual* individual);
VALA_EXTERN gboolean contacts_utils_has_pref (FolksAbstractFieldDetails* details);
VALA_EXTERN ContactsTypeSet* contacts_utils_select_typeset_from_fielddetails (FolksAbstractFieldDetails* a);
static gint _contacts_utils_compare_fields_gcompare_data_func (gconstpointer a,
                                                        gconstpointer b,
                                                        gpointer self);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gint __lambda20_ (GObject* a,
                  GObject* b);
VALA_EXTERN gboolean contacts_utils_persona_is_google (FolksPersona* persona);
static gint ___lambda20__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void contacts_utils_set_individual_property_data_free (gpointer _data);
static gboolean contacts_utils_set_individual_property_co (ContactsUtilsSetIndividualPropertyData* _data_);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void contacts_utils_set_individual_property_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void contacts_utils_set_persona_property_data_free (gpointer _data);
static gboolean contacts_utils_set_persona_property_co (ContactsUtilsSetPersonaPropertyData* _data_);
static void contacts_utils_set_persona_property_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN GType contacts_utils_property_display_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContactsUtilsPropertyDisplayInfo* contacts_utils_property_display_info_dup (const ContactsUtilsPropertyDisplayInfo* self);
VALA_EXTERN void contacts_utils_property_display_info_free (ContactsUtilsPropertyDisplayInfo* self);
VALA_EXTERN void contacts_utils_property_display_info_copy (const ContactsUtilsPropertyDisplayInfo* self,
                                                ContactsUtilsPropertyDisplayInfo* dest);
VALA_EXTERN void contacts_utils_property_display_info_destroy (ContactsUtilsPropertyDisplayInfo* self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const ContactsUtilsPropertyDisplayInfo CONTACTS_UTILS_display_infos[19] = {{"alias", N_ ("Alias"), NULL}, {"avatar", N_ ("Avatar"), "emblem-photos-symbolic"}, {"birthday", N_ ("Birthday"), "birthday-symbolic"}, {"calendar-event-id", N_ ("Calendar event"), "calendar-symbolic"}, {"email-addresses", N_ ("Email address"), "mail-unread-symbolic"}, {"full-name", N_ ("Full name"), NULL}, {"gender", N_ ("Gender"), NULL}, {"groups", N_ ("Group"), NULL}, {"im-addresses", N_ ("Instant messaging"), "chat-symbolic"}, {"is-favourite", N_ ("Favourite"), "emblem-favorite-symbolic"}, {"local-ids", N_ ("Local ID"), NULL}, {"nickname", N_ ("Nickname"), "avatar-default-symbolic"}, {"notes", N_ ("Note"), "note-symbolic"}, {"phone-numbers", N_ ("Phone number"), "phone-symbolic"}, {"postal-addresses", N_ ("Address"), "mark-location-symbolic"}, {"roles", N_ ("Role"), "building-symbolic"}, {"structured-name", N_ ("Structured name"), "avatar-default-symbolic"}, {"urls", N_ ("Website"), "website-symbolic"}, {"web-service-addresses", N_ ("Web service"), NULL}};

gboolean
contacts_is_set (const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (str != NULL) {
		_tmp0_ = g_strcmp0 (str, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
contacts_add_separator (GtkListBoxRow* row,
                        GtkListBoxRow* before_row)
{
	GtkSeparator* _tmp0_;
	GtkSeparator* _tmp1_;
	g_return_if_fail (row != NULL);
	_tmp0_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

void
contacts_utils_compose_mail (const gchar* email)
{
	gchar* mailto_uri = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (email != NULL);
	_tmp0_ = g_uri_escape_string (email, "@", FALSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("mailto:", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	mailto_uri = _tmp3_;
	gtk_show_uri (NULL, mailto_uri, (guint32) 0);
	_g_free0 (mailto_uri);
}

gpointer
contacts_utils_get_first (GType t_type,
                          GBoxedCopyFunc t_dup_func,
                          GDestroyNotify t_destroy_func,
                          GeeCollection* collection)
{
	GeeIterator* i = NULL;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer result;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
	i = _tmp0_;
	_tmp1_ = i;
	if (gee_iterator_next (_tmp1_)) {
		GeeIterator* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = i;
		_tmp3_ = gee_iterator_get (_tmp2_);
		result = _tmp3_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}

void
contacts_utils_grab_entry_focus_no_select (GtkSearchEntry* entry)
{
	gint start = 0;
	gint end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	g_return_if_fail (entry != NULL);
	_tmp2_ = gtk_editable_get_selection_bounds ((GtkEditable*) entry, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	if (!_tmp2_) {
		end = gtk_editable_get_position ((GtkEditable*) entry);
		start = end;
	}
	gtk_widget_grab_focus ((GtkWidget*) entry);
	gtk_editable_select_region ((GtkEditable*) entry, start, end);
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
contacts_utils_get_stock_avatars (gint* result_length1)
{
	gchar** files = NULL;
	gchar** _tmp0_;
	gint files_length1;
	gint _files_size_;
	gchar** system_data_dirs = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup4 (_tmp2_, _vala_array_length (_tmp1_)) : _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	system_data_dirs = _tmp3_;
	system_data_dirs_length1 = _tmp3__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	_tmp4_ = system_data_dirs;
	_tmp4__length1 = system_data_dirs_length1;
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp4_;
		data_dir_collection_length1 = _tmp4__length1;
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			gchar* _tmp5_;
			gchar* data_dir = NULL;
			_tmp5_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp5_;
			{
				gchar* path = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GDir* dir = NULL;
				GDir* _tmp15_;
				_tmp6_ = data_dir;
				_tmp7_ = g_build_filename (_tmp6_, "pixmaps", "faces", NULL);
				path = _tmp7_;
				dir = NULL;
				{
					GDir* _tmp8_ = NULL;
					const gchar* _tmp9_;
					GDir* _tmp10_;
					GDir* _tmp11_;
					_tmp9_ = path;
					_tmp10_ = g_dir_open (_tmp9_, (guint) 0, &_inner_error0_);
					_tmp8_ = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp11_ = _tmp8_;
					_tmp8_ = NULL;
					_g_dir_close0 (dir);
					dir = _tmp11_;
					_g_dir_close0 (_tmp8_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp12_;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp12_ = path;
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_debug ("contacts-utils.vala:97: Couldn't open stock avatars folder \"%s\": %s", _tmp12_, _tmp14_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (data_dir);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp15_ = dir;
				if (_tmp15_ != NULL) {
					gchar* face = NULL;
					while (TRUE) {
						GDir* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* filename = NULL;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp16_ = dir;
						_tmp17_ = g_dir_read_name (_tmp16_);
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (face);
						face = _tmp18_;
						_tmp19_ = face;
						if (!(_tmp19_ != NULL)) {
							break;
						}
						_tmp20_ = path;
						_tmp21_ = face;
						_tmp22_ = g_build_filename (_tmp20_, _tmp21_, NULL);
						filename = _tmp22_;
						_tmp23_ = filename;
						_tmp24_ = g_strdup (_tmp23_);
						_vala_array_add1 (&files, &files_length1, &_files_size_, _tmp24_);
						_g_free0 (filename);
					}
					_g_free0 (face);
				}
				_g_dir_close0 (dir);
				_g_free0 (path);
				_g_free0 (data_dir);
			}
		}
	}
	_tmp25_ = files;
	_tmp25__length1 = files_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add2 (FolksPersonaStore** * array,
                  gint* length,
                  gint* size,
                  FolksPersonaStore* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

FolksPersonaStore**
contacts_utils_get_eds_address_books (ContactsStore* contacts_store,
                                      gint* result_length1)
{
	FolksPersonaStore** stores = NULL;
	FolksPersonaStore** _tmp0_;
	gint stores_length1;
	gint _stores_size_;
	FolksPersonaStore** _tmp29_;
	gint _tmp29__length1;
	FolksPersonaStore** result;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	_tmp0_ = g_new0 (FolksPersonaStore*, 0 + 1);
	stores = _tmp0_;
	stores_length1 = 0;
	_stores_size_ = stores_length1;
	{
		GeeIterator* _backend_it = NULL;
		FolksBackendStore* _tmp1_;
		FolksBackendStore* _tmp2_;
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp1_ = contacts_store_get_backend_store (contacts_store);
		_tmp2_ = _tmp1_;
		_tmp3_ = folks_backend_store_get_enabled_backends (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_map_get_values (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_backend_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			_tmp10_ = _backend_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _backend_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			backend = (FolksBackend*) _tmp12_;
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp13_;
				GeeMap* _tmp14_;
				GeeMap* _tmp15_;
				GeeCollection* _tmp16_;
				GeeCollection* _tmp17_;
				GeeCollection* _tmp18_;
				GeeIterator* _tmp19_;
				GeeIterator* _tmp20_;
				_tmp13_ = backend;
				_tmp14_ = folks_backend_get_persona_stores (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = gee_map_get_values (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_g_object_unref0 (_tmp18_);
				_persona_store_it = _tmp20_;
				while (TRUE) {
					GeeIterator* _tmp21_;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp22_;
					gpointer _tmp23_;
					FolksPersonaStore* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					_tmp21_ = _persona_store_it;
					if (!gee_iterator_next (_tmp21_)) {
						break;
					}
					_tmp22_ = _persona_store_it;
					_tmp23_ = gee_iterator_get (_tmp22_);
					persona_store = (FolksPersonaStore*) _tmp23_;
					_tmp24_ = persona_store;
					_tmp25_ = folks_persona_store_get_type_id (_tmp24_);
					_tmp26_ = _tmp25_;
					if (g_strcmp0 (_tmp26_, "eds") == 0) {
						FolksPersonaStore* _tmp27_;
						FolksPersonaStore* _tmp28_;
						_tmp27_ = persona_store;
						_tmp28_ = _g_object_ref0 (_tmp27_);
						_vala_array_add2 (&stores, &stores_length1, &_stores_size_, _tmp28_);
					}
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp29_ = stores;
	_tmp29__length1 = stores_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	return result;
}

static void
_vala_array_add3 (FolksPersonaStore** * array,
                  gint* length,
                  gint* size,
                  FolksPersonaStore* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

FolksPersonaStore**
contacts_utils_get_eds_address_books_from_backend (FolksBackendStore* backend_store,
                                                   gint* result_length1)
{
	FolksPersonaStore** stores = NULL;
	FolksPersonaStore** _tmp0_;
	gint stores_length1;
	gint _stores_size_;
	FolksPersonaStore** _tmp27_;
	gint _tmp27__length1;
	FolksPersonaStore** result;
	g_return_val_if_fail (backend_store != NULL, NULL);
	_tmp0_ = g_new0 (FolksPersonaStore*, 0 + 1);
	stores = _tmp0_;
	stores_length1 = 0;
	_stores_size_ = stores_length1;
	{
		GeeIterator* _backend_it = NULL;
		GeeMap* _tmp1_;
		GeeMap* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = folks_backend_store_get_enabled_backends (backend_store);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_map_get_values (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_backend_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			_tmp8_ = _backend_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _backend_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			backend = (FolksBackend*) _tmp10_;
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp11_;
				GeeMap* _tmp12_;
				GeeMap* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				GeeIterator* _tmp17_;
				GeeIterator* _tmp18_;
				_tmp11_ = backend;
				_tmp12_ = folks_backend_get_persona_stores (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = gee_map_get_values (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp16_);
				_persona_store_it = _tmp18_;
				while (TRUE) {
					GeeIterator* _tmp19_;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp20_;
					gpointer _tmp21_;
					FolksPersonaStore* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp19_ = _persona_store_it;
					if (!gee_iterator_next (_tmp19_)) {
						break;
					}
					_tmp20_ = _persona_store_it;
					_tmp21_ = gee_iterator_get (_tmp20_);
					persona_store = (FolksPersonaStore*) _tmp21_;
					_tmp22_ = persona_store;
					_tmp23_ = folks_persona_store_get_type_id (_tmp22_);
					_tmp24_ = _tmp23_;
					if (g_strcmp0 (_tmp24_, "eds") == 0) {
						FolksPersonaStore* _tmp25_;
						FolksPersonaStore* _tmp26_;
						_tmp25_ = persona_store;
						_tmp26_ = _g_object_ref0 (_tmp25_);
						_vala_array_add3 (&stores, &stores_length1, &_stores_size_, _tmp26_);
					}
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp27_ = stores;
	_tmp27__length1 = stores_length1;
	if (result_length1) {
		*result_length1 = _tmp27__length1;
	}
	result = _tmp27_;
	return result;
}

FolksPersonaStore*
contacts_utils_get_key_file_address_book (ContactsStore* contacts_store)
{
	FolksPersonaStore* result;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	{
		GeeIterator* _backend_it = NULL;
		FolksBackendStore* _tmp0_;
		FolksBackendStore* _tmp1_;
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp0_ = contacts_store_get_backend_store (contacts_store);
		_tmp1_ = _tmp0_;
		_tmp2_ = folks_backend_store_get_enabled_backends (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_map_get_values (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_backend_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			_tmp9_ = _backend_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _backend_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			backend = (FolksBackend*) _tmp11_;
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp12_;
				GeeMap* _tmp13_;
				GeeMap* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				GeeCollection* _tmp17_;
				GeeIterator* _tmp18_;
				GeeIterator* _tmp19_;
				_tmp12_ = backend;
				_tmp13_ = folks_backend_get_persona_stores (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_map_get_values (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
				_tmp19_ = _tmp18_;
				_g_object_unref0 (_tmp17_);
				_persona_store_it = _tmp19_;
				while (TRUE) {
					GeeIterator* _tmp20_;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp21_;
					gpointer _tmp22_;
					FolksPersonaStore* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp20_ = _persona_store_it;
					if (!gee_iterator_next (_tmp20_)) {
						break;
					}
					_tmp21_ = _persona_store_it;
					_tmp22_ = gee_iterator_get (_tmp21_);
					persona_store = (FolksPersonaStore*) _tmp22_;
					_tmp23_ = persona_store;
					_tmp24_ = folks_persona_store_get_type_id (_tmp23_);
					_tmp25_ = _tmp24_;
					if (g_strcmp0 (_tmp25_, "key-file") == 0) {
						result = persona_store;
						_g_object_unref0 (_persona_store_it);
						_g_object_unref0 (backend);
						_g_object_unref0 (_backend_it);
						return result;
					}
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	result = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->dialog);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda19_ (Block2Data* _data2_)
{
	gtk_window_destroy ((GtkWindow*) _data2_->dialog);
}

static void
___lambda19__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda19_ (self);
}

void
contacts_utils_show_error_dialog (const gchar* _error_,
                                  GtkWindow* toplevel)
{
	Block2Data* _data2_;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (_error_ != NULL);
	g_return_if_fail (toplevel != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (toplevel, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _error_);
	g_object_ref_sink (_tmp0_);
	_data2_->dialog = _tmp0_;
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda19__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

gboolean
contacts_utils_persona_is_main (FolksPersona* persona)
{
	FolksPersonaStore* store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = folks_persona_get_store (persona);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	store = _tmp2_;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_is_primary_store (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		result = FALSE;
		_g_object_unref0 (store);
		return result;
	}
	result = !contacts_utils_persona_is_google_other (persona);
	_g_object_unref0 (store);
	return result;
}

gboolean
contacts_utils_has_main_persona (FolksIndividual* individual)
{
	gboolean _result_ = FALSE;
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	_result_ = FALSE;
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			gboolean _tmp6_ = FALSE;
			FolksPersona* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStore* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp7_ = p;
			_tmp8_ = folks_persona_get_store (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = folks_persona_store_get_is_primary_store (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				FolksPersona* _tmp12_;
				_tmp12_ = p;
				_tmp6_ = !contacts_utils_persona_is_google_other (_tmp12_);
			} else {
				_tmp6_ = FALSE;
			}
			_result_ |= _tmp6_;
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = _result_;
	return result;
}

gboolean
contacts_utils_is_ignorable (FolksIndividual* individual)
{
	GeeIterator* i = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeIterator* _tmp4_;
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	_tmp0_ = folks_individual_get_personas (individual);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	i = _tmp2_;
	_tmp4_ = i;
	if (gee_iterator_next (_tmp4_)) {
		GeeIterator* _tmp5_;
		_tmp5_ = i;
		_tmp3_ = !gee_iterator_has_next (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		FolksPersonaStore* persona_store = NULL;
		GeeIterator* _tmp6_;
		gpointer _tmp7_;
		FolksPersona* _tmp8_;
		FolksPersonaStore* _tmp9_;
		FolksPersonaStore* _tmp10_;
		FolksPersonaStore* _tmp11_;
		FolksPersonaStore* _tmp12_;
		FolksPersonaStore* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		FolksPersonaStore* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp6_ = i;
		_tmp7_ = gee_iterator_get (_tmp6_);
		_tmp8_ = (FolksPersona*) _tmp7_;
		_tmp9_ = folks_persona_get_store (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp8_);
		persona_store = _tmp12_;
		_tmp13_ = persona_store;
		_tmp14_ = folks_persona_store_get_type_id (_tmp13_);
		_tmp15_ = _tmp14_;
		if (g_strcmp0 (_tmp15_, "key-file") == 0) {
			result = TRUE;
			_g_object_unref0 (persona_store);
			_g_object_unref0 (i);
			return result;
		}
		_tmp17_ = persona_store;
		_tmp18_ = folks_persona_store_get_type_id (_tmp17_);
		_tmp19_ = _tmp18_;
		if (g_strcmp0 (_tmp19_, "telepathy") == 0) {
			FolksPersonaStore* _tmp20_;
			FolksPersonaStoreTrust _tmp21_;
			FolksPersonaStoreTrust _tmp22_;
			_tmp20_ = persona_store;
			_tmp21_ = folks_persona_store_get_trust_level (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == FOLKS_PERSONA_STORE_TRUST_NONE;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			result = TRUE;
			_g_object_unref0 (persona_store);
			_g_object_unref0 (i);
			return result;
		}
		_g_object_unref0 (persona_store);
	}
	result = FALSE;
	_g_object_unref0 (i);
	return result;
}

gboolean
contacts_utils_suggest_link_to (ContactsStore* store,
                                FolksIndividual* _self_,
                                FolksIndividual* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (store != NULL, FALSE);
	g_return_val_if_fail (_self_ != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	if (contacts_utils_non_linkable (_self_)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = contacts_utils_non_linkable (other);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (!contacts_store_may_suggest_link (store, _self_, other)) {
		result = FALSE;
		return result;
	}
	if (!contacts_utils_has_main_persona (_self_)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !contacts_utils_has_mainable_persona (other);
	}
	result = _tmp1_;
	return result;
}

gboolean
contacts_utils_has_pref (FolksAbstractFieldDetails* details)
{
	GeeCollection* evolution_pref = NULL;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean result;
	g_return_val_if_fail (details != NULL, FALSE);
	_tmp0_ = folks_abstract_field_details_get_parameter_values (details, "x-evolution-ui-slot");
	evolution_pref = _tmp0_;
	_tmp2_ = evolution_pref;
	if (_tmp2_ != NULL) {
		GeeCollection* _tmp3_;
		gpointer _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = evolution_pref;
		_tmp4_ = contacts_utils_get_first (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp3_);
		_tmp5_ = (gchar*) _tmp4_;
		_tmp1_ = g_strcmp0 (_tmp5_, "1") == 0;
		_g_free0 (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_object_unref0 (evolution_pref);
		return result;
	}
	{
		GeeIterator* _param_it = NULL;
		GeeMultiMap* _tmp6_;
		GeeMultiMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp6_ = folks_abstract_field_details_get_parameters (details);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_multi_map_get (_tmp7_, "type");
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_param_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* param = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp12_ = _param_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _param_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			param = (gchar*) _tmp14_;
			_tmp15_ = param;
			if (g_ascii_strcasecmp (_tmp15_, "PREF") == 0) {
				result = TRUE;
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				_g_object_unref0 (evolution_pref);
				return result;
			}
			_g_free0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = FALSE;
	_g_object_unref0 (evolution_pref);
	return result;
}

ContactsTypeSet*
contacts_utils_select_typeset_from_fielddetails (FolksAbstractFieldDetails* a)
{
	ContactsTypeSet* _tmp6_;
	ContactsTypeSet* _tmp7_;
	ContactsTypeSet* _tmp8_;
	ContactsTypeSet* result;
	g_return_val_if_fail (a != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (a, FOLKS_TYPE_EMAIL_FIELD_DETAILS)) {
		ContactsTypeSet* _tmp0_;
		ContactsTypeSet* _tmp1_;
		ContactsTypeSet* _tmp2_;
		_tmp0_ = contacts_typeset_get_email ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (a, FOLKS_TYPE_PHONE_FIELD_DETAILS)) {
		ContactsTypeSet* _tmp3_;
		ContactsTypeSet* _tmp4_;
		ContactsTypeSet* _tmp5_;
		_tmp3_ = contacts_typeset_get_phone ();
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = contacts_typeset_get_general ();
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

gint
contacts_utils_compare_fields (void* _a,
                               void* _b)
{
	FolksAbstractFieldDetails* a = NULL;
	FolksAbstractFieldDetails* _tmp0_;
	FolksAbstractFieldDetails* b = NULL;
	FolksAbstractFieldDetails* _tmp1_;
	gboolean a_has_pref = FALSE;
	FolksAbstractFieldDetails* _tmp2_;
	FolksAbstractFieldDetails* _tmp3_;
	ContactsTypeSet* type_set = NULL;
	FolksAbstractFieldDetails* _tmp5_;
	ContactsTypeSet* _tmp6_;
	gint _result_ = 0;
	ContactsTypeSet* _tmp7_;
	FolksAbstractFieldDetails* _tmp8_;
	const gchar* _tmp9_;
	ContactsTypeSet* _tmp10_;
	FolksAbstractFieldDetails* _tmp11_;
	const gchar* _tmp12_;
	FolksAbstractFieldDetails* aa = NULL;
	FolksAbstractFieldDetails* _tmp13_;
	FolksAbstractFieldDetails* _tmp14_;
	FolksAbstractFieldDetails* bb = NULL;
	FolksAbstractFieldDetails* _tmp15_;
	FolksAbstractFieldDetails* _tmp16_;
	gboolean _tmp17_ = FALSE;
	FolksAbstractFieldDetails* _tmp18_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_a, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_b, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	b = _tmp1_;
	_tmp2_ = a;
	a_has_pref = contacts_utils_has_pref (_tmp2_);
	_tmp3_ = b;
	if (a_has_pref != contacts_utils_has_pref (_tmp3_)) {
		gint _tmp4_ = 0;
		if (a_has_pref) {
			_tmp4_ = -1;
		} else {
			_tmp4_ = 1;
		}
		result = _tmp4_;
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	}
	_tmp5_ = a;
	_tmp6_ = contacts_utils_select_typeset_from_fielddetails (_tmp5_);
	type_set = _tmp6_;
	_tmp7_ = type_set;
	_tmp8_ = a;
	_tmp9_ = contacts_typeset_format_type (_tmp7_, _tmp8_);
	_tmp10_ = type_set;
	_tmp11_ = b;
	_tmp12_ = contacts_typeset_format_type (_tmp10_, _tmp11_);
	_result_ = g_ascii_strcasecmp (_tmp9_, _tmp12_);
	if (_result_ != 0) {
		result = _result_;
		_g_object_unref0 (type_set);
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	}
	_tmp13_ = a;
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS) ? ((FolksAbstractFieldDetails*) _tmp13_) : NULL);
	aa = _tmp14_;
	_tmp15_ = b;
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS) ? ((FolksAbstractFieldDetails*) _tmp15_) : NULL);
	bb = _tmp16_;
	_tmp18_ = aa;
	if (_tmp18_ != NULL) {
		FolksAbstractFieldDetails* _tmp19_;
		_tmp19_ = bb;
		_tmp17_ = _tmp19_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GCompareFunc _tmp20_;
		FolksAbstractFieldDetails* _tmp21_;
		gconstpointer _tmp22_;
		gconstpointer _tmp23_;
		FolksAbstractFieldDetails* _tmp24_;
		gconstpointer _tmp25_;
		gconstpointer _tmp26_;
		_tmp20_ = ((GCompareFunc) g_strcmp0);
		_tmp21_ = aa;
		_tmp22_ = folks_abstract_field_details_get_value (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = bb;
		_tmp25_ = folks_abstract_field_details_get_value (_tmp24_);
		_tmp26_ = _tmp25_;
		result = _tmp20_ ((const gchar*) _tmp23_, (const gchar*) _tmp26_);
		_g_object_unref0 (bb);
		_g_object_unref0 (aa);
		_g_object_unref0 (type_set);
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	}
	g_warning ("contacts-utils.vala:247: Unsupported AbstractFieldDetails value type");
	result = 0;
	_g_object_unref0 (bb);
	_g_object_unref0 (aa);
	_g_object_unref0 (type_set);
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}

static gint
_contacts_utils_compare_fields_gcompare_data_func (gconstpointer a,
                                                   gconstpointer b,
                                                   gpointer self)
{
	gint result;
	result = contacts_utils_compare_fields (a, b);
	return result;
}

GeeList*
contacts_utils_sort_fields (GType t_type,
                            GBoxedCopyFunc t_dup_func,
                            GDestroyNotify t_destroy_func,
                            GeeCollection* fields)
{
	GeeArrayList* res = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (fields != NULL, NULL);
	_tmp0_ = gee_array_list_new (t_type, (GBoxedCopyFunc) t_dup_func, (GDestroyNotify) t_destroy_func, NULL, NULL, NULL);
	res = _tmp0_;
	gee_array_list_add_all (res, fields);
	gee_list_sort ((GeeList*) res, _contacts_utils_compare_fields_gcompare_data_func, NULL, NULL);
	result = (GeeList*) res;
	return result;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
contacts_utils_format_address (FolksPostalAddress* addr,
                               gint* result_length1)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gint lines_length1;
	gint _lines_size_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** result;
	g_return_val_if_fail (addr != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp1_ = folks_postal_address_get_street (addr);
	_tmp2_ = _tmp1_;
	if (contacts_is_set (_tmp2_)) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = folks_postal_address_get_street (addr);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_vala_array_add4 (&lines, &lines_length1, &_lines_size_, _tmp5_);
	}
	_tmp6_ = folks_postal_address_get_extension (addr);
	_tmp7_ = _tmp6_;
	if (contacts_is_set (_tmp7_)) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = folks_postal_address_get_extension (addr);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_vala_array_add5 (&lines, &lines_length1, &_lines_size_, _tmp10_);
	}
	_tmp11_ = folks_postal_address_get_locality (addr);
	_tmp12_ = _tmp11_;
	if (contacts_is_set (_tmp12_)) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = folks_postal_address_get_locality (addr);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_vala_array_add6 (&lines, &lines_length1, &_lines_size_, _tmp15_);
	}
	_tmp16_ = folks_postal_address_get_region (addr);
	_tmp17_ = _tmp16_;
	if (contacts_is_set (_tmp17_)) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = folks_postal_address_get_region (addr);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup (_tmp19_);
		_vala_array_add7 (&lines, &lines_length1, &_lines_size_, _tmp20_);
	}
	_tmp21_ = folks_postal_address_get_postal_code (addr);
	_tmp22_ = _tmp21_;
	if (contacts_is_set (_tmp22_)) {
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp23_ = folks_postal_address_get_postal_code (addr);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		_vala_array_add8 (&lines, &lines_length1, &_lines_size_, _tmp25_);
	}
	_tmp26_ = folks_postal_address_get_po_box (addr);
	_tmp27_ = _tmp26_;
	if (contacts_is_set (_tmp27_)) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = folks_postal_address_get_po_box (addr);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup (_tmp29_);
		_vala_array_add9 (&lines, &lines_length1, &_lines_size_, _tmp30_);
	}
	_tmp31_ = folks_postal_address_get_country (addr);
	_tmp32_ = _tmp31_;
	if (contacts_is_set (_tmp32_)) {
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp33_ = folks_postal_address_get_country (addr);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strdup (_tmp34_);
		_vala_array_add10 (&lines, &lines_length1, &_lines_size_, _tmp35_);
	}
	_tmp36_ = folks_postal_address_get_address_format (addr);
	_tmp37_ = _tmp36_;
	if (contacts_is_set (_tmp37_)) {
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp38_ = folks_postal_address_get_address_format (addr);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strdup (_tmp39_);
		_vala_array_add11 (&lines, &lines_length1, &_lines_size_, _tmp40_);
	}
	_tmp41_ = lines;
	_tmp41__length1 = lines_length1;
	if (result_length1) {
		*result_length1 = _tmp41__length1;
	}
	result = _tmp41_;
	return result;
}

/**
   * Takes an individual's postal address and creates a "maps:q=..." URI for
   * it, which can be launched to use the local system's maps handler
   * (e.g. GNOME Maps).
   *
   * See also https://www.iana.org/assignments/uri-schemes/prov/maps for the
   * "specification"
   */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
contacts_utils_create_maps_uri (FolksPostalAddress* address)
{
	gchar* address_parts = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (address != NULL, NULL);
	_tmp1_ = contacts_utils_format_address (address, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = _vala_g_strjoinv (" ", _tmp2_, (gint) _tmp0_);
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	address_parts = _tmp4_;
	_tmp5_ = g_uri_escape_string (address_parts, NULL, TRUE);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("maps:q=%s", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	_g_free0 (address_parts);
	return result;
}

gboolean
contacts_utils_can_remove_personas (FolksIndividual* individual)
{
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			FolksPersonaStore* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksMaybeBool _tmp9_;
			FolksMaybeBool _tmp10_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			_tmp7_ = folks_persona_get_store (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_persona_store_get_can_remove_personas (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == FOLKS_MAYBE_BOOL_TRUE) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = FALSE;
	return result;
}

static gint
__lambda20_ (GObject* a,
             GObject* b)
{
	FolksPersonaStore* store_a = NULL;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store_b = NULL;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	FolksPersonaStore* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	FolksPersonaStore* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	FolksPersonaStore* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GCompareFunc _tmp27_;
	FolksPersonaStore* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	FolksPersonaStore* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = folks_persona_get_store (G_TYPE_CHECK_INSTANCE_CAST (a, FOLKS_TYPE_PERSONA, FolksPersona));
	_tmp1_ = _tmp0_;
	store_a = _tmp1_;
	_tmp2_ = folks_persona_get_store (G_TYPE_CHECK_INSTANCE_CAST (b, FOLKS_TYPE_PERSONA, FolksPersona));
	_tmp3_ = _tmp2_;
	store_b = _tmp3_;
	_tmp4_ = store_a;
	_tmp5_ = store_b;
	if (_tmp4_ == _tmp5_) {
		gboolean a_is_other = FALSE;
		if (!contacts_utils_persona_is_google (G_TYPE_CHECK_INSTANCE_CAST (a, FOLKS_TYPE_PERSONA, FolksPersona))) {
			result = 0;
			return result;
		}
		a_is_other = contacts_utils_persona_is_google_other (G_TYPE_CHECK_INSTANCE_CAST (a, FOLKS_TYPE_PERSONA, FolksPersona));
		if (a_is_other != contacts_utils_persona_is_google_other (G_TYPE_CHECK_INSTANCE_CAST (b, FOLKS_TYPE_PERSONA, FolksPersona))) {
			gint _tmp6_ = 0;
			if (a_is_other) {
				_tmp6_ = 1;
			} else {
				_tmp6_ = -1;
			}
			result = _tmp6_;
			return result;
		}
	}
	_tmp7_ = store_a;
	_tmp8_ = folks_persona_store_get_is_primary_store (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = store_b;
	_tmp11_ = folks_persona_store_get_is_primary_store (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp9_ != _tmp12_) {
		gint _tmp13_ = 0;
		FolksPersonaStore* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = store_a;
		_tmp15_ = folks_persona_store_get_is_primary_store (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			_tmp13_ = -1;
		} else {
			_tmp13_ = 1;
		}
		result = _tmp13_;
		return result;
	}
	_tmp17_ = store_a;
	_tmp18_ = folks_persona_store_get_type_id (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = store_b;
	_tmp21_ = folks_persona_store_get_type_id (_tmp20_);
	_tmp22_ = _tmp21_;
	if ((g_strcmp0 (_tmp19_, "eds") == 0) != (g_strcmp0 (_tmp22_, "eds") == 0)) {
		gint _tmp23_ = 0;
		FolksPersonaStore* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = store_a;
		_tmp25_ = folks_persona_store_get_type_id (_tmp24_);
		_tmp26_ = _tmp25_;
		if (g_strcmp0 (_tmp26_, "eds") == 0) {
			_tmp23_ = -1;
		} else {
			_tmp23_ = 1;
		}
		result = _tmp23_;
		return result;
	}
	_tmp27_ = ((GCompareFunc) g_strcmp0);
	_tmp28_ = store_a;
	_tmp29_ = folks_persona_store_get_id (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = store_b;
	_tmp32_ = folks_persona_store_get_id (_tmp31_);
	_tmp33_ = _tmp32_;
	result = _tmp27_ (_tmp30_, _tmp33_);
	return result;
}

static gint
___lambda20__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda20_ ((GObject*) a, (GObject*) b);
	return result;
}

GListModel*
contacts_utils_get_personas_for_display (FolksIndividual* individual)
{
	GListStore* persona_list = NULL;
	GListStore* _tmp0_;
	GListStore* _tmp14_;
	GListModel* result;
	g_return_val_if_fail (individual != NULL, NULL);
	_tmp0_ = g_list_store_new (FOLKS_TYPE_PERSONA);
	persona_list = _tmp0_;
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp1_ = folks_individual_get_personas (individual);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_persona_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksPersona* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStore* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp4_ = _persona_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _persona_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			persona = (FolksPersona*) _tmp6_;
			_tmp7_ = persona;
			_tmp8_ = folks_persona_get_store (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = folks_persona_store_get_type_id (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "key-file") != 0) {
				GListStore* _tmp12_;
				FolksPersona* _tmp13_;
				_tmp12_ = persona_list;
				_tmp13_ = persona;
				g_list_store_append (_tmp12_, (GObject*) _tmp13_);
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp14_ = persona_list;
	g_list_store_sort (_tmp14_, ___lambda20__gcompare_data_func, NULL);
	result = (GListModel*) persona_list;
	return result;
}

FolksPersona*
contacts_utils_find_primary_persona (FolksIndividual* individual)
{
	FolksPersona* result;
	g_return_val_if_fail (individual != NULL, NULL);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			FolksPersonaStore* _tmp7_;
			FolksPersonaStore* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			_tmp7_ = folks_persona_get_store (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_persona_store_get_is_primary_store (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				result = p;
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	return result;
}

FolksPersona*
contacts_utils_find_persona_from_uid (FolksIndividual* individual,
                                      const gchar* uid)
{
	FolksPersona* result;
	g_return_val_if_fail (individual != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			_tmp7_ = folks_persona_get_uid (_tmp6_);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 (_tmp8_, uid) == 0) {
				result = p;
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	return result;
}

gchar*
contacts_utils_format_persona_stores (FolksIndividual* individual)
{
	gchar* stores = NULL;
	gchar* _tmp0_;
	gboolean first = FALSE;
	gchar* result;
	g_return_val_if_fail (individual != NULL, NULL);
	_tmp0_ = g_strdup ("");
	stores = _tmp0_;
	first = TRUE;
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp1_ = folks_individual_get_personas (individual);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp9_;
			FolksPersona* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp4_ = _p_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			p = (FolksPersona*) _tmp6_;
			if (!first) {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = stores;
				_tmp8_ = g_strconcat (_tmp7_, ", ", NULL);
				_g_free0 (stores);
				stores = _tmp8_;
			}
			_tmp9_ = stores;
			_tmp10_ = p;
			_tmp11_ = contacts_utils_format_persona_store_name_for_contact (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (stores);
			stores = _tmp13_;
			_g_free0 (_tmp12_);
			first = FALSE;
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = stores;
	return result;
}

gchar*
contacts_utils_format_persona_store_name (FolksPersonaStore* store)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = folks_persona_store_get_type_id (store);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "eds") == 0) {
		gchar* eds_name = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = folks_persona_store_get_id (store);
		_tmp3_ = _tmp2_;
		_tmp4_ = contacts_lookup_esource_name_by_uid (_tmp3_);
		eds_name = _tmp4_;
		_tmp5_ = eds_name;
		if (_tmp5_ != NULL) {
			result = eds_name;
			return result;
		}
		_g_free0 (eds_name);
	}
	_tmp6_ = folks_persona_store_get_display_name (store);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	return result;
}

gboolean
contacts_utils_has_mainable_persona (FolksIndividual* individual)
{
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			gboolean _tmp6_ = FALSE;
			FolksPersona* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStore* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp7_ = p;
			_tmp8_ = folks_persona_get_store (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = folks_persona_store_get_type_id (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "eds") == 0) {
				FolksPersona* _tmp12_;
				_tmp12_ = p;
				_tmp6_ = !contacts_utils_persona_is_google_other (_tmp12_);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = FALSE;
	return result;
}

gboolean
contacts_utils_non_linkable (FolksIndividual* individual)
{
	gboolean all_unlinkable = FALSE;
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	all_unlinkable = TRUE;
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			if (!contacts_utils_persona_is_google_other (_tmp6_)) {
				all_unlinkable = FALSE;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = all_unlinkable;
	return result;
}

gboolean
contacts_utils_persona_is_google (FolksPersona* persona)
{
	gboolean _tmp0_ = FALSE;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp1_ = folks_persona_get_store (persona);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "eds") == 0) {
		FolksPersonaStore* _tmp5_;
		FolksPersonaStore* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = folks_persona_get_store (persona);
		_tmp6_ = _tmp5_;
		_tmp7_ = folks_persona_store_get_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = contacts_esource_uid_is_google (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
   * Return true only for personas which are in a Google address book, but which
   * are not in the user's "My Contacts" group in the address book.
   */
gboolean
contacts_utils_persona_is_google_other (FolksPersona* persona)
{
	EdsfPersona* p = NULL;
	gboolean _tmp0_ = FALSE;
	EdsfPersona* _tmp1_;
	gboolean result;
	g_return_val_if_fail (persona != NULL, FALSE);
	if (!contacts_utils_persona_is_google (persona)) {
		result = FALSE;
		return result;
	}
	p = G_TYPE_CHECK_INSTANCE_TYPE (persona, EDSF_TYPE_PERSONA) ? ((EdsfPersona*) persona) : NULL;
	_tmp1_ = p;
	if (_tmp1_ != NULL) {
		EdsfPersona* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = p;
		_tmp3_ = edsf_persona_get_in_google_personal_group (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
contacts_utils_format_persona_store_name_for_contact (FolksPersona* persona)
{
	FolksPersonaStore* store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPersonaStore* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = folks_persona_get_store (persona);
	_tmp1_ = _tmp0_;
	store = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "eds") == 0) {
		gchar* eds_name = NULL;
		FolksPersonaStore* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		if (contacts_utils_persona_is_google_other (persona)) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Google"));
			result = _tmp5_;
			return result;
		}
		_tmp6_ = store;
		_tmp7_ = folks_persona_store_get_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = contacts_lookup_esource_name_by_uid_for_contact (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		eds_name = _tmp10_;
		_tmp11_ = eds_name;
		if (_tmp11_ != NULL) {
			result = eds_name;
			return result;
		}
		_g_free0 (eds_name);
	}
	_tmp12_ = store;
	_tmp13_ = folks_persona_store_get_display_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	return result;
}

static void
contacts_utils_set_individual_property_data_free (gpointer _data)
{
	ContactsUtilsSetIndividualPropertyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_free0 (_data_->property_name);
	G_IS_VALUE (&_data_->value) ? (g_value_unset (&_data_->value), NULL) : NULL;
	g_slice_free (ContactsUtilsSetIndividualPropertyData, _data_);
}

void
contacts_utils_set_individual_property (FolksIndividual* individual,
                                        const gchar* property_name,
                                        GValue* value,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ContactsUtilsSetIndividualPropertyData* _data_;
	FolksIndividual* _tmp0_;
	gchar* _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue _tmp4_ = {0};
	g_return_if_fail (individual != NULL);
	g_return_if_fail (property_name != NULL);
	g_return_if_fail (value != NULL);
	_data_ = g_slice_new0 (ContactsUtilsSetIndividualPropertyData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_utils_set_individual_property_data_free);
	_tmp0_ = _g_object_ref0 (individual);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp0_;
	_tmp1_ = g_strdup (property_name);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp1_;
	_tmp2_ = *value;
	_tmp3_ = _tmp2_;
	if (G_IS_VALUE (&_tmp3_)) {
		g_value_init (&_tmp4_, G_VALUE_TYPE (&_tmp3_));
		g_value_copy (&_tmp3_, &_tmp4_);
	} else {
		_tmp4_ = _tmp3_;
	}
	G_IS_VALUE (&_data_->value) ? (g_value_unset (&_data_->value), NULL) : NULL;
	_data_->value = _tmp4_;
	contacts_utils_set_individual_property_co (_data_);
}

void
contacts_utils_set_individual_property_finish (GAsyncResult* _res_,
                                               GError** error)
{
	ContactsUtilsSetIndividualPropertyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
contacts_utils_set_individual_property_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	ContactsUtilsSetIndividualPropertyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_utils_set_individual_property_co (_data_);
}

static gboolean
contacts_utils_set_individual_property_co (ContactsUtilsSetIndividualPropertyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_individual_get_personas (_data_->individual);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp1_, &_data_->_tmp2_);
	_data_->personas_copy = _data_->_tmp3_;
	_data_->personas_copy_length1 = _data_->_tmp2_;
	_data_->_personas_copy_size_ = _data_->personas_copy_length1;
	_data_->_tmp4_ = _data_->personas_copy;
	_data_->_tmp4__length1 = _data_->personas_copy_length1;
	{
		_data_->p_collection_length1 = 0;
		_data_->_p_collection_size_ = 0;
		_data_->p_collection = _data_->_tmp4_;
		_data_->p_collection_length1 = _data_->_tmp4__length1;
		for (_data_->p_it = 0; _data_->p_it < _data_->p_collection_length1; _data_->p_it = _data_->p_it + 1) {
			_data_->_tmp5_ = _g_object_ref0 (_data_->p_collection[_data_->p_it]);
			_data_->p = _data_->_tmp5_;
			{
				_data_->_tmp6_ = _data_->p;
				_data_->_tmp8_ = 0;
				_data_->_tmp7_ = folks_persona_get_writeable_properties (_data_->_tmp6_, &_data_->_tmp8_);
				_data_->_tmp7__length1 = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->_tmp7_;
				_data_->_tmp9__length1 = _data_->_tmp7__length1;
				if (_vala_string_array_contains (_data_->_tmp9_, _data_->_tmp9__length1, _data_->property_name)) {
					_data_->_tmp10_ = _data_->p;
					_data_->_tmp11_ = _data_->value;
					_data_->_state_ = 1;
					contacts_utils_set_persona_property (_data_->_tmp10_, _data_->property_name, &_data_->_tmp11_, contacts_utils_set_individual_property_ready, _data_);
					return FALSE;
					_state_1:
					contacts_utils_set_persona_property_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->p);
						_data_->personas_copy = (_vala_array_free (_data_->personas_copy, _data_->personas_copy_length1, (GDestroyNotify) g_object_unref), NULL);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->p);
			}
		}
	}
	_data_->personas_copy = (_vala_array_free (_data_->personas_copy, _data_->personas_copy_length1, (GDestroyNotify) g_object_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_utils_set_persona_property_data_free (gpointer _data)
{
	ContactsUtilsSetPersonaPropertyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->property_name);
	G_IS_VALUE (&_data_->new_value) ? (g_value_unset (&_data_->new_value), NULL) : NULL;
	g_slice_free (ContactsUtilsSetPersonaPropertyData, _data_);
}

void
contacts_utils_set_persona_property (FolksPersona* persona,
                                     const gchar* property_name,
                                     GValue* new_value,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ContactsUtilsSetPersonaPropertyData* _data_;
	FolksPersona* _tmp0_;
	gchar* _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue _tmp4_ = {0};
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property_name != NULL);
	g_return_if_fail (new_value != NULL);
	_data_ = g_slice_new0 (ContactsUtilsSetPersonaPropertyData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_utils_set_persona_property_data_free);
	_tmp0_ = _g_object_ref0 (persona);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp0_;
	_tmp1_ = g_strdup (property_name);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp1_;
	_tmp2_ = *new_value;
	_tmp3_ = _tmp2_;
	if (G_IS_VALUE (&_tmp3_)) {
		g_value_init (&_tmp4_, G_VALUE_TYPE (&_tmp3_));
		g_value_copy (&_tmp3_, &_tmp4_);
	} else {
		_tmp4_ = _tmp3_;
	}
	G_IS_VALUE (&_data_->new_value) ? (g_value_unset (&_data_->new_value), NULL) : NULL;
	_data_->new_value = _tmp4_;
	contacts_utils_set_persona_property_co (_data_);
}

void
contacts_utils_set_persona_property_finish (GAsyncResult* _res_,
                                            GError** error)
{
	ContactsUtilsSetPersonaPropertyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_utils_set_persona_property_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsUtilsSetPersonaPropertyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_utils_set_persona_property_co (_data_);
}

static gboolean
contacts_utils_set_persona_property_co (ContactsUtilsSetPersonaPropertyData* _data_)
{
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	static GQuark _tmp1_label18 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
		case 15:
		goto _state_15;
		case 16:
		goto _state_16;
		case 17:
		goto _state_17;
		case 18:
		goto _state_18;
		case 19:
		goto _state_19;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = 0U;
	_data_->_tmp0_ = _data_->property_name;
	_data_->_tmp2_ = (NULL == _data_->_tmp0_) ? 0 : g_quark_from_string (_data_->_tmp0_);
	if (_data_->_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("alias")))) {
		switch (0) {
			default:
			{
				_data_->_tmp3_ = _data_->new_value;
				_data_->_state_ = 1;
				folks_alias_details_change_alias (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetails), g_value_get_string (&_data_->_tmp3_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_1:
				folks_alias_details_change_alias_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("avatar")))) {
		switch (0) {
			default:
			{
				_data_->_tmp4_ = _data_->new_value;
				_data_->_state_ = 2;
				folks_avatar_details_change_avatar (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_AVATAR_DETAILS, FolksAvatarDetails), g_value_get_object (&_data_->_tmp4_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_2:
				folks_avatar_details_change_avatar_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_AVATAR_DETAILS, FolksAvatarDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				_data_->_tmp5_ = _data_->new_value;
				_data_->_state_ = 3;
				folks_birthday_details_change_birthday (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails), g_value_get_boxed (&_data_->_tmp5_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_3:
				folks_birthday_details_change_birthday_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("calendar-event-id")))) {
		switch (0) {
			default:
			{
				_data_->_tmp6_ = _data_->new_value;
				_data_->_state_ = 4;
				folks_birthday_details_change_calendar_event_id (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails), g_value_get_string (&_data_->_tmp6_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_4:
				folks_birthday_details_change_calendar_event_id_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_BIRTHDAY_DETAILS, FolksBirthdayDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp7_ = _data_->new_value;
				_data_->_state_ = 5;
				folks_email_details_change_email_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails), g_value_get_object (&_data_->_tmp7_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_5:
				folks_email_details_change_email_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("is-favourite")))) {
		switch (0) {
			default:
			{
				_data_->_tmp8_ = _data_->new_value;
				_data_->_state_ = 6;
				folks_favourite_details_change_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails), g_value_get_boolean (&_data_->_tmp8_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_6:
				folks_favourite_details_change_is_favourite_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("gender")))) {
		switch (0) {
			default:
			{
				_data_->_tmp9_ = _data_->new_value;
				_data_->_state_ = 7;
				folks_gender_details_change_gender (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetails), g_value_get_enum (&_data_->_tmp9_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_7:
				folks_gender_details_change_gender_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("groups")))) {
		switch (0) {
			default:
			{
				_data_->_tmp10_ = _data_->new_value;
				_data_->_state_ = 8;
				folks_group_details_change_groups (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_GROUP_DETAILS, FolksGroupDetails), g_value_get_object (&_data_->_tmp10_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_8:
				folks_group_details_change_groups_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_GROUP_DETAILS, FolksGroupDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("im-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp11_ = _data_->new_value;
				_data_->_state_ = 9;
				folks_im_details_change_im_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_IM_DETAILS, FolksImDetails), g_value_get_object (&_data_->_tmp11_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_9:
				folks_im_details_change_im_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_IM_DETAILS, FolksImDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("local-ids")))) {
		switch (0) {
			default:
			{
				_data_->_tmp12_ = _data_->new_value;
				_data_->_state_ = 10;
				folks_local_id_details_change_local_ids (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails), g_value_get_object (&_data_->_tmp12_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_10:
				folks_local_id_details_change_local_ids_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("structured-name")))) {
		switch (0) {
			default:
			{
				_data_->_tmp13_ = _data_->new_value;
				_data_->_state_ = 11;
				folks_name_details_change_structured_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails), g_value_get_object (&_data_->_tmp13_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_11:
				folks_name_details_change_structured_name_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("full-name")))) {
		switch (0) {
			default:
			{
				_data_->_tmp14_ = _data_->new_value;
				_data_->_state_ = 12;
				folks_name_details_change_full_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails), g_value_get_string (&_data_->_tmp14_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_12:
				folks_name_details_change_full_name_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				_data_->_tmp15_ = _data_->new_value;
				_data_->_state_ = 13;
				folks_name_details_change_nickname (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails), g_value_get_string (&_data_->_tmp15_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_13:
				folks_name_details_change_nickname_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NAME_DETAILS, FolksNameDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				_data_->_tmp16_ = _data_->new_value;
				_data_->_state_ = 14;
				folks_note_details_change_notes (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NOTE_DETAILS, FolksNoteDetails), g_value_get_object (&_data_->_tmp16_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_14:
				folks_note_details_change_notes_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_NOTE_DETAILS, FolksNoteDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				_data_->_tmp17_ = _data_->new_value;
				_data_->_state_ = 15;
				folks_phone_details_change_phone_numbers (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails), g_value_get_object (&_data_->_tmp17_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_15:
				folks_phone_details_change_phone_numbers_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp18_ = _data_->new_value;
				_data_->_state_ = 16;
				folks_postal_address_details_change_postal_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails), g_value_get_object (&_data_->_tmp18_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_16:
				folks_postal_address_details_change_postal_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, FolksPostalAddressDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				_data_->_tmp19_ = _data_->new_value;
				_data_->_state_ = 17;
				folks_role_details_change_roles (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetails), g_value_get_object (&_data_->_tmp19_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_17:
				folks_role_details_change_roles_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				_data_->_tmp20_ = _data_->new_value;
				_data_->_state_ = 18;
				folks_url_details_change_urls (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_URL_DETAILS, FolksUrlDetails), g_value_get_object (&_data_->_tmp20_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_18:
				folks_url_details_change_urls_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_URL_DETAILS, FolksUrlDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("web-service-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp21_ = _data_->new_value;
				_data_->_state_ = 19;
				folks_web_service_details_change_web_service_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails), g_value_get_object (&_data_->_tmp21_), contacts_utils_set_persona_property_ready, _data_);
				return FALSE;
				_state_19:
				folks_web_service_details_change_web_service_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->persona, FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails), _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					if ((_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error0_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_critical ("contacts-utils.vala:537: Unknown property '%s' in Contact.set_persona_" \
"property().", _data_->property_name);
				break;
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
contacts_utils_property_display_info_copy (const ContactsUtilsPropertyDisplayInfo* self,
                                           ContactsUtilsPropertyDisplayInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).property_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).property_name);
	(*dest).property_name = _tmp1_;
	_tmp2_ = (*self).display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).display_name);
	(*dest).display_name = _tmp3_;
	_tmp4_ = (*self).icon_name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).icon_name);
	(*dest).icon_name = _tmp5_;
}

void
contacts_utils_property_display_info_destroy (ContactsUtilsPropertyDisplayInfo* self)
{
	_g_free0 ((*self).property_name);
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).icon_name);
}

ContactsUtilsPropertyDisplayInfo*
contacts_utils_property_display_info_dup (const ContactsUtilsPropertyDisplayInfo* self)
{
	ContactsUtilsPropertyDisplayInfo* dup;
	dup = g_new0 (ContactsUtilsPropertyDisplayInfo, 1);
	contacts_utils_property_display_info_copy (self, dup);
	return dup;
}

void
contacts_utils_property_display_info_free (ContactsUtilsPropertyDisplayInfo* self)
{
	contacts_utils_property_display_info_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
contacts_utils_property_display_info_get_type_once (void)
{
	GType contacts_utils_property_display_info_type_id;
	contacts_utils_property_display_info_type_id = g_boxed_type_register_static ("ContactsUtilsPropertyDisplayInfo", (GBoxedCopyFunc) contacts_utils_property_display_info_dup, (GBoxedFreeFunc) contacts_utils_property_display_info_free);
	return contacts_utils_property_display_info_type_id;
}

GType
contacts_utils_property_display_info_get_type (void)
{
	static volatile gsize contacts_utils_property_display_info_type_id__once = 0;
	if (g_once_init_enter (&contacts_utils_property_display_info_type_id__once)) {
		GType contacts_utils_property_display_info_type_id;
		contacts_utils_property_display_info_type_id = contacts_utils_property_display_info_get_type_once ();
		g_once_init_leave (&contacts_utils_property_display_info_type_id__once, contacts_utils_property_display_info_type_id);
	}
	return contacts_utils_property_display_info_type_id__once;
}

const gchar*
contacts_utils_get_display_name_for_property (const gchar* property_name)
{
	const gchar* result;
	g_return_val_if_fail (property_name != NULL, NULL);
	{
		ContactsUtilsPropertyDisplayInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
		info_collection = CONTACTS_UTILS_display_infos;
		info_collection_length1 = G_N_ELEMENTS (CONTACTS_UTILS_display_infos);
		for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
			ContactsUtilsPropertyDisplayInfo info = {0};
			info = info_collection[info_it];
			{
				ContactsUtilsPropertyDisplayInfo _tmp0_;
				const gchar* _tmp1_;
				_tmp0_ = info;
				_tmp1_ = _tmp0_.property_name;
				if (g_strcmp0 (_tmp1_, property_name) == 0) {
					ContactsUtilsPropertyDisplayInfo _tmp2_;
					const gchar* _tmp3_;
					_tmp2_ = info;
					_tmp3_ = _tmp2_.display_name;
					result = gettext (_tmp3_);
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (NULL);
}

const gchar*
contacts_utils_get_icon_name_for_property (const gchar* property_name)
{
	const gchar* result;
	g_return_val_if_fail (property_name != NULL, NULL);
	{
		ContactsUtilsPropertyDisplayInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
		info_collection = CONTACTS_UTILS_display_infos;
		info_collection_length1 = G_N_ELEMENTS (CONTACTS_UTILS_display_infos);
		for (info_it = 0; info_it < info_collection_length1; info_it = info_it + 1) {
			ContactsUtilsPropertyDisplayInfo info = {0};
			info = info_collection[info_it];
			{
				ContactsUtilsPropertyDisplayInfo _tmp0_;
				const gchar* _tmp1_;
				_tmp0_ = info;
				_tmp1_ = _tmp0_.property_name;
				if (g_strcmp0 (_tmp1_, property_name) == 0) {
					ContactsUtilsPropertyDisplayInfo _tmp2_;
					const gchar* _tmp3_;
					_tmp2_ = info;
					_tmp3_ = _tmp2_.icon_name;
					result = _tmp3_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

