# Fish shell completion for gum
# Generated by gum completion

# disable file completion unless explicitly enabled
complete -c gum -f

# gum
complete -c gum -f -s h -l help -d 'Show context-sensitive help.'
complete -c gum -f -s v -l version -d 'Print the version number'

# choose
complete -c gum -f -n '__fish_use_subcommand' -a choose -d 'Choose an option from a list of choices'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l limit -d 'Maximum number of options to pick'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l no-limit -d 'Pick unlimited number of options (ignores limit)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l ordered -d 'Maintain the order of the selected options'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l height -d 'Height of the list'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor -d 'Prefix to show on item that corresponds to the cursor position'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header -d 'Header value'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor-prefix -d 'Prefix to show on the cursor item (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected-prefix -d 'Prefix to show on selected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l unselected-prefix -d 'Prefix to show on unselected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected -d 'Options that should start as selected'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l header.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l header.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l header.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l header.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l header.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l header.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l header.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l header.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l item.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l item.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l item.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l item.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'none hidden normal rounded thick double' -l selected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -xa 'left center right bottom middle top' -l selected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l selected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -l selected.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from choose' -x -l timeout -d 'Timeout until choose returns selected element'

# confirm
complete -c gum -f -n '__fish_use_subcommand' -a confirm -d 'Ask a user to confirm an action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l default -d 'Default confirmation action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l affirmative -d 'The title of the affirmative action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l negative -d 'The title of the negative action'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l prompt.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'none hidden normal rounded thick double' -l selected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'left center right bottom middle top' -l selected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l selected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l selected.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'none hidden normal rounded thick double' -l unselected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -xa 'left center right bottom middle top' -l unselected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l unselected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -l unselected.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from confirm' -x -l timeout -d 'Timeout until confirm returns selected value or default if provided'

# file
complete -c gum -f -n '__fish_use_subcommand' -a file -d 'Pick a file from a folder'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -s c -l cursor -d 'The cursor character'
complete -c gum -f -n '__fish_seen_subcommand_from file' -s a -l all -d 'Show hidden and 'dot' files'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file -d 'Allow files selection'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory -d 'Allow directories selection'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l height -d 'Maximum number of files to display'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l symlink.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l symlink.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l symlink.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l symlink.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l symlink.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l symlink.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l symlink.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l symlink.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l directory.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l directory.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l directory.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l directory.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l file.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l file.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l permissions.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l permissions.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l permissions.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l permissions.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l permissions.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l permissions.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l permissions.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l permissions.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l selected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l selected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l selected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l selected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l selected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l selected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l selected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l selected.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'none hidden normal rounded thick double' -l file-size.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from file' -xa 'left center right bottom middle top' -l file-size.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l file-size.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file-size.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file-size.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file-size.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file-size.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -l file-size.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from file' -x -l timeout -d 'Timeout until command aborts without a selection'

# filter
complete -c gum -f -n '__fish_use_subcommand' -a filter -d 'Filter items from a list'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator -d 'Character for selection'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l indicator.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l indicator.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l indicator.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l indicator.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l limit -d 'Maximum number of options to pick'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l no-limit -d 'Pick unlimited number of options (ignores limit)'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l strict -d 'Only returns if anything matched. Otherwise return Filter'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-prefix -d 'Character to indicate selected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l selected-indicator.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l selected-indicator.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l selected-indicator.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l selected-indicator.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix -d 'Character to indicate unselected items (hidden if limit is 1)'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l unselected-prefix.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l unselected-prefix.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l unselected-prefix.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l unselected-prefix.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l header.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l header.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l header.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l header.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l header.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l header.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l header.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l header -d 'Header value'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l text.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l text.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l text.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l text.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l cursor-text.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l cursor-text.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l cursor-text.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l cursor-text.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l cursor-text.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l cursor-text.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l cursor-text.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l cursor-text.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l match.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l match.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l match.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l match.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l placeholder -d 'Placeholder value'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt -d 'Prompt to display'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l prompt.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l width -d 'Input width'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l height -d 'Input height'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l value -d 'Initial filter value'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l reverse -d 'Display from the bottom of the screen'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l fuzzy -d 'Enable fuzzy matching'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -l sort -d 'Sort the results'
complete -c gum -f -n '__fish_seen_subcommand_from filter' -x -l timeout -d 'Timeout until filter command aborts'

# format
complete -c gum -f -n '__fish_use_subcommand' -a format -d 'Format a string using a template'
complete -c gum -f -n '__fish_seen_subcommand_from format' -x -l theme -d 'Glamour theme to use for markdown formatting'
complete -c gum -f -n '__fish_seen_subcommand_from format' -x -s l -l language -d 'Programming language to parse code'
complete -c gum -f -n '__fish_seen_subcommand_from format' -xa 'markdown template code emoji' -s t -l type -d 'Format to use (markdown,template,code,emoji)'

# input
complete -c gum -f -n '__fish_use_subcommand' -a input -d 'Prompt for some input'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l placeholder -d 'Placeholder value'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt -d 'Prompt to display'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l prompt.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'blink hide static' -l cursor.mode -d 'Cursor mode'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l value -d 'Initial value (can also be passed via stdin)'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l char-limit -d 'Maximum value length (0 for no limit)'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l width -d 'Input width (0 for terminal width)'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l password -d 'Mask input characters'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header -d 'Header value'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'none hidden normal rounded thick double' -l header.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from input' -xa 'left center right bottom middle top' -l header.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l header.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l header.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l header.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l header.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l header.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -l header.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from input' -x -l timeout -d 'Timeout until input aborts'

# join
complete -c gum -f -n '__fish_use_subcommand' -a join -d 'Join text vertically or horizontally'
complete -c gum -f -n '__fish_seen_subcommand_from join' -xa 'left center right bottom middle top' -l align -d 'Text alignment'
complete -c gum -f -n '__fish_seen_subcommand_from join' -l horizontal -d 'Join (potentially multi-line) strings horizontally'
complete -c gum -f -n '__fish_seen_subcommand_from join' -l vertical -d 'Join (potentially multi-line) strings vertically'

# pager
complete -c gum -f -n '__fish_use_subcommand' -a pager -d 'Scroll through a file'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'none hidden normal rounded thick double' -l border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'left center right bottom middle top' -l align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'none hidden normal rounded thick double' -l help.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'left center right bottom middle top' -l help.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l help.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l help.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l help.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l help.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l help.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l help.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l show-line-numbers -d 'Show line numbers'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'none hidden normal rounded thick double' -l line-number.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'left center right bottom middle top' -l line-number.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l line-number.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l line-number.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l line-number.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l line-number.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l line-number.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l line-number.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l soft-wrap -d 'Soft wrap lines'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'none hidden normal rounded thick double' -l match.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'left center right bottom middle top' -l match.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'none hidden normal rounded thick double' -l match-highlight.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -xa 'left center right bottom middle top' -l match-highlight.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l match-highlight.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match-highlight.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match-highlight.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match-highlight.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match-highlight.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -l match-highlight.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from pager' -x -l timeout -d 'Timeout until command exits'

# spin
complete -c gum -f -n '__fish_use_subcommand' -a spin -d 'Display spinner while running a command'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l show-output -d 'Show or pipe output of command during execution'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'line dot minidot jump pulse points globe moon monkey meter hamburger' -s s -l spinner -d 'Spinner type'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'none hidden normal rounded thick double' -l spinner.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left center right bottom middle top' -l spinner.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l spinner.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l spinner.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title -d 'Text to display to user while spinning'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'none hidden normal rounded thick double' -l title.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left center right bottom middle top' -l title.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l title.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -l title.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -xa 'left right' -s a -l align -d 'Alignment of spinner with regard to the title'
complete -c gum -f -n '__fish_seen_subcommand_from spin' -x -l timeout -d 'Timeout until spin command aborts'

# style
complete -c gum -f -n '__fish_use_subcommand' -a style -d 'Apply coloring, borders, spacing to text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -xa 'none hidden normal rounded thick double' -l border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from style' -xa 'left center right bottom middle top' -l align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from style' -x -l padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from style' -l underline -d 'Underline text'

# table
complete -c gum -f -n '__fish_use_subcommand' -a table -d 'Render a table of data'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s s -l separator -d 'Row separator'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s c -l columns -d 'Column names'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s w -l widths -d 'Column widths'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l height -d 'Table height'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'none hidden normal rounded thick double' -l cell.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'left center right bottom middle top' -l cell.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l cell.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l cell.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l cell.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l cell.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l cell.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l cell.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'none hidden normal rounded thick double' -l header.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'left center right bottom middle top' -l header.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l header.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l header.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l header.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l header.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l header.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l header.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'none hidden normal rounded thick double' -l selected.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from table' -xa 'left center right bottom middle top' -l selected.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -l selected.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l selected.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l selected.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l selected.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l selected.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -l selected.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from table' -x -s f -l file -d 'file path'

# write
complete -c gum -f -n '__fish_use_subcommand' -a write -d 'Prompt for long-form text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l width -d 'Text area width (0 for terminal width)'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l height -d 'Text area height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header -d 'Header value'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder -d 'Placeholder value'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt -d 'Prompt to display'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-cursor-line -d 'Show cursor line'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l show-line-numbers -d 'Show line numbers'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l value -d 'Initial value (can be passed via stdin)'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l char-limit -d 'Maximum value length (0 for no limit)'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'blink hide static' -l cursor.mode -d 'Cursor mode'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l base.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l base.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l base.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l base.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l cursor-line-number.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l cursor-line-number.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line-number.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line-number.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l cursor-line.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l cursor-line.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor-line.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor-line.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l cursor.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l cursor.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l cursor.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l cursor.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l end-of-buffer.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l end-of-buffer.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l end-of-buffer.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l end-of-buffer.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l line-number.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l line-number.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l line-number.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l line-number.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l header.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l header.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l header.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l header.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l header.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l header.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l header.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l header.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l placeholder.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l placeholder.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l placeholder.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l placeholder.underline -d 'Underline text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.background -d 'Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.foreground -d 'Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'none hidden normal rounded thick double' -l prompt.border -d 'Border Style'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.border-background -d 'Border Background Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.border-foreground -d 'Border Foreground Color'
complete -c gum -f -n '__fish_seen_subcommand_from write' -xa 'left center right bottom middle top' -l prompt.align -d 'Text Alignment'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.height -d 'Text height'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.width -d 'Text width'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.margin -d 'Text margin'
complete -c gum -f -n '__fish_seen_subcommand_from write' -x -l prompt.padding -d 'Text padding'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.bold -d 'Bold text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.faint -d 'Faint text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.italic -d 'Italicize text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.strikethrough -d 'Strikethrough text'
complete -c gum -f -n '__fish_seen_subcommand_from write' -l prompt.underline -d 'Underline text'

