/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import org.openstreetmap.josm.spi.preferences.Config;

public final class GuiSizesHelper {
    private static float screenDPI = -1.0f;

    private GuiSizesHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float getScreenDPI() {
        if (screenDPI != -1.0f) return screenDPI;
        Class<GuiSizesHelper> clazz = GuiSizesHelper.class;
        synchronized (GuiSizesHelper.class) {
            if (screenDPI != -1.0f) return screenDPI;
            float scalePref = (float)Config.getPref().getDouble("gui.scale", 1.0);
            screenDPI = scalePref != 0.0f ? 96.0f * scalePref : (!GraphicsEnvironment.isHeadless() ? (float)Toolkit.getDefaultToolkit().getScreenResolution() : 96.0f);
            // ** MonitorExit[var0] (shouldn't be in output)
            return screenDPI;
        }
    }

    public static float getPixelDensity() {
        return GuiSizesHelper.getScreenDPI() / 96.0f;
    }

    public static void setPixelDensity(float pixelDensity) {
        screenDPI = pixelDensity * 96.0f;
    }

    public static boolean isHiDPI() {
        return GuiSizesHelper.getPixelDensity() >= 2.0f;
    }

    public static int getSizeDpiAdjusted(int size) {
        if (size <= 0) {
            return size;
        }
        return Math.round((float)size * GuiSizesHelper.getScreenDPI() / 96.0f);
    }

    public static float getSizeDpiAdjusted(float size) {
        if (size <= 0.0f) {
            return size;
        }
        return size * GuiSizesHelper.getScreenDPI() / 96.0f;
    }

    public static double getSizeDpiAdjusted(double size) {
        if (size <= 0.0) {
            return size;
        }
        return size * (double)GuiSizesHelper.getScreenDPI() / 96.0;
    }

    public static Dimension getDimensionDpiAdjusted(Dimension dim) {
        float pixelPerInch = GuiSizesHelper.getScreenDPI();
        int width = dim.width;
        int height = dim.height;
        if (dim.width > 0) {
            width = Math.round((float)dim.width * pixelPerInch / 96.0f);
        }
        if (dim.height > 0) {
            height = Math.round((float)dim.height * pixelPerInch / 96.0f);
        }
        return new Dimension(width, height);
    }
}

