/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.expression;

import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenOperator;

public enum TokenType {
    QUOTED_STRING,
    JSON_DATA,
    OPERATOR,
    OPEN_PAREN_MATH,
    COMMA,
    CLOSE_PAREN_MATH,
    NUMBER,
    PLAIN_TEXT,
    SPACES,
    FUNCTION_NAME,
    OPEN_PAREN_FUNC,
    CLOSE_PAREN_FUNC;

    public static final char COMMERCIAL_MINUS_SIGN = '\u2052';

    private boolean isSingleChar1() {
        return this == OPEN_PAREN_MATH || this == COMMA || this == CLOSE_PAREN_MATH;
    }

    private static boolean isPlainTextBreak(char ch, char ch2) {
        TokenType tmp = TokenType.fromChar(ch, ch2);
        return tmp.isSingleChar1() || tmp == OPERATOR || tmp == SPACES;
    }

    private static TokenType fromChar(char ch, char ch2) {
        TokenType result = PLAIN_TEXT;
        if (TLineType.isQuote(ch)) {
            result = QUOTED_STRING;
        } else if (TokenOperator.getTokenOperator(ch, ch2) != null) {
            result = OPERATOR;
        } else if (ch == '(') {
            result = OPEN_PAREN_MATH;
        } else if (ch == ')') {
            result = CLOSE_PAREN_MATH;
        } else if (ch == ',') {
            result = COMMA;
        } else if (TLineType.isLatinDigit(ch)) {
            result = NUMBER;
        } else if (TLineType.isSpaceChar(ch)) {
            result = SPACES;
        }
        return result;
    }

    public static final Token eatOneToken(Token lastToken, Eater eater, boolean manageColon) throws EaterException {
        char ch = eater.peekChar();
        if (ch == '\u0000') {
            return null;
        }
        if (manageColon && ch == ':') {
            return null;
        }
        if (ch == '-' && TokenType.isTheMinusAnOperation(lastToken)) {
            ch = '\u2052';
        }
        TokenOperator tokenOperator = TokenOperator.getTokenOperator(ch, eater.peekCharN2());
        if (TLineType.isQuote(ch)) {
            return new Token(eater.eatAndGetQuotedString(), QUOTED_STRING, null);
        }
        if (tokenOperator != null) {
            if (tokenOperator.getDisplay().length() == 1) {
                eater.eatOneChar();
                return new Token(ch, OPERATOR, null);
            }
            return new Token("" + eater.eatOneChar() + eater.eatOneChar(), OPERATOR, null);
        }
        if (ch == '(') {
            return new Token(eater.eatOneChar(), OPEN_PAREN_MATH, null);
        }
        if (ch == ')') {
            return new Token(eater.eatOneChar(), CLOSE_PAREN_MATH, null);
        }
        if (ch == ',') {
            return new Token(eater.eatOneChar(), COMMA, null);
        }
        if (TLineType.isLatinDigit(ch) || ch == '-') {
            return new Token(eater.eatAndGetNumber(), NUMBER, null);
        }
        if (TLineType.isSpaceChar(ch)) {
            return new Token(eater.eatAndGetSpaces(), SPACES, null);
        }
        return new Token(TokenType.eatAndGetTokenPlainText(eater), PLAIN_TEXT, null);
    }

    private static boolean isTheMinusAnOperation(Token lastToken) {
        if (lastToken == null) {
            return false;
        }
        TokenType type = lastToken.getTokenType();
        return type != OPERATOR && type != OPEN_PAREN_MATH && type != COMMA;
    }

    private static String eatAndGetTokenPlainText(Eater eater) throws EaterException {
        StringBuilder result = new StringBuilder();
        char ch;
        while ((ch = eater.peekChar()) != '\u0000' && !TokenType.isPlainTextBreak(ch, eater.peekCharN2())) {
            result.append(eater.eatOneChar());
        }
        return result.toString();
    }
}

